#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "Michelsen Example"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (R)          (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
  151.024     1.00000e-12        0.00000         9.55765e-16       1.00000e+00      72.1370     23.6882     0.745964     2.34123e-16     3.88903e-17
  155.000     3.70033e-12        0.00000         3.44928e-15       1.00000e+00      72.1338     23.6882     0.745206     8.44109e-16     1.25104e-16
  160.000     1.73932e-11        0.00000         1.57258e-14       1.00000e+00      72.1289     23.6882     0.744240     3.84370e-15     4.98804e-16
  165.000     7.40084e-11        0.00000         6.49662e-14       1.00000e+00      72.1229     23.6882     0.743259     1.58594e-14     1.82152e-15
  170.000     2.87644e-10        0.00000         2.45378e-13       1.00000e+00      72.1159     23.6882     0.742264     5.98269e-14     6.14082e-15
  175.000     1.02933e-09        0.00000         8.54060e-13       1.00000e+00      72.1076     23.6882     0.741254     2.07973e-13     1.92468e-14
  180.000     3.41544e-09        0.00000         2.75860e-12       1.00000e+00      72.0979     23.6882     0.740229     6.70910e-13     5.64328e-14
  185.000     1.05744e-08        0.00000         8.32037e-12       1.00000e+00      72.0868     23.6882     0.739188     2.02104e-12     1.55652e-13
  190.000     3.07199e-08        0.00000         2.35651e-11       1.00000e+00      72.0741     23.6882     0.738131     5.71685e-12     4.05861e-13
  195.000     8.41624e-08        0.00000         6.29842e-11       1.00000e+00      72.0597     23.6882     0.737058     1.52607e-11     1.00491e-12
  200.000     2.18429e-07        0.00000         1.59578e-10       1.00000e+00      72.0435     23.6882     0.735968     3.86163e-11     2.37209e-12
  205.000     5.39213e-07        0.00000         3.84808e-10       1.00000e+00      72.0255     23.6882     0.734862     9.30030e-11     5.35737e-12
  210.000     1.27076e-06        0.00000         8.86390e-10       1.00000e+00      72.0054     23.6882     0.733738     2.13960e-10     1.16144e-11
  215.000     2.86852e-06        0.00000         1.95679e-09       1.00000e+00      71.9834     23.6882     0.732597     4.71748e-10     2.42405e-11
  220.000     6.22096e-06        0.00000         4.15242e-09       1.00000e+00      71.9592     23.6882     0.731438     9.99827e-10     4.88363e-11
  225.000     1.29972e-05        0.00000         8.49324e-09       1.00000e+00      71.9328     23.6882     0.730261     2.04248e-09     9.52038e-11
  230.000     2.62252e-05        0.00000         1.67856e-08       1.00000e+00      71.9041     23.6882     0.729065     4.03164e-09     1.79985e-10
  235.000     5.12222e-05        0.00000         3.21271e-08       1.00000e+00      71.8731     23.6882     0.727850     7.70692e-09     3.30646e-10
  240.000     9.70448e-05        0.00000         5.96730e-08       1.00000e+00      71.8397     23.6882     0.726616     1.42972e-08     5.91344e-10
  245.000     1.78687e-04        0.00000         1.07765e-07       1.00000e+00      71.8037     23.6882     0.725362     2.57880e-08     1.03134e-09
  250.000     3.20320e-04        0.00000         1.89550e-07       1.00000e+00      71.7652     23.6882     0.724088     4.53038e-08     1.75681e-09
  255.000     5.59948e-04        0.00000         3.25249e-07       9.99999e-01      71.7241     23.6882     0.722793     7.76422e-08     2.92706e-09
  260.000     9.55941e-04        0.00000         5.45245e-07       9.99999e-01      71.6802     23.6882     0.721478     1.30002e-07     4.77633e-09
  265.000     1.59600e-03        0.00000         8.94218e-07       9.99998e-01      71.6337     23.6882     0.720141     2.12950e-07     7.64265e-09
  270.000     2.60917e-03        0.00000         1.43654e-06       9.99997e-01      71.5842     23.6882     0.718782     3.41689e-07     1.20052e-08
  275.000     4.18173e-03        0.00000         2.26318e-06       9.99995e-01      71.5319     23.6882     0.717400     5.37670e-07     1.85322e-08
  280.000     6.57756e-03        0.00000         3.50040e-06       9.99992e-01      71.4766     23.6882     0.715995     8.30616e-07     2.81407e-08
  285.000     1.01642e-02        0.00000         5.32047e-06       9.99989e-01      71.4183     23.6882     0.714567     1.26102e-06     4.20712e-08
  290.000     1.54449e-02        0.00000         7.95463e-06       9.99984e-01      71.3569     23.6882     0.713115     1.88315e-06     6.19786e-08
  295.000     2.30987e-02        0.00000         1.17086e-05       9.99977e-01      71.2922     23.6882     0.711638     2.76863e-06     9.00419e-08
  300.000     3.40279e-02        0.00000         1.69808e-05       9.99967e-01      71.2243     23.6882     0.710136     4.01068e-06     1.29095e-07
  305.000     4.94153e-02        0.00000         2.42832e-05       9.99955e-01      71.1529     23.6882     0.708608     5.72890e-06     1.82783e-07
  310.000     7.07909e-02        0.00000         3.42655e-05       9.99938e-01      71.0781     23.6882     0.707053     8.07483e-06     2.55740e-07
  315.000     1.00110e-01        0.00000         4.77419e-05       9.99916e-01      70.9996     23.6882     0.705470     1.12381e-05     3.53801e-07
  320.000     1.39839e-01        0.00000         6.57210e-05       9.99887e-01      70.9174     23.6882     0.703859     1.54532e-05     4.84240e-07
  325.000     1.93062e-01        0.00000         8.94384e-05       9.99850e-01      70.8314     23.6882     0.702219     2.10072e-05     6.56049e-07
  330.000     2.63585e-01        0.00000         1.20392e-04       9.99804e-01      70.7413     23.6882     0.700548     2.82476e-05     8.80241e-07
  335.000     3.56065e-01        0.00000         1.60381e-04       9.99746e-01      70.6471     23.6882     0.698847     3.75911e-05     1.17021e-06
  340.000     4.76145e-01        0.00000         2.11545e-04       9.99673e-01      70.5485     23.6882     0.697113     4.95327e-05     1.54211e-06
  345.000     6.30601e-01        0.00000         2.76405e-04       9.99584e-01      70.4454     23.6882     0.695345     6.46557e-05     2.01532e-06
  350.000     8.27505e-01        0.00000         3.57910e-04       9.99476e-01      70.3376     23.6882     0.693543     8.36413e-05     2.61292e-06
  355.000     1.07639e+00        0.00000         4.59483e-04       9.99344e-01      70.2248     23.6882     0.691705     1.07280e-04     3.36222e-06
  360.000     1.38845e+00        0.00000         5.85064e-04       9.99186e-01      70.1068     23.6882     0.689830     1.36481e-04     4.29543e-06
  365.000     1.77671e+00        0.00000         7.39165e-04       9.98998e-01      69.9834     23.6882     0.687916     1.72286e-04     5.45030e-06
  370.000     2.25626e+00        0.00000         9.26912e-04       9.98775e-01      69.8542     23.6882     0.685961     2.15879e-04     6.87092e-06
  375.000     2.84447e+00        0.00000         1.15411e-03       9.98513e-01      69.7190     23.6882     0.683964     2.68600e-04     8.60861e-06
  380.000     3.56122e+00        0.00000         1.42727e-03       9.98207e-01      69.5773     23.6882     0.681923     3.31959e-04     1.07229e-05
  385.000     4.42916e+00        0.00000         1.75370e-03       9.97852e-01      69.4289     23.6882     0.679835     4.07647e-04     1.32825e-05
  390.000     5.47399e+00        0.00000         2.14154e-03       9.97442e-01      69.2734     23.6882     0.677699     4.97557e-04     1.63671e-05
  395.000     6.72478e+00        0.00000         2.59985e-03       9.96970e-01      69.1102     23.6882     0.675512     6.03794e-04     2.00682e-05
  400.000     8.21426e+00        0.00000         3.13863e-03       9.96432e-01      68.9389     23.6882     0.673271     7.28704e-04     2.44914e-05
  405.000     9.97922e+00        0.00000         3.76897e-03       9.95819e-01      68.7591     23.6882     0.670974     8.74886e-04     2.97582e-05
  410.000     1.20609e+01        0.00000         4.50309e-03       9.95125e-01      68.5700     23.6882     0.668618     1.04522e-03     3.60085e-05
  415.000     1.45056e+01        0.00000         5.35443e-03       9.94343e-01      68.3711     23.6882     0.666198     1.24291e-03     4.34034e-05
  420.000     1.73649e+01        0.00000         6.33783e-03       9.93464e-01      68.1617     23.6882     0.663712     1.47150e-03     5.21289e-05
  425.000     2.06966e+01        0.00000         7.46959e-03       9.92480e-01      67.9410     23.6882     0.661155     1.73492e-03     6.24000e-05
  430.000     2.45655e+01        0.00000         8.76770e-03       9.91383e-01      67.7082     23.6882     0.658523     2.03754e-03     7.44655e-05
  435.000     2.90440e+01        0.00000         1.02520e-02       9.90162e-01      67.4624     23.6882     0.655810     2.38425e-03     8.86149e-05
  440.000     3.42135e+01        0.00000         1.19445e-02       9.88808e-01      67.2025     23.6882     0.653011     2.78050e-03     1.05186e-04
  445.000     4.01653e+01        0.00000         1.38694e-02       9.87310e-01      66.9273     23.6882     0.650120     3.23242e-03     1.24574e-04
  450.000     4.70028e+01        0.00000         1.60540e-02       9.85656e-01      66.6355     23.6882     0.647130     3.74694e-03     1.47245e-04
  455.000     5.48431e+01        0.00000         1.85286e-02       9.83832e-01      66.3257     23.6882     0.644032     4.33191e-03     1.73750e-04
  460.000     6.38194e+01        0.00000         2.13273e-02       9.81825e-01      65.9961     23.6882     0.640818     4.99633e-03     2.04750e-04
  465.000     7.40850e+01        0.00000         2.44890e-02       9.79619e-01      65.6449     23.6882     0.637477     5.75056e-03     2.41034e-04
  470.000     8.58165e+01        0.00000         2.80579e-02       9.77196e-01      65.2697     23.6882     0.633996     6.60665e-03     2.83566e-04
  475.000     9.92202e+01        0.00000         3.20851e-02       9.74535e-01      64.8679     23.6882     0.630362     7.57878e-03     3.33521e-04
  480.000     1.14539e+02        0.00000         3.66304e-02       9.71612e-01      64.4365     23.6882     0.626557     8.68382e-03     3.92363e-04
  485.000     1.32064e+02        0.00000         4.17643e-02       9.68399e-01      63.9717     23.6882     0.622561     9.94211e-03     4.61930e-04
  490.000     1.52146e+02        0.00000         4.75717e-02       9.64862e-01      63.4689     23.6882     0.618349     1.13786e-02     5.44574e-04
  495.000     1.75219e+02        0.00000         5.41563e-02       9.60959e-01      62.9225     23.6882     0.613889     1.30245e-02     6.43360e-04
  500.000     2.01831e+02        0.00000         6.16482e-02       9.56639e-01      62.3254     23.6882     0.609143     1.49197e-02     7.62376e-04
  505.000     2.32691e+02        0.00000         7.02149e-02       9.51833e-01      61.6683     23.6882     0.604058     1.71166e-02     9.07228e-04
  510.000     2.68751e+02        0.00000         8.00791e-02       9.46450e-01      60.9387     23.6882     0.598565     1.96867e-02     1.08588e-03
  515.000     3.11343e+02        0.00000         9.15514e-02       9.40362e-01      60.1190     23.6882     0.592565     2.27314e-02     1.31019e-03
  520.000     3.62446e+02        0.00000         1.05090e-01       9.33376e-01      59.1829     23.6882     0.585910     2.64043e-02     1.59884e-03
  525.000     4.25258e+02        0.00000         1.21433e-01       9.25181e-01      58.0879     23.6882     0.578359     3.09569e-02     1.98399e-03
  530.000     5.05651e+02        0.00000         1.41929e-01       9.15200e-01      56.7554     23.6882     0.569468     3.68595e-02     2.52876e-03
  535.000     6.17214e+02        0.00000         1.69683e-01       9.02084e-01      55.0029     23.6882     0.558197     4.52194e-02     3.38980e-03
  540.000     8.18970e+02        0.00000         2.18141e-01       8.79918e-01      52.0343     23.6882     0.539989     6.09428e-02     5.30837e-03
  540.942     9.06146e+02        0.00000         2.38469e-01       8.70783e-01      50.8100     23.6882     0.532749     6.80187e-02     6.30792e-03
  541.285     1.00260e+03        0.00000         2.60573e-01       8.60896e-01      49.4868     23.6882     0.525075     7.60751e-02     7.55687e-03
  541.285     1.00328e+03        0.00000         2.60726e-01       8.60828e-01      49.4777     23.6882     0.525022     7.61323e-02     7.56617e-03
  540.982     1.09670e+03        0.00000         2.81764e-01       8.51421e-01      48.2225     23.6882     0.517875     8.41881e-02     8.94151e-03
  540.000     1.19882e+03        0.00000         3.04371e-01       8.41266e-01      46.8747     23.6882     0.510333     9.33078e-02     1.06612e-02
  538.071     1.31655e+03        0.00000         3.29952e-01       8.29643e-01      45.3463     23.6882     0.501933     1.04279e-01     1.29789e-02
  535.000     1.44584e+03        0.00000         3.57487e-01       8.16867e-01      43.6907     23.6882     0.493007     1.16978e-01     1.60370e-02
  530.000     1.60045e+03        0.00000         3.89693e-01       8.01356e-01      41.7292     23.6882     0.482659     1.33239e-01     2.06213e-02
  525.000     1.72163e+03        0.00000         4.14426e-01       7.88812e-01      40.1939     23.6882     0.474735     1.46993e-01     2.51751e-02
  520.000     1.82295e+03        0.00000         4.34786e-01       7.77883e-01      38.9021     23.6882     0.468195     1.59349e-01     2.98771e-02
  515.000     1.91025e+03        0.00000         4.52113e-01       7.67986e-01      37.7752     23.6882     0.462595     1.70774e-01     3.48138e-02
  510.000     1.98669e+03        0.00000         4.67135e-01       7.58803e-01      36.7705     23.6882     0.457694     1.81519e-01     4.00429e-02
  505.000     2.05423e+03        0.00000         4.80303e-01       7.50138e-01      35.8616     23.6882     0.453345     1.91737e-01     4.56107e-02
  500.000     2.11415e+03        0.00000         4.91918e-01       7.41858e-01      35.0309     23.6882     0.449452     2.01528e-01     5.15593e-02
  495.000     2.16739e+03        0.00000         5.02192e-01       7.33865e-01      34.2657     23.6882     0.445943     2.10963e-01     5.79293e-02
  490.000     2.21463e+03        0.00000         5.11284e-01       7.26085e-01      33.5566     23.6882     0.442769     2.20093e-01     6.47617e-02
  485.000     2.25637e+03        0.00000         5.19314e-01       7.18462e-01      32.8964     23.6882     0.439891     2.28958e-01     7.20992e-02
  480.000     2.29303e+03        0.00000         5.26373e-01       7.10946e-01      32.2795     23.6882     0.437278     2.37586e-01     7.99869e-02
  475.000     2.32492e+03        0.00000         5.32537e-01       7.03499e-01      31.7011     23.6882     0.434907     2.46003e-01     8.84729e-02
  470.000     2.35231e+03        0.00000         5.37863e-01       6.96086e-01      31.1576     23.6882     0.432759     2.54229e-01     9.76086e-02
  465.000     2.37541e+03        0.00000         5.42400e-01       6.88675e-01      30.6457     23.6882     0.430817     2.62278e-01     1.07450e-01
  460.000     2.39440e+03        0.00000         5.46186e-01       6.81241e-01      30.1627     23.6882     0.429068     2.70165e-01     1.18056e-01
  455.000     2.40943e+03        0.00000         5.49252e-01       6.73758e-01      29.7064     23.6882     0.427501     2.77900e-01     1.29493e-01
  450.000     2.42062e+03        0.00000         5.51625e-01       6.66202e-01      29.2747     23.6882     0.426108     2.85494e-01     1.41831e-01
  445.000     2.42808e+03        0.00000         5.53323e-01       6.58553e-01      28.8659     23.6882     0.424880     2.92956e-01     1.55148e-01
  440.000     2.43189e+03        0.00000         5.54365e-01       6.50789e-01      28.4786     23.6882     0.423811     3.00291e-01     1.69525e-01
  435.000     2.43215e+03        0.00000         5.54761e-01       6.42891e-01      28.1112     23.6882     0.422895     3.07507e-01     1.85054e-01
  430.000     2.42891e+03        0.00000         5.54522e-01       6.34838e-01      27.7628     23.6882     0.422129     3.14609e-01     2.01832e-01
  425.000     2.42223e+03        0.00000         5.53653e-01       6.26612e-01      27.4321     23.6882     0.421508     3.21602e-01     2.19966e-01
  420.000     2.41216e+03        0.00000         5.52159e-01       6.18193e-01      27.1183     23.6882     0.421031     3.28491e-01     2.39572e-01
  415.000     2.39874e+03        0.00000         5.50040e-01       6.09563e-01      26.8205     23.6882     0.420693     3.35280e-01     2.60772e-01
  410.000     2.38201e+03        0.00000         5.47296e-01       6.00703e-01      26.5379     23.6882     0.420495     3.41972e-01     2.83702e-01
  405.000     2.36200e+03        0.00000         5.43925e-01       5.91594e-01      26.2697     23.6882     0.420435     3.48571e-01     3.08505e-01
  400.000     2.33873e+03        0.00000         5.39921e-01       5.82217e-01      26.0155     23.6882     0.420512     3.55080e-01     3.35334e-01
  395.000     2.31223e+03        0.00000         5.35279e-01       5.72551e-01      25.7745     23.6882     0.420728     3.61501e-01     3.64353e-01
  390.000     2.28251e+03        0.00000         5.29989e-01       5.62576e-01      25.5463     23.6882     0.421082     3.67838e-01     3.95735e-01
  385.000     2.24960e+03        0.00000         5.24042e-01       5.52273e-01      25.3303     23.6882     0.421576     3.74093e-01     4.29659e-01
  380.000     2.21349e+03        0.00000         5.17426e-01       5.41621e-01      25.1263     23.6882     0.422213     3.80268e-01     4.66311e-01
  375.000     2.17422e+03        0.00000         5.10130e-01       5.30596e-01      24.9336     23.6882     0.422994     3.86365e-01     5.05879e-01
  370.000     2.13178e+03        0.00000         5.02137e-01       5.19179e-01      24.7521     23.6882     0.423924     3.92387e-01     5.48550e-01
  365.000     2.08619e+03        0.00000         4.93433e-01       5.07345e-01      24.5814     23.6882     0.425007     3.98335e-01     5.94500e-01
  360.000     2.03745e+03        0.00000         4.84001e-01       4.95071e-01      24.4211     23.6882     0.426247     4.04211e-01     6.43891e-01
  355.000     1.98558e+03        0.00000         4.73821e-01       4.82332e-01      24.2711     23.6882     0.427651     4.10017e-01     6.96854e-01
  350.000     1.93057e+03        0.00000         4.62876e-01       4.69105e-01      24.1310     23.6882     0.429226     4.15755e-01     7.53473e-01
  345.000     1.87245e+03        0.00000         4.51146e-01       4.55364e-01      24.0008     23.6882     0.430979     4.21426e-01     8.13770e-01
  340.000     1.81121e+03        0.00000         4.38609e-01       4.41082e-01      23.8801     23.6882     0.432920     4.27033e-01     8.77673e-01
  335.000     1.74689e+03        0.00000         4.25245e-01       4.26233e-01      23.7690     23.6882     0.435059     4.32576e-01     9.44988e-01
  331.765     1.70362e+03        0.00000         4.16146e-01       4.16311e-01      23.7022     23.6882     0.436561     4.36130e-01     9.90050e-01
  331.069     1.69416e+03        0.50000         4.14145e-01       4.14145e-01      23.6882     23.6882     0.436891     4.36891e-01     1.00000e+00
      NaN             NaN            NaN                 NaN               NaN          NaN         NaN          NaN             NaN             NaN
  192.425     1.05513e+02        0.50000         3.34958e-02       3.34958e-02      23.6882     23.6882     0.578820     5.78820e-01     1.00000e+00
  187.459     3.53169e+02        0.00000         1.13992e-01       1.13941e-01      23.7003     23.6882     0.584672     5.84637e-01     9.90017e-01
  186.288     4.27266e+02        0.00000         1.38446e-01       1.38381e-01      23.7008     23.6882     0.586072     5.86040e-01     9.89576e-01
  185.000     5.16909e+02        0.00000         1.68250e-01       1.68132e-01      23.7064     23.6882     0.587639     5.87599e-01     9.84924e-01
  183.865     6.03551e+02        0.00000         1.97201e-01       1.97061e-01      23.7065     23.6882     0.589021     5.88987e-01     9.84834e-01
  182.652     7.04716e+02        0.00000         2.31221e-01       2.31031e-01      23.7090     23.6882     0.590516     5.90485e-01     9.82755e-01
  181.363     8.22838e+02        0.00000         2.71169e-01       2.70934e-01      23.7097     23.6882     0.592120     5.92096e-01     9.82110e-01
  180.000     9.60759e+02        0.00000         3.18109e-01       3.17817e-01      23.7106     23.6882     0.593836     5.93820e-01     9.81280e-01
  178.895     1.08331e+03        0.00000         3.60024e-01       3.59713e-01      23.7091     23.6882     0.595243     5.95235e-01     9.82528e-01
  177.750     1.22150e+03        0.00000         4.07544e-01       4.07195e-01      23.7086     23.6882     0.596719     5.96719e-01     9.82888e-01
      NaN             NaN            NaN                 NaN               NaN          NaN         NaN          NaN             NaN             NaN
  172.051     2.11871e+03        0.50000         7.20408e-01       7.20408e-01      23.6882     23.6882     0.604401     6.04401e-01     1.00000e+00
  169.802     2.59693e+03        0.00000         8.89536e-01       8.90014e-01      23.6767     23.6882     0.607622     6.07590e-01     9.89977e-01
  169.010     2.78676e+03        0.00000         9.57149e-01       9.57737e-01      23.6752     23.6882     0.608777     6.08737e-01     9.88632e-01
  168.214     2.99046e+03        0.00000         1.02958e+00       1.03063e+00      23.6668     23.6882     0.609977     6.09905e-01     9.81229e-01
  167.414     3.20906e+03        0.00000         1.10756e+00       1.10910e+00      23.6596     23.6882     0.611198     6.11093e-01     9.74897e-01
  166.611     3.44363e+03        0.00000         1.19148e+00       1.19355e+00      23.6527     23.6882     0.612442     6.12301e-01     9.68813e-01
  165.806     3.69535e+03        0.00000         1.28171e+00       1.28444e+00      23.6452     23.6882     0.613713     6.13527e-01     9.62174e-01
  165.000     3.96547e+03        0.00000         1.37874e+00       1.38225e+00      23.6372     23.6882     0.615010     6.14772e-01     9.55036e-01
  164.369     4.19067e+03        0.00000         1.45977e+00       1.46400e+00      23.6306     23.6882     0.616043     6.15759e-01     9.49220e-01
  163.739     4.42866e+03        0.00000         1.54552e+00       1.55058e+00      23.6237     23.6882     0.617093     6.16757e-01     9.43071e-01
  163.110     4.68016e+03        0.00000         1.63626e+00       1.64228e+00      23.6165     23.6882     0.618158     6.17764e-01     9.36634e-01
  162.483     4.94594e+03        0.00000         1.73228e+00       1.73938e+00      23.6090     23.6882     0.619239     6.18782e-01     9.29923e-01
  161.858     5.22682e+03        0.00000         1.83387e+00       1.84220e+00      23.6012     23.6882     0.620337     6.19808e-01     9.22921e-01
  161.235     5.52364e+03        0.00000         1.94135e+00       1.95108e+00      23.5931     23.6882     0.621450     6.20844e-01     9.15636e-01
  160.616     5.83733e+03        0.00000         2.05504e+00       2.06635e+00      23.5848     23.6882     0.622579     6.21887e-01     9.08081e-01
  160.000     6.16883e+03        0.00000         2.17531e+00       2.18840e+00      23.5761     23.6882     0.623723     6.22939e-01     9.00257e-01
  159.482     6.46422e+03        0.00000         2.28255e+00       2.29734e+00      23.5686     23.6882     0.624704     6.23835e-01     8.93434e-01
  158.967     6.77376e+03        0.00000         2.39501e+00       2.41166e+00      23.5608     23.6882     0.625696     6.24736e-01     8.86429e-01
  158.456     7.09812e+03        0.00000         2.51293e+00       2.53163e+00      23.5530     23.6882     0.626699     6.25642e-01     8.79250e-01
  157.948     7.43802e+03        0.00000         2.63655e+00       2.65751e+00      23.5449     23.6882     0.627713     6.26553e-01     8.71906e-01
  157.445     7.79419e+03        0.00000         2.76615e+00       2.78960e+00      23.5367     23.6882     0.628737     6.27467e-01     8.64402e-01
  156.946     8.16741e+03        0.00000         2.90202e+00       2.92819e+00      23.5283     23.6882     0.629771     6.28385e-01     8.56745e-01
  156.452     8.55851e+03        0.00000         3.04443e+00       3.07359e+00      23.5198     23.6882     0.630816     6.29306e-01     8.48946e-01
  155.962     8.96834e+03        0.00000         3.19371e+00       3.22614e+00      23.5111     23.6882     0.631870     6.30230e-01     8.41014e-01
  155.478     9.39779e+03        0.00000         3.35017e+00       3.38617e+00      23.5024     23.6882     0.632934     6.31157e-01     8.32954e-01
  155.000     9.84780e+03        0.00000         3.51414e+00       3.55404e+00      23.4935     23.6882     0.634007     6.32086e-01     8.24781e-01
  154.510     1.03375e+04        0.00000         3.69258e+00       3.73688e+00      23.4842     23.6882     0.635129     6.33051e-01     8.16189e-01
  154.026     1.08515e+04        0.00000         3.87989e+00       3.92901e+00      23.4749     23.6882     0.636261     6.34018e-01     8.07495e-01
  153.549     1.13910e+04        0.00000         4.07651e+00       4.13088e+00      23.4654     23.6882     0.637401     6.34985e-01     7.98711e-01
  153.079     1.19574e+04        0.00000         4.28289e+00       4.34298e+00      23.4559     23.6882     0.638550     6.35953e-01     7.89849e-01
  152.616     1.25520e+04        0.00000         4.49950e+00       4.56580e+00      23.4463     23.6882     0.639706     6.36921e-01     7.80922e-01
  152.160     1.31761e+04        0.00000         4.72683e+00       4.79989e+00      23.4367     23.6882     0.640870     6.37889e-01     7.71942e-01
  151.712     1.38312e+04        0.00000         4.96541e+00       5.04578e+00      23.4271     23.6882     0.642040     6.38855e-01     7.62920e-01
  151.272     1.45190e+04        0.00000         5.21577e+00       5.30407e+00      23.4175     23.6882     0.643217     6.39820e-01     7.53871e-01
  150.840     1.52409e+04        0.00000         5.47848e+00       5.57537e+00      23.4079     23.6882     0.644398     6.40783e-01     7.44806e-01
  150.416     1.59987e+04        0.00000         5.75415e+00       5.86030e+00      23.3984     23.6882     0.645585     6.41743e-01     7.35739e-01
  150.000     1.67942e+04        0.00000         6.04339e+00       6.15956e+00      23.3889     23.6882     0.646775     6.42700e-01     7.26680e-01
  149.514     1.77971e+04        0.00000         6.40785e+00       6.53701e+00      23.3776     23.6882     0.648202     6.43839e-01     7.15882e-01
  149.041     1.88599e+04        0.00000         6.79382e+00       6.93718e+00      23.3663     23.6882     0.649632     6.44972e-01     7.05134e-01
  148.579     1.99861e+04        0.00000         7.20257e+00       7.36142e+00      23.3553     23.6882     0.651065     6.46098e-01     6.94455e-01
  148.131     2.11796e+04        0.00000         7.63541e+00       7.81113e+00      23.3443     23.6882     0.652498     6.47216e-01     6.83865e-01
  147.695     2.24444e+04        0.00000         8.09374e+00       8.28781e+00      23.3336     23.6882     0.653930     6.48325e-01     6.73382e-01
  147.272     2.37847e+04        0.00000         8.57906e+00       8.79307e+00      23.3230     23.6882     0.655359     6.49424e-01     6.63021e-01
  146.861     2.52050e+04        0.00000         9.09294e+00       9.32857e+00      23.3126     23.6882     0.656785     6.50512e-01     6.52800e-01
  146.463     2.67102e+04        0.00000         9.63704e+00       9.89610e+00      23.3024     23.6882     0.658205     6.51589e-01     6.42733e-01
  146.079     2.83052e+04        0.00000         1.02131e+01       1.04975e+01      23.2924     23.6882     0.659618     6.52653e-01     6.32832e-01
  145.706     2.99955e+04        0.00000         1.08231e+01       1.11349e+01      23.2827     23.6882     0.661023     6.53704e-01     6.23112e-01
  145.347     3.17867e+04        0.00000         1.14689e+01       1.18103e+01      23.2732     23.6882     0.662417     6.54741e-01     6.13582e-01
  145.000     3.36849e+04        0.00000         1.21527e+01       1.25260e+01      23.2640     23.6882     0.663800     6.55762e-01     6.04254e-01
  144.317     3.80147e+04        0.00000         1.37102e+01       1.41581e+01      23.2457     23.6882     0.666638     6.57841e-01     5.85490e-01
  143.686     4.29009e+04        0.00000         1.54647e+01       1.59993e+01      23.2285     23.6882     0.669406     6.59845e-01     5.67702e-01
  143.106     4.84153e+04        0.00000         1.74413e+01       1.80763e+01      23.2126     23.6882     0.672091     6.61769e-01     5.50933e-01
  142.574     5.46384e+04        0.00000         1.96682e+01       2.04191e+01      23.1980     23.6882     0.674682     6.63607e-01     5.35207e-01
  142.089     6.16615e+04        0.00000         2.21774e+01       2.30615e+01      23.1845     23.6882     0.677168     6.65356e-01     5.20532e-01
  141.648     6.95872e+04        0.00000         2.50050e+01       2.60420e+01      23.1722     23.6882     0.679543     6.67013e-01     5.06897e-01
  141.248     7.85318e+04        0.00000         2.81918e+01       2.94038e+01      23.1610     23.6882     0.681800     6.68576e-01     4.94284e-01
  140.885     8.86260e+04        0.00000         3.17838e+01       3.31957e+01      23.1509     23.6882     0.683933     6.70044e-01     4.82659e-01
  140.559     1.00018e+05        0.00000         3.58333e+01       3.74729e+01      23.1418     23.6882     0.685941     6.71417e-01     4.71984e-01
  140.264     1.12874e+05        0.00000         4.03989e+01       4.22976e+01      23.1336     23.6882     0.687821     6.72697e-01     4.62214e-01
  140.000     1.27382e+05        0.00000         4.55471e+01       4.77403e+01      23.1262     23.6882     0.689575     6.73884e-01     4.53299e-01
  139.381     1.80649e+05        0.00000         6.44234e+01       6.77087e+01      23.1091     23.6882     0.693949     6.76825e-01     4.31863e-01
  138.935     2.56190e+05        0.00000         9.11578e+01       9.60067e+01      23.0969     23.6882     0.697375     6.79108e-01     4.15847e-01
  138.616     3.63320e+05        0.00000         1.29042e+02       1.36119e+02      23.0882     23.6882     0.699991     6.80839e-01     4.04062e-01
  138.390     5.15248e+05        0.00000         1.82743e+02       1.92990e+02      23.0821     23.6882     0.701947     6.82129e-01     3.95489e-01
  138.229     7.30707e+05        0.00000         2.58882e+02       2.73631e+02      23.0779     23.6882     0.703388     6.83075e-01     3.89306e-01
  138.125     1.00000e+06        0.00000         3.54032e+02       3.74412e+02      23.0751     23.6882     0.704344     6.83702e-01     3.85261e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                   Liq Den      Gas Den           
#   (R)         (psia)       Liq Mole Frac     Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   --------------   --------------   ---------   ---------   ----------   ----------   -------------
  331.069      1694.16          0.5000           0.414145         0.414145       23.6882     23.6882     0.436891     0.436891     1.00000e+00
  330.374      1684.63          1.0000           0.411967         0.412128       23.6882     23.6744     0.437650     0.437223     9.90046e-01
  330.000      1679.49          1.0000           0.410791         0.411035       23.6882     23.6671     0.438058     0.437408     9.84859e-01
  325.000      1609.03          1.0000           0.394728         0.395958       23.6882     23.5746     0.443481     0.439981     9.18930e-01
  320.000      1535.57          1.0000           0.378018         0.379999       23.6882     23.4911     0.448845     0.442790     8.60017e-01
  315.000      1459.12          1.0000           0.360635         0.363142       23.6882     23.4168     0.454154     0.445851     8.07825e-01
  310.000      1379.76          1.0000           0.342557         0.345378       23.6882     23.3514     0.459409     0.449178     7.62100e-01
  305.000      1297.55          1.0000           0.323761         0.326704       23.6882     23.2951     0.464613     0.452786     7.22634e-01
  300.000      1212.59          1.0000           0.304230         0.307124       23.6882     23.2478     0.469767     0.456688     6.89263e-01
  295.000      1125.01          1.0000           0.283951         0.286652       23.6882     23.2093     0.474876     0.460891     6.61855e-01
  290.000      1034.96          1.0000           0.262922         0.265315       23.6882     23.1796     0.479941     0.465400     6.40297e-01
  285.000       942.65          1.0000           0.241148         0.243154       23.6882     23.1587     0.484966     0.470212     6.24483e-01
  280.000       848.34          1.0000           0.218649         0.220227       23.6882     23.1461     0.489956     0.475313     6.14295e-01
  275.000       752.38          1.0000           0.195463         0.196608       23.6882     23.1418     0.494914     0.480681     6.09585e-01
  270.000       655.17          1.0000           0.171651         0.172394       23.6882     23.1453     0.499846     0.486286     6.10164e-01
  265.000       557.25          1.0000           0.147304         0.147703       23.6882     23.1561     0.504757     0.492087     6.15793e-01
  264.658       550.54          1.0000           0.145620         0.145997       23.6882     23.1571     0.505093     0.492491     6.16356e-01
  264.658       550.54          1.0000           0.145620         0.571653       23.6882     25.0122     0.505093     0.135856     1.38299e-05
  260.000       506.46          1.0000           0.134924         0.597193       23.6882     25.2289     0.510476     0.122833     6.43105e-06
  255.000       462.06          1.0000           0.124120         0.622545       23.6882     25.4444     0.516180     0.110543     2.88319e-06
  250.000       420.44          1.0000           0.113960         0.646283       23.6882     25.6453     0.521795     0.099610     1.30579e-06
  245.000       381.44          1.0000           0.104396         0.668741       23.6882     25.8335     0.527314     0.089773     5.93161e-07
  240.000       344.94          1.0000           0.095393         0.690133       23.6882     26.0104     0.532732     0.080855     2.68830e-07
  235.000       310.83          1.0000           0.086921         0.710607       23.6882     26.1770     0.538043     0.072728     1.21047e-07
  230.000       279.01          1.0000           0.078956         0.730264       23.6882     26.3339     0.543246     0.065295     5.39563e-08
  225.000       249.40          1.0000           0.071475         0.749176       23.6882     26.4818     0.548338     0.058484     2.37325e-08
  220.000       221.93          1.0000           0.064462         0.767392       23.6882     26.6209     0.553320     0.052234     1.02694e-08
  215.000       196.51          1.0000           0.057898         0.784946       23.6882     26.7517     0.558190     0.046497     4.35884e-09
  210.000       173.09          1.0000           0.051770         0.801860       23.6882     26.8745     0.562951     0.041234     1.80943e-09
  205.000       151.59          1.0000           0.046064         0.818146       23.6882     26.9895     0.567601     0.036411     7.32408e-10
  200.000       131.93          1.0000           0.040767         0.833807       23.6882     27.0969     0.572143     0.031999     2.88160e-10
  195.000       114.05          1.0000           0.035868         0.848842       23.6882     27.1970     0.576578     0.027972     1.09834e-10
  192.425       105.51          1.0000           0.033496         0.856339       23.6882     27.2457     0.578820     0.026041     6.59360e-11
  192.425       105.51          0.5000           0.033496         0.033496       23.6882     23.6882     0.578820     0.578820     1.00000e+00
      NaN          NaN             NaN                NaN              NaN           NaN         NaN          NaN          NaN             NaN
  177.750      1221.50          1.0000           0.407195         0.407543       23.6882     23.7085     0.596719     0.596719     9.82930e-01
  176.854      1338.22          1.0000           0.447486         0.447801       23.6882     23.7047     0.597894     0.597889     9.86051e-01
  175.937      1466.10          1.0000           0.491804         0.492118       23.6882     23.7030     0.599108     0.599099     9.87438e-01
  175.000      1606.20          1.0000           0.540554         0.540885       23.6882     23.7022     0.600361     0.600348     9.88081e-01
  174.300      1717.55          1.0000           0.579437         0.579743       23.6882     23.7002     0.601306     0.601293     9.89777e-01
  172.051      2118.71          0.5000           0.720408         0.720408       23.6882     23.6882     0.604401     0.604401     1.00000e+00
END

set output "Figures/Env_001_P_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:4.0e+03] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_001_LogP_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_001_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using (1/$1):2 with lines title "Dew Points", \
     $Env_BP using (1/$1):2 with lines title "Bubble Points"
unset logscale y

set title "P-T Diagram for Macondo Reservoir Fluid"
show title

$Env_DP << END
#   Temp         Sat Pres                                                                                     Liq Den       Gas Den             
#    (F)          (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#----------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   19.6742     1.00000e-12        0.00000         1.47147e-15          1.00000       441.107     52.6900     0.933477     1.64073e-16     3.15263e-18
   20.0000     1.04358e-12        0.00000         1.53461e-15          1.00000       441.107     52.6900     0.933444     1.71108e-16     3.28845e-18
   25.0000     1.99188e-12        0.00000         2.90045e-15          1.00000       441.107     52.6900     0.932937     3.23223e-16     6.23195e-18
   30.0000     3.74480e-12        0.00000         5.40023e-15          1.00000       441.107     52.6900     0.932425     6.01465e-16     1.16369e-17
   35.0000     6.93799e-12        0.00000         9.90938e-15          1.00000       441.107     52.6900     0.931908     1.10307e-15     2.14208e-17
   40.0000     1.26731e-11        0.00000         1.79296e-14          1.00000       441.107     52.6900     0.931386     1.99473e-15     3.88882e-17
   45.0000     2.28332e-11        0.00000         3.20019e-14          1.00000       441.107     52.6900     0.930859     3.55831e-15     6.96586e-17
   50.0000     4.05951e-11        0.00000         5.63703e-14          1.00000       441.107     52.6900     0.930326     6.26426e-15     1.23165e-16
   55.0000     7.12495e-11        0.00000         9.80325e-14          1.00000       441.107     52.6900     0.929789     1.08878e-14     2.15045e-16
   60.0000     1.23499e-10        0.00000         1.68386e-13          1.00000       441.107     52.6900     0.929247     1.86905e-14     3.70911e-16
   65.0000     2.11487e-10        0.00000         2.85774e-13          1.00000       441.107     52.6900     0.928699     3.17016e-14     6.32221e-16
   70.0000     3.57930e-10        0.00000         4.79377e-13          1.00000       441.107     52.6900     0.928146     5.31469e-14     1.06532e-15
   75.0000     5.98910e-10        0.00000         7.95099e-13          1.00000       441.107     52.6900     0.927588     8.80969e-14     1.77524e-15
   80.0000     9.91104e-10        0.00000         1.30437e-12          1.00000       441.107     52.6900     0.927025     1.44436e-13     2.92642e-15
   85.0000     1.62260e-09        0.00000         2.11717e-12          1.00000       441.107     52.6900     0.926456     2.34295e-13     4.77375e-15
   90.0000     2.62891e-09        0.00000         3.40110e-12          1.00000       441.107     52.6900     0.925882     3.76148e-13     7.70828e-15
   95.0000     4.21639e-09        0.00000         5.40908e-12          1.00000       441.107     52.6900     0.925302     5.97848e-13     1.23242e-14
  100.0000     6.69625e-09        0.00000         8.51907e-12          1.00000       441.107     52.6900     0.924717     9.40990e-13     1.95157e-14
  105.0000     1.05334e-08        0.00000         1.32906e-11          1.00000       441.107     52.6900     0.924126     1.46710e-12     3.06163e-14
  110.0000     1.64162e-08        0.00000         2.05447e-11          1.00000       441.107     52.6900     0.923530     2.26639e-12     4.75970e-14
  115.0000     2.53543e-08        0.00000         3.14751e-11          1.00000       441.107     52.6900     0.922927     3.46991e-12     7.33454e-14
  120.0000     3.88164e-08        0.00000         4.78029e-11          1.00000       441.107     52.6900     0.922319     5.26647e-12     1.12057e-13
  125.0000     5.89206e-08        0.00000         7.19888e-11          1.00000       441.107     52.6900     0.921706     7.92577e-12     1.69778e-13
  130.0000     8.86969e-08        0.00000         1.07523e-10          1.00000       441.107     52.6900     0.921086     1.18300e-11     2.55150e-13
  135.0000     1.32445e-07        0.00000         1.59315e-10          1.00000       441.107     52.6900     0.920461     1.75165e-11     3.80435e-13
  140.0000     1.96221e-07        0.00000         2.34222e-10          1.00000       441.107     52.6900     0.919829     2.57347e-11     5.62890e-13
  145.0000     2.88487e-07        0.00000         3.41745e-10          1.00000       441.107     52.6900     0.919192     3.75226e-11     8.26641e-13
  150.0000     4.20984e-07        0.00000         4.94959e-10          1.00000       441.107     52.6900     0.918548     5.43070e-11     1.20516e-12
  155.0000     6.09884e-07        0.00000         7.11724e-10          1.00000       441.106     52.6900     0.917898     7.80352e-11     1.74457e-12
  160.0000     8.77313e-07        0.00000         1.01627e-09          1.00000       441.106     52.6900     0.917242     1.11347e-10     2.50802e-12
  165.0000     1.25333e-06        0.00000         1.44127e-09          1.00000       441.106     52.6900     0.916580     1.57797e-10     3.58135e-12
  170.0000     1.77851e-06        0.00000         2.03044e-09          1.00000       441.106     52.6900     0.915912     2.22141e-10     5.08056e-12
  175.0000     2.50727e-06        0.00000         2.84197e-09          1.00000       441.106     52.6900     0.915237     3.10698e-10     7.16139e-12
  180.0000     3.51214e-06        0.00000         3.95281e-09          1.00000       441.106     52.6900     0.914555     4.31819e-10     1.00317e-11
  185.0000     4.88919e-06        0.00000         5.46407e-09          1.00000       441.105     52.6900     0.913867     5.96465e-10     1.39673e-11
  190.0000     6.76494e-06        0.00000         7.50789e-09          1.00000       441.105     52.6900     0.913173     8.18948e-10     1.93318e-11
  195.0000     9.30502e-06        0.00000         1.02559e-08          1.00000       441.105     52.6900     0.912472     1.11784e-09     2.66024e-11
  200.0000     1.27250e-05        0.00000         1.39299e-08          1.00000       441.104     52.6900     0.911764     1.51711e-09     3.64014e-11
  205.0000     1.73042e-05        0.00000         1.88149e-08          1.00000       441.104     52.6900     0.911049     2.04753e-09     4.95365e-11
  210.0000     2.34019e-05        0.00000         2.52750e-08          1.00000       441.103     52.6900     0.910327     2.74837e-09     6.70498e-11
  215.0000     3.14787e-05        0.00000         3.37732e-08          1.00000       441.103     52.6900     0.909599     3.66953e-09     9.02801e-11
  220.0000     4.21215e-05        0.00000         4.48956e-08          1.00000       441.102     52.6900     0.908863     4.87406e-09     1.20938e-10
  225.0000     5.60745e-05        0.00000         5.93794e-08          1.00000       441.101     52.6900     0.908121     6.44123e-09     1.61199e-10
  230.0000     7.42767e-05        0.00000         7.81486e-08          1.00000       441.100     52.6900     0.907371     8.47026e-09     2.13817e-10
  235.0000     9.79078e-05        0.00000         1.02355e-07          1.00000       441.099     52.6900     0.906614     1.10847e-08     2.82261e-10
  240.0000     1.28442e-04        0.00000         1.33429e-07          1.00000       441.098     52.6900     0.905849     1.44377e-08     3.70882e-10
  245.0000     1.67715e-04        0.00000         1.73137e-07          1.00000       441.097     52.6900     0.905077     1.87185e-08     4.85115e-10
  250.0000     2.17998e-04        0.00000         2.23653e-07          1.00000       441.095     52.6900     0.904298     2.41592e-08     6.31716e-10
  255.0000     2.82098e-04        0.00000         2.87640e-07          1.00000       441.094     52.6900     0.903511     3.10441e-08     8.19053e-10
  260.0000     3.63457e-04        0.00000         3.68345e-07          1.00000       441.092     52.6900     0.902716     3.97196e-08     1.05744e-09
  265.0000     4.66289e-04        0.00000         4.69715e-07          1.00000       441.090     52.6900     0.901914     5.06058e-08     1.35956e-09
  270.0000     5.95729e-04        0.00000         5.96526e-07          1.00000       441.087     52.6900     0.901104     6.42107e-08     1.74091e-09
  275.0000     7.58004e-04        0.00000         7.54533e-07          1.00000       441.085     52.6900     0.900286     8.11455e-08     2.22039e-09
  280.0000     9.60645e-04        0.00000         9.50648e-07          1.00000       441.082     52.6900     0.899459     1.02143e-07     2.82095e-09
  285.0000     1.21272e-03        0.00000         1.19314e-06          1.00000       441.078     52.6900     0.898625     1.28080e-07     3.57036e-09
  290.0000     1.52511e-03        0.00000         1.49186e-06          1.00000       441.075     52.6900     0.897782     1.59999e-07     4.50209e-09
  295.0000     1.91082e-03        0.00000         1.85852e-06          1.00000       441.071     52.6900     0.896931     1.99135e-07     5.65638e-09
  300.0000     2.38534e-03        0.00000         2.30697e-06          1.00000       441.066     52.6900     0.896072     2.46951e-07     7.08136e-09
  305.0000     2.96706e-03        0.00000         2.85356e-06          1.00000       441.061     52.6900     0.895204     3.05167e-07     8.83453e-09
  310.0000     3.67775e-03        0.00000         3.51748e-06          1.00000       441.056     52.6900     0.894328     3.75805e-07     1.09842e-08
  315.0000     4.54305e-03        0.00000         4.32125e-06          1.00000       441.050     52.6900     0.893442     4.61229e-07     1.36116e-08
  320.0000     5.59312e-03        0.00000         5.29115e-06          1.00000       441.043     52.6900     0.892548     5.64196e-07     1.68123e-08
  325.0000     6.86330e-03        0.00000         6.45781e-06          1.00000       441.035     52.6900     0.891645     6.87911e-07     2.06994e-08
  330.0000     8.39483e-03        0.00000         7.85673e-06          1.00000       441.027     52.6900     0.890732     8.36090e-07     2.54056e-08
  335.0000     1.02358e-02        0.00000         9.52905e-06          1.00000       441.018     52.6900     0.889811     1.01303e-06     3.10862e-08
  340.0000     1.24419e-02        0.00000         1.15222e-05          1.00000       441.009     52.6900     0.888880     1.22366e-06     3.79230e-08
  345.0000     1.50777e-02        0.00000         1.38908e-05          0.99999       440.998     52.6900     0.887939     1.47368e-06     4.61276e-08
  350.0000     1.82177e-02        0.00000         1.66974e-05          0.99999       440.986     52.6900     0.886989     1.76959e-06     5.59457e-08
  355.0000     2.19477e-02        0.00000         2.00138e-05          0.99999       440.973     52.6900     0.886029     2.11883e-06     6.76623e-08
  360.0000     2.63660e-02        0.00000         2.39215e-05          0.99999       440.960     52.6900     0.885059     2.52985e-06     8.16066e-08
  365.0000     3.15854e-02        0.00000         2.85138e-05          0.99999       440.944     52.6900     0.884079     3.01228e-06     9.81582e-08
  370.0000     3.77343e-02        0.00000         3.38962e-05          0.99999       440.928     52.6900     0.883089     3.57702e-06     1.17754e-07
  375.0000     4.49593e-02        0.00000         4.01883e-05          0.99998       440.910     52.6900     0.882088     4.23639e-06     1.40894e-07
  380.0000     5.34266e-02        0.00000         4.75251e-05          0.99998       440.890     52.6900     0.881077     5.00428e-06     1.68152e-07
  385.0000     6.33246e-02        0.00000         5.60586e-05          0.99998       440.869     52.6900     0.880055     5.89630e-06     2.00182e-07
  390.0000     7.48663e-02        0.00000         6.59600e-05          0.99998       440.846     52.6900     0.879023     6.92997e-06     2.37731e-07
  395.0000     8.82918e-02        0.00000         7.74208e-05          0.99997       440.821     52.6900     0.877979     8.12492e-06     2.81645e-07
  400.0000     1.03871e-01        0.00000         9.06555e-05          0.99997       440.794     52.6900     0.876924     9.50302e-06     3.32886e-07
  405.0000     1.21907e-01        0.00000         1.05903e-04          0.99996       440.765     52.6900     0.875858     1.10887e-05     3.92542e-07
  410.0000     1.42740e-01        0.00000         1.23431e-04          0.99996       440.734     52.6900     0.874780     1.29090e-05     4.61844e-07
  415.0000     1.66747e-01        0.00000         1.43535e-04          0.99995       440.700     52.6900     0.873690     1.49941e-05     5.42175e-07
  420.0000     1.94354e-01        0.00000         1.66543e-04          0.99995       440.663     52.6900     0.872588     1.73773e-05     6.35097e-07
  425.0000     2.26028e-01        0.00000         1.92820e-04          0.99994       440.624     52.6900     0.871474     2.00952e-05     7.42360e-07
  430.0000     2.62293e-01        0.00000         2.22766e-04          0.99993       440.581     52.6900     0.870347     2.31886e-05     8.65928e-07
  435.0000     3.03728e-01        0.00000         2.56825e-04          0.99992       440.536     52.6900     0.869208     2.67019e-05     1.00800e-06
  440.0000     3.50972e-01        0.00000         2.95482e-04          0.99991       440.487     52.6900     0.868056     3.06841e-05     1.17102e-06
  445.0000     4.04731e-01        0.00000         3.39274e-04          0.99990       440.434     52.6900     0.866891     3.51889e-05     1.35773e-06
  450.0000     4.65784e-01        0.00000         3.88785e-04          0.99988       440.378     52.6900     0.865712     4.02750e-05     1.57118e-06
  455.0000     5.34986e-01        0.00000         4.44657e-04          0.99987       440.317     52.6900     0.864520     4.60065e-05     1.81474e-06
  460.0000     6.13276e-01        0.00000         5.07591e-04          0.99985       440.252     52.6900     0.863314     5.24533e-05     2.09219e-06
  465.0000     7.01685e-01        0.00000         5.78350e-04          0.99984       440.182     52.6900     0.862093     5.96913e-05     2.40767e-06
  470.0000     8.01337e-01        0.00000         6.57765e-04          0.99982       440.108     52.6900     0.860858     6.78033e-05     2.76581e-06
  475.0000     9.13462e-01        0.00000         7.46740e-04          0.99980       440.028     52.6900     0.859608     7.68787e-05     3.17167e-06
  480.0000     1.03940e+00        0.00000         8.46254e-04          0.99977       439.943     52.6900     0.858343     8.70146e-05     3.63090e-06
  485.0000     1.18062e+00        0.00000         9.57371e-04          0.99975       439.852     52.6900     0.857063     9.83160e-05     4.14966e-06
  490.0000     1.33869e+00        0.00000         1.08124e-03          0.99972       439.755     52.6900     0.855767     1.10896e-04     4.73479e-06
  495.0000     1.51536e+00        0.00000         1.21910e-03          0.99969       439.651     52.6900     0.854454     1.24877e-04     5.39377e-06
  500.0000     1.71247e+00        0.00000         1.37229e-03          0.99965       439.540     52.6900     0.853125     1.40390e-04     6.13483e-06
  505.0000     1.93206e+00        0.00000         1.54225e-03          0.99962       439.422     52.6900     0.851780     1.57577e-04     6.96701e-06
  510.0000     2.17632e+00        0.00000         1.73054e-03          0.99958       439.296     52.6900     0.850417     1.76590e-04     7.90019e-06
  515.0000     2.44760e+00        0.00000         1.93882e-03          0.99953       439.162     52.6900     0.849036     1.97592e-04     8.94522e-06
  520.0000     2.74845e+00        0.00000         2.16889e-03          0.99949       439.019     52.6900     0.847637     2.20758e-04     1.01139e-05
  525.0000     3.08162e+00        0.00000         2.42267e-03          0.99944       438.867     52.6900     0.846219     2.46273e-04     1.14193e-05
  530.0000     3.45005e+00        0.00000         2.70222e-03          0.99938       438.705     52.6900     0.844783     2.74340e-04     1.28756e-05
  535.0000     3.85694e+00        0.00000         3.00973e-03          0.99932       438.533     52.6900     0.843327     3.05171e-04     1.44981e-05
  540.0000     4.30568e+00        0.00000         3.34755e-03          0.99926       438.349     52.6900     0.841851     3.38994e-04     1.63037e-05
  545.0000     4.79994e+00        0.00000         3.71822e-03          0.99919       438.155     52.6900     0.840354     3.76053e-04     1.83109e-05
  550.0000     5.34365e+00        0.00000         4.12440e-03          0.99912       437.948     52.6900     0.838837     4.16607e-04     2.05397e-05
  555.0000     5.94101e+00        0.00000         4.56896e-03          0.99904       437.728     52.6900     0.837297     4.60933e-04     2.30119e-05
  560.0000     6.59653e+00        0.00000         5.05495e-03          0.99896       437.495     52.6900     0.835736     5.09324e-04     2.57513e-05
  565.0000     7.31502e+00        0.00000         5.58562e-03          0.99887       437.248     52.6900     0.834151     5.62095e-04     2.87838e-05
  570.0000     8.10165e+00        0.00000         6.16442e-03          0.99877       436.985     52.6900     0.832543     6.19578e-04     3.21375e-05
  575.0000     8.96193e+00        0.00000         6.79503e-03          0.99867       436.706     52.6900     0.830911     6.82126e-04     3.58431e-05
  580.0000     9.90175e+00        0.00000         7.48137e-03          0.99856       436.410     52.6900     0.829254     7.50117e-04     3.99340e-05
  585.0000     1.09274e+01        0.00000         8.22758e-03          0.99844       436.097     52.6900     0.827571     8.23950e-04     4.44465e-05
  590.0000     1.20456e+01        0.00000         9.03808e-03          0.99832       435.764     52.6900     0.825862     9.04050e-04     4.94202e-05
  595.0000     1.32635e+01        0.00000         9.91757e-03          0.99818       435.411     52.6900     0.824125     9.90869e-04     5.48980e-05
  600.0000     1.45888e+01        0.00000         1.08710e-02          0.99804       435.038     52.6900     0.822360     1.08489e-03     6.09268e-05
  605.0000     1.60296e+01        0.00000         1.19037e-02          0.99790       434.642     52.6900     0.820567     1.18661e-03     6.75577e-05
  610.0000     1.75948e+01        0.00000         1.30213e-02          0.99774       434.222     52.6900     0.818743     1.29659e-03     7.48462e-05
  615.0000     1.92935e+01        0.00000         1.42298e-02          0.99757       433.777     52.6900     0.816888     1.41539e-03     8.28531e-05
  620.0000     2.11358e+01        0.00000         1.55354e-02          0.99740       433.306     52.6900     0.815001     1.54364e-03     9.16443e-05
  625.0000     2.31323e+01        0.00000         1.69449e-02          0.99721       432.808     52.6900     0.813080     1.68197e-03     1.01292e-04
  630.0000     2.52944e+01        0.00000         1.84656e-02          0.99702       432.279     52.6900     0.811125     1.83110e-03     1.11875e-04
  635.0000     2.76342e+01        0.00000         2.01049e-02          0.99681       431.719     52.6900     0.809135     1.99176e-03     1.23480e-04
  640.0000     3.01648e+01        0.00000         2.18710e-02          0.99659       431.126     52.6900     0.807107     2.16474e-03     1.36202e-04
  645.0000     3.29001e+01        0.00000         2.37725e-02          0.99636       430.498     52.6900     0.805041     2.35088e-03     1.50142e-04
  650.0000     3.58550e+01        0.00000         2.58185e-02          0.99612       429.832     52.6900     0.802935     2.55110e-03     1.65416e-04
  655.0000     3.90456e+01        0.00000         2.80190e-02          0.99587       429.127     52.6900     0.800787     2.76635e-03     1.82147e-04
  660.0000     4.24892e+01        0.00000         3.03842e-02          0.99561       428.380     52.6900     0.798596     2.99768e-03     2.00472e-04
  665.0000     4.62042e+01        0.00000         3.29254e-02          0.99533       427.589     52.6900     0.796360     3.24619e-03     2.20544e-04
  670.0000     5.02107e+01        0.00000         3.56544e-02          0.99504       426.750     52.6900     0.794077     3.51308e-03     2.42527e-04
  675.0000     5.45302e+01        0.00000         3.85840e-02          0.99474       425.861     52.6900     0.791744     3.79965e-03     2.66607e-04
  680.0000     5.91859e+01        0.00000         4.17279e-02          0.99442       424.918     52.6900     0.789360     4.10728e-03     2.92988e-04
  685.0000     6.42033e+01        0.00000         4.51008e-02          0.99409       423.918     52.6900     0.786922     4.43748e-03     3.21896e-04
  690.0000     6.96095e+01        0.00000         4.87184e-02          0.99374       422.857     52.6900     0.784428     4.79189e-03     3.53583e-04
  695.0000     7.54344e+01        0.00000         5.25978e-02          0.99338       421.731     52.6900     0.781874     5.17227e-03     3.88331e-04
  700.0000     8.17105e+01        0.00000         5.67574e-02          0.99300       420.535     52.6900     0.779257     5.58057e-03     4.26454e-04
  705.0000     8.84734e+01        0.00000         6.12170e-02          0.99261       419.265     52.6900     0.776575     6.01889e-03     4.68305e-04
  710.0000     9.57618e+01        0.00000         6.59983e-02          0.99220       417.915     52.6900     0.773823     6.48956e-03     5.14282e-04
  715.0000     1.03619e+02        0.00000         7.11248e-02          0.99177       416.480     52.6900     0.770998     6.99513e-03     5.64834e-04
  720.0000     1.12092e+02        0.00000         7.66220e-02          0.99133       414.952     52.6900     0.768094     7.53842e-03     6.20468e-04
  725.0000     1.21233e+02        0.00000         8.25182e-02          0.99087       413.325     52.6900     0.765108     8.12256e-03     6.81763e-04
  730.0000     1.31101e+02        0.00000         8.88442e-02          0.99039       411.591     52.6900     0.762033     8.75103e-03     7.49383e-04
  735.0000     1.41761e+02        0.00000         9.56341e-02          0.98989       409.741     52.6900     0.758863     9.42775e-03     8.24087e-04
  740.0000     1.53287e+02        0.00000         1.02926e-01          0.98937       407.766     52.6900     0.755593     1.01571e-02     9.06753e-04
  745.0000     1.65762e+02        0.00000         1.10761e-01          0.98883       405.654     52.6900     0.752213     1.09441e-02     9.98402e-04
  750.0000     1.79280e+02        0.00000         1.19188e-01          0.98828       403.392     52.6900     0.748716     1.17943e-02     1.10023e-03
  755.0000     1.93951e+02        0.00000         1.28260e-01          0.98770       400.968     52.6900     0.745091     1.27144e-02     1.21364e-03
  760.0000     2.09899e+02        0.00000         1.38037e-01          0.98710       398.363     52.6900     0.741328     1.37118e-02     1.34030e-03
  765.0000     2.27271e+02        0.00000         1.48589e-01          0.98648       395.561     52.6900     0.737411     1.47953e-02     1.48222e-03
  770.0000     2.46240e+02        0.00000         1.59997e-01          0.98583       392.538     52.6900     0.733327     1.59754e-02     1.64183e-03
  775.0000     2.67011e+02        0.00000         1.72355e-01          0.98517       389.269     52.6900     0.729057     1.72644e-02     1.82208e-03
  780.0000     2.89831e+02        0.00000         1.85775e-01          0.98448       385.723     52.6900     0.724578     1.86775e-02     2.02668e-03
  785.0000     3.15007e+02        0.00000         2.00392e-01          0.98377       381.862     52.6900     0.719862     2.02330e-02     2.26028e-03
  790.0000     3.42919e+02        0.00000         2.16373e-01          0.98303       377.641     52.6900     0.714876     2.19540e-02     2.52888e-03
  795.0000     3.74054e+02        0.00000         2.33923e-01          0.98227       373.001     52.6900     0.709577     2.38703e-02     2.84037e-03
  800.0000     4.09052e+02        0.00000         2.53311e-01          0.98149       367.867     52.6900     0.703907     2.60208e-02     3.20539e-03
  805.0000     4.48783e+02        0.00000         2.74893e-01          0.98069       362.136     52.6900     0.697790     2.84587e-02     3.63887e-03
  810.0000     4.94481e+02        0.00000         2.99164e-01          0.97986       355.668     52.6900     0.691117     3.12594e-02     4.16262e-03
  815.0000     5.48007e+02        0.00000         3.26857e-01          0.97902       348.252     52.6900     0.683725     3.45369e-02     4.81052e-03
  820.0000     6.12409e+02        0.00000         3.59149e-01          0.97816       339.548     52.6900     0.675347     3.84784e-02     5.63975e-03
  825.0000     6.93360e+02        0.00000         3.98192e-01          0.97731       328.935     52.6900     0.665491     4.34328e-02     6.76026e-03
  830.0000     8.04180e+02        0.00000         4.48944e-01          0.97652       314.973     52.6900     0.653001     5.02205e-02     8.43889e-03
  835.0000     1.00367e+03        0.00000         5.32883e-01          0.97599       291.417     52.6900     0.632806     6.24696e-02     1.19008e-02
  835.9509     1.09171e+03        0.00000         5.67076e-01          0.97609       281.637     52.6900     0.624647     6.78928e-02     1.36179e-02
  836.2862     1.18748e+03        0.00000         6.02405e-01          0.97641       271.410     52.6900     0.616211     7.38053e-02     1.56242e-02
  836.2862     1.18842e+03        0.00000         6.02744e-01          0.97641       271.312     52.6900     0.616130     7.38636e-02     1.56447e-02
  835.9747     1.28551e+03        0.00000         6.36652e-01          0.97695       261.371     52.6900     0.607998     7.98734e-02     1.78336e-02
  835.0000     1.39053e+03        0.00000         6.71298e-01          0.97775       251.083     52.6900     0.599625     8.63928e-02     2.03830e-02
  833.0213     1.51903e+03        0.00000         7.10983e-01          0.97904       239.123     52.6900     0.589917     9.43969e-02     2.37724e-02
  830.0000     1.65940e+03        0.00000         7.51158e-01          0.98080       226.812     52.6900     0.579915     1.03176e-01     2.78351e-02
  825.0000     1.83923e+03        0.00000         7.98179e-01          0.98358       212.122     52.6900     0.567919     1.14478e-01     3.36302e-02
  820.0000     1.98880e+03        0.00000         8.33818e-01          0.98631       200.769     52.6900     0.558566     1.23926e-01     3.89963e-02
  815.0000     2.12142e+03        0.00000         8.63018e-01          0.98905       191.315     52.6900     0.550701     1.32341e-01     4.42030e-02
  810.0000     2.24277e+03        0.00000         8.87913e-01          0.99181       183.140     52.6900     0.543831     1.40072e-01     4.93634e-02
  805.0000     2.35589e+03        0.00000         9.09665e-01          0.99459       175.905     52.6900     0.537689     1.47305e-01     5.45376e-02
  800.0000     2.46262e+03        0.00000         9.28992e-01          0.99740       169.401     52.6900     0.532113     1.54155e-01     5.97626e-02
  795.0000     2.56421e+03        0.00000         9.46376e-01          1.00023       163.488     52.6900     0.526992     1.60697e-01     6.50634e-02
  790.0000     2.66152e+03        0.00000         9.62159e-01          1.00310       158.065     52.6900     0.522252     1.66984e-01     7.04582e-02
  785.0000     2.75517e+03        0.00000         9.76597e-01          1.00600       153.057     52.6900     0.517833     1.73054e-01     7.59610e-02
  780.0000     2.84565e+03        0.00000         9.89884e-01          1.00893       148.407     52.6900     0.513694     1.78938e-01     8.15830e-02
  775.0000     2.93335e+03        0.00000         1.00217e+00          1.01188       144.070     52.6900     0.509801     1.84658e-01     8.73337e-02
  770.0000     3.01854e+03        0.00000         1.01359e+00          1.01487       140.009     52.6900     0.506125     1.90233e-01     9.32214e-02
  765.0000     3.10149e+03        0.00000         1.02424e+00          1.01788       136.193     52.6900     0.502644     1.95677e-01     9.92533e-02
  760.0000     3.18239e+03        0.00000         1.03420e+00          1.02092       132.597     52.6900     0.499341     2.01003e-01     1.05436e-01
  755.0000     3.26140e+03        0.00000         1.04355e+00          1.02399       129.201     52.6900     0.496199     2.06222e-01     1.11776e-01
  750.0000     3.33867e+03        0.00000         1.05234e+00          1.02709       125.985     52.6900     0.493204     2.11341e-01     1.18280e-01
  745.0000     3.41432e+03        0.00000         1.06063e+00          1.03021       122.934     52.6900     0.490347     2.16369e-01     1.24951e-01
  740.0000     3.48845e+03        0.00000         1.06846e+00          1.03336       120.035     52.6900     0.487615     2.21312e-01     1.31798e-01
  735.0000     3.56115e+03        0.00000         1.07588e+00          1.03653       117.275     52.6900     0.485002     2.26175e-01     1.38823e-01
  730.0000     3.63250e+03        0.00000         1.08291e+00          1.03973       114.644     52.6900     0.482499     2.30964e-01     1.46034e-01
  725.0000     3.70257e+03        0.00000         1.08959e+00          1.04295       112.132     52.6900     0.480099     2.35682e-01     1.53434e-01
  720.0000     3.77142e+03        0.00000         1.09594e+00          1.04620       109.731     52.6900     0.477797     2.40334e-01     1.61030e-01
  715.0000     3.83909e+03        0.00000         1.10200e+00          1.04947       107.434     52.6900     0.475586     2.44923e-01     1.68827e-01
  710.0000     3.90565e+03        0.00000         1.10777e+00          1.05276       105.232     52.6900     0.473463     2.49451e-01     1.76829e-01
  705.0000     3.97112e+03        0.00000         1.11329e+00          1.05607       103.121     52.6900     0.471421     2.53923e-01     1.85042e-01
  700.0000     4.03556e+03        0.00000         1.11856e+00          1.05941       101.095     52.6900     0.469459     2.58340e-01     1.93471e-01
  695.0000     4.09898e+03        0.00000         1.12361e+00          1.06276        99.149     52.6900     0.467571     2.62705e-01     2.02122e-01
  690.0000     4.16143e+03        0.00000         1.12844e+00          1.06614        97.277     52.6900     0.465755     2.67019e-01     2.10999e-01
  685.0000     4.22294e+03        0.00000         1.13308e+00          1.06953        95.476     52.6900     0.464008     2.71285e-01     2.20109e-01
  680.0000     4.28352e+03        0.00000         1.13753e+00          1.07295        93.742     52.6900     0.462326     2.75504e-01     2.29458e-01
  675.0000     4.34319e+03        0.00000         1.14181e+00          1.07638        92.070     52.6900     0.460707     2.79678e-01     2.39049e-01
  670.0000     4.40199e+03        0.00000         1.14592e+00          1.07983        90.459     52.6900     0.459148     2.83809e-01     2.48890e-01
  665.0000     4.45993e+03        0.00000         1.14987e+00          1.08330        88.904     52.6900     0.457648     2.87898e-01     2.58987e-01
  660.0000     4.51702e+03        0.00000         1.15368e+00          1.08679        87.403     52.6900     0.456204     2.91945e-01     2.69344e-01
  655.0000     4.57328e+03        0.00000         1.15735e+00          1.09029        85.953     52.6900     0.454815     2.95953e-01     2.79968e-01
  650.0000     4.62873e+03        0.00000         1.16089e+00          1.09382        84.552     52.6900     0.453478     2.99922e-01     2.90865e-01
  645.0000     4.68337e+03        0.00000         1.16431e+00          1.09735        83.197     52.6900     0.452192     3.03854e-01     3.02042e-01
  640.0000     4.73723e+03        0.00000         1.16760e+00          1.10091        81.886     52.6900     0.450955     3.07749e-01     3.13504e-01
  635.0000     4.79030e+03        0.00000         1.17078e+00          1.10447        80.617     52.6900     0.449766     3.11609e-01     3.25258e-01
  630.0000     4.84261e+03        0.00000         1.17386e+00          1.10806        79.388     52.6900     0.448624     3.15434e-01     3.37311e-01
  625.0000     4.89415e+03        0.00000         1.17683e+00          1.11165        78.198     52.6900     0.447526     3.19225e-01     3.49668e-01
  620.0000     4.94494e+03        0.00000         1.17971e+00          1.11526        77.045     52.6900     0.446473     3.22982e-01     3.62337e-01
  615.0000     4.99499e+03        0.00000         1.18249e+00          1.11888        75.927     52.6900     0.445462     3.26708e-01     3.75325e-01
  610.0000     5.04429e+03        0.00000         1.18519e+00          1.12252        74.842     52.6900     0.444494     3.30401e-01     3.88638e-01
  605.0000     5.09286e+03        0.00000         1.18780e+00          1.12617        73.790     52.6900     0.443565     3.34063e-01     4.02284e-01
  600.0000     5.14070e+03        0.00000         1.19033e+00          1.12983        72.769     52.6900     0.442677     3.37695e-01     4.16269e-01
  595.0000     5.18782e+03        0.00000         1.19278e+00          1.13350        71.777     52.6900     0.441828     3.41297e-01     4.30601e-01
  590.0000     5.23422e+03        0.00000         1.19515e+00          1.13718        70.814     52.6900     0.441016     3.44870e-01     4.45287e-01
  585.0000     5.27990e+03        0.00000         1.19745e+00          1.14087        69.879     52.6900     0.440242     3.48413e-01     4.60334e-01
  580.0000     5.32488e+03        0.00000         1.19969e+00          1.14457        68.970     52.6900     0.439504     3.51929e-01     4.75751e-01
  575.0000     5.36914e+03        0.00000         1.20185e+00          1.14829        68.086     52.6900     0.438802     3.55417e-01     4.91543e-01
  570.0000     5.41269e+03        0.00000         1.20395e+00          1.15201        67.227     52.6900     0.438135     3.58877e-01     5.07720e-01
  565.0000     5.45554e+03        0.00000         1.20599e+00          1.15573        66.392     52.6900     0.437503     3.62311e-01     5.24289e-01
  560.0000     5.49769e+03        0.00000         1.20797e+00          1.15947        65.579     52.6900     0.436905     3.65718e-01     5.41257e-01
  555.0000     5.53914e+03        0.00000         1.20990e+00          1.16321        64.788     52.6900     0.436339     3.69100e-01     5.58632e-01
  550.0000     5.57988e+03        0.00000         1.21176e+00          1.16696        64.019     52.6900     0.435807     3.72456e-01     5.76423e-01
  545.0000     5.61993e+03        0.00000         1.21357e+00          1.17072        63.270     52.6900     0.435307     3.75787e-01     5.94637e-01
  540.0000     5.65928e+03        0.00000         1.21533e+00          1.17448        62.540     52.6900     0.434839     3.79093e-01     6.13282e-01
  535.0000     5.69793e+03        0.00000         1.21703e+00          1.17824        61.830     52.6900     0.434402     3.82374e-01     6.32366e-01
  530.0000     5.73588e+03        0.00000         1.21869e+00          1.18201        61.138     52.6900     0.433997     3.85632e-01     6.51897e-01
  525.0000     5.77314e+03        0.00000         1.22030e+00          1.18579        60.464     52.6900     0.433622     3.88866e-01     6.71883e-01
  520.0000     5.80969e+03        0.00000         1.22186e+00          1.18956        59.808     52.6900     0.433277     3.92076e-01     6.92332e-01
  515.0000     5.84555e+03        0.00000         1.22338e+00          1.19334        59.168     52.6900     0.432963     3.95264e-01     7.13251e-01
  510.0000     5.88071e+03        0.00000         1.22485e+00          1.19713        58.544     52.6900     0.432678     3.98429e-01     7.34648e-01
  505.0000     5.91516e+03        0.00000         1.22627e+00          1.20091        57.936     52.6900     0.432422     4.01571e-01     7.56531e-01
  500.0000     5.94892e+03        0.00000         1.22766e+00          1.20470        57.343     52.6900     0.432196     4.04691e-01     7.78908e-01
  495.0000     5.98197e+03        0.00000         1.22900e+00          1.20848        56.766     52.6900     0.431999     4.07790e-01     8.01785e-01
  490.0000     6.01432e+03        0.00000         1.23030e+00          1.21226        56.202     52.6900     0.431830     4.10867e-01     8.25170e-01
  485.0000     6.04596e+03        0.00000         1.23156e+00          1.21605        55.653     52.6900     0.431690     4.13923e-01     8.49070e-01
  480.0000     6.07689e+03        0.00000         1.23278e+00          1.21983        55.117     52.6900     0.431579     4.16958e-01     8.73491e-01
  475.0000     6.10711e+03        0.00000         1.23396e+00          1.22361        54.594     52.6900     0.431496     4.19972e-01     8.98439e-01
  470.0000     6.13662e+03        0.00000         1.23511e+00          1.22738        54.084     52.6900     0.431441     4.22966e-01     9.23922e-01
  465.0000     6.16542e+03        0.00000         1.23622e+00          1.23116        53.587     52.6900     0.431414     4.25940e-01     9.49943e-01
  460.0000     6.19350e+03        0.00000         1.23729e+00          1.23492        53.101     52.6900     0.431416     4.28894e-01     9.76508e-01
  457.4885     6.20734e+03        0.00000         1.23782e+00          1.23681        52.863     52.6900     0.431433     4.30370e-01     9.90011e-01
  455.6608     6.21729e+03        0.50000         1.23819e+00          1.23819        52.690     52.6900     0.431441     4.31441e-01     1.00000e+00
       NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   90.4361     6.33373e+03        0.50000         1.48871e+00          1.48871        52.690     52.6900     0.608258     6.08258e-01     1.00000e+00
   89.8117     6.33444e+03        0.00000         1.49233e+00          1.48986        52.848     52.6900     0.609361     6.08546e-01     9.90050e-01
   85.0000     6.34246e+03        0.00000         1.52122e+00          1.49942        54.064     52.6900     0.617729     6.10783e-01     9.18309e-01
   80.0000     6.35611e+03        0.00000         1.55395e+00          1.51074        55.368     52.6900     0.626381     6.13139e-01     8.50102e-01
   75.0000     6.37595e+03        0.00000         1.58956e+00          1.52368        56.700     52.6900     0.634929     6.15532e-01     7.88315e-01
   70.0000     6.40287e+03        0.00000         1.62824e+00          1.53848        58.053     52.6900     0.643327     6.17965e-01     7.32633e-01
   65.0000     6.43785e+03        0.00000         1.67022e+00          1.55539        59.416     52.6900     0.651543     6.20441e-01     6.82626e-01
   60.0000     6.48200e+03        0.00000         1.71582e+00          1.57472        60.783     52.6900     0.659552     6.22965e-01     6.37811e-01
   55.0000     6.53655e+03        0.00000         1.76541e+00          1.59680        62.146     52.6900     0.667341     6.25540e-01     5.97691e-01
   50.0000     6.60295e+03        0.00000         1.81947e+00          1.62202        63.501     52.6900     0.674902     6.28171e-01     5.61784e-01
   45.0000     6.68282e+03        0.00000         1.87856e+00          1.65084        64.841     52.6900     0.682230     6.30860e-01     5.29635e-01
   40.0000     6.77807e+03        0.00000         1.94339e+00          1.68377        66.162     52.6900     0.689329     6.33615e-01     5.00833e-01
   35.0000     6.89093e+03        0.00000         2.01478e+00          1.72144        67.460     52.6900     0.696202     6.36438e-01     4.75009e-01
   30.0000     7.02401e+03        0.00000         2.09376e+00          1.76456        68.731     52.6900     0.702856     6.39338e-01     4.51835e-01
   25.0000     7.18047e+03        0.00000         2.18152e+00          1.81402        69.972     52.6900     0.709301     6.42319e-01     4.31025e-01
   20.0000     7.36407e+03        0.00000         2.27956e+00          1.87084        71.180     52.6900     0.715546     6.45391e-01     4.12332e-01
   15.0000     7.57939e+03        0.00000         2.38967e+00          1.93632        72.350     52.6900     0.721601     6.48560e-01     3.95540e-01
   10.0000     7.83207e+03        0.00000         2.51409e+00          2.01201        73.479     52.6900     0.727480     6.51838e-01     3.80465e-01
    5.0000     8.12916e+03        0.00000         2.65559e+00          2.09985        74.563     52.6900     0.733194     6.55237e-01     3.66950e-01
    0.0000     8.47954e+03        0.00000         2.81769e+00          2.20230        75.598     52.6900     0.738759     6.58770e-01     3.54863e-01
   -5.0000     8.89464e+03        0.00000         3.00486e+00          2.32253        76.580     52.6900     0.744188     6.62455e-01     3.44094e-01
   -7.5781     9.13871e+03        0.00000         3.11302e+00          2.39276        77.064     52.6900     0.746941     6.64421e-01     3.39025e-01
  -10.0000     9.38947e+03        0.00000         3.22297e+00          2.46464        77.504     52.6900     0.749501     6.66313e-01     3.34552e-01
  -12.5793     9.68223e+03        0.00000         3.35005e+00          2.54825        77.956     52.6900     0.752202     6.68380e-01     3.30087e-01
  -15.0000     9.98411e+03        0.00000         3.47985e+00          2.63415        78.364     52.6900     0.754716     6.70372e-01     3.26170e-01
  -17.5815     1.03389e+04        0.00000         3.63101e+00          2.73478        78.780     52.6900     0.757379     6.72556e-01     3.22278e-01
  -20.0000     1.07063e+04        0.00000         3.78619e+00          2.83864        79.153     52.6900     0.759860     6.74663e-01     3.18896e-01
  -22.5850     1.11420e+04        0.00000         3.96871e+00          2.96143        79.531     52.6900     0.762500     6.76988e-01     3.15560e-01
  -25.0000     1.15954e+04        0.00000         4.15714e+00          3.08882        79.864     52.6900     0.764961     6.79234e-01     3.12346e-01
  -27.5904     1.21400e+04        0.00000         4.38167e+00          3.24135        80.198     52.6900     0.767601     6.81731e-01     3.09015e-01
  -30.0000     1.27101e+04        0.00000         4.61498e+00          3.40057        80.487     52.6900     0.770062     6.84145e-01     3.06159e-01
  -31.7553     1.31705e+04        0.00000         4.80221e+00          3.52881        80.682     52.6900     0.771862     6.85965e-01     3.04226e-01
  -33.4199     1.36476e+04        0.00000         4.99525e+00          3.66142        80.856     52.6900     0.773578     6.87743e-01     3.02510e-01
  -35.0000     1.41419e+04        0.00000         5.19432e+00          3.79855        81.010     52.6900     0.775218     6.89483e-01     3.00987e-01
  -36.7669     1.47496e+04        0.00000         5.43783e+00          3.96676        81.169     52.6900     0.777068     6.91495e-01     2.99409e-01
  -38.4312     1.53835e+04        0.00000         5.69051e+00          4.14181        81.304     52.6900     0.778831     6.93460e-01     2.98047e-01
  -40.0000     1.60446e+04        0.00000         5.95276e+00          4.32397        81.418     52.6900     0.780514     6.95381e-01     2.96876e-01
  -41.3513     1.66715e+04        0.00000         6.20036e+00          4.49636        81.506     52.6900     0.781986     6.97096e-01     2.95959e-01
  -42.6326     1.73230e+04        0.00000         6.45657e+00          4.67513        81.580     52.6900     0.783403     6.98779e-01     2.95170e-01
  -43.8477     1.79999e+04        0.00000         6.72173e+00          4.86052        81.640     52.6900     0.784769     7.00431e-01     2.94499e-01
  -45.0000     1.87033e+04        0.00000         6.99619e+00          5.05277        81.688     52.6900     0.786089     7.02055e-01     2.93933e-01
  -46.3811     1.96386e+04        0.00000         7.35960e+00          5.30786        81.734     52.6900     0.787708     7.04081e-01     2.93352e-01
  -47.6713     2.06207e+04        0.00000         7.73941e+00          5.57505        81.764     52.6900     0.789263     7.06065e-01     2.92910e-01
  -48.8760     2.16520e+04        0.00000         8.13642e+00          5.85491        81.780     52.6900     0.790760     7.08007e-01     2.92592e-01
  -50.0000     2.27347e+04        0.00000         8.55147e+00          6.14806        81.783     52.6900     0.792203     7.09910e-01     2.92386e-01
  -51.1709     2.40147e+04        0.00000         9.03989e+00          6.49368        81.773     52.6900     0.793765     7.12001e-01     2.92272e-01
  -52.2512     2.53667e+04        0.00000         9.55343e+00          6.85777        81.751     52.6900     0.795269     7.14045e-01     2.92269e-01
  -53.2464     2.67948e+04        0.00000         1.00935e+01          7.24132        81.718     52.6900     0.796720     7.16043e-01     2.92363e-01
  -54.1611     2.83033e+04        0.00000         1.06614e+01          7.64538        81.675     52.6900     0.798122     7.17998e-01     2.91917e-01
  -55.0000     2.98968e+04        0.00000         1.12588e+01          8.07106        81.624     52.6900     0.799478     7.19910e-01     2.91147e-01
  -55.9346     3.19820e+04        0.00000         1.20370e+01          8.62646        81.552     52.6900     0.801088     7.22205e-01     2.90386e-01
  -56.7679     3.42126e+04        0.00000         1.28654e+01          9.21871        81.471     52.6900     0.802638     7.24438e-01     2.89810e-01
  -57.5068     3.65988e+04        0.00000         1.37475e+01          9.85029        81.382     52.6900     0.804131     7.26608e-01     2.89400e-01
  -58.1578     3.91514e+04        0.00000         1.46870e+01         10.52384        81.289     52.6900     0.805571     7.28717e-01     2.89137e-01
  -58.7269     4.18820e+04        0.00000         1.56876e+01         11.24222        81.190     52.6900     0.806959     7.30766e-01     2.89006e-01
  -59.2200     4.48031e+04        0.00000         1.67536e+01         12.00845        81.089     52.6900     0.808298     7.32754e-01     2.88992e-01
  -59.6426     4.79279e+04        0.00000         1.78895e+01         12.82581        80.986     52.6900     0.809590     7.34682e-01     2.89082e-01
  -60.0000     5.12707e+04        0.00000         1.91001e+01         13.69779        80.881     52.6900     0.810837     7.36551e-01     2.89264e-01
  -60.4220     5.66846e+04        0.00000         2.10521e+01         15.10538        80.723     52.6900     0.812612     7.39224e-01     2.89681e-01
  -60.7261     6.26702e+04        0.00000         2.31997e+01         16.65585        80.567     52.6900     0.814294     7.41767e-01     2.90245e-01
  -60.9272     6.92878e+04        0.00000         2.55633e+01         18.36412        80.413     52.6900     0.815884     7.44181e-01     2.90928e-01
  -61.0388     7.66042e+04        0.00000         2.81657e+01         20.24671        80.262     52.6900     0.817387     7.46469e-01     2.91704e-01
  -61.0736     8.46931e+04        0.00000         3.10320e+01         22.32194        80.116     52.6900     0.818804     7.48631e-01     2.92552e-01
  -60.8190     1.15310e+05        0.00000         4.18084e+01         30.13485        79.701     52.6900     0.822650     7.54523e-01     2.95414e-01
  -60.2271     1.56995e+05        0.00000         5.63699e+01         40.70772        79.346     52.6900     0.825784     7.59346e-01     2.98356e-01
  -59.4992     2.13749e+05        0.00000         7.60927e+01         55.04232        79.051     52.6900     0.828290     7.63217e-01     3.01112e-01
  -58.7644     2.91021e+05        0.00000         1.02854e+02         74.50499        78.813     52.6900     0.830259     7.66270e-01     3.03541e-01
  -58.0945     3.96226e+05        0.00000         1.39211e+02        100.95728        78.624     52.6900     0.831784     7.68641e-01     3.05588e-01
  -57.5213     5.39463e+05        0.00000         1.88647e+02        136.93392        78.476     52.6900     0.832950     7.70459e-01     3.07256e-01
  -57.0513     7.34482e+05        0.00000         2.55901e+02        185.88545        78.362     52.6900     0.833833     7.71839e-01     3.08581e-01
  -56.6774     1.00000e+06        0.00000         3.47427e+02        252.50890        78.276     52.6900     0.834496     7.72879e-01     3.09613e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                     Liq Den      Gas Den          
#   (F)         (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)     Kmin/Kmax
#---------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -----------
  455.661      6217.29          0.5000            1.23819           1.23819        52.6900     52.6900     0.431441     0.431441      1.00000
  453.833      6227.15          1.0000            1.23956           1.23856        52.6900     52.5186     0.432510     0.431453      0.99004
  450.000      6247.51          1.0000            1.24244           1.23932        52.6900     52.1661     0.434742     0.431503      0.96966
  445.000      6273.43          1.0000            1.24619           1.24029        52.6900     51.7156     0.437638     0.431589      0.94383
  440.000      6298.62          1.0000            1.24993           1.24122        52.6900     51.2761     0.440514     0.431703      0.91887
  435.000      6323.08          1.0000            1.25367           1.24212        52.6900     50.8473     0.443372     0.431846      0.89474
  430.000      6346.81          1.0000            1.25739           1.24298        52.6900     50.4290     0.446211     0.432016      0.87142
  425.000      6369.81          1.0000            1.26111           1.24381        52.6900     50.0211     0.449032     0.432215      0.84889
  420.000      6392.07          1.0000            1.26481           1.24461        52.6900     49.6232     0.451835     0.432443      0.82710
  415.000      6413.58          1.0000            1.26851           1.24538        52.6900     49.2351     0.454620     0.432700      0.80605
  410.000      6434.35          1.0000            1.27219           1.24612        52.6900     48.8567     0.457388     0.432986      0.78569
  405.000      6454.38          1.0000            1.27586           1.24682        52.6900     48.4878     0.460138     0.433301      0.76602
  400.000      6473.65          1.0000            1.27951           1.24750        52.6900     48.1282     0.462870     0.433645      0.74701
  395.000      6492.17          1.0000            1.28315           1.24814        52.6900     47.7777     0.465586     0.434020      0.72863
  390.000      6509.94          1.0000            1.28677           1.24876        52.6900     47.4362     0.468285     0.434425      0.71087
  385.000      6526.94          1.0000            1.29038           1.24935        52.6900     47.1036     0.470967     0.434861      0.69372
  380.000      6543.18          1.0000            1.29397           1.24991        52.6900     46.7797     0.473633     0.435327      0.67714
  375.000      6558.65          1.0000            1.29754           1.25044        52.6900     46.4643     0.476282     0.435826      0.66113
  370.000      6573.35          1.0000            1.30109           1.25095        52.6900     46.1574     0.478916     0.436357      0.64567
  365.000      6587.27          1.0000            1.30462           1.25143        52.6900     45.8590     0.481534     0.436920      0.63075
  360.000      6600.42          1.0000            1.30813           1.25188        52.6900     45.5688     0.484136     0.437517      0.61635
  355.000      6612.78          1.0000            1.31162           1.25231        52.6900     45.2868     0.486722     0.438148      0.60245
  350.000      6624.37          1.0000            1.31508           1.25271        52.6900     45.0130     0.489293     0.438814      0.58905
  345.000      6635.16          1.0000            1.31852           1.25310        52.6900     44.7473     0.491850     0.439515      0.57613
  340.000      6645.16          1.0000            1.32193           1.25346        52.6900     44.4897     0.494391     0.440253      0.56369
  335.000      6654.37          1.0000            1.32532           1.25380        52.6900     44.2401     0.496917     0.441029      0.55171
  330.000      6662.78          1.0000            1.32868           1.25412        52.6900     43.9985     0.499429     0.441843      0.54018
  325.000      6670.40          1.0000            1.33202           1.25442        52.6900     43.7650     0.501927     0.442697      0.52911
  320.000      6677.21          1.0000            1.33532           1.25471        52.6900     43.5395     0.504410     0.443591      0.51846
  315.000      6683.21          1.0000            1.33859           1.25498        52.6900     43.3221     0.506880     0.444528      0.50826
  310.000      6688.41          1.0000            1.34184           1.25523        52.6900     43.1128     0.509336     0.445509      0.49847
  305.000      6692.79          1.0000            1.34505           1.25548        52.6900     42.9117     0.511778     0.446535      0.48912
  300.000      6696.37          1.0000            1.34822           1.25572        52.6900     42.7188     0.514206     0.447608      0.48017
  295.000      6699.13          1.0000            1.35137           1.25595        52.6900     42.5343     0.516622     0.448729      0.47165
  290.000      6701.08          1.0000            1.35448           1.25619        52.6900     42.3584     0.519024     0.449901      0.46354
  285.000      6702.21          1.0000            1.35755           1.25642        52.6900     42.1910     0.521414     0.451127      0.45584
  280.000      6702.53          1.0000            1.36059           1.25665        52.6900     42.0326     0.523791     0.452407      0.44855
  275.000      6702.03          1.0000            1.36359           1.25689        52.6900     41.8831     0.526156     0.453745      0.44168
  270.000      6700.72          1.0000            1.36656           1.25715        52.6900     41.7430     0.528508     0.455143      0.43523
  265.000      6698.59          1.0000            1.36949           1.25742        52.6900     41.6124     0.530848     0.456605      0.42921
  260.000      6695.65          1.0000            1.37238           1.25772        52.6900     41.4916     0.533177     0.458134      0.42362
  255.000      6691.90          1.0000            1.37523           1.25805        52.6900     41.3811     0.535494     0.459733      0.41846
  250.000      6687.35          1.0000            1.37804           1.25841        52.6900     41.2812     0.537800     0.461407      0.41376
  245.000      6682.00          1.0000            1.38082           1.25882        52.6900     41.1924     0.540095     0.463159      0.40953
  240.000      6675.85          1.0000            1.38355           1.25929        52.6900     41.1153     0.542378     0.464994      0.40577
  235.000      6668.91          1.0000            1.38625           1.25982        52.6900     41.0503     0.544652     0.466918      0.40252
  230.000      6661.19          1.0000            1.38892           1.26043        52.6900     40.9982     0.546915     0.468936      0.39979
  225.000      6652.71          1.0000            1.39155           1.26113        52.6900     40.9597     0.549168     0.471055      0.39761
  220.000      6643.47          1.0000            1.39414           1.26194        52.6900     40.9357     0.551411     0.473280      0.39601
  215.000      6633.49          1.0000            1.39670           1.26287        52.6900     40.9271     0.553645     0.475621      0.39504
  210.000      6622.78          1.0000            1.39924           1.26394        52.6900     40.9351     0.555870     0.478084      0.39473
  205.000      6611.37          1.0000            1.40175           1.26519        52.6900     40.9608     0.558086     0.480681      0.39514
  200.000      6599.28          1.0000            1.40423           1.26663        52.6900     41.0058     0.560294     0.483420      0.39633
  195.000      6586.55          1.0000            1.40670           1.26829        52.6900     41.0715     0.562494     0.486313      0.39838
  190.000      6573.19          1.0000            1.40916           1.27021        52.6900     41.1598     0.564687     0.489372      0.40135
  185.000      6559.26          1.0000            1.41162           1.27243        52.6900     41.2728     0.566872     0.492612      0.40537
  180.000      6544.79          1.0000            1.41408           1.27499        52.6900     41.4127     0.569052     0.496048      0.41053
  175.000      6529.84          1.0000            1.41655           1.27796        52.6900     41.5824     0.571225     0.499695      0.41698
  170.000      6514.46          1.0000            1.41905           1.28138        52.6900     41.7847     0.573394     0.503573      0.42489
  165.000      6498.75          1.0000            1.42159           1.28534        52.6900     42.0231     0.575559     0.507701      0.43443
  160.000      6482.77          1.0000            1.42419           1.28991        52.6900     42.3014     0.577720     0.512099      0.44583
  155.000      6466.62          1.0000            1.42687           1.29518        52.6900     42.6239     0.579878     0.516791      0.45936
  150.000      6450.43          1.0000            1.42965           1.30128        52.6900     42.9952     0.582035     0.521797      0.47531
  145.000      6434.33          1.0000            1.43256           1.30830        52.6900     43.4204     0.584192     0.527141      0.49404
  140.000      6418.48          1.0000            1.43565           1.31640        52.6900     43.9048     0.586351     0.532844      0.51593
  135.000      6403.08          1.0000            1.43894           1.32572        52.6900     44.4538     0.588512     0.538922      0.54144
  130.000      6388.33          1.0000            1.44249           1.33643        52.6900     45.0729     0.590678     0.545388      0.57103
  125.000      6374.50          1.0000            1.44636           1.34868        52.6900     45.7667     0.592850     0.552247      0.60522
  120.000      6361.88          1.0000            1.45061           1.36266        52.6900     46.5391     0.595032     0.559491      0.64452
  115.000      6350.82          1.0000            1.45532           1.37853        52.6900     47.3924     0.597225     0.567103      0.68939
  110.000      6341.70          1.0000            1.46059           1.39645        52.6900     48.3268     0.599432     0.575046      0.74024
  105.000      6334.96          1.0000            1.46652           1.41656        52.6900     49.3404     0.601655     0.583275      0.79736
  100.000      6331.10          1.0000            1.47322           1.43899        52.6900     50.4285     0.603899     0.591727      0.86090
   95.000      6330.65          1.0000            1.48084           1.46385        52.6900     51.5844     0.606166     0.600334      0.93084
   91.061      6333.09          1.0000            1.48758           1.48512        52.6900     52.5322     0.607971     0.607152      0.98999
   90.436      6333.73          0.5000            1.48871           1.48871        52.6900     52.6900     0.608258     0.608258      1.00000
END

set output "Figures/Env_002_P_vs_T_1.pdf"
set xlabel "Temperature (F)"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.2e+04] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_002_LogP_vs_T_1.pdf"
set xlabel "Temperature (F)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_002_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using (1/($1+459.67)):2 with lines title "Dew Points", \
     $Env_BP using (1/($1+459.67)):2 with lines title "Bubble Points"
unset logscale y

set title "P-T Diagram for Reservoir Fluid A"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                    Liq Den       Gas Den             
#   (R)          (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   498.51     1.00000e-12        0.00000         1.81145e-15          1.00000       628.000     125.165     1.03805     3.74771e-16     1.98868e-17
   500.00     1.19996e-12        0.00000         2.16749e-15          1.00000       628.000     125.165     1.03790     4.48369e-16     2.37344e-17
   505.00     2.19090e-12        0.00000         3.92007e-15          1.00000       628.000     125.165     1.03742     8.10530e-16     4.25692e-17
   510.00     3.94646e-12        0.00000         6.99531e-15          1.00000       628.000     125.165     1.03692     1.44569e-15     7.53662e-17
   515.00     7.01625e-12        0.00000         1.23218e-14          1.00000       628.000     125.165     1.03643     2.54529e-15     1.31763e-16
   520.00     1.23165e-11        0.00000         2.14325e-14          1.00000       628.000     125.165     1.03593     4.42511e-15     2.27570e-16
   525.00     2.13562e-11        0.00000         3.68268e-14          1.00000       628.000     125.165     1.03542     7.59983e-15     3.88419e-16
   530.00     3.65909e-11        0.00000         6.25332e-14          1.00000       628.000     125.165     1.03491     1.28984e-14     6.55395e-16
   535.00     6.19712e-11        0.00000         1.04970e-13          1.00000       628.000     125.165     1.03440     2.16409e-14     1.09364e-15
   540.00     1.03782e-10        0.00000         1.74251e-13          1.00000       627.999     125.165     1.03388     3.59060e-14     1.80531e-15
   545.00     1.71914e-10        0.00000         2.86143e-13          1.00000       627.999     125.165     1.03335     5.89324e-14     2.94902e-15
   550.00     2.81772e-10        0.00000         4.64971e-13          1.00000       627.999     125.165     1.03282     9.57136e-14     4.76850e-15
   555.00     4.57100e-10        0.00000         7.47882e-13          1.00000       627.999     125.165     1.03229     1.53871e-13     7.63468e-15
   560.00     7.34141e-10        0.00000         1.19106e-12          1.00000       627.999     125.165     1.03175     2.44923e-13     1.21068e-14
   565.00     1.16768e-09        0.00000         1.87866e-12          1.00000       627.999     125.165     1.03120     3.86114e-13     1.90200e-14
   570.00     1.83978e-09        0.00000         2.93558e-12          1.00000       627.998     125.165     1.03066     6.03018e-13     2.96109e-14
   575.00     2.87222e-09        0.00000         4.54554e-12          1.00000       627.998     125.165     1.03010     9.33230e-13     4.56943e-14
   580.00     4.44414e-09        0.00000         6.97640e-12          1.00000       627.998     125.165     1.02954     1.43152e-12     6.99111e-14
   585.00     6.81684e-09        0.00000         1.06154e-11          1.00000       627.997     125.165     1.02898     2.17704e-12     1.06073e-13
   590.00     1.03683e-08        0.00000         1.60178e-11          1.00000       627.997     125.165     1.02841     3.28317e-12     1.59640e-13
   595.00     1.56406e-08        0.00000         2.39734e-11          1.00000       627.996     125.165     1.02783     4.91107e-12     2.38367e-13
   600.00     2.34058e-08        0.00000         3.55968e-11          1.00000       627.996     125.165     1.02725     7.28806e-12     3.53191e-13
   605.00     3.47542e-08        0.00000         5.24489e-11          1.00000       627.995     125.165     1.02666     1.07322e-11     5.19426e-13
   610.00     5.12143e-08        0.00000         7.67001e-11          1.00000       627.994     125.165     1.02607     1.56856e-11     7.58353e-13
   615.00     7.49140e-08        0.00000         1.11346e-10          1.00000       627.993     125.165     1.02548     2.27576e-11     1.09935e-12
   620.00     1.08794e-07        0.00000         1.60493e-10          1.00000       627.992     125.165     1.02487     3.27832e-11     1.58270e-12
   625.00     1.56891e-07        0.00000         2.29729e-10          1.00000       627.991     125.165     1.02426     4.68982e-11     2.26325e-12
   630.00     2.24708e-07        0.00000         3.26614e-10          1.00000       627.990     125.165     1.02365     6.66371e-11     3.21526e-12
   635.00     3.19699e-07        0.00000         4.61304e-10          1.00000       627.988     125.165     1.02303     9.40603e-11     4.53858e-12
   640.00     4.51898e-07        0.00000         6.47358e-10          1.00000       627.986     125.165     1.02241     1.31916e-10     6.36669e-12
   645.00     6.34723e-07        0.00000         9.02767e-10          1.00000       627.984     125.165     1.02177     1.83850e-10     8.87699e-12
   650.00     8.86016e-07        0.00000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   655.00     1.22936e-06        0.00000         1.72397e-09          1.00000       627.980     125.165     1.02049     3.50652e-10     1.69551e-11
   660.00     1.69573e-06        0.00000         2.36146e-09          1.00000       627.977     125.165     1.01984     4.80013e-10     2.32332e-11
   665.00     2.32564e-06        0.00000         3.21636e-09          1.00000       627.974     125.165     1.01919     6.53369e-10     3.16611e-11
   670.00     3.17168e-06        0.00000         4.35651e-09          1.00000       627.971     125.165     1.01853     8.84410e-10     4.29146e-11
   675.00     4.30189e-06        0.00000         5.86897e-09          1.00000       627.967     125.165     1.01786     1.19068e-09     5.78636e-11
   680.00     5.80374e-06        0.00000         7.86485e-09          1.00000       627.963     125.165     1.01719     1.59455e-09     7.76212e-11
   685.00     7.78913e-06        0.00000         1.04852e-08          1.00000       627.958     125.165     1.01650     2.12440e-09     1.03605e-10
   690.00     1.04005e-05        0.00000         1.39083e-08          1.00000       627.953     125.165     1.01582     2.81608e-09     1.37613e-10
   695.00     1.38184e-05        0.00000         1.83584e-08          1.00000       627.948     125.165     1.01512     3.71459e-09     1.81914e-10
   700.00     1.82703e-05        0.00000         2.41160e-08          1.00000       627.942     125.165     1.01442     4.87625e-09     2.39357e-10
   705.00     2.40419e-05        0.00000         3.15308e-08          1.00000       627.935     125.165     1.01372     6.37115e-09     3.13507e-10
   710.00     3.14900e-05        0.00000         4.10365e-08          1.00000       627.928     125.165     1.01300     8.28614e-09     4.08804e-10
   715.00     4.10584e-05        0.00000         5.31686e-08          1.00000       627.920     125.165     1.01228     1.07284e-08     5.30753e-10
   720.00     5.32969e-05        0.00000         6.85860e-08          1.00000       627.911     125.165     1.01155     1.38296e-08     6.86155e-10
   725.00     6.88835e-05        0.00000         8.80952e-08          1.00000       627.901     125.165     1.01082     1.77507e-08     8.83376e-10
   730.00     8.86509e-05        0.00000         1.12680e-07          1.00000       627.891     125.165     1.01008     2.26882e-08     1.13267e-09
   735.00     1.13618e-04        0.00000         1.43536e-07          1.00000       627.879     125.165     1.00933     2.88800e-08     1.44655e-09
   740.00     1.45025e-04        0.00000         1.82108e-07          1.00000       627.867     125.165     1.00857     3.66143e-08     1.84023e-09
   745.00     1.84379e-04        0.00000         2.30141e-07          1.00000       627.853     125.165     1.00781     4.62376e-08     2.33217e-09
   750.00     2.33502e-04        0.00000         2.89728e-07          1.00000       627.838     125.165     1.00704     5.81659e-08     2.94464e-09
   755.00     2.94588e-04        0.00000         3.63374e-07          1.00000       627.822     125.165     1.00626     7.28965e-08     3.70443e-09
   760.00     3.70270e-04        0.00000         4.54066e-07          1.00000       627.805     125.165     1.00547     9.10215e-08     4.64368e-09
   765.00     4.63700e-04        0.00000         5.65353e-07          1.00000       627.787     125.165     1.00467     1.13244e-07     5.80079e-09
   770.00     5.78632e-04        0.00000         7.01438e-07          1.00000       627.766     125.165     1.00387     1.40395e-07     7.22154e-09
   775.00     7.19528e-04        0.00000         8.67281e-07          1.00000       627.745     125.165     1.00306     1.73454e-07     8.96025e-09
   780.00     8.91669e-04        0.00000         1.06871e-06          1.00000       627.721     125.165     1.00224     2.13574e-07     1.10813e-08
   785.00     1.10129e-03        0.00000         1.31258e-06          1.00000       627.696     125.165     1.00141     2.62103e-07     1.36605e-08
   790.00     1.35572e-03        0.00000         1.60687e-06          1.00000       627.669     125.165     1.00058     3.20614e-07     1.67872e-08
   795.00     1.66356e-03        0.00000         1.96090e-06          1.00000       627.640     125.165     0.99973     3.90941e-07     2.05663e-08
   800.00     2.03486e-03        0.00000         2.38550e-06          1.00000       627.608     125.165     0.99888     4.75209e-07     2.51204e-08
   805.00     2.48134e-03        0.00000         2.89319e-06          1.00000       627.575     125.165     0.99801     5.75879e-07     3.05925e-08
   810.00     3.01662e-03        0.00000         3.49846e-06          1.00000       627.539     125.165     0.99714     6.95788e-07     3.71491e-08
   815.00     3.65648e-03        0.00000         4.21797e-06          0.99999       627.501     125.165     0.99626     8.38198e-07     4.49833e-08
   820.00     4.41915e-03        0.00000         5.07088e-06          0.99999       627.460     125.165     0.99537     1.00685e-06     5.43187e-08
   825.00     5.32565e-03        0.00000         6.07910e-06          0.99999       627.416     125.165     0.99447     1.20604e-06     6.54132e-08
   830.00     6.40012e-03        0.00000         7.26768e-06          0.99999       627.369     125.165     0.99356     1.44063e-06     7.85640e-08
   835.00     7.67026e-03        0.00000         8.66516e-06          0.99999       627.319     125.165     0.99264     1.71620e-06     9.41124e-08
   840.00     9.16769e-03        0.00000         1.03039e-05          0.99999       627.266     125.165     0.99171     2.03904e-06     1.12449e-07
   845.00     1.09285e-02        0.00000         1.22208e-05          0.99998       627.209     125.165     0.99077     2.41629e-06     1.34022e-07
   850.00     1.29937e-02        0.00000         1.44572e-05          0.99998       627.149     125.165     0.98982     2.85602e-06     1.59341e-07
   855.00     1.54099e-02        0.00000         1.70601e-05          0.99998       627.085     125.165     0.98886     3.36731e-06     1.88985e-07
   860.00     1.82298e-02        0.00000         2.00822e-05          0.99998       627.017     125.165     0.98789     3.96035e-06     2.23614e-07
   865.00     2.15129e-02        0.00000         2.35826e-05          0.99997       626.945     125.165     0.98691     4.64658e-06     2.63975e-07
   870.00     2.53262e-02        0.00000         2.76276e-05          0.99997       626.868     125.165     0.98592     5.43880e-06     3.10912e-07
   875.00     2.97450e-02        0.00000         3.22913e-05          0.99996       626.787     125.165     0.98491     6.35127e-06     3.65377e-07
   880.00     3.48538e-02        0.00000         3.76562e-05          0.99996       626.701     125.165     0.98390     7.39989e-06     4.28444e-07
   885.00     4.07472e-02        0.00000         4.38141e-05          0.99995       626.610     125.165     0.98287     8.60232e-06     5.01317e-07
   890.00     4.75307e-02        0.00000         5.08671e-05          0.99994       626.514     125.165     0.98183     9.97811e-06     5.85350e-07
   895.00     5.53220e-02        0.00000         5.89280e-05          0.99993       626.413     125.165     0.98078     1.15489e-05     6.82056e-07
   900.00     6.42517e-02        0.00000         6.81218e-05          0.99992       626.305     125.165     0.97971     1.33387e-05     7.93127e-07
   905.00     7.44649e-02        0.00000         7.85861e-05          0.99991       626.192     125.165     0.97864     1.53737e-05     9.20452e-07
   910.00     8.61223e-02        0.00000         9.04728e-05          0.99990       626.073     125.165     0.97755     1.76830e-05     1.06613e-06
   915.00     9.94014e-02        0.00000         1.03948e-04          0.99989       625.947     125.165     0.97645     2.02982e-05     1.23250e-06
   920.00     1.14498e-01        0.00000         1.19196e-04          0.99988       625.814     125.165     0.97533     2.32543e-05     1.42216e-06
   925.00     1.31628e-01        0.00000         1.36415e-04          0.99986       625.674     125.165     0.97420     2.65893e-05     1.63798e-06
   930.00     1.51028e-01        0.00000         1.55826e-04          0.99984       625.527     125.165     0.97306     3.03446e-05     1.88314e-06
   935.00     1.72958e-01        0.00000         1.77666e-04          0.99982       625.373     125.165     0.97190     3.45657e-05     2.16116e-06
   940.00     1.97702e-01        0.00000         2.02195e-04          0.99980       625.210     125.165     0.97073     3.93016e-05     2.47590e-06
   945.00     2.25572e-01        0.00000         2.29696e-04          0.99977       625.039     125.165     0.96954     4.46058e-05     2.83163e-06
   950.00     2.56908e-01        0.00000         2.60475e-04          0.99975       624.860     125.165     0.96834     5.05361e-05     3.23305e-06
   955.00     2.92078e-01        0.00000         2.94865e-04          0.99972       624.672     125.165     0.96712     5.71553e-05     3.68531e-06
   960.00     3.31485e-01        0.00000         3.33225e-04          0.99969       624.474     125.165     0.96589     6.45310e-05     4.19407e-06
   965.00     3.75567e-01        0.00000         3.75943e-04          0.99965       624.267     125.165     0.96464     7.27362e-05     4.76552e-06
   970.00     4.24795e-01        0.00000         4.23438e-04          0.99961       624.050     125.165     0.96337     8.18495e-05     5.40643e-06
   975.00     4.79684e-01        0.00000         4.76159e-04          0.99957       623.823     125.165     0.96209     9.19553e-05     6.12422e-06
   980.00     5.40786e-01        0.00000         5.34592e-04          0.99952       623.585     125.165     0.96079     1.03145e-04     6.92697e-06
   985.00     6.08701e-01        0.00000         5.99256e-04          0.99947       623.336     125.165     0.95948     1.15515e-04     7.82348e-06
   990.00     6.84072e-01        0.00000         6.70709e-04          0.99941       623.075     125.165     0.95814     1.29169e-04     8.82338e-06
   995.00     7.67594e-01        0.00000         7.49547e-04          0.99935       622.802     125.165     0.95679     1.44221e-04     9.93709e-06
  1000.00     8.60012e-01        0.00000         8.36410e-04          0.99929       622.517     125.165     0.95542     1.60788e-04     1.11760e-05
  1005.00     9.62127e-01        0.00000         9.31978e-04          0.99922       622.220     125.165     0.95403     1.78997e-04     1.25524e-05
  1010.00     1.07480e+00        0.00000         1.03698e-03          0.99914       621.909     125.165     0.95262     1.98984e-04     1.40797e-05
  1015.00     1.19894e+00        0.00000         1.15218e-03          0.99906       621.584     125.165     0.95119     2.20892e-04     1.57724e-05
  1020.00     1.33555e+00        0.00000         1.27842e-03          0.99897       621.245     125.165     0.94974     2.44876e-04     1.76463e-05
  1025.00     1.48566e+00        0.00000         1.41656e-03          0.99887       620.891     125.165     0.94827     2.71097e-04     1.97183e-05
  1030.00     1.65040e+00        0.00000         1.56754e-03          0.99877       620.522     125.165     0.94678     2.99728e-04     2.20068e-05
  1035.00     1.83096e+00        0.00000         1.73234e-03          0.99865       620.137     125.165     0.94526     3.30951e-04     2.45318e-05
  1040.00     2.02863e+00        0.00000         1.91200e-03          0.99853       619.736     125.165     0.94373     3.64960e-04     2.73148e-05
  1045.00     2.24474e+00        0.00000         2.10763e-03          0.99840       619.318     125.165     0.94217     4.01961e-04     3.03790e-05
  1050.00     2.48075e+00        0.00000         2.32039e-03          0.99826       618.882     125.165     0.94058     4.42168e-04     3.37494e-05
  1055.00     2.73818e+00        0.00000         2.55153e-03          0.99812       618.428     125.165     0.93898     4.85811e-04     3.74532e-05
  1060.00     3.01865e+00        0.00000         2.80235e-03          0.99796       617.956     125.165     0.93734     5.33130e-04     4.15194e-05
  1065.00     3.32388e+00        0.00000         3.07421e-03          0.99779       617.464     125.165     0.93569     5.84381e-04     4.59795e-05
  1070.00     3.65570e+00        0.00000         3.36857e-03          0.99761       616.953     125.165     0.93401     6.39832e-04     5.08673e-05
  1075.00     4.01603e+00        0.00000         3.68696e-03          0.99741       616.420     125.165     0.93230     6.99763e-04     5.62195e-05
  1080.00     4.40691e+00        0.00000         4.03098e-03          0.99721       615.866     125.165     0.93056     7.64474e-04     6.20752e-05
  1085.00     4.83051e+00        0.00000         4.40231e-03          0.99699       615.290     125.165     0.92879     8.34277e-04     6.84768e-05
  1090.00     5.28910e+00        0.00000         4.80274e-03          0.99676       614.692     125.165     0.92700     9.09500e-04     7.54700e-05
  1095.00     5.78508e+00        0.00000         5.23413e-03          0.99652       614.069     125.165     0.92518     9.90491e-04     8.31039e-05
  1100.00     6.32102e+00        0.00000         5.69844e-03          0.99625       613.422     125.165     0.92333     1.07761e-03     9.14312e-05
  1105.00     6.89957e+00        0.00000         6.19773e-03          0.99598       612.749     125.165     0.92144     1.17125e-03     1.00509e-04
  1110.00     7.52358e+00        0.00000         6.73415e-03          0.99569       612.051     125.165     0.91953     1.27180e-03     1.10399e-04
  1115.00     8.19603e+00        0.00000         7.30997e-03          0.99538       611.325     125.165     0.91758     1.37968e-03     1.21166e-04
  1120.00     8.92005e+00        0.00000         7.92757e-03          0.99505       610.571     125.165     0.91559     1.49535e-03     1.32883e-04
  1125.00     9.69898e+00        0.00000         8.58944e-03          0.99471       609.788     125.165     0.91358     1.61926e-03     1.45625e-04
  1130.00     1.05363e+01        0.00000         9.29818e-03          0.99435       608.974     125.165     0.91152     1.75190e-03     1.59476e-04
  1135.00     1.14357e+01        0.00000         1.00565e-02          0.99397       608.130     125.165     0.90943     1.89379e-03     1.74525e-04
  1140.00     1.24010e+01        0.00000         1.08674e-02          0.99356       607.253     125.165     0.90730     2.04548e-03     1.90867e-04
  1145.00     1.34364e+01        0.00000         1.17337e-02          0.99314       606.342     125.165     0.90514     2.20751e-03     2.08608e-04
  1150.00     1.45460e+01        0.00000         1.26587e-02          0.99270       605.397     125.165     0.90293     2.38050e-03     2.27858e-04
  1155.00     1.57346e+01        0.00000         1.36457e-02          0.99223       604.415     125.165     0.90068     2.56507e-03     2.48739e-04
  1160.00     1.70068e+01        0.00000         1.46981e-02          0.99174       603.396     125.165     0.89839     2.76188e-03     2.71383e-04
  1165.00     1.83677e+01        0.00000         1.58195e-02          0.99123       602.339     125.165     0.89605     2.97163e-03     2.95931e-04
  1170.00     1.98226e+01        0.00000         1.70139e-02          0.99069       601.240     125.165     0.89367     3.19504e-03     3.22537e-04
  1175.00     2.13771e+01        0.00000         1.82851e-02          0.99013       600.100     125.165     0.89124     3.43289e-03     3.51367e-04
  1180.00     2.30372e+01        0.00000         1.96374e-02          0.98954       598.917     125.165     0.88877     3.68599e-03     3.82601e-04
  1185.00     2.48090e+01        0.00000         2.10753e-02          0.98892       597.688     125.165     0.88624     3.95521e-03     4.16437e-04
  1190.00     2.66992e+01        0.00000         2.26033e-02          0.98827       596.412     125.165     0.88366     4.24145e-03     4.53088e-04
  1195.00     2.87148e+01        0.00000         2.42264e-02          0.98760       595.087     125.165     0.88102     4.54566e-03     4.92784e-04
  1200.00     3.08632e+01        0.00000         2.59497e-02          0.98689       593.710     125.165     0.87833     4.86887e-03     5.35779e-04
  1205.00     3.31521e+01        0.00000         2.77787e-02          0.98616       592.281     125.165     0.87558     5.21215e-03     5.82349e-04
  1210.00     3.55900e+01        0.00000         2.97190e-02          0.98539       590.796     125.165     0.87278     5.57665e-03     6.32795e-04
  1215.00     3.81855e+01        0.00000         3.17768e-02          0.98459       589.253     125.165     0.86990     5.96357e-03     6.87446e-04
  1220.00     4.09481e+01        0.00000         3.39584e-02          0.98375       587.649     125.165     0.86697     6.37421e-03     7.46664e-04
  1225.00     4.38877e+01        0.00000         3.62705e-02          0.98288       585.983     125.165     0.86396     6.80994e-03     8.10843e-04
  1230.00     4.70149e+01        0.00000         3.87204e-02          0.98198       584.250     125.165     0.86089     7.27224e-03     8.80419e-04
  1235.00     5.03410e+01        0.00000         4.13155e-02          0.98103       582.447     125.165     0.85774     7.76266e-03     9.55871e-04
  1240.00     5.38781e+01        0.00000         4.40641e-02          0.98005       580.572     125.165     0.85451     8.28288e-03     1.03773e-03
  1245.00     5.76391e+01        0.00000         4.69747e-02          0.97903       578.621     125.165     0.85121     8.83471e-03     1.12657e-03
  1250.00     6.16379e+01        0.00000         5.00564e-02          0.97796       576.590     125.165     0.84782     9.42008e-03     1.22305e-03
  1255.00     6.58894e+01        0.00000         5.33189e-02          0.97686       574.475     125.165     0.84434     1.00411e-02     1.32789e-03
  1260.00     7.04096e+01        0.00000         5.67729e-02          0.97570       572.271     125.165     0.84077     1.06999e-02     1.44188e-03
  1265.00     7.52157e+01        0.00000         6.04294e-02          0.97451       569.974     125.165     0.83711     1.13991e-02     1.56591e-03
  1270.00     8.03265e+01        0.00000         6.43006e-02          0.97326       567.578     125.165     0.83334     1.21412e-02     1.70098e-03
  1275.00     8.57622e+01        0.00000         6.83993e-02          0.97197       565.078     125.165     0.82947     1.29292e-02     1.84822e-03
  1280.00     9.15449e+01        0.00000         7.27397e-02          0.97063       562.468     125.165     0.82548     1.37661e-02     2.00887e-03
  1285.00     9.76985e+01        0.00000         7.73368e-02          0.96923       559.741     125.165     0.82138     1.46553e-02     2.18438e-03
  1290.00     1.04249e+02        0.00000         8.22073e-02          0.96778       556.889     125.165     0.81715     1.56008e-02     2.37634e-03
  1295.00     1.11227e+02        0.00000         8.73691e-02          0.96627       553.906     125.165     0.81278     1.66065e-02     2.58659e-03
  1300.00     1.18662e+02        0.00000         9.28418e-02          0.96470       550.781     125.165     0.80828     1.76771e-02     2.81724e-03
  1305.00     1.26590e+02        0.00000         9.86472e-02          0.96307       547.505     125.165     0.80362     1.88178e-02     3.07068e-03
  1310.00     1.35051e+02        0.00000         1.04809e-01          0.96138       544.068     125.165     0.79880     2.00341e-02     3.34971e-03
  1315.00     1.44088e+02        0.00000         1.11354e-01          0.95962       540.457     125.165     0.79381     2.13326e-02     3.65753e-03
  1320.00     1.53750e+02        0.00000         1.18311e-01          0.95778       536.658     125.165     0.78863     2.27204e-02     3.99791e-03
  1325.00     1.64094e+02        0.00000         1.25713e-01          0.95587       532.656     125.165     0.78325     2.42057e-02     4.37527e-03
  1330.00     1.75183e+02        0.00000         1.33599e-01          0.95388       528.434     125.165     0.77765     2.57979e-02     4.79483e-03
  1335.00     1.87088e+02        0.00000         1.42009e-01          0.95180       523.972     125.165     0.77182     2.75078e-02     5.26280e-03
  1340.00     1.99896e+02        0.00000         1.50993e-01          0.94964       519.246     125.165     0.76573     2.93480e-02     5.78670e-03
  1345.00     2.13703e+02        0.00000         1.60606e-01          0.94738       514.231     125.165     0.75935     3.13331e-02     6.37560e-03
  1350.00     2.28626e+02        0.00000         1.70915e-01          0.94501       508.893     125.165     0.75266     3.34806e-02     7.04070e-03
  1355.00     2.44804e+02        0.00000         1.81996e-01          0.94254       503.197     125.165     0.74561     3.58113e-02     7.79591e-03
  1360.00     2.62405e+02        0.00000         1.93942e-01          0.93994       497.097     125.165     0.73817     3.83507e-02     8.65881e-03
  1365.00     2.81636e+02        0.00000         2.06867e-01          0.93720       490.537     125.165     0.73028     4.11302e-02     9.65202e-03
  1370.00     3.02758e+02        0.00000         2.20911e-01          0.93432       483.448     125.165     0.72188     4.41895e-02     1.08052e-02
  1375.00     3.26106e+02        0.00000         2.36253e-01          0.93126       475.742     125.165     0.71287     4.75797e-02     1.21583e-02
  1380.00     3.52127e+02        0.00000         2.53126e-01          0.92802       467.303     125.165     0.70314     5.13691e-02     1.37666e-02
  1385.00     3.81433e+02        0.00000         2.71850e-01          0.92454       457.972     125.165     0.69253     5.56518e-02     1.57099e-02
  1390.00     4.14910e+02        0.00000         2.92877e-01          0.92079       447.521     125.165     0.68081     6.05641e-02     1.81090e-02
  1395.00     4.53927e+02        0.00000         3.16899e-01          0.91670       435.603     125.165     0.66763     6.63169e-02     2.11598e-02
  1400.00     5.00810e+02        0.00000         3.45076e-01          0.91213       421.630     125.165     0.65241     7.32697e-02     2.52128e-02
  1405.00     5.60178e+02        0.00000         3.79679e-01          0.90687       404.451     125.165     0.63395     8.21377e-02     3.10020e-02
  1410.00     6.44474e+02        0.00000         4.26745e-01          0.90030       380.996     125.165     0.60911     9.48503e-02     4.06256e-02
  1413.30     7.41511e+02        0.00000         4.77924e-01          0.89391       355.300     125.165     0.58221     1.09655e-01     5.40416e-02
  1414.50     8.53158e+02        0.00000         5.32862e-01          0.88796       327.411     125.165     0.55317     1.26903e-01     7.31375e-02
  1414.50     8.53715e+02        0.00000         5.33125e-01          0.88793       327.277     125.165     0.55303     1.26989e-01     7.32437e-02
  1413.44     9.65890e+02        0.00000         5.84110e-01          0.88335       301.033     125.165     0.52569     1.44529e-01     9.71986e-02
  1410.00     1.09280e+03        0.00000         6.36861e-01          0.87971       273.436     125.165     0.49670     1.64598e-01     1.31330e-01
  1405.00     1.21075e+03        0.00000         6.81363e-01          0.87769       249.739     125.165     0.47146     1.83431e-01     1.71286e-01
  1400.00     1.30364e+03        0.00000         7.13487e-01          0.87699       232.359     125.165     0.45265     1.98368e-01     2.09561e-01
  1395.00     1.38393e+03        0.00000         7.39268e-01          0.87699       218.223     125.165     0.43711     2.11340e-01     2.48374e-01
  1390.00     1.45622e+03        0.00000         7.60977e-01          0.87746       206.176     125.165     0.42368     2.23061e-01     2.88590e-01
  1385.00     1.52284e+03        0.00000         7.79775e-01          0.87828       195.628     125.165     0.41174     2.33891e-01     3.30693e-01
  1380.00     1.58516e+03        0.00000         7.96353e-01          0.87937       186.228     125.165     0.40095     2.44042e-01     3.75023e-01
  1375.00     1.64406e+03        0.00000         8.11163e-01          0.88068       177.747     125.165     0.39108     2.53650e-01     4.21852e-01
  1370.00     1.70015e+03        0.00000         8.24523e-01          0.88220       170.023     125.165     0.38197     2.62809e-01     4.71419e-01
  1365.00     1.75387e+03        0.00000         8.36667e-01          0.88388       162.938     125.165     0.37350     2.71589e-01     5.23947e-01
  1360.00     1.80556e+03        0.00000         8.47772e-01          0.88571       156.401     125.165     0.36559     2.80040e-01     5.79654e-01
  1355.00     1.85547e+03        0.00000         8.57978e-01          0.88768       150.341     125.165     0.35816     2.88203e-01     6.38757e-01
  1350.00     1.90381e+03        0.00000         8.67396e-01          0.88977       144.701     125.165     0.35116     2.96109e-01     7.01476e-01
  1345.00     1.95073e+03        0.00000         8.76118e-01          0.89197       139.435     125.165     0.34454     3.03784e-01     7.68037e-01
  1340.00     1.99639e+03        0.00000         8.84221e-01          0.89427       134.503     125.165     0.33827     3.11250e-01     8.38676e-01
  1335.00     2.04089e+03        0.00000         8.91768e-01          0.89668       129.873     125.165     0.33232     3.18523e-01     9.13636e-01
  1330.19     2.08269e+03        0.00000         8.98554e-01          0.89907       125.677     125.165     0.32687     3.25353e-01     9.90050e-01
  1329.58     2.08789e+03        0.50000         8.99379e-01          0.89938       125.165     125.165     0.32620     3.26203e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   576.79     3.39201e+03        0.00000         1.72828e+00          1.37666       171.355     125.165     0.87031     7.98083e-01     3.03487e-01
   576.65     3.62643e+03        0.00000         1.84149e+00          1.46897       170.906     125.165     0.87119     7.99824e-01     3.04341e-01
   576.53     3.87704e+03        0.00000         1.96179e+00          1.56731       170.444     125.165     0.87210     8.01609e-01     3.05311e-01
   576.45     4.14498e+03        0.00000         2.08962e+00          1.67206       169.970     125.165     0.87303     8.03435e-01     3.06394e-01
   576.39     4.43144e+03        0.00000         2.22543e+00          1.78363       169.487     125.165     0.87399     8.05303e-01     3.07589e-01
   576.38     4.73769e+03        0.00000         2.36972e+00          1.90245       168.996     125.165     0.87498     8.07212e-01     3.08892e-01
   576.84     6.61978e+03        0.00000         3.23890e+00          2.62319       166.475     125.165     0.88044     8.17333e-01     3.16871e-01
   578.27     9.24955e+03        0.00000         4.41561e+00          3.60799       164.012     125.165     0.88681     8.28251e-01     3.26676e-01
   580.66     1.29240e+04        0.00000         6.01207e+00          4.95221       161.793     125.165     0.89406     8.39683e-01     3.37304e-01
   583.87     1.80582e+04        0.00000         8.18566e+00          6.78795       159.931     125.165     0.90198     8.51258e-01     3.47769e-01
   587.67     2.52320e+04        0.00000         1.11576e+01          9.29976       158.465     125.165     0.91020     8.62553e-01     3.57333e-01
   591.79     3.52557e+04        0.00000         1.52388e+01         12.74696       157.366     125.165     0.91829     8.73156e-01     3.65598e-01
   595.95     4.92613e+04        0.00000         2.08666e+01         17.49482       156.577     125.165     0.92582     8.82723e-01     3.72468e-01
   599.90     6.88309e+04        0.00000         2.86553e+01         24.05759       156.026     125.165     0.93251     8.91029e-01     3.78032e-01
   603.45     9.61746e+04        0.00000         3.94663e+01         33.15800       155.648     125.165     0.93820     8.97988e-01     3.82463e-01
   606.50     1.34381e+05        0.00000         5.45063e+01         45.80948       155.390     125.165     0.94285     9.03634e-01     3.85946e-01
   609.01     1.87765e+05        0.00000         7.54635e+01         63.43056       155.214     125.165     0.94654     9.08090e-01     3.88651e-01
   611.02     2.62356e+05        0.00000         1.04697e+02         88.00447       155.093     125.165     0.94940     9.11527e-01     3.90727e-01
   612.58     3.66580e+05        0.00000         1.45505e+02        122.30228       155.009     125.165     0.95156     9.14129e-01     3.92299e-01
   613.77     5.12207e+05        0.00000         2.02493e+02        170.19510       154.950     125.165     0.95318     9.16072e-01     3.93477e-01
   614.66     7.15687e+05        0.00000         2.82096e+02        237.09068       154.908     125.165     0.95438     9.17506e-01     3.94350e-01
   615.32     1.00000e+06        0.00000         3.93304e+02        330.54377       154.879     125.165     0.95525     9.18556e-01     3.94992e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                     Liq Den      Gas Den           
#   (R)         (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
  1329.58      2087.89          0.5000            0.89938           0.89938        125.165     125.165     0.326203     0.326203     1.00000e+00
  1328.98      2093.09          1.0000            0.89969           0.90020        125.165     124.654     0.327052     0.325534     9.90048e-01
  1325.00      2126.77          1.0000            0.90175           0.90541        125.165     121.407     0.332553     0.321265     9.28027e-01
  1320.00      2168.31          1.0000            0.90440           0.91158        125.165     117.527     0.339332     0.316115     8.56853e-01
  1315.00      2209.00          1.0000            0.90713           0.91739        125.165     113.856     0.345969     0.311193     7.92399e-01
  1310.00      2248.89          1.0000            0.90994           0.92284        125.165     110.378     0.352471     0.306484     7.33862e-01
  1305.00      2288.02          1.0000            0.91281           0.92798        125.165     107.078     0.358845     0.301974     6.80559e-01
  1300.00      2326.44          1.0000            0.91575           0.93282        125.165     103.944     0.365099     0.297651     6.31905e-01
  1295.00      2364.19          1.0000            0.91875           0.93739        125.165     100.963     0.371239     0.293504     5.87395e-01
  1290.00      2401.29          1.0000            0.92181           0.94170        125.165      98.126     0.377270     0.289522     5.46595e-01
  1285.00      2437.78          1.0000            0.92493           0.94579        125.165      95.422     0.383197     0.285697     5.09123e-01
  1280.00      2473.67          1.0000            0.92810           0.94965        125.165      92.844     0.389024     0.282019     4.74648e-01
  1275.00      2509.01          1.0000            0.93133           0.95331        125.165      90.382     0.394756     0.278482     4.42879e-01
  1270.00      2543.79          1.0000            0.93460           0.95678        125.165      88.031     0.400396     0.275079     4.13559e-01
  1265.00      2578.06          1.0000            0.93793           0.96008        125.165      85.783     0.405948     0.271802     3.86460e-01
  1260.00      2611.81          1.0000            0.94130           0.96320        125.165      83.632     0.411415     0.268647     3.61382e-01
  1255.00      2645.07          1.0000            0.94472           0.96617        125.165      81.572     0.416800     0.265607     3.38145e-01
  1250.00      2677.86          1.0000            0.94819           0.96899        125.165      79.599     0.422105     0.262677     3.16589e-01
  1245.00      2710.18          1.0000            0.95170           0.97168        125.165      77.708     0.427333     0.259853     2.96570e-01
  1240.00      2742.04          1.0000            0.95525           0.97423        125.165      75.893     0.432487     0.257131     2.77960e-01
  1235.00      2773.47          1.0000            0.95884           0.97666        125.165      74.152     0.437569     0.254505     2.60643e-01
  1230.00      2804.46          1.0000            0.96248           0.97897        125.165      72.480     0.442581     0.251972     2.44514e-01
  1225.00      2835.03          1.0000            0.96615           0.98117        125.165      70.874     0.447525     0.249529     2.29479e-01
  1220.00      2865.18          1.0000            0.96985           0.98326        125.165      69.330     0.452402     0.247171     2.15453e-01
  1215.00      2894.93          1.0000            0.97360           0.98526        125.165      67.844     0.457216     0.244896     2.02357e-01
  1210.00      2924.28          1.0000            0.97738           0.98716        125.165      66.416     0.461966     0.242701     1.90121e-01
  1205.00      2953.24          1.0000            0.98119           0.98898        125.165      65.040     0.466655     0.240583     1.78682e-01
  1200.00      2981.80          1.0000            0.98504           0.99070        125.165      63.716     0.471285     0.238538     1.67979e-01
  1195.00      3009.99          1.0000            0.98892           0.99235        125.165      62.440     0.475856     0.236565     1.57960e-01
  1190.00      3037.80          1.0000            0.99283           0.99392        125.165      61.210     0.480370     0.234661     1.48576e-01
  1185.00      3065.24          1.0000            0.99677           0.99541        125.165      60.024     0.484829     0.232823     1.39781e-01
  1180.00      3092.31          1.0000            1.00075           0.99683        125.165      58.880     0.489233     0.231050     1.31535e-01
  1175.00      3119.02          1.0000            1.00475           0.99819        125.165      57.777     0.493585     0.229338     1.23798e-01
  1170.00      3145.37          1.0000            1.00878           0.99948        125.165      56.711     0.497884     0.227687     1.16537e-01
  1165.00      3171.35          1.0000            1.01284           1.00070        125.165      55.683     0.502133     0.226095     1.09720e-01
  1160.00      3196.99          1.0000            1.01692           1.00187        125.165      54.689     0.506331     0.224558     1.03315e-01
  1155.00      3222.27          1.0000            1.02103           1.00298        125.165      53.729     0.510481     0.223077     9.72972e-02
  1150.00      3247.20          1.0000            1.02517           1.00404        125.165      52.801     0.514583     0.221648     9.16398e-02
  1145.00      3271.79          1.0000            1.02933           1.00504        125.165      51.904     0.518638     0.220271     8.63197e-02
  1140.00      3296.03          1.0000            1.03351           1.00598        125.165      51.036     0.522647     0.218944     8.13152e-02
  1135.00      3319.92          1.0000            1.03772           1.00688        125.165      50.197     0.526612     0.217665     7.66061e-02
  1130.00      3343.47          1.0000            1.04195           1.00773        125.165      49.385     0.530531     0.216433     7.21737e-02
  1125.00      3366.68          1.0000            1.04620           1.00854        125.165      48.598     0.534408     0.215247     6.80007e-02
  1120.00      3389.55          1.0000            1.05048           1.00930        125.165      47.837     0.538241     0.214105     6.40709e-02
  1115.00      3412.08          1.0000            1.05477           1.01001        125.165      47.100     0.542033     0.213006     6.03693e-02
  1110.00      3434.27          1.0000            1.05908           1.01068        125.165      46.385     0.545784     0.211949     5.68818e-02
  1105.00      3456.12          1.0000            1.06341           1.01131        125.165      45.693     0.549494     0.210933     5.35955e-02
  1100.00      3477.63          1.0000            1.06776           1.01190        125.165      45.022     0.553165     0.209957     5.04981e-02
  1095.00      3498.81          1.0000            1.07213           1.01245        125.165      44.371     0.556796     0.209019     4.75784e-02
  1090.00      3519.64          1.0000            1.07652           1.01297        125.165      43.740     0.560389     0.208119     4.48257e-02
  1085.00      3540.14          1.0000            1.08092           1.01344        125.165      43.128     0.563945     0.207255     4.22300e-02
  1080.00      3560.30          1.0000            1.08533           1.01388        125.165      42.534     0.567463     0.206427     3.97822e-02
  1075.00      3580.11          1.0000            1.08977           1.01428        125.165      41.957     0.570945     0.205634     3.74736e-02
  1070.00      3599.59          1.0000            1.09421           1.01464        125.165      41.397     0.574391     0.204874     3.52960e-02
  1065.00      3618.73          1.0000            1.09867           1.01497        125.165      40.854     0.577801     0.204148     3.32418e-02
  1060.00      3637.53          1.0000            1.10314           1.01526        125.165      40.326     0.581177     0.203454     3.13039e-02
  1055.00      3655.98          1.0000            1.10762           1.01552        125.165      39.813     0.584518     0.202791     2.94757e-02
  1050.00      3674.09          1.0000            1.11212           1.01575        125.165      39.315     0.587826     0.202159     2.77507e-02
  1045.00      3691.86          1.0000            1.11662           1.01595        125.165      38.831     0.591100     0.201556     2.61232e-02
  1040.00      3709.28          1.0000            1.12114           1.01611        125.165      38.361     0.594342     0.200983     2.45876e-02
  1035.00      3726.36          1.0000            1.12566           1.01623        125.165      37.903     0.597552     0.200438     2.31387e-02
  1030.00      3743.09          1.0000            1.13019           1.01633        125.165      37.458     0.600730     0.199921     2.17717e-02
  1025.00      3759.47          1.0000            1.13473           1.01639        125.165      37.025     0.603876     0.199432     2.04818e-02
  1020.00      3775.50          1.0000            1.13928           1.01642        125.165      36.604     0.606992     0.198968     1.92649e-02
  1015.00      3791.17          1.0000            1.14383           1.01642        125.165      36.194     0.610078     0.198531     1.81167e-02
  1010.00      3806.49          1.0000            1.14839           1.01639        125.165      35.795     0.613133     0.198119     1.70335e-02
  1005.00      3821.46          1.0000            1.15295           1.01633        125.165      35.407     0.616159     0.197732     1.60117e-02
  1000.00      3836.07          1.0000            1.15751           1.01623        125.165      35.029     0.619157     0.197369     1.50479e-02
   995.00      3850.31          1.0000            1.16207           1.01611        125.165      34.661     0.622125     0.197030     1.41388e-02
   990.00      3864.20          1.0000            1.16664           1.01595        125.165      34.302     0.625065     0.196714     1.32814e-02
   985.00      3877.72          1.0000            1.17121           1.01576        125.165      33.953     0.627978     0.196420     1.24729e-02
   980.00      3890.88          1.0000            1.17578           1.01553        125.165      33.613     0.630863     0.196149     1.17105e-02
   975.00      3903.66          1.0000            1.18034           1.01528        125.165      33.281     0.633721     0.195900     1.09918e-02
   970.00      3916.08          1.0000            1.18491           1.01499        125.165      32.957     0.636552     0.195671     1.03143e-02
   965.00      3928.12          1.0000            1.18947           1.01467        125.165      32.642     0.639357     0.195464     9.67576e-03
   960.00      3939.78          1.0000            1.19402           1.01432        125.165      32.335     0.642136     0.195277     9.07403e-03
   955.00      3951.07          1.0000            1.19857           1.01393        125.165      32.035     0.644889     0.195110     8.50709e-03
   950.00      3961.98          1.0000            1.20312           1.01352        125.165      31.742     0.647618     0.194963     7.97303e-03
   945.00      3972.50          1.0000            1.20766           1.01307        125.165      31.457     0.650321     0.194835     7.47004e-03
   940.00      3982.63          1.0000            1.21218           1.01258        125.165      31.178     0.652999     0.194726     6.99641e-03
   935.00      3992.38          1.0000            1.21670           1.01206        125.165      30.907     0.655653     0.194636     6.55052e-03
   930.00      4001.73          1.0000            1.22121           1.01151        125.165      30.641     0.658284     0.194563     6.13084e-03
   925.00      4010.68          1.0000            1.22571           1.01092        125.165      30.382     0.660890     0.194508     5.73593e-03
   920.00      4019.24          1.0000            1.23019           1.01029        125.165      30.129     0.663474     0.194471     5.36442e-03
   915.00      4027.39          1.0000            1.23465           1.00963        125.165      29.882     0.666034     0.194451     5.01502e-03
   910.00      4035.14          1.0000            1.23911           1.00893        125.165      29.641     0.668571     0.194448     4.68649e-03
   905.00      4042.48          1.0000            1.24354           1.00820        125.165      29.405     0.671086     0.194462     4.37769e-03
   900.00      4049.41          1.0000            1.24796           1.00743        125.165      29.175     0.673579     0.194491     4.08750e-03
   895.00      4055.92          1.0000            1.25235           1.00662        125.165      28.950     0.676050     0.194537     3.81490e-03
   890.00      4062.01          1.0000            1.25673           1.00577        125.165      28.730     0.678499     0.194599     3.55890e-03
   885.00      4067.68          1.0000            1.26108           1.00488        125.165      28.515     0.680927     0.194675     3.31857e-03
   880.00      4072.92          1.0000            1.26540           1.00396        125.165      28.304     0.683334     0.194768     3.09302e-03
   875.00      4077.73          1.0000            1.26970           1.00299        125.165      28.098     0.685720     0.194875     2.88143e-03
   870.00      4082.11          1.0000            1.27398           1.00198        125.165      27.897     0.688086     0.194996     2.68300e-03
   865.00      4086.04          1.0000            1.27822           1.00092        125.165      27.700     0.690431     0.195133     2.49699e-03
   860.00      4089.54          1.0000            1.28243           0.99983        125.165      27.508     0.692756     0.195283     2.32268e-03
   855.00      4092.59          1.0000            1.28661           0.99869        125.165      27.319     0.695061     0.195448     2.15941e-03
   850.00      4095.18          1.0000            1.29076           0.99750        125.165      27.135     0.697347     0.195627     2.00654e-03
   845.00      4097.33          1.0000            1.29486           0.99627        125.165      26.955     0.699613     0.195819     1.86347e-03
   840.00      4099.01          1.0000            1.29893           0.99500        125.165      26.778     0.701861     0.196025     1.72963e-03
   835.00      4100.22          1.0000            1.30296           0.99367        125.165      26.605     0.704089     0.196244     1.60449e-03
   830.00      4100.97          1.0000            1.30695           0.99230        125.165      26.435     0.706299     0.196476     1.48753e-03
   825.00      4101.25          1.0000            1.31089           0.99088        125.165      26.270     0.708490     0.196721     1.37827e-03
   820.00      4101.05          1.0000            1.31479           0.98941        125.165      26.107     0.710663     0.196979     1.27625e-03
   815.00      4100.36          1.0000            1.31863           0.98788        125.165      25.948     0.712818     0.197250     1.18105e-03
   810.00      4099.19          1.0000            1.32243           0.98630        125.165      25.792     0.714956     0.197533     1.09225e-03
   805.00      4097.52          1.0000            1.32617           0.98467        125.165      25.639     0.717075     0.197829     1.00947e-03
   800.00      4095.36          1.0000            1.32986           0.98298        125.165      25.489     0.719178     0.198137     9.32348e-04
   795.00      4092.69          1.0000            1.33348           0.98124        125.165      25.342     0.721263     0.198457     8.60530e-04
   790.00      4089.52          1.0000            1.33705           0.97944        125.165      25.198     0.723331     0.198789     7.93694e-04
   785.00      4085.83          1.0000            1.34055           0.97758        125.165      25.057     0.725382     0.199133     7.31531e-04
   780.00      4081.63          1.0000            1.34398           0.97566        125.165      24.918     0.727417     0.199489     6.73751e-04
   775.00      4076.90          1.0000            1.34735           0.97368        125.165      24.783     0.729436     0.199857     6.20077e-04
   770.00      4071.63          1.0000            1.35064           0.97163        125.165      24.649     0.731438     0.200236     5.70250e-04
   765.00      4065.84          1.0000            1.35386           0.96952        125.165      24.519     0.733424     0.200627     5.24025e-04
   760.00      4059.50          1.0000            1.35699           0.96734        125.165      24.391     0.735395     0.201029     4.81171e-04
   755.00      4052.62          1.0000            1.36005           0.96509        125.165      24.265     0.737349     0.201443     4.41469e-04
   750.00      4045.18          1.0000            1.36302           0.96278        125.165      24.141     0.739289     0.201868     4.04714e-04
   745.00      4037.18          1.0000            1.36590           0.96039        125.165      24.020     0.741212     0.202304     3.70711e-04
   740.00      4028.61          1.0000            1.36868           0.95793        125.165      23.901     0.743121     0.202752     3.39278e-04
   735.00      4019.48          1.0000            1.37137           0.95539        125.165      23.784     0.745015     0.203211     3.10242e-04
   730.00      4009.76          1.0000            1.37396           0.95278        125.165      23.670     0.746894     0.203682     2.83442e-04
   725.00      3999.46          1.0000            1.37645           0.95008        125.165      23.557     0.748758     0.204163     2.58726e-04
   720.00      3988.57          1.0000            1.37883           0.94731        125.165      23.446     0.750608     0.204656     2.35950e-04
   715.00      3977.08          1.0000            1.38109           0.94445        125.165      23.338     0.752444     0.205160     2.14978e-04
   710.00      3964.98          1.0000            1.38324           0.94151        125.165      23.231     0.754265     0.205675     1.95685e-04
   705.00      3952.28          1.0000            1.38527           0.93847        125.165      23.126     0.756073     0.206202     1.77952e-04
   700.00      3938.95          1.0000            1.38717           0.93535        125.165      23.023     0.757866     0.206740     1.61667e-04
   695.00      3924.99          1.0000            1.38893           0.93214        125.165      22.922     0.759646     0.207289     1.46726e-04
   690.00      3910.40          1.0000            1.39056           0.92883        125.165      22.822     0.761413     0.207850     1.33030e-04
   685.00      3895.17          1.0000            1.39205           0.92542        125.165      22.724     0.763166     0.208423     1.20487e-04
   680.00      3879.29          1.0000            1.39340           0.92191        125.165      22.628     0.764905     0.209007     1.09012e-04
   675.00      3862.75          1.0000            1.39458           0.91830        125.165      22.534     0.766632     0.209602     9.85245e-05
   670.00      3845.54          1.0000            1.39561           0.91458        125.165      22.441     0.768345     0.210210     8.89487e-05
   665.00      3827.67          1.0000            1.39648           0.91076        125.165      22.349     0.770046     0.210829     8.02146e-05
   660.00      3809.11          1.0000            1.39717           0.90682        125.165      22.259     0.771734     0.211461     7.22567e-05
   655.00      3789.86          1.0000            1.39769           0.90276        125.165      22.171     0.773410     0.212104     6.50139e-05
   650.00      3769.91          1.0000            1.39802           0.89859        125.165      22.084     0.775073     0.212761     5.84290e-05
   645.00      3749.25          1.0000            1.39816           0.89430        125.165      21.999     0.776724     0.213429     5.24492e-05
   640.00      3727.88          1.0000            1.39810           0.88988        125.165      21.914     0.778363     0.214111     4.70251e-05
   635.00      3705.78          1.0000            1.39784           0.88533        125.165      21.832     0.779989     0.214806     4.21107e-05
   630.00      3682.95          1.0000            1.39736           0.88065        125.165      21.750     0.781604     0.215515     3.76636e-05
   625.00      3659.38          1.0000            1.39666           0.87583        125.165      21.670     0.783207     0.216237     3.36441e-05
   620.00      3635.05          1.0000            1.39572           0.87087        125.165      21.591     0.784798     0.216973     3.00157e-05
   615.00      3609.96          1.0000            1.39455           0.86576        125.165      21.514     0.786378     0.217724     2.67445e-05
   610.00      3584.10          1.0000            1.39313           0.86051        125.165      21.438     0.787947     0.218489     2.37991e-05
   605.00      3557.45          1.0000            1.39145           0.85510        125.165      21.363     0.789504     0.219270     2.11506e-05
   600.00      3530.02          1.0000            1.38951           0.84953        125.165      21.289     0.791050     0.220067     1.87722e-05
   595.00      3501.78          1.0000            1.38728           0.84380        125.165      21.216     0.792585     0.220880     1.66392e-05
   590.00      3472.72          1.0000            1.38477           0.83789        125.165      21.145     0.794109     0.221710     1.47291e-05
   585.00      3442.85          1.0000            1.38196           0.83182        125.165      21.074     0.795622     0.222557     1.30209e-05
   580.00      3412.14          1.0000            1.37883           0.82556        125.165      21.005     0.797125     0.223423     1.14954e-05
   576.79      3392.00          1.0000            1.37666           0.82145        125.165      20.961     0.798083     0.223988     1.06052e-05
END

set output "Figures/Env_003_P_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:7.0e+03] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_003_LogP_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "Vapor Pressure of CO2"
show title

$Env_VP << END
#   Temp        Sat Pres                                          Liq Den       Gas Den
#   (R)          (psia)        Liq Z-Factor      Gas Z-Factor     (g/cm3)       (g/cm3)
#---------   -------------   ---------------   ---------------   ---------   -------------
  547.570     1.07160e+03      3.05301e-01         0.30530        0.42109     4.21089e-01
  545.000     1.03815e+03      2.40343e-01         0.37807        0.52064     3.30977e-01
  540.000     9.75320e+02      1.98880e-01         0.43448        0.59658     2.73080e-01
  535.000     9.15388e+02      1.72709e-01         0.47527        0.65080     2.36493e-01
  530.000     8.58258e+02      1.52913e-01         0.50936        0.69568     2.08847e-01
  525.000     8.03836e+02      1.36865e-01         0.53937        0.73489     1.86479e-01
  520.000     7.52033e+02      1.23357e-01         0.56652        0.77015     1.67697e-01
  515.000     7.02760e+02      1.11713e-01         0.59149        0.80243     1.51552e-01
  510.000     6.55934e+02      1.01510e-01         0.61470        0.83232     1.37447e-01
  505.000     6.11470e+02      9.24635e-02         0.63644        0.86024     1.24979e-01
  500.000     5.69287e+02      8.43701e-02         0.65690        0.88651     1.13859e-01
  495.000     5.29307e+02      7.70790e-02         0.67626        0.91133     1.03872e-01
  490.000     4.91453e+02      7.04748e-02         0.69461        0.93489     9.48534e-02
  485.000     4.55648e+02      6.44667e-02         0.71206        0.95733     8.66725e-02
  480.000     4.21819e+02      5.89818e-02         0.72867        0.97876     7.92250e-02
  475.000     3.89894e+02      5.39606e-02         0.74451        0.99928     7.24253e-02
  470.000     3.59802e+02      4.93535e-02         0.75963        1.01896     6.62022e-02
  465.000     3.31473e+02      4.51189e-02         0.77407        1.03787     6.04959e-02
  460.000     3.04839e+02      4.12214e-02         0.78786        1.05608     5.52553e-02
  455.000     2.79834e+02      3.76305e-02         0.80104        1.07364     5.04367e-02
  450.000     2.56393e+02      3.43198e-02         0.81363        1.09058     4.60020e-02
  445.000     2.34450e+02      3.12659e-02         0.82565        1.10695     4.19181e-02
  440.000     2.13944e+02      2.84485e-02         0.83714        1.12279     3.81556e-02
  435.000     1.94812e+02      2.58493e-02         0.84810        1.13812     3.46887e-02
  430.000     1.76994e+02      2.34520e-02         0.85856        1.15297     3.14941e-02
  425.000     1.60430e+02      2.12419e-02         0.86852        1.16738     2.85513e-02
  420.000     1.45062e+02      1.92057e-02         0.87801        1.18136     2.58413e-02
  415.000     1.30833e+02      1.73313e-02         0.88703        1.19494     2.33474e-02
  410.000     1.17686e+02      1.56075e-02         0.89561        1.20814     2.10539e-02
  405.000     1.05566e+02      1.40242e-02         0.90374        1.22096     1.89468e-02
  400.000     9.44204e+01      1.25717e-02         0.91144        1.23344     1.70132e-02
  395.000     8.41953e+01      1.12415e-02         0.91873        1.24559     1.52409e-02
  390.000     7.48394e+01      1.00252e-02         0.92561        1.25742     1.36190e-02
  385.000     6.63024e+01      8.91529e-03         0.93209        1.26894     1.21372e-02
  380.000     5.85351e+01      7.90448e-03         0.93819        1.28017     1.07858e-02
  375.000     5.14898e+01      6.98604e-03         0.94391        1.29112     9.55586e-03
  370.000     4.51197e+01      6.15358e-03         0.94926        1.30180     8.43896e-03
  365.000     3.93797e+01      5.40106e-03         0.95426        1.31223     7.42716e-03
  360.000     3.42258e+01      4.72277e-03         0.95891        1.32240     6.51301e-03
  355.000     2.96156e+01      4.11327e-03         0.96323        1.33233     5.68946e-03
  350.000     2.55080e+01      3.56740e-03         0.96723        1.34204     4.94981e-03
  345.000     2.18635e+01      3.08026e-03         0.97091        1.35151     4.28775e-03
  340.000     1.86442e+01      2.64719e-03         0.97430        1.36078     3.69727e-03
  335.000     1.58136e+01      2.26374e-03         0.97740        1.36984     3.17267e-03
  330.000     1.33372e+01      1.92572e-03         0.98022        1.37869     2.70854e-03
  325.000     1.11818e+01      1.62912e-03         0.98278        1.38735     2.29975e-03
  320.000     9.31620e+00      1.37015e-03         0.98510        1.39582     1.94141e-03
  315.000     7.71072e+00      1.14522e-03         0.98718        1.40412     1.62891e-03
  310.000     6.33762e+00      9.50971e-04         0.98904        1.41223     1.35788e-03
  305.000     5.17089e+00      7.84211e-04         0.99069        1.42017     1.12418e-03
  300.000     4.18636e+00      6.41963e-04         0.99215        1.42795     9.23949e-04
  295.000     3.36162e+00      5.21448e-04         0.99343        1.43557     7.53529e-04
  290.000     2.67609e+00      4.20083e-04         0.99454        1.44303     6.09521e-04
  285.000     2.11093e+00      3.35481e-04         0.99550        1.45034     4.88760e-04
  280.000     1.64907e+00      2.65448e-04         0.99633        1.45750     3.88316e-04
  275.000     1.27510e+00      2.07981e-04         0.99703        1.46452     3.05499e-04
  270.000     9.75265e-01      1.61264e-04         0.99763        1.47140     2.37848e-04
  265.000     7.37375e-01      1.23661e-04         0.99812        1.47815     1.83134e-04
  260.000     5.50720e-01      9.37153e-05         0.99853        1.48476     1.39350e-04
  255.000     4.05991e-01      7.01354e-05         0.99886        1.49124     1.04708e-04
  250.000     2.95178e-01      5.17914e-05         0.99913        1.49760     7.76302e-05
  245.000     2.11468e-01      3.77040e-05         0.99935        1.50383     5.67377e-05
  240.000     1.49134e-01      2.70340e-05         0.99952        1.50995     4.08398e-05
  235.000     1.03423e-01      1.90710e-05         0.99965        1.51595     2.89209e-05
  230.000     7.04482e-02      1.32216e-05         0.99975        1.52184     2.01262e-05
  225.000     4.70750e-02      8.99712e-06         0.99982        1.52761     1.37466e-05
  220.000     3.08165e-02      6.00135e-06         0.99988        1.53328     9.20288e-06
  215.000     1.97333e-02      3.91811e-06         0.99992        1.53884     6.02985e-06
  210.000     1.23402e-02      2.49967e-06         0.99994        1.54430     3.86044e-06
  205.000     7.52267e-03      1.55558e-06         0.99996        1.54965     2.41070e-06
  200.000     4.46148e-03      9.42440e-07         0.99998        1.55491     1.46544e-06
  195.000     2.56856e-03      5.54653e-07         0.99999        1.56006     8.65306e-07
  190.000     1.43201e-03      3.16338e-07         0.99999        1.56513     4.95113e-07
  185.000     7.71028e-04      1.74374e-07         1.00000        1.57009     2.73785e-07
  180.000     3.99720e-04      9.26231e-08         1.00000        1.57497     1.45879e-07
  175.000     1.98856e-04      4.72520e-08         1.00000        1.57976     7.46467e-08
  170.000     9.45765e-05      2.30655e-08         1.00000        1.58446     3.65463e-08
  165.000     4.28199e-05      1.07282e-08         1.00000        1.58907     1.70479e-08
  160.000     1.83675e-05      4.73218e-09         1.00000        1.59359     7.54117e-09
  155.000     7.42412e-06      1.96896e-09         1.00000        1.59803     3.14646e-09
  150.000     2.81035e-06      7.68084e-10         1.00000        1.60239     1.23077e-09
  145.000     9.89343e-07      2.78972e-10         1.00000        1.60667     4.48216e-10
  140.000     3.21302e-07      9.35912e-11         1.00000        1.61087     1.50763e-10
  135.000     9.53761e-08      2.87373e-11         1.00000        1.61498     4.64103e-11
  130.000     2.56019e-08      7.99069e-12         1.00000        1.61902     1.29371e-11
  125.000     6.13764e-09      1.98740e-12         1.00000        1.62299     3.22552e-12
  120.000     1.29507e-09      4.35780e-13         1.00000        1.62688     7.08960e-13
  115.000     2.36428e-10      8.28207e-14         1.00000        1.63069     1.35055e-13
  110.000     3.65914e-11      1.33700e-14         1.00000        1.63443     2.18522e-14
  105.000     4.68584e-12      1.78965e-15         1.00000        1.63809     2.93161e-15
  101.548     1.00000e-12      3.94312e-16         1.00000        1.64058     6.46900e-16
END

set output "Figures/Env_004_LogP_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_VP using 1:2 with lines notitle
unset logscale y

set output "Figures/Env_004_LogP_vs_TI_1.pdf"
set xlabel "1/Temperature (1/R)"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_VP using (1/$1):2 with lines notitle
unset logscale y

set title "P-X Diagram for Reservoir Fluid A with CO2"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-12        1.00000e+00        3.51617e-13        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-12        1.00000e+00        7.03234e-13        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-12        1.00000e+00        1.75809e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-11        1.00000e+00        3.51617e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-11        1.00000e+00        7.03234e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-11        1.00000e+00        1.75809e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-10        1.00000e+00        3.51617e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-10        1.00000e+00        7.03234e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-10        1.00000e+00        1.75809e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-09        1.00000e+00        3.51617e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-09        1.00000e+00        7.03234e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-09        1.00000e+00        1.75809e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-08        1.00000e+00        3.51617e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-08        1.00000e+00        7.03234e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-08        1.00000e+00        1.75809e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-07        1.00000e+00        3.51617e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-07        1.00000e+00        7.03234e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-07        1.00000e+00        1.75809e-07        1.00000e+00       8.86017e-07        0.000000         1.25126e-09          1.00000       627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-06        9.99999e-01        3.51617e-07        1.00000e+00       8.86017e-07        0.000000         1.25127e-09          1.00000       627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   2.00000e-06        9.99998e-01        7.03235e-07        9.99999e-01       8.86018e-07        0.000000         1.25127e-09          1.00000       627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   5.00000e-06        9.99995e-01        1.75809e-06        9.99998e-01       8.86021e-07        0.000000         1.25127e-09          1.00000       627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   1.00000e-05        9.99990e-01        3.51619e-06        9.99996e-01       8.86025e-07        0.000000         1.25128e-09          1.00000       627.982     125.164     1.02114     2.54665e-10     1.23038e-11
   2.00000e-05        9.99980e-01        7.03243e-06        9.99993e-01       8.86034e-07        0.000000         1.25129e-09          1.00000       627.982     125.163     1.02114     2.54666e-10     1.23038e-11
   5.00000e-05        9.99950e-01        1.75814e-05        9.99982e-01       8.86061e-07        0.000000         1.25133e-09          1.00000       627.982     125.161     1.02114     2.54668e-10     1.23038e-11
   1.00000e-04        9.99900e-01        3.51640e-05        9.99965e-01       8.86105e-07        0.000000         1.25139e-09          1.00000       627.982     125.156     1.02114     2.54673e-10     1.23038e-11
   2.00000e-04        9.99800e-01        7.03325e-05        9.99930e-01       8.86194e-07        0.000000         1.25151e-09          1.00000       627.982     125.148     1.02114     2.54682e-10     1.23038e-11
   5.00000e-04        9.99500e-01        1.75866e-04        9.99824e-01       8.86459e-07        0.000000         1.25189e-09          1.00000       627.982     125.124     1.02114     2.54709e-10     1.23038e-11
   1.00000e-03        9.99000e-01        3.51845e-04        9.99648e-01       8.86903e-07        0.000000         1.25252e-09          1.00000       627.982     125.083     1.02114     2.54753e-10     1.23038e-11
   2.00000e-03        9.98000e-01        7.04147e-04        9.99296e-01       8.87792e-07        0.000000         1.25377e-09          1.00000       627.982     125.002     1.02114     2.54843e-10     1.23038e-11
   5.00000e-03        9.95000e-01        1.76380e-03        9.98236e-01       8.90469e-07        0.000000         1.25755e-09          1.00000       627.982     124.759     1.02114     2.55114e-10     1.23038e-11
   1.00000e-02        9.90000e-01        3.53912e-03        9.96461e-01       8.94966e-07        0.000000         1.26390e-09          1.00000       627.982     124.353     1.02114     2.55568e-10     1.23038e-11
   2.00000e-02        9.80000e-01        7.12473e-03        9.92875e-01       9.04098e-07        0.000000         1.27680e-09          1.00000       627.982     123.541     1.02114     2.56491e-10     1.23038e-11
   3.00000e-02        9.70000e-01        1.07578e-02        9.89242e-01       9.13419e-07        0.000000         1.28996e-09          1.00000       627.982     122.730     1.02114     2.57433e-10     1.23038e-11
   4.00000e-02        9.60000e-01        1.44392e-02        9.85561e-01       9.22934e-07        0.000000         1.30340e-09          1.00000       627.982     121.918     1.02114     2.58395e-10     1.23038e-11
   5.00000e-02        9.50000e-01        1.81699e-02        9.81830e-01       9.32649e-07        0.000000         1.31712e-09          1.00000       627.982     121.107     1.02114     2.59377e-10     1.23038e-11
   6.00000e-02        9.40000e-01        2.19510e-02        9.78049e-01       9.42570e-07        0.000000         1.33113e-09          1.00000       627.982     120.295     1.02114     2.60379e-10     1.23038e-11
   7.00000e-02        9.30000e-01        2.57834e-02        9.74217e-01       9.52706e-07        0.000000         1.34545e-09          1.00000       627.982     119.484     1.02114     2.61404e-10     1.23038e-11
   8.00000e-02        9.20000e-01        2.96683e-02        9.70332e-01       9.63061e-07        0.000000         1.36007e-09          1.00000       627.982     118.672     1.02114     2.62450e-10     1.23038e-11
   9.00000e-02        9.10000e-01        3.36066e-02        9.66393e-01       9.73644e-07        0.000000         1.37502e-09          1.00000       627.982     117.861     1.02114     2.63520e-10     1.23038e-11
   1.00000e-01        9.00000e-01        3.75996e-02        9.62400e-01       9.84463e-07        0.000000         1.39029e-09          1.00000       627.982     117.049     1.02114     2.64613e-10     1.23038e-11
   1.10000e-01        8.90000e-01        4.16483e-02        9.58352e-01       9.95524e-07        0.000000         1.40591e-09          1.00000       627.982     116.238     1.02114     2.65731e-10     1.23038e-11
   1.20000e-01        8.80000e-01        4.57540e-02        9.54246e-01       1.00684e-06        0.000000         1.42189e-09          1.00000       627.982     115.426     1.02114     2.66874e-10     1.23038e-11
   1.30000e-01        8.70000e-01        4.99178e-02        9.50082e-01       1.01841e-06        0.000000         1.43823e-09          1.00000       627.982     114.614     1.02114     2.68044e-10     1.23038e-11
   1.40000e-01        8.60000e-01        5.41410e-02        9.45859e-01       1.03025e-06        0.000000         1.45496e-09          1.00000       627.982     113.803     1.02114     2.69241e-10     1.23038e-11
   1.50000e-01        8.50000e-01        5.84248e-02        9.41575e-01       1.04237e-06        0.000000         1.47208e-09          1.00000       627.982     112.991     1.02114     2.70466e-10     1.23038e-11
   1.60000e-01        8.40000e-01        6.27706e-02        9.37229e-01       1.05478e-06        0.000000         1.48960e-09          1.00000       627.982     112.180     1.02114     2.71720e-10     1.23038e-11
   1.70000e-01        8.30000e-01        6.71798e-02        9.32820e-01       1.06749e-06        0.000000         1.50755e-09          1.00000       627.982     111.368     1.02114     2.73004e-10     1.23038e-11
   1.80000e-01        8.20000e-01        7.16537e-02        9.28346e-01       1.08051e-06        0.000000         1.52593e-09          1.00000       627.982     110.557     1.02114     2.74320e-10     1.23038e-11
   1.90000e-01        8.10000e-01        7.61938e-02        9.23806e-01       1.09385e-06        0.000000         1.54477e-09          1.00000       627.982     109.745     1.02114     2.75668e-10     1.23038e-11
   2.00000e-01        8.00000e-01        8.08015e-02        9.19199e-01       1.10752e-06        0.000000         1.56408e-09          1.00000       627.982     108.934     1.02114     2.77050e-10     1.23038e-11
   2.10000e-01        7.90000e-01        8.54783e-02        9.14522e-01       1.12154e-06        0.000000         1.58388e-09          1.00000       627.982     108.122     1.02114     2.78467e-10     1.23038e-11
   2.20000e-01        7.80000e-01        9.02260e-02        9.09774e-01       1.13592e-06        0.000000         1.60418e-09          1.00000       627.982     107.311     1.02114     2.79920e-10     1.23038e-11
   2.30000e-01        7.70000e-01        9.50459e-02        9.04954e-01       1.15067e-06        0.000000         1.62502e-09          1.00000       627.982     106.499     1.02114     2.81411e-10     1.23038e-11
   2.40000e-01        7.60000e-01        9.99399e-02        9.00060e-01       1.16581e-06        0.000000         1.64640e-09          1.00000       627.982     105.687     1.02114     2.82941e-10     1.23038e-11
   2.50000e-01        7.50000e-01        1.04910e-01        8.95090e-01       1.18136e-06        0.000000         1.66835e-09          1.00000       627.982     104.876     1.02114     2.84512e-10     1.23038e-11
   2.60000e-01        7.40000e-01        1.09957e-01        8.90043e-01       1.19732e-06        0.000000         1.69090e-09          1.00000       627.982     104.064     1.02114     2.86125e-10     1.23038e-11
   2.70000e-01        7.30000e-01        1.15084e-01        8.84916e-01       1.21372e-06        0.000000         1.71406e-09          1.00000       627.982     103.253     1.02114     2.87783e-10     1.23038e-11
   2.80000e-01        7.20000e-01        1.20291e-01        8.79709e-01       1.23058e-06        0.000000         1.73787e-09          1.00000       627.982     102.441     1.02114     2.89486e-10     1.23038e-11
   2.90000e-01        7.10000e-01        1.25582e-01        8.74418e-01       1.24791e-06        0.000000         1.76234e-09          1.00000       627.982     101.630     1.02114     2.91238e-10     1.23038e-11
   3.00000e-01        7.00000e-01        1.30958e-01        8.69042e-01       1.26574e-06        0.000000         1.78752e-09          1.00000       627.982     100.818     1.02114     2.93040e-10     1.23038e-11
   3.10000e-01        6.90000e-01        1.36422e-01        8.63578e-01       1.28408e-06        0.000000         1.81343e-09          1.00000       627.982     100.007     1.02114     2.94894e-10     1.23038e-11
   3.20000e-01        6.80000e-01        1.41975e-01        8.58025e-01       1.30297e-06        0.000000         1.84009e-09          1.00000       627.982      99.195     1.02114     2.96802e-10     1.23038e-11
   3.30000e-01        6.70000e-01        1.47619e-01        8.52381e-01       1.32241e-06        0.000000         1.86756e-09          1.00000       627.982      98.384     1.02114     2.98768e-10     1.23038e-11
   3.40000e-01        6.60000e-01        1.53357e-01        8.46643e-01       1.34245e-06        0.000000         1.89585e-09          1.00000       627.982      97.572     1.02114     3.00793e-10     1.23038e-11
   3.50000e-01        6.50000e-01        1.59192e-01        8.40808e-01       1.36310e-06        0.000000         1.92502e-09          1.00000       627.982      96.760     1.02114     3.02880e-10     1.23038e-11
   3.60000e-01        6.40000e-01        1.65125e-01        8.34875e-01       1.38440e-06        0.000000         1.95510e-09          1.00000       627.982      95.949     1.02114     3.05032e-10     1.23038e-11
   3.70000e-01        6.30000e-01        1.71160e-01        8.28840e-01       1.40638e-06        0.000000         1.98613e-09          1.00000       627.982      95.137     1.02114     3.07253e-10     1.23038e-11
   3.80000e-01        6.20000e-01        1.77298e-01        8.22702e-01       1.42906e-06        0.000000         2.01817e-09          1.00000       627.982      94.326     1.02114     3.09546e-10     1.23038e-11
   3.90000e-01        6.10000e-01        1.83543e-01        8.16457e-01       1.45249e-06        0.000000         2.05125e-09          1.00000       627.982      93.514     1.02114     3.11913e-10     1.23038e-11
   4.00000e-01        6.00000e-01        1.89897e-01        8.10103e-01       1.47669e-06        0.000000         2.08544e-09          1.00000       627.982      92.703     1.02114     3.14360e-10     1.23038e-11
   4.10000e-01        5.90000e-01        1.96364e-01        8.03636e-01       1.50172e-06        0.000000         2.12079e-09          1.00000       627.982      91.891     1.02114     3.16889e-10     1.23038e-11
   4.20000e-01        5.80000e-01        2.02945e-01        7.97055e-01       1.52761e-06        0.000000         2.15735e-09          1.00000       627.982      91.080     1.02114     3.19506e-10     1.23038e-11
   4.30000e-01        5.70000e-01        2.09645e-01        7.90355e-01       1.55441e-06        0.000000         2.19520e-09          1.00000       627.982      90.268     1.02114     3.22215e-10     1.23038e-11
   4.40000e-01        5.60000e-01        2.16467e-01        7.83533e-01       1.58217e-06        0.000000         2.23440e-09          1.00000       627.982      89.457     1.02114     3.25020e-10     1.23038e-11
   4.50000e-01        5.50000e-01        2.23414e-01        7.76586e-01       1.61094e-06        0.000000         2.27503e-09          1.00000       627.982      88.645     1.02114     3.27927e-10     1.23038e-11
   4.60000e-01        5.40000e-01        2.30488e-01        7.69512e-01       1.64077e-06        0.000000         2.31716e-09          1.00000       627.982      87.833     1.02114     3.30942e-10     1.23038e-11
   4.70000e-01        5.30000e-01        2.37695e-01        7.62305e-01       1.67173e-06        0.000000         2.36088e-09          1.00000       627.982      87.022     1.02114     3.34071e-10     1.23038e-11
   4.80000e-01        5.20000e-01        2.45038e-01        7.54962e-01       1.70388e-06        0.000000         2.40628e-09          1.00000       627.982      86.210     1.02114     3.37320e-10     1.23038e-11
   4.90000e-01        5.10000e-01        2.52520e-01        7.47480e-01       1.73729e-06        0.000000         2.45346e-09          1.00000       627.982      85.399     1.02114     3.40696e-10     1.23038e-11
   5.00000e-01        5.00000e-01        2.60145e-01        7.39855e-01       1.77203e-06        0.000000         2.50253e-09          1.00000       627.982      84.587     1.02114     3.44208e-10     1.23038e-11
   5.10000e-01        4.90000e-01        2.67919e-01        7.32081e-01       1.80820e-06        0.000000         2.55360e-09          1.00000       627.982      83.776     1.02114     3.47863e-10     1.23038e-11
   5.20000e-01        4.80000e-01        2.75844e-01        7.24156e-01       1.84587e-06        0.000000         2.60680e-09          1.00000       627.982      82.964     1.02114     3.51670e-10     1.23038e-11
   5.30000e-01        4.70000e-01        2.83926e-01        7.16074e-01       1.88514e-06        0.000000         2.66226e-09          1.00000       627.982      82.153     1.02114     3.55639e-10     1.23038e-11
   5.40000e-01        4.60000e-01        2.92170e-01        7.07830e-01       1.92612e-06        0.000000         2.72014e-09          1.00000       627.982      81.341     1.02114     3.59781e-10     1.23038e-11
   5.50000e-01        4.50000e-01        3.00579e-01        6.99421e-01       1.96893e-06        0.000000         2.78059e-09          1.00000       627.982      80.530     1.02114     3.64107e-10     1.23038e-11
   5.60000e-01        4.40000e-01        3.09160e-01        6.90840e-01       2.01367e-06        0.000000         2.84378e-09          1.00000       627.982      79.718     1.02114     3.68629e-10     1.23038e-11
   5.70000e-01        4.30000e-01        3.17917e-01        6.82083e-01       2.06050e-06        0.000000         2.90992e-09          1.00000       627.982      78.906     1.02114     3.73362e-10     1.23038e-11
   5.80000e-01        4.20000e-01        3.26856e-01        6.73144e-01       2.10956e-06        0.000000         2.97920e-09          1.00000       627.982      78.095     1.02114     3.78320e-10     1.23038e-11
   5.90000e-01        4.10000e-01        3.35983e-01        6.64017e-01       2.16102e-06        0.000000         3.05186e-09          1.00000       627.982      77.283     1.02114     3.83520e-10     1.23038e-11
   6.00000e-01        4.00000e-01        3.45304e-01        6.54696e-01       2.21504e-06        0.000000         3.12816e-09          1.00000       627.982      76.472     1.02114     3.88980e-10     1.23038e-11
   6.10000e-01        3.90000e-01        3.54824e-01        6.45176e-01       2.27184e-06        0.000000         3.20837e-09          1.00000       627.982      75.660     1.02114     3.94720e-10     1.23038e-11
   6.20000e-01        3.80000e-01        3.64551e-01        6.35449e-01       2.33162e-06        0.000000         3.29280e-09          1.00000       627.982      74.849     1.02114     4.00762e-10     1.23038e-11
   6.30000e-01        3.70000e-01        3.74492e-01        6.25508e-01       2.39464e-06        0.000000         3.38179e-09          1.00000       627.982      74.037     1.02114     4.07131e-10     1.23038e-11
   6.40000e-01        3.60000e-01        3.84652e-01        6.15348e-01       2.46116e-06        0.000000         3.47573e-09          1.00000       627.982      73.226     1.02114     4.13853e-10     1.23038e-11
   6.50000e-01        3.50000e-01        3.95040e-01        6.04960e-01       2.53148e-06        0.000000         3.57504e-09          1.00000       627.982      72.414     1.02114     4.20960e-10     1.23038e-11
   6.60000e-01        3.40000e-01        4.05664e-01        5.94336e-01       2.60593e-06        0.000000         3.68019e-09          1.00000       627.982      71.603     1.02114     4.28485e-10     1.23038e-11
   6.70000e-01        3.30000e-01        4.16532e-01        5.83468e-01       2.68490e-06        0.000000         3.79171e-09          1.00000       627.982      70.791     1.02114     4.36465e-10     1.23038e-11
   6.80000e-01        3.20000e-01        4.27651e-01        5.72349e-01       2.76880e-06        0.000000         3.91020e-09          1.00000       627.982      69.979     1.02114     4.44945e-10     1.23038e-11
   6.90000e-01        3.10000e-01        4.39032e-01        5.60968e-01       2.85812e-06        0.000000         4.03634e-09          1.00000       627.982      69.168     1.02114     4.53972e-10     1.23038e-11
   7.00000e-01        3.00000e-01        4.50682e-01        5.49318e-01       2.95339e-06        0.000000         4.17088e-09          1.00000       627.982      68.356     1.02114     4.63600e-10     1.23038e-11
   7.10000e-01        2.90000e-01        4.62613e-01        5.37387e-01       3.05523e-06        0.000000         4.31470e-09          1.00000       627.982      67.545     1.02114     4.73892e-10     1.23038e-11
   7.20000e-01        2.80000e-01        4.74834e-01        5.25166e-01       3.16434e-06        0.000000         4.46880e-09          1.00000       627.982      66.733     1.02114     4.84920e-10     1.23038e-11
   7.30000e-01        2.70000e-01        4.87355e-01        5.12645e-01       3.28154e-06        0.000000         4.63431e-09          1.00000       627.982      65.922     1.02114     4.96764e-10     1.23038e-11
   7.40000e-01        2.60000e-01        5.00189e-01        4.99811e-01       3.40775e-06        0.000000         4.81255e-09          1.00000       627.982      65.110     1.02114     5.09520e-10     1.23038e-11
   7.50000e-01        2.50000e-01        5.13347e-01        4.86653e-01       3.54407e-06        0.000000         5.00506e-09          1.00000       627.982      64.299     1.02114     5.23296e-10     1.23038e-11
   7.60000e-01        2.40000e-01        5.26841e-01        4.73159e-01       3.69173e-06        0.000000         5.21360e-09          1.00000       627.982      63.487     1.02114     5.38220e-10     1.23038e-11
   7.70000e-01        2.30000e-01        5.40684e-01        4.59316e-01       3.85224e-06        0.000000         5.44028e-09          1.00000       627.982      62.676     1.02114     5.54442e-10     1.23038e-11
   7.80000e-01        2.20000e-01        5.54891e-01        4.45109e-01       4.02735e-06        0.000000         5.68756e-09          1.00000       627.982      61.864     1.02114     5.72138e-10     1.23038e-11
   7.90000e-01        2.10000e-01        5.69476e-01        4.30524e-01       4.21913e-06        0.000000         5.95840e-09          1.00000       627.982      61.052     1.02114     5.91520e-10     1.23038e-11
   8.00000e-01        2.00000e-01        5.84453e-01        4.15547e-01       4.43008e-06        0.000000         6.25632e-09          1.00000       627.982      60.241     1.02114     6.12840e-10     1.23038e-11
   8.10000e-01        1.90000e-01        5.99840e-01        4.00160e-01       4.66324e-06        0.000000         6.58560e-09          1.00000       627.982      59.429     1.02114     6.36404e-10     1.23038e-11
   8.20000e-01        1.80000e-01        6.15652e-01        3.84348e-01       4.92231e-06        0.000000         6.95147e-09          1.00000       627.982      58.618     1.02114     6.62587e-10     1.23038e-11
   8.30000e-01        1.70000e-01        6.31909e-01        3.68091e-01       5.21186e-06        0.000000         7.36038e-09          1.00000       627.982      57.806     1.02114     6.91850e-10     1.23038e-11
   8.40000e-01        1.60000e-01        6.48628e-01        3.51372e-01       5.53760e-06        0.000000         7.82040e-09          1.00000       627.982      56.995     1.02114     7.24770e-10     1.23038e-11
   8.50000e-01        1.50000e-01        6.65831e-01        3.34169e-01       5.90678e-06        0.000000         8.34176e-09          1.00000       627.982      56.183     1.02114     7.62080e-10     1.23038e-11
   8.60000e-01        1.40000e-01        6.83538e-01        3.16462e-01       6.32869e-06        0.000000         8.93760e-09          1.00000       627.982      55.372     1.02114     8.04720e-10     1.23038e-11
   8.70000e-01        1.30000e-01        7.01771e-01        2.98229e-01       6.81551e-06        0.000000         9.62511e-09          1.00000       627.982      54.560     1.02114     8.53920e-10     1.23038e-11
   8.80000e-01        1.20000e-01        7.20555e-01        2.79445e-01       7.38347e-06        0.000000         1.04272e-08          1.00000       627.982      53.749     1.02114     9.11321e-10     1.23038e-11
   8.90000e-01        1.10000e-01        7.39915e-01        2.60085e-01       8.05469e-06        0.000000         1.13751e-08          1.00000       627.982      52.937     1.02114     9.79157e-10     1.23038e-11
   9.00000e-01        1.00000e-01        7.59878e-01        2.40122e-01       8.86016e-06        0.000000         1.25126e-08          1.00000       627.982      52.125     1.02114     1.06056e-09     1.23038e-11
   9.10000e-01        9.00000e-02        7.80473e-01        2.19527e-01       9.84463e-06        0.000000         1.39029e-08          1.00000       627.982      51.314     1.02114     1.16005e-09     1.23038e-11
   9.20000e-01        8.00000e-02        8.01729e-01        1.98271e-01       1.10752e-05        0.000000         1.56408e-08          1.00000       627.982      50.502     1.02114     1.28442e-09     1.23038e-11
   9.30000e-01        7.00000e-02        8.23679e-01        1.76321e-01       1.26574e-05        0.000000         1.78752e-08          1.00000       627.982      49.691     1.02114     1.44432e-09     1.23038e-11
   9.40000e-01        6.00000e-02        8.46359e-01        1.53641e-01       1.47669e-05        0.000000         2.08544e-08          1.00000       627.982      48.879     1.02114     1.65752e-09     1.23038e-11
   9.50000e-01        5.00000e-02        8.69804e-01        1.30196e-01       1.77203e-05        0.000000         2.50253e-08          1.00000       627.982      48.068     1.02114     1.95600e-09     1.23038e-11
   9.60000e-01        4.00000e-02        8.94054e-01        1.05946e-01       2.21504e-05        0.000000         3.12816e-08          1.00000       627.982      47.256     1.02114     2.40372e-09     1.23038e-11
   9.70000e-01        3.00000e-02        9.19152e-01        8.08476e-02       2.95339e-05        0.000000         4.17088e-08          1.00000       627.982      46.445     1.02114     3.14992e-09     1.23038e-11
   9.80000e-01        2.00000e-02        9.45143e-01        5.48569e-02       4.43008e-05        0.000000         6.25632e-08          1.00000       627.982      45.633     1.02114     4.64233e-09     1.23038e-11
   9.90000e-01        1.00000e-02        9.72075e-01        2.79251e-02       8.86017e-05        0.000000         1.25126e-07          1.00000       627.982      44.822     1.02114     9.11953e-09     1.23038e-11
   9.95000e-01        5.00000e-03        9.85910e-01        1.40901e-02       1.77203e-04        0.000000         2.50253e-07          1.00000       627.982      44.416     1.02114     1.80740e-08     1.23038e-11
   9.98000e-01        2.00000e-03        9.94333e-01        5.66711e-03       4.43009e-04        0.000000         6.25633e-07          1.00000       627.982      44.172     1.02114     4.49373e-08     1.23039e-11
   9.99000e-01        1.00000e-03        9.97161e-01        2.83877e-03       8.86020e-04        0.000000         1.25127e-06          1.00000       627.982      44.091     1.02114     8.97097e-08     1.23039e-11
   9.99500e-01        5.00000e-04        9.98579e-01        1.42069e-03       1.77205e-03        0.000000         2.50255e-06          1.00000       627.982      44.051     1.02114     1.79255e-07     1.23039e-11
   9.99800e-01        2.00000e-04        9.99431e-01        5.68591e-04       4.43018e-03        0.000000         6.25646e-06          1.00000       627.981      44.026     1.02114     4.47897e-07     1.23041e-11
   9.99900e-01        1.00000e-04        9.99716e-01        2.84348e-04       8.86058e-03        0.000000         1.25132e-05          1.00000       627.981      44.018     1.02114     8.95650e-07     1.23044e-11
   9.99950e-01        5.00000e-05        9.99858e-01        1.42187e-04       1.77220e-02        0.000000         2.50275e-05          1.00000       627.979      44.014     1.02114     1.79122e-06     1.23050e-11
   9.99980e-01        2.00000e-05        9.99943e-01        5.68780e-05       4.43112e-02        0.000000         6.25770e-05          0.99999       627.974      44.012     1.02114     4.47846e-06     1.23068e-11
   9.99990e-01        1.00000e-05        9.99972e-01        2.84395e-05       8.86430e-02        0.000000         1.25181e-04          0.99998       627.965      44.011     1.02114     8.95892e-06     1.23098e-11
   9.99995e-01        5.00000e-06        9.99986e-01        1.42199e-05       1.77369e-01        0.000000         2.50473e-04          0.99996       627.948      44.010     1.02114     1.79264e-05     1.23158e-11
   9.99998e-01        2.00000e-06        9.99994e-01        5.68799e-06       4.44045e-01        0.000000         6.27011e-04          0.99991       627.896      44.010     1.02114     4.48812e-05     1.23339e-11
   9.99999e-01        1.00000e-06        9.99997e-01        2.84400e-06       8.90180e-01        0.000000         1.25680e-03          0.99982       627.808      44.010     1.02113     8.99816e-05     1.23642e-11
   1.00000e+00        5.00000e-07        9.99999e-01        1.42200e-06       1.78881e+00        0.000000         2.52483e-03          0.99963       627.633      44.010     1.02113     1.80850e-04     1.24254e-11
   1.00000e+00        2.00000e-07        9.99999e-01        5.68800e-07       4.53724e+00        0.000000         6.39873e-03          0.99906       627.097      44.010     1.02112     4.58980e-04     1.26146e-11
   1.00000e+00        1.00000e-07        1.00000e+00        2.84400e-07       9.30537e+00        0.000000         1.31039e-02          0.99808       626.170      44.010     1.02110     9.42243e-04     1.29498e-11
   1.00000e+00        5.00000e-08        1.00000e+00        1.42200e-07       1.96545e+01        0.000000         2.75900e-02          0.99595       624.165      44.010     1.02106     1.99444e-03     1.37087e-11
   1.00000e+00        3.59153e-08        1.00000e+00        1.02143e-07       2.86999e+01        0.000000         4.01764e-02          0.99408       622.422      44.010     1.02103     2.91780e-03     1.44088e-11
   1.00000e+00        2.63728e-08        1.00000e+00        7.50042e-08       4.19082e+01        0.000000         5.84308e-02          0.99135       619.892      44.010     1.02098     4.27235e-03     1.54968e-11
   1.00000e+00        2.00000e-08        1.00000e+00        5.68801e-08       6.11953e+01        0.000000         8.48241e-02          0.98737       616.232      44.010     1.02091     6.26377e-03     1.72367e-11
   1.00000e+00        1.67903e-08        1.00000e+00        4.77517e-08       8.09202e+01        0.000000         1.11499e-01          0.98328       612.529      44.010     1.02084     8.31713e-03     1.92213e-11
   1.00000e+00        1.45820e-08        1.00000e+00        4.14713e-08       1.07003e+02        0.000000         1.46288e-01          0.97788       607.695      44.010     1.02074     1.10587e-02     2.22058e-11
   1.00000e+00        1.32476e-08        1.00000e+00        3.76761e-08       1.41493e+02        0.000000         1.91464e-01          0.97072       601.411      44.010     1.02061     1.47311e-02     2.68862e-11
   1.00000e+00        1.27779e-08        1.00000e+00        3.63404e-08       1.87100e+02        0.000000         2.49799e-01          0.96124       593.288      44.010     1.02045     1.96714e-02     3.46478e-11
   1.00000e+00        1.27779e-08        1.00000e+00        3.63404e-08       1.87142e+02        0.000000         2.49853e-01          0.96123       593.281      44.010     1.02045     1.96760e-02     3.46560e-11
   1.00000e+00        1.30660e-08        1.00000e+00        3.71597e-08       2.29089e+02        0.000000         3.02144e-01          0.95249       585.994      44.010     1.02030     2.43074e-02     4.37921e-11
   1.00000e+00        1.40642e-08        1.00000e+00        3.99986e-08       2.80439e+02        0.000000         3.64453e-01          0.94177       577.311      44.010     1.02012     3.00947e-02     5.83706e-11
   1.00000e+00        1.61282e-08        1.00000e+00        4.58686e-08       3.43298e+02        0.000000         4.38291e-01          0.92861       567.029      44.010     1.01990     3.73625e-02     8.30934e-11
   1.00000e+00        2.00000e-08        1.00000e+00        5.68801e-08       4.20248e+02        0.000000         5.25238e-01          0.91244       554.951      44.010     1.01964     4.65473e-02     1.28293e-10
   1.00000e+00        2.52372e-08        1.00000e+00        7.17748e-08       4.91671e+02        0.000000         6.02768e-01          0.89740       544.228      44.010     1.01941     5.53711e-02     1.92375e-10
   1.00000e+00        3.41109e-08        1.00000e+00        9.70116e-08       5.75232e+02        0.000000         6.89884e-01          0.87976       532.263      44.010     1.01915     6.60809e-02     3.09739e-10
   1.00000e+00        5.00000e-08        1.00000e+00        1.42200e-07       6.72995e+02        0.000000         7.87298e-01          0.85907       519.034      44.010     1.01886     7.91735e-02     5.42354e-10
   1.00000e+00        6.89127e-08        1.00000e+00        1.95988e-07       7.50492e+02        0.000000         8.61370e-01          0.84265       509.119      44.010     1.01864     9.00109e-02     8.47272e-10
   1.00000e+00        1.00000e-07        1.00000e+00        2.84400e-07       8.36914e+02        0.000000         9.40998e-01          0.82434       498.640      44.010     1.01841     1.02605e-01     1.39590e-09
   1.00000e+00        2.00000e-07        9.99999e-01        5.68800e-07       9.91032e+02        0.000000         1.07616e+00          0.79179       481.405      44.010     1.01805     1.26496e-01     3.41158e-09
   1.00000e+00        3.08624e-07        9.99999e-01        8.77728e-07       1.08450e+03        0.000000         1.15443e+00          0.77218       471.823      44.010     1.01785     1.41941e-01     5.86997e-09
   1.00000e+00        5.00000e-07        9.99999e-01        1.42200e-06       1.18679e+03        0.000000         1.23739e+00          0.75093       462.056      44.010     1.01767     1.59723e-01     1.06193e-08
   9.99999e-01        1.00000e-06        9.99997e-01        2.84400e-06       1.33220e+03        0.000000         1.35125e+00          0.72132       449.404      44.010     1.01745     1.86654e-01     2.45226e-08
   9.99998e-01        2.00000e-06        9.99994e-01        5.68799e-06       1.47792e+03        0.000000         1.46155e+00          0.69273       438.094      44.010     1.01730     2.15619e-01     5.59302e-08
   9.99995e-01        5.00000e-06        9.99986e-01        1.42199e-05       1.67587e+03        0.000000         1.60698e+00          0.65656       424.749      44.010     1.01719     2.57966e-01     1.64367e-07
   9.99990e-01        1.00000e-05        9.99972e-01        2.84395e-05       1.83498e+03        0.000000         1.72142e+00          0.63070       415.542      44.011     1.01719     2.94044e-01     3.69874e-07
   9.99980e-01        2.00000e-05        9.99943e-01        5.68780e-05       2.00982e+03        0.000000         1.84564e+00          0.60658       406.799      44.012     1.01726     3.34871e-01     8.32616e-07
   9.99968e-01        3.21394e-05        9.99909e-01        9.13990e-05       2.14485e+03        0.000000         1.94091e+00          0.59151       400.909      44.013     1.01737     3.66483e-01     1.45454e-06
   9.99950e-01        5.00000e-05        9.99858e-01        1.42187e-04       2.28896e+03        0.000000         2.04221e+00          0.57900       395.340      44.014     1.01754     3.99570e-01     2.45576e-06
   9.99928e-01        7.22003e-05        9.99795e-01        2.05311e-04       2.42958e+03        0.000000         2.14085e+00          0.57023       390.525      44.016     1.01774     4.30657e-01     3.74613e-06
   9.99900e-01        1.00000e-04        9.99716e-01        2.84348e-04       2.57884e+03        0.000000         2.24540e+00          0.56431       385.987      44.018     1.01800     4.61939e-01     5.35742e-06
   9.99852e-01        1.47580e-04        9.99580e-01        4.19603e-04       2.80785e+03        0.000000         2.40563e+00          0.56090       379.975      44.022     1.01846     5.06060e-01     8.24716e-06
   9.99800e-01        2.00000e-04        9.99431e-01        5.68591e-04       3.05720e+03        0.000000         2.57989e+00          0.56322       374.476      44.026     1.01904     5.48788e-01     1.16138e-05
   9.99760e-01        2.40389e-04        9.99317e-01        6.83364e-04       3.26689e+03        0.000000         2.72628e+00          0.56869       370.519      44.030     1.01957     5.80831e-01     1.43485e-05
   9.99723e-01        2.77462e-04        9.99211e-01        7.88700e-04       3.49096e+03        0.000000         2.88256e+00          0.57709       366.831      44.033     1.02018     6.11674e-01     1.69905e-05
   9.99691e-01        3.09182e-04        9.99121e-01        8.78813e-04       3.73039e+03        0.000000         3.04940e+00          0.58819       363.396      44.035     1.02086     6.41330e-01     1.93886e-05
   9.99666e-01        3.34218e-04        9.99050e-01        9.49931e-04       3.98625e+03        0.000000         3.22751e+00          0.60179       360.198      44.037     1.02160     6.69858e-01     2.14272e-05
   9.99648e-01        3.51925e-04        9.99000e-01        1.00023e-03       4.25965e+03        0.000000         3.41769e+00          0.61774       357.225      44.039     1.02242     6.97337e-01     2.30303e-05
   9.99638e-01        3.62239e-04        9.98970e-01        1.02952e-03       4.55181e+03        0.000000         3.62078e+00          0.63594       354.468      44.039     1.02330     7.23856e-01     2.41606e-05
   9.99634e-01        3.65540e-04        9.98961e-01        1.03890e-03       4.86401e+03        0.000000         3.83772e+00          0.65631       351.918      44.040     1.02425     7.49503e-01     2.48134e-05
   9.99695e-01        3.05176e-04        9.99133e-01        8.67434e-04       6.78511e+03        0.000000         5.17466e+00          0.79077       342.048      44.035     1.02993     8.67652e-01     2.21745e-05
   9.99803e-01        1.96859e-04        9.99440e-01        5.59665e-04       9.46499e+03        0.000000         7.05822e+00          0.98339       336.693      44.026     1.03682     9.73075e-01     1.48430e-05
   9.99870e-01        1.30173e-04        9.99630e-01        3.70123e-04       1.19777e+04        0.000000         8.85197e+00          1.16185       335.386      44.021     1.04213     1.04213e+00     9.90478e-06
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   2.59269e-01        7.40731e-01        1.09585e-01        8.90415e-01       1.00000e+06        0.000000         3.17721e+02        247.50378       137.808     104.124     0.99603     9.66077e-01     3.55735e-01
   2.60000e-01        7.40000e-01        1.09957e-01        8.90043e-01       9.42649e+05        0.000000         2.99425e+02        233.19039       137.767     104.064     0.99598     9.66018e-01     3.55531e-01
   2.64347e-01        7.35653e-01        1.12176e-01        8.87824e-01       6.99667e+05        0.000000         2.21919e+02        172.56014       137.527     103.712     0.99570     9.65655e-01     3.54316e-01
   2.70000e-01        7.30000e-01        1.15084e-01        8.84916e-01       5.19317e+05        0.000000         1.64410e+02        127.58117       137.215     103.253     0.99529     9.65143e-01     3.52745e-01
   2.74601e-01        7.25399e-01        1.17469e-01        8.82531e-01       4.26471e+05        0.000000         1.34816e+02        104.44153       136.964     102.879     0.99494     9.64692e-01     3.51475e-01
   2.80000e-01        7.20000e-01        1.20291e-01        8.79709e-01       3.50224e+05        0.000000         1.10526e+02         85.45422       136.670     102.441     0.99448     9.64122e-01     3.49994e-01
   2.84721e-01        7.15279e-01        1.22779e-01        8.77221e-01       3.01289e+05        0.000000         9.49460e+01         73.27984       136.415     102.058     0.99406     9.63584e-01     3.48708e-01
   2.90000e-01        7.10000e-01        1.25582e-01        8.74418e-01       2.59190e+05        0.000000         8.15520e+01         62.81810       136.132     101.630     0.99355     9.62939e-01     3.47281e-01
   2.94792e-01        7.05208e-01        1.28148e-01        8.71852e-01       2.28967e+05        0.000000         7.19438e+01         55.31689       135.877     101.241     0.99305     9.62310e-01     3.45994e-01
   3.00000e-01        7.00000e-01        1.30958e-01        8.69042e-01       2.02268e+05        0.000000         6.34633e+01         48.69966       135.602     100.818     0.99247     9.61577e-01     3.44607e-01
   3.04840e-01        6.95160e-01        1.33592e-01        8.66408e-01       1.81733e+05        0.000000         5.69471e+01         43.61816       135.349     100.425     0.99189     9.60848e-01     3.43329e-01
   3.10000e-01        6.90000e-01        1.36422e-01        8.63578e-01       1.63283e+05        0.000000         5.10985e+01         39.06032       135.082     100.007     0.99123     9.60016e-01     3.41978e-01
   3.14875e-01        6.85125e-01        1.39117e-01        8.60883e-01       1.48408e+05        0.000000         4.63885e+01         35.39239       134.832      99.611     0.99057     9.59175e-01     3.40713e-01
   3.20000e-01        6.80000e-01        1.41975e-01        8.58025e-01       1.34887e+05        0.000000         4.21128e+01         32.06532       134.572      99.195     0.98982     9.58231e-01     3.39396e-01
   3.24902e-01        6.75098e-01        1.44730e-01        8.55270e-01       1.23601e+05        0.000000         3.85484e+01         29.29411       134.327      98.797     0.98906     9.57265e-01     3.38150e-01
   3.30000e-01        6.70000e-01        1.47619e-01        8.52381e-01       1.13260e+05        0.000000         3.52869e+01         26.76066       134.074      98.384     0.98822     9.56192e-01     3.36867e-01
   3.34925e-01        6.65075e-01        1.50433e-01        8.49567e-01       1.04390e+05        0.000000         3.24939e+01         24.59333       133.834      97.984     0.98735     9.55085e-01     3.35642e-01
   3.40000e-01        6.60000e-01        1.53357e-01        8.46643e-01       9.62157e+04        0.000000         2.99237e+01         22.60100       133.591      97.572     0.98640     9.53867e-01     3.34395e-01
   3.44945e-01        6.55055e-01        1.56231e-01        8.43769e-01       8.90481e+04        0.000000         2.76739e+01         20.85905       133.357      97.171     0.98541     9.52598e-01     3.33196e-01
   3.50000e-01        6.50000e-01        1.59192e-01        8.40808e-01       8.24144e+04        0.000000         2.55953e+01         19.25167       133.124      96.760     0.98433     9.51210e-01     3.31987e-01
   3.54964e-01        6.45036e-01        1.62125e-01        8.37875e-01       7.64866e+04        0.000000         2.37415e+01         17.81990       132.899      96.358     0.98320     9.49753e-01     3.30817e-01
   3.60000e-01        6.40000e-01        1.65125e-01        8.34875e-01       7.09853e+04        0.000000         2.20243e+01         16.49554       132.676      95.949     0.98198     9.48169e-01     3.29650e-01
   3.64982e-01        6.35018e-01        1.68119e-01        8.31881e-01       6.59845e+04        0.000000         2.04665e+01         15.29597       132.462      95.545     0.98069     9.46488e-01     3.28515e-01
   3.70000e-01        6.30000e-01        1.71160e-01        8.28840e-01       6.13361e+04        0.000000         1.90216e+01         14.18505       132.253      95.137     0.97930     9.44671e-01     3.27393e-01
   3.75002e-01        6.24998e-01        1.74217e-01        8.25783e-01       5.70409e+04        0.000000         1.76895e+01         13.16258       132.052      94.731     0.97782     9.42722e-01     3.26300e-01
   3.80000e-01        6.20000e-01        1.77298e-01        8.22702e-01       5.30465e+04        0.000000         1.64535e+01         12.21564       131.860      94.326     0.97623     9.40622e-01     3.25233e-01
   3.85026e-01        6.14974e-01        1.80423e-01        8.19577e-01       4.92925e+04        0.000000         1.52948e+01         11.32959       131.676      93.918     0.97451     9.38338e-01     3.24190e-01
   3.90000e-01        6.10000e-01        1.83543e-01        8.16457e-01       4.58041e+04        0.000000         1.42207e+01         10.51003       131.504      93.514     0.97268     9.35886e-01     3.23191e-01
   3.93381e-01        6.06619e-01        1.85679e-01        8.14321e-01       4.35478e+04        0.000000         1.35274e+01          9.98206       131.395      93.240     0.97134     9.34096e-01     3.22534e-01
   3.96717e-01        6.03283e-01        1.87799e-01        8.12201e-01       4.14025e+04        0.000000         1.28695e+01          9.48180       131.293      92.969     0.96995     9.32221e-01     3.21904e-01
   4.00000e-01        6.00000e-01        1.89897e-01        8.10103e-01       3.93630e+04        0.000000         1.22451e+01          9.00784       131.199      92.703     0.96850     9.30258e-01     3.21306e-01
   4.03419e-01        5.96581e-01        1.92096e-01        8.07904e-01       3.73056e+04        0.000000         1.16165e+01          8.53151       131.109      92.425     0.96689     9.28075e-01     3.20708e-01
   4.06757e-01        5.93243e-01        1.94254e-01        8.05746e-01       3.53558e+04        0.000000         1.10218e+01          8.08183       131.031      92.154     0.96522     9.25788e-01     3.20154e-01
   4.10000e-01        5.90000e-01        1.96364e-01        8.03636e-01       3.35079e+04        0.000000         1.04593e+01          7.65733       130.964      91.891     0.96347     9.23397e-01     3.19648e-01
   4.13487e-01        5.86513e-01        1.98645e-01        8.01355e-01       3.15636e+04        0.000000         9.86863e+00          7.21257       130.904      91.608     0.96145     9.20609e-01     3.19148e-01
   4.16826e-01        5.83174e-01        2.00844e-01        7.99156e-01       2.97321e+04        0.000000         9.31333e+00          6.79552       130.860      91.337     0.95934     9.17688e-01     3.18722e-01
   4.20000e-01        5.80000e-01        2.02945e-01        7.97055e-01       2.80069e+04        0.000000         8.79127e+00          6.40447       130.834      91.080     0.95714     9.14632e-01     3.18379e-01
   4.22769e-01        5.77231e-01        2.04789e-01        7.95211e-01       2.65027e+04        0.000000         8.33690e+00          6.06505       130.825      90.855     0.95504     9.11691e-01     3.18143e-01
   4.25369e-01        5.74631e-01        2.06528e-01        7.93472e-01       2.50792e+04        0.000000         7.90761e+00          5.74524       130.832      90.644     0.95286     9.08634e-01     3.17994e-01
   4.27784e-01        5.72216e-01        2.08150e-01        7.91850e-01       2.37323e+04        0.000000         7.50196e+00          5.44391       130.856      90.448     0.95061     9.05464e-01     3.17940e-01
   4.30000e-01        5.70000e-01        2.09645e-01        7.90355e-01       2.24577e+04        0.000000         7.11859e+00          5.16000       130.896      90.268     0.94829     9.02180e-01     3.17991e-01
   4.31744e-01        5.68256e-01        2.10826e-01        7.89174e-01       2.14111e+04        0.000000         6.80415e+00          4.92783       130.944      90.127     0.94622     8.99251e-01     3.18128e-01
   4.33319e-01        5.66681e-01        2.11896e-01        7.88104e-01       2.04134e+04        0.000000         6.50460e+00          4.70729       131.003      89.999     0.94411     8.96240e-01     3.18359e-01
   4.34715e-01        5.65285e-01        2.12847e-01        7.87153e-01       1.94621e+04        0.000000         6.21917e+00          4.49780       131.075      89.885     0.94194     8.93150e-01     3.18693e-01
   4.35923e-01        5.64077e-01        2.13671e-01        7.86329e-01       1.85552e+04        0.000000         5.94715e+00          4.29878       131.159      89.787     0.93972     8.89981e-01     3.19138e-01
   4.36933e-01        5.63067e-01        2.14362e-01        7.85638e-01       1.76906e+04        0.000000         5.68784e+00          4.10970       131.253      89.705     0.93745     8.86736e-01     3.19705e-01
   4.37735e-01        5.62265e-01        2.14911e-01        7.85089e-01       1.68662e+04        0.000000         5.44059e+00          3.93005       131.358      89.640     0.93513     8.83419e-01     3.20404e-01
   4.38320e-01        5.61680e-01        2.15312e-01        7.84688e-01       1.60802e+04        0.000000         5.20477e+00          3.75933       131.472      89.593     0.93276     8.80033e-01     3.21247e-01
   4.38678e-01        5.61322e-01        2.15558e-01        7.84442e-01       1.53309e+04        0.000000         4.97979e+00          3.59710       131.596      89.564     0.93034     8.76581e-01     3.22246e-01
   4.38800e-01        5.61200e-01        2.15642e-01        7.84358e-01       1.46165e+04        0.000000         4.76508e+00          3.44289       131.726      89.554     0.92787     8.73067e-01     3.23415e-01
   4.38800e-01        5.61200e-01        2.15642e-01        7.84358e-01       1.46080e+04        0.000000         4.76254e+00          3.44108       131.728      89.554     0.92784     8.73025e-01     3.23430e-01
   4.38671e-01        5.61329e-01        2.15553e-01        7.84447e-01       1.39169e+04        0.000000         4.55452e+00          3.29233       131.866      89.564     0.92528     8.69397e-01     3.24083e-01
   4.38280e-01        5.61720e-01        2.15285e-01        7.84715e-01       1.32584e+04        0.000000         4.35600e+00          3.15100       132.009      89.596     0.92268     8.65715e-01     3.23987e-01
   4.37619e-01        5.62381e-01        2.14831e-01        7.85169e-01       1.26310e+04        0.000000         4.16645e+00          3.01670       132.154      89.650     0.92002     8.61985e-01     3.24103e-01
   4.36679e-01        5.63321e-01        2.14188e-01        7.85812e-01       1.20334e+04        0.000000         3.98540e+00          2.88905       132.299      89.726     0.91731     8.58214e-01     3.24450e-01
   4.35454e-01        5.64546e-01        2.13351e-01        7.86649e-01       1.14640e+04        0.000000         3.81240e+00          2.76768       132.442      89.825     0.91455     8.54406e-01     3.25047e-01
   4.33936e-01        5.66064e-01        2.12316e-01        7.87684e-01       1.09216e+04        0.000000         3.64700e+00          2.65225       132.580      89.949     0.91174     8.50570e-01     3.25916e-01
   4.32120e-01        5.67880e-01        2.11081e-01        7.88919e-01       1.04048e+04        0.000000         3.48879e+00          2.54243       132.709      90.096     0.90888     8.46711e-01     3.27080e-01
   4.30000e-01        5.70000e-01        2.09645e-01        7.90355e-01       9.91253e+03        0.000000         3.33739e+00          2.43791       132.827      90.268     0.90596     8.42838e-01     3.28563e-01
   4.27866e-01        5.72134e-01        2.08205e-01        7.91795e-01       9.49597e+03        0.000000         3.20868e+00          2.34952       132.919      90.441     0.90333     8.39402e-01     3.30164e-01
   4.25488e-01        5.74512e-01        2.06608e-01        7.93392e-01       9.09691e+03        0.000000         3.08478e+00          2.26486       132.997      90.634     0.90065     8.35966e-01     3.32057e-01
   4.22867e-01        5.77133e-01        2.04854e-01        7.95146e-01       8.71463e+03        0.000000         2.96546e+00          2.18374       133.056      90.847     0.89792     8.32534e-01     3.34263e-01
   4.20000e-01        5.80000e-01        2.02945e-01        7.97055e-01       8.34841e+03        0.000000         2.85049e+00          2.10598       133.095      91.080     0.89514     8.29114e-01     3.36806e-01
   4.16907e-01        5.83093e-01        2.00897e-01        7.99103e-01       7.99946e+03        0.000000         2.74028e+00          2.03181       133.110      91.331     0.89232     8.25729e-01     3.39695e-01
   4.13572e-01        5.86428e-01        1.98702e-01        8.01298e-01       7.66510e+03        0.000000         2.63397e+00          1.96064       133.098      91.601     0.88945     8.22366e-01     3.42972e-01
   4.10000e-01        5.90000e-01        1.96364e-01        8.03636e-01       7.34471e+03        0.000000         2.53140e+00          1.89231       133.054      91.891     0.88652     8.19030e-01     3.46671e-01
   4.05182e-01        5.94818e-01        1.93234e-01        8.06766e-01       6.96132e+03        0.000000         2.40760e+00          1.81032       132.948      92.282     0.88274     8.14888e-01     3.51969e-01
   4.00000e-01        6.00000e-01        1.89897e-01        8.10103e-01       6.59795e+03        0.000000         2.28906e+00          1.73232       132.775      92.703     0.87884     8.10807e-01     3.58078e-01
   3.95584e-01        6.04416e-01        1.87078e-01        8.12922e-01       6.32001e+03        0.000000         2.19748e+00          1.67241       132.581      93.061     0.87562     8.07581e-01     3.63644e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                    Liq Den     Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)     (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ---------   ---------   -------------
   9.99870e-01        1.30173e-04        9.99630e-01        3.70123e-04         11977.7         1.0000             1.1619            8.85197        44.021     335.386     1.04213     1.04213     9.90478e-06
   9.99892e-01        1.07596e-04        9.99694e-01        3.05942e-04         13203.3         1.0000             1.2478            9.73706        44.019     335.393     1.06957     1.04437     8.18695e-06
   9.99948e-01        5.24901e-05        9.99851e-01        1.49268e-04         18418.1         1.0000             1.6065           13.57145        44.014     337.545     1.15879     1.05195     3.93609e-06
   9.99976e-01        2.37236e-05        9.99933e-01        6.74671e-05         25692.6         1.0000             2.0921           19.07400        44.012     342.365     1.24121     1.05901     1.72133e-06
   9.99990e-01        1.02664e-05        9.99971e-01        2.91970e-05         35840.3         1.0000             2.7510           26.96413        44.011     348.972     1.31671     1.06517     7.11948e-07
   9.99996e-01        4.39476e-06        9.99988e-01        1.24986e-05         49995.9         1.0000             3.6486           38.24178        44.010     356.490     1.38487     1.07026     2.89429e-07
   9.99998e-01        1.92214e-06        9.99995e-01        5.46655e-06         69742.4         1.0000             4.8771           54.28944        44.010     364.155     1.44522     1.07427     1.20071e-07
   9.99999e-01        8.84988e-07        9.99997e-01        2.51691e-06         97288.2         1.0000             6.5660           77.01628        44.010     371.384     1.49746     1.07732     5.25815e-08
   1.00000e+00        4.39447e-07        9.99999e-01        1.24979e-06        135713.4         1.0000             8.8972          109.06318        44.010     377.805     1.54158     1.07959     2.49668e-08
   1.00000e+00        2.39090e-07        9.99999e-01        6.79972e-07        189315.3         1.0000            12.1254          154.09349        44.010     383.243     1.57792     1.08123     1.30756e-08
   1.00000e+00        1.43434e-07        1.00000e+00        4.07927e-07        264087.9         1.0000            16.6071          217.20200        44.010     387.675     1.60713     1.08242     7.60293e-09
   1.00000e+00        9.46623e-08        1.00000e+00        2.69220e-07        368393.1         1.0000            22.8400          305.48714        44.010     391.178     1.63009     1.08327     4.89468e-09
   1.00000e+00        6.81354e-08        1.00000e+00        1.93777e-07        513894.9         1.0000            31.5189          428.84859        44.010     393.881     1.64778     1.08387     3.45595e-09
   1.00000e+00        5.28369e-08        1.00000e+00        1.50268e-07        716864.6         1.0000            43.6128          601.09837        44.010     395.928     1.66119     1.08431     2.64110e-09
   1.00000e+00        4.35612e-08        1.00000e+00        1.23888e-07       1000000.0         1.0000            60.4732          841.50879        44.010     397.456     1.67122     1.08461     2.15375e-09
           NaN                NaN                NaN                NaN             NaN            NaN                NaN                NaN           NaN         NaN         NaN         NaN             NaN
   3.95584e-01        6.04416e-01        1.87078e-01        8.12922e-01          6320.0         1.0000             1.6724            1.02997        93.061      45.177     0.80758     0.63658     3.19603e-02
   3.90000e-01        6.10000e-01        1.83543e-01        8.16457e-01          6205.8         1.0000             1.6532            1.01268        93.514      44.561     0.80611     0.62708     2.85906e-02
   3.80000e-01        6.20000e-01        1.77298e-01        8.22702e-01          6018.9         1.0000             1.6222            0.98558        94.326      43.522     0.80369     0.61035     2.35111e-02
   3.70000e-01        6.30000e-01        1.71160e-01        8.28840e-01          5851.3         1.0000             1.5949            0.96267        95.137      42.553     0.80150     0.59394     1.94052e-02
   3.60000e-01        6.40000e-01        1.65125e-01        8.34875e-01          5700.1         1.0000             1.5709            0.94326        95.949      41.639     0.79951     0.57782     1.60593e-02
   3.50000e-01        6.50000e-01        1.59192e-01        8.40808e-01          5563.0         1.0000             1.5496            0.92682        96.760      40.773     0.79770     0.56200     1.33155e-02
   3.40000e-01        6.60000e-01        1.53357e-01        8.46643e-01          5438.1         1.0000             1.5306            0.91291        97.572      39.949     0.79605     0.54646     1.09551e-02
   3.30000e-01        6.70000e-01        1.47619e-01        8.52381e-01          5323.7         1.0000             1.5138            0.90121        98.384      39.161     0.79454     0.53124     9.02503e-03
   3.20000e-01        6.80000e-01        1.41975e-01        8.58025e-01          5218.7         1.0000             1.4988            0.89141        99.195      38.406     0.79315     0.51633     7.44520e-03
   3.10000e-01        6.90000e-01        1.36422e-01        8.63578e-01          5121.8         1.0000             1.4854            0.88328       100.007      37.681     0.79188     0.50176     6.15112e-03
   3.00000e-01        7.00000e-01        1.30958e-01        8.69042e-01          5032.2         1.0000             1.4734            0.87660       100.818      36.984     0.79070     0.48754     5.09046e-03
   2.90000e-01        7.10000e-01        1.25582e-01        8.74418e-01          4949.0         1.0000             1.4628            0.87119       101.630      36.311     0.78961     0.47369     4.22056e-03
   2.80000e-01        7.20000e-01        1.20291e-01        8.79709e-01          4871.6         1.0000             1.4532            0.86689       102.441      35.662     0.78860     0.46021     3.50655e-03
   2.70000e-01        7.30000e-01        1.15084e-01        8.84916e-01          4799.3         1.0000             1.4447            0.86355       103.253      35.033     0.78766     0.44711     2.91990e-03
   2.60000e-01        7.40000e-01        1.09957e-01        8.90043e-01          4731.7         1.0000             1.4372            0.86106       104.064      34.424     0.78679     0.43440     2.43731e-03
   2.50000e-01        7.50000e-01        1.04910e-01        8.95090e-01          4668.3         1.0000             1.4304            0.85930       104.876      33.832     0.78598     0.42207     2.03972e-03
   2.40000e-01        7.60000e-01        9.99399e-02        9.00060e-01          4608.6         1.0000             1.4244            0.85817       105.687      33.257     0.78521     0.41013     1.71160e-03
   2.30000e-01        7.70000e-01        9.50459e-02        9.04954e-01          4552.3         1.0000             1.4191            0.85759       106.499      32.696     0.78450     0.39856     1.44030e-03
   2.20000e-01        7.80000e-01        9.02260e-02        9.09774e-01          4499.1         1.0000             1.4145            0.85748       107.311      32.150     0.78383     0.38737     1.21548e-03
   2.10000e-01        7.90000e-01        8.54783e-02        9.14522e-01          4448.8         1.0000             1.4104            0.85778       108.122      31.616     0.78320     0.37654     1.02876e-03
   2.00000e-01        8.00000e-01        8.08015e-02        9.19199e-01          4401.0         1.0000             1.4068            0.85843       108.934      31.093     0.78260     0.36607     8.73290e-04
   1.90000e-01        8.10000e-01        7.61938e-02        9.23806e-01          4355.6         1.0000             1.4036            0.85939       109.745      30.582     0.78204     0.35593     7.43519e-04
   1.80000e-01        8.20000e-01        7.16537e-02        9.28346e-01          4312.4         1.0000             1.4009            0.86060       110.557      30.079     0.78151     0.34613     6.34908e-04
   1.70000e-01        8.30000e-01        6.71798e-02        9.32820e-01          4271.2         1.0000             1.3986            0.86202       111.368      29.586     0.78100     0.33664     5.43759e-04
   1.60000e-01        8.40000e-01        6.27706e-02        9.37229e-01          4231.8         1.0000             1.3967            0.86363       112.180      29.101     0.78052     0.32746     4.67055e-04
   1.50000e-01        8.50000e-01        5.84248e-02        9.41575e-01          4194.1         1.0000             1.3951            0.86540       112.991      28.624     0.78007     0.31857     4.02325e-04
   1.40000e-01        8.60000e-01        5.41410e-02        9.45859e-01          4158.0         1.0000             1.3938            0.86729       113.803      28.154     0.77963     0.30996     3.47549e-04
   1.30000e-01        8.70000e-01        4.99178e-02        9.50082e-01          4123.3         1.0000             1.3928            0.86929       114.614      27.690     0.77922     0.30161     3.01067e-04
   1.20000e-01        8.80000e-01        4.57540e-02        9.54246e-01          4090.0         1.0000             1.3920            0.87138       115.426      27.232     0.77882     0.29353     2.61514e-04
   1.10000e-01        8.90000e-01        4.16483e-02        9.58352e-01          4058.0         1.0000             1.3915            0.87353       116.238      26.780     0.77844     0.28569     2.27765e-04
   1.00000e-01        9.00000e-01        3.75996e-02        9.62400e-01          4027.2         1.0000             1.3912            0.87574       117.049      26.333     0.77807     0.27808     1.98891e-04
   9.00000e-02        9.10000e-01        3.36066e-02        9.66393e-01          3997.4         1.0000             1.3911            0.87799       117.861      25.891     0.77772     0.27069     1.74121e-04
   8.00000e-02        9.20000e-01        2.96683e-02        9.70332e-01          3968.7         1.0000             1.3913            0.88027       118.672      25.453     0.77738     0.26352     1.52816e-04
   7.00000e-02        9.30000e-01        2.57834e-02        9.74217e-01          3941.0         1.0000             1.3916            0.88257       119.484      25.019     0.77706     0.25655     1.34445e-04
   6.00000e-02        9.40000e-01        2.19510e-02        9.78049e-01          3914.2         1.0000             1.3920            0.88488       120.295      24.590     0.77675     0.24978     1.18564e-04
   5.00000e-02        9.50000e-01        1.81699e-02        9.81830e-01          3888.2         1.0000             1.3927            0.88719       121.107      24.164     0.77644     0.24319     1.04800e-04
   4.00000e-02        9.60000e-01        1.44392e-02        9.85561e-01          3863.1         1.0000             1.3935            0.88950       121.918      23.742     0.77615     0.23678     9.28439e-05
   3.00000e-02        9.70000e-01        1.07578e-02        9.89242e-01          3838.7         1.0000             1.3944            0.89180       122.730      23.323     0.77587     0.23054     8.24327e-05
   2.00000e-02        9.80000e-01        7.12473e-03        9.92875e-01          3815.1         1.0000             1.3955            0.89409       123.541      22.907     0.77560     0.22446     7.33460e-05
   1.00000e-02        9.90000e-01        3.53912e-03        9.96461e-01          3792.2         1.0000             1.3967            0.89635       124.353      22.494     0.77533     0.21854     6.53974e-05
   5.00000e-03        9.95000e-01        1.76380e-03        9.98236e-01          3781.0         1.0000             1.3973            0.89747       124.759      22.289     0.77520     0.21563     6.17996e-05
   2.00000e-03        9.98000e-01        7.04147e-04        9.99296e-01          3774.3         1.0000             1.3977            0.89815       125.002      22.166     0.77512     0.21390     5.97510e-05
   1.00000e-03        9.99000e-01        3.51845e-04        9.99648e-01          3772.1         1.0000             1.3979            0.89837       125.083      22.125     0.77510     0.21333     5.90858e-05
   5.00000e-04        9.99500e-01        1.75866e-04        9.99824e-01          3771.0         1.0000             1.3980            0.89848       125.124      22.104     0.77509     0.21305     5.87563e-05
   2.00000e-04        9.99800e-01        7.03325e-05        9.99930e-01          3770.3         1.0000             1.3980            0.89855       125.148      22.092     0.77508     0.21287     5.85597e-05
   1.00000e-04        9.99900e-01        3.51640e-05        9.99965e-01          3770.1         1.0000             1.3980            0.89857       125.156      22.088     0.77508     0.21282     5.84943e-05
   5.00000e-05        9.99950e-01        1.75814e-05        9.99982e-01          3770.0         1.0000             1.3980            0.89858       125.161      22.086     0.77507     0.21279     5.84617e-05
   2.00000e-05        9.99980e-01        7.03243e-06        9.99993e-01          3770.0         1.0000             1.3980            0.89859       125.163      22.085     0.77507     0.21277     5.84421e-05
   1.00000e-05        9.99990e-01        3.51619e-06        9.99996e-01          3769.9         1.0000             1.3980            0.89859       125.164      22.084     0.77507     0.21277     5.84356e-05
   5.00000e-06        9.99995e-01        1.75809e-06        9.99998e-01          3769.9         1.0000             1.3980            0.89859       125.164      22.084     0.77507     0.21276     5.84323e-05
   2.00000e-06        9.99998e-01        7.03235e-07        9.99999e-01          3769.9         1.0000             1.3980            0.89859       125.164      22.084     0.77507     0.21276     5.84303e-05
   1.00000e-06        9.99999e-01        3.51617e-07        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.164      22.084     0.77507     0.21276     5.84297e-05
   5.00000e-07        1.00000e+00        1.75809e-07        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84294e-05
   2.00000e-07        1.00000e+00        7.03234e-08        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84292e-05
   1.00000e-07        1.00000e+00        3.51617e-08        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84291e-05
   5.00000e-08        1.00000e+00        1.75809e-08        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84291e-05
   2.00000e-08        1.00000e+00        7.03234e-09        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84291e-05
   1.00000e-08        1.00000e+00        3.51617e-09        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84291e-05
   5.00000e-09        1.00000e+00        1.75809e-09        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   2.00000e-09        1.00000e+00        7.03234e-10        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   1.00000e-09        1.00000e+00        3.51617e-10        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   5.00000e-10        1.00000e+00        1.75809e-10        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   2.00000e-10        1.00000e+00        7.03234e-11        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   1.00000e-10        1.00000e+00        3.51617e-11        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   5.00000e-11        1.00000e+00        1.75809e-11        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   2.00000e-11        1.00000e+00        7.03234e-12        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   1.00000e-11        1.00000e+00        3.51617e-12        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   5.00000e-12        1.00000e+00        1.75809e-12        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   2.00000e-12        1.00000e+00        7.03234e-13        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   1.00000e-12        1.00000e+00        3.51617e-13        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00          3769.9         1.0000             1.3980            0.89859       125.165      22.084     0.77507     0.21276     5.84290e-05
END

set output "Figures/Env_005_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_005_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_005_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Solvent"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                    Liq Den       Gas Den             
#   (R)          (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
  131.128     1.00000e-12        0.00000         9.07031e-16       1.00000e+00      58.0965     34.6656     0.72911     3.94604e-16     3.66876e-90
  135.000     4.14554e-12        0.00000         3.65587e-15       1.00000e+00      58.0886     34.6656     0.72829     1.58892e-15     4.70532e-87
  140.000     2.29945e-11        0.00000         1.95786e-14       1.00000e+00      58.0754     34.6656     0.72722     8.49867e-15     2.61779e-83
  145.000     1.12561e-10        0.00000         9.26476e-14       1.00000e+00      58.0584     34.6656     0.72612     4.01675e-14     7.78491e-80
  150.000     4.92489e-10        0.00000         3.92310e-13       1.00000e+00      58.0367     34.6656     0.72500     1.69887e-13     1.31989e-76
  155.000     1.94736e-09        0.00000         1.50289e-12       1.00000e+00      58.0097     34.6656     0.72385     6.50086e-13     1.34930e-73
  160.000     7.02626e-09        0.00000         5.25865e-12       1.00000e+00      57.9767     34.6656     0.72267     2.27227e-12     8.73369e-71
  165.000     2.33290e-08        0.00000         1.69477e-11       1.00000e+00      57.9370     34.6656     0.72146     7.31589e-12     3.73609e-68
  170.000     7.18105e-08        0.00000         5.06793e-11       1.00000e+00      57.8899     34.6656     0.72023     2.18572e-11     1.09685e-65
  175.000     2.06278e-07        0.00000         1.41534e-10       1.00000e+00      57.8349     34.6656     0.71895     6.09916e-11     2.28483e-63
  180.000     5.56182e-07        0.00000         3.71282e-10       1.00000e+00      57.7713     34.6656     0.71765     1.59882e-10     3.47833e-61
  185.000     1.41492e-06        0.00000         9.19575e-10       1.00000e+00      57.6987     34.6656     0.71630     3.95745e-10     3.97285e-59
  190.000     3.41197e-06        0.00000         2.16023e-09       1.00000e+00      57.6167     34.6656     0.71492     9.29195e-10     3.48522e-57
  195.000     7.83136e-06        0.00000         4.83309e-09       1.00000e+00      57.5250     34.6656     0.71350     2.07806e-09     2.39807e-55
  200.000     1.71730e-05        0.00000         1.03362e-08       1.00000e+00      57.4234     34.6656     0.71203     4.44295e-09     1.31878e-53
  205.000     3.60985e-05        0.00000         2.12010e-08       1.00000e+00      57.3118     34.6656     0.71053     9.11154e-09     5.89541e-52
  210.000     7.29604e-05        0.00000         4.18325e-08       1.00000e+00      57.1902     34.6656     0.70898     1.79773e-08     2.17532e-50
  215.000     1.42179e-04        0.00000         7.96191e-08       9.99999e-01      57.0586     34.6656     0.70739     3.42178e-08     6.71738e-49
  220.000     2.67804e-04        0.00000         1.46536e-07       9.99999e-01      56.9172     34.6656     0.70575     6.29870e-08     1.75785e-47
  225.000     4.88684e-04        0.00000         2.61384e-07       9.99998e-01      56.7664     34.6656     0.70407     1.12383e-07     3.94284e-46
  230.000     8.65710e-04        0.00000         4.52813e-07       9.99996e-01      56.6064     34.6656     0.70234     1.94761e-07     7.65921e-45
  235.000     1.49169e-03        0.00000         7.63282e-07       9.99993e-01      56.4377     34.6656     0.70057     3.28450e-07     1.30080e-43
  240.000     2.50444e-03        0.00000         1.25411e-06       9.99989e-01      56.2608     34.6656     0.69876     5.39957e-07     1.94828e-42
  245.000     4.10361e-03        0.00000         2.01172e-06       9.99984e-01      56.0762     34.6656     0.69690     8.66689e-07     2.59384e-41
  250.000     6.57194e-03        0.00000         3.15515e-06       9.99975e-01      55.8844     34.6656     0.69500     1.36025e-06     3.09209e-40
  255.000     1.03012e-02        0.00000         4.84495e-06       9.99963e-01      55.6862     34.6656     0.69305     2.09036e-06     3.32269e-39
  260.000     1.58236e-02        0.00000         7.29330e-06       9.99945e-01      55.4820     34.6656     0.69106     3.14928e-06     3.23849e-38
  265.000     2.38481e-02        0.00000         1.07755e-05       9.99921e-01      55.2726     34.6656     0.68903     4.65692e-06     2.87935e-37
  270.000     3.53030e-02        0.00000         1.56422e-05       9.99888e-01      55.0585     34.6656     0.68696     6.76632e-06     2.34772e-36
  275.000     5.13832e-02        0.00000         2.23331e-05       9.99845e-01      54.8404     34.6656     0.68485     9.66966e-06     1.76415e-35
  280.000     7.36027e-02        0.00000         3.13910e-05       9.99787e-01      54.6189     34.6656     0.68270     1.36045e-05     1.22730e-34
  285.000     1.03852e-01        0.00000         4.34757e-05       9.99712e-01      54.3945     34.6656     0.68051     1.88604e-05     7.93855e-34
  290.000     1.44459e-01        0.00000         5.93791e-05       9.99616e-01      54.1679     34.6656     0.67828     2.57851e-05     4.79340e-33
  295.000     1.98252e-01        0.00000         8.00389e-05       9.99495e-01      53.9394     34.6656     0.67602     3.47914e-05     2.71193e-32
  300.000     2.68629e-01        0.00000         1.06553e-04       9.99343e-01      53.7097     34.6656     0.67372     4.63630e-05     1.44267e-31
  305.000     3.59618e-01        0.00000         1.40190e-04       9.99156e-01      53.4791     34.6656     0.67138     6.10610e-05     7.24005e-31
  310.000     4.75953e-01        0.00000         1.82405e-04       9.98927e-01      53.2481     34.6656     0.66900     7.95287e-05     3.43834e-30
  315.000     6.23132e-01        0.00000         2.34847e-04       9.98650e-01      53.0169     34.6656     0.66659     1.02497e-04     1.54974e-29
  320.000     8.07488e-01        0.00000         2.99368e-04       9.98318e-01      52.7860     34.6656     0.66414     1.30789e-04     6.64777e-29
  325.000     1.03624e+00        0.00000         3.78031e-04       9.97924e-01      52.5556     34.6656     0.66165     1.65324e-04     2.72106e-28
  330.000     1.31758e+00        0.00000         4.73118e-04       9.97459e-01      52.3260     34.6656     0.65913     2.07120e-04     1.06542e-27
  335.000     1.66067e+00        0.00000         5.87132e-04       9.96915e-01      52.0974     34.6656     0.65656     2.57298e-04     3.99995e-27
  340.000     2.07577e+00        0.00000         7.22802e-04       9.96284e-01      51.8699     34.6656     0.65396     3.17082e-04     1.44315e-26
  345.000     2.57421e+00        0.00000         8.83084e-04       9.95558e-01      51.6436     34.6656     0.65132     3.87805e-04     5.01437e-26
  350.000     3.16848e+00        0.00000         1.07117e-03       9.94726e-01      51.4188     34.6656     0.64864     4.70907e-04     1.68135e-25
  355.000     3.87226e+00        0.00000         1.29046e-03       9.93779e-01      51.1954     34.6656     0.64592     5.67940e-04     5.45101e-25
  360.000     4.70045e+00        0.00000         1.54463e-03       9.92709e-01      50.9736     34.6656     0.64316     6.80567e-04     1.71192e-24
  365.000     5.66919e+00        0.00000         1.83753e-03       9.91506e-01      50.7532     34.6656     0.64035     8.10567e-04     5.21730e-24
  370.000     6.79592e+00        0.00000         2.17328e-03       9.90160e-01      50.5345     34.6656     0.63749     9.59836e-04     1.54563e-23
  375.000     8.09937e+00        0.00000         2.55623e-03       9.88661e-01      50.3172     34.6656     0.63459     1.13039e-03     4.45828e-23
  380.000     9.59964e+00        0.00000         2.99095e-03       9.87000e-01      50.1014     34.6656     0.63164     1.32437e-03     1.25405e-22
  385.000     1.13182e+01        0.00000         3.48225e-03       9.85167e-01      49.8870     34.6656     0.62864     1.54405e-03     3.44505e-22
  390.000     1.32778e+01        0.00000         4.03521e-03       9.83152e-01      49.6740     34.6656     0.62558     1.79183e-03     9.25646e-22
  395.000     1.55029e+01        0.00000         4.65512e-03       9.80947e-01      49.4622     34.6656     0.62247     2.07027e-03     2.43594e-21
  400.000     1.80192e+01        0.00000         5.34755e-03       9.78540e-01      49.2515     34.6656     0.61929     2.38205e-03     6.28701e-21
  405.000     2.08539e+01        0.00000         6.11836e-03       9.75923e-01      49.0419     34.6656     0.61606     2.73006e-03     1.59348e-20
  410.000     2.40359e+01        0.00000         6.97367e-03       9.73086e-01      48.8332     34.6656     0.61276     3.11732e-03     3.97122e-20
  415.000     2.75958e+01        0.00000         7.91991e-03       9.70018e-01      48.6252     34.6656     0.60939     3.54708e-03     9.74339e-20
  420.000     3.15657e+01        0.00000         8.96386e-03       9.66711e-01      48.4178     34.6656     0.60594     4.02277e-03     2.35627e-19
  425.000     3.59795e+01        0.00000         1.01126e-02       9.63155e-01      48.2108     34.6656     0.60243     4.54806e-03     5.62318e-19
  430.000     4.08731e+01        0.00000         1.13738e-02       9.59338e-01      48.0040     34.6656     0.59883     5.12689e-03     1.32581e-18
  435.000     4.62844e+01        0.00000         1.27552e-02       9.55252e-01      47.7973     34.6656     0.59514     5.76346e-03     3.09182e-18
  440.000     5.22533e+01        0.00000         1.42653e-02       9.50884e-01      47.5904     34.6656     0.59136     6.46233e-03     7.13959e-18
  445.000     5.88221e+01        0.00000         1.59132e-02       9.46225e-01      47.3830     34.6656     0.58749     7.22839e-03     1.63436e-17
  450.000     6.60354e+01        0.00000         1.77084e-02       9.41263e-01      47.1751     34.6656     0.58352     8.06695e-03     3.71297e-17
  455.000     7.39408e+01        0.00000         1.96613e-02       9.35985e-01      46.9663     34.6656     0.57944     8.98380e-03     8.38093e-17
  460.000     8.25887e+01        0.00000         2.17828e-02       9.30378e-01      46.7563     34.6656     0.57524     9.98525e-03     1.88173e-16
  465.000     9.20327e+01        0.00000         2.40850e-02       9.24429e-01      46.5449     34.6656     0.57092     1.10783e-02     4.20755e-16
  470.000     1.02330e+02        0.00000         2.65809e-02       9.18124e-01      46.3316     34.6656     0.56646     1.22705e-02     9.38070e-16
  475.000     1.13543e+02        0.00000         2.92849e-02       9.11445e-01      46.1163     34.6656     0.56187     1.35704e-02     2.08797e-15
  480.000     1.25737e+02        0.00000         3.22126e-02       9.04375e-01      45.8984     34.6656     0.55712     1.49874e-02     4.64591e-15
  485.000     1.38983e+02        0.00000         3.53815e-02       8.96894e-01      45.6775     34.6656     0.55221     1.65323e-02     1.03488e-14
  490.000     1.53360e+02        0.00000         3.88109e-02       8.88981e-01      45.4533     34.6656     0.54712     1.82171e-02     2.31118e-14
  495.000     1.68952e+02        0.00000         4.25229e-02       8.80612e-01      45.2251     34.6656     0.54184     2.00553e-02     5.18344e-14
  500.000     1.85853e+02        0.00000         4.65422e-02       8.71757e-01      44.9923     34.6656     0.53635     2.20627e-02     1.16956e-13
  505.000     2.04165e+02        0.00000         5.08970e-02       8.62385e-01      44.7543     34.6656     0.53063     2.42574e-02     2.66024e-13
  510.000     2.24005e+02        0.00000         5.56203e-02       8.52459e-01      44.5103     34.6656     0.52465     2.66606e-02     6.11355e-13
  515.000     2.45503e+02        0.00000         6.07503e-02       8.41935e-01      44.2594     34.6656     0.51840     2.92973e-02     1.42321e-12
  520.000     2.68808e+02        0.00000         6.63325e-02       8.30761e-01      44.0004     34.6656     0.51183     3.21973e-02     3.36634e-12
  525.000     2.94092e+02        0.00000         7.24213e-02       8.18875e-01      43.7320     34.6656     0.50491     3.53967e-02     8.11930e-12
  530.000     3.21558e+02        0.00000         7.90834e-02       8.06199e-01      43.4527     34.6656     0.49759     3.89401e-02     2.00554e-11
  535.000     3.51448e+02        0.00000         8.64015e-02       7.92639e-01      43.1604     34.6656     0.48981     4.28832e-02     5.10062e-11
  540.000     3.84058e+02        0.00000         9.44814e-02       7.78071e-01      42.8526     34.6656     0.48149     4.72976e-02     1.34477e-10
  545.000     4.19763e+02        0.00000         1.03461e-01       7.62334e-01      42.5260     34.6656     0.47254     5.22778e-02     3.70825e-10
  550.000     4.59049e+02        0.00000         1.13530e-01       7.45210e-01      42.1759     34.6656     0.46282     5.79527e-02     1.08252e-09
  555.000     5.02583e+02        0.00000         1.24953e-01       7.26385e-01      41.7958     34.6656     0.45213     6.45065e-02     3.40349e-09
  560.000     5.51328e+02        0.00000         1.38134e-01       7.05390e-01      41.3758     34.6656     0.44017     7.22185e-02     1.18295e-08
  565.000     6.06809e+02        0.00000         1.53738e-01       6.81444e-01      40.8996     34.6656     0.42648     8.15510e-02     4.74606e-08
  570.000     6.71792e+02        0.00000         1.73015e-01       6.53081e-01      40.3362     34.6656     0.41014     9.33788e-02     2.38604e-07
  575.000     7.52691e+02        0.00000         1.98991e-01       6.16748e-01      39.6100     34.6656     0.38894     1.09824e-01     1.83610e-06
  580.000     8.80985e+02        0.00000         2.47193e-01       5.54200e-01      38.3304     34.6656     0.35156     1.41817e-01     6.11414e-05
  580.796     9.45979e+02        0.00000         2.77357e-01       5.17805e-01      37.5585     34.6656     0.32922     1.62760e-01     4.86009e-04
  580.796     9.46220e+02        0.00000         2.77481e-01       5.17661e-01      37.5554     34.6656     0.32913     1.62847e-01     4.90076e-04
  580.000     1.00072e+03        0.00000         3.08819e-01       4.81786e-01      36.7673     34.6656     0.30662     1.85304e-01     3.97869e-03
  575.000     1.06430e+03        0.00000         3.64613e-01       4.22160e-01      35.3797     34.6656     0.26809     2.26870e-01     1.53628e-01
  570.822     1.08023e+03        0.00000         3.93116e-01       3.93421e-01      34.6694     34.6656     0.24911     2.48894e-01     9.90010e-01
  570.807     1.08027e+03        0.50000         3.93330e-01       3.93330e-01      34.6656     34.6656     0.24897     2.48966e-01     1.00000e+00
      NaN             NaN            NaN                 NaN               NaN          NaN         NaN         NaN             NaN             NaN
  287.955     6.53105e+01        0.00000         1.07222e-02       1.71124e-02      42.6376     34.6656     1.34625     6.85808e-01     3.45508e-16
  287.987     9.60248e+01        0.00000         1.57611e-02       2.51511e-02      42.6366     34.6656     1.34637     6.85977e-01     3.46327e-16
  288.034     1.41184e+02        0.00000         2.31657e-02       3.69598e-02      42.6353     34.6656     1.34655     6.86224e-01     3.47526e-16
  288.104     2.07580e+02        0.00000         3.40437e-02       5.42997e-02      42.6333     34.6656     1.34681     6.86585e-01     3.49274e-16
  288.205     3.05201e+02        0.00000         5.00187e-02       7.97467e-02      42.6304     34.6656     1.34719     6.87111e-01     3.51814e-16
  288.353     4.48731e+02        0.00000         7.34660e-02       1.17060e-01      42.6262     34.6656     1.34775     6.87872e-01     3.55484e-16
  288.567     6.59761e+02        0.00000         1.07854e-01       1.71710e-01      42.6202     34.6656     1.34857     6.88969e-01     3.60739e-16
  288.878     9.70035e+02        0.00000         1.58233e-01       2.51620e-01      42.6117     34.6656     1.34978     6.90533e-01     3.68165e-16
  289.323     1.42623e+03        0.00000         2.31923e-01       3.68208e-01      42.5997     34.6656     1.35153     6.92737e-01     3.78441e-16
  289.954     2.09695e+03        0.00000         3.39479e-01       5.37821e-01      42.5832     34.6656     1.35407     6.95789e-01     3.92201e-16
  290.837     3.08311e+03        0.00000         4.96018e-01       7.83696e-01      42.5613     34.6656     1.35774     6.99921e-01     4.09656e-16
  292.045     4.53305e+03        0.00000         7.23017e-01       1.13865e+00      42.5330     34.6656     1.36294     7.05353e-01     4.29858e-16
  293.655     6.66486e+03        0.00000         1.05077e+00       1.64885e+00      42.4982     34.6656     1.37018     7.12243e-01     4.49532e-16
  295.728     9.79922e+03        0.00000         1.52176e+00       2.37928e+00      42.4578     34.6656     1.37996     7.20623e-01     4.62057e-16
  298.292     1.44076e+04        0.00000         2.19568e+00       3.42202e+00      42.4139     34.6656     1.39267     7.30340e-01     4.58076e-16
  301.312     2.11833e+04        0.00000         3.15695e+00       4.90902e+00      42.3698     34.6656     1.40839     7.41033e-01     4.29495e-16
  304.685     3.11454e+04        0.00000         4.52679e+00       7.03205e+00      42.3286     34.6656     1.42673     7.52171e-01     3.75620e-16
  308.244     4.57925e+04        0.00000         6.48200e+00       1.00729e+01      42.2932     34.6656     1.44683     7.63131e-01     3.05830e-16
  311.784     6.73279e+04        0.00000         9.28360e+00       1.44490e+01      42.2652     34.6656     1.46746     7.73322e-01     2.34721e-16
  315.100     9.89910e+04        0.00000         1.33193e+01       2.07795e+01      42.2446     34.6656     1.48728     7.82290e-01     1.73950e-16
  318.034     1.45545e+05        0.00000         1.91653e+01       2.99825e+01      42.2306     34.6656     1.50519     7.89787e-01     1.28141e-16
  320.495     2.13992e+05        0.00000         2.76755e+01       4.34152e+01      42.2217     34.6656     1.52045     7.95774e-01     9.63149e-17
  322.462     3.14628e+05        0.00000         4.01112e+01       6.30787e+01      42.2163     34.6656     1.53282     8.00373e-01     7.51848e-17
  323.973     4.62593e+05        0.00000         5.83301e+01       9.19178e+01      42.2133     34.6656     1.54242     8.03794e-01     6.14239e-17
  325.097     6.80142e+05        0.00000         8.50648e+01       1.34263e+02      42.2116     34.6656     1.54962     8.06278e-01     5.24904e-17
  325.913     1.00000e+06        0.00000         1.24332e+02       1.96480e+02      42.2106     34.6656     1.55487     8.08047e-01     4.66618e-17
END

$Env_BP << END
#   Temp      Sat Pres                                                                                   Liq Den      Gas Den            
#   (R)        (psia)       Liq Mole Frac     Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)       Kmin/Kmax
#---------   ----------   ----------------   --------------   --------------   ---------   ---------   ----------   -----------   -------------
  570.807     1080.266         0.5000           0.393330         0.393330       34.6656     34.6656     0.248966     0.2489659     1.00000e+00
  570.792     1080.299         1.0000           0.393239         0.393561       34.6656     34.6615     0.249038     0.2488049     9.89443e-01
  570.000     1081.839         1.0000           0.388594         0.398185       34.6656     34.5448     0.252724     0.2457777     7.28504e-01
  565.000     1084.807         1.0000           0.362846         0.425062       34.6656     33.8717     0.273802     0.2283740     1.24643e-01
  560.000     1079.630         1.0000           0.341367         0.448269       34.6656     33.2852     0.292228     0.2136767     2.66914e-02
  555.000     1069.076         1.0000           0.322688         0.469055       34.6656     32.7541     0.308879     0.2007771     6.59073e-03
  550.000     1054.672         1.0000           0.306034         0.488085       34.6656     32.2621     0.324221     0.1891948     1.79731e-03
  545.000     1037.384         1.0000           0.290934         0.505758       34.6656     31.7993     0.338535     0.1786386     5.27403e-04
  540.000     1017.876         1.0000           0.277078         0.522340       34.6656     31.3593     0.352009     0.1689162     1.63704e-04
  535.000      996.633         1.0000           0.264248         0.538018       34.6656     30.9376     0.364775     0.1598927     5.31086e-05
  530.000      974.026         1.0000           0.252285         0.552926       34.6656     30.5308     0.376929     0.1514689     1.78498e-05
  525.000      950.347         1.0000           0.241066         0.567167       34.6656     30.1365     0.388546     0.1435694     6.17382e-06
  520.000      925.830         1.0000           0.230498         0.580823       34.6656     29.7528     0.399684     0.1361351     2.18594e-06
  515.000      900.672         1.0000           0.220505         0.593956       34.6656     29.3783     0.410391     0.1291186     7.88946e-07
  510.000      875.036         1.0000           0.211026         0.606618       34.6656     29.0116     0.420704     0.1224811     2.89246e-07
  505.000      849.060         1.0000           0.202010         0.618851       34.6656     28.6518     0.430656     0.1161905     1.07406e-07
  500.000      822.863         1.0000           0.193415         0.630690       34.6656     28.2982     0.440275     0.1102195     4.02945e-08
  495.000      796.549         1.0000           0.185205         0.642165       34.6656     27.9502     0.449584     0.1045448     1.52400e-08
  490.000      770.206         1.0000           0.177349         0.653301       34.6656     27.6071     0.458603     0.0991462     5.79985e-09
  485.000      743.914         1.0000           0.169822         0.664120       34.6656     27.2686     0.467350     0.0940060     2.21722e-09
  480.000      717.742         1.0000           0.162600         0.674640       34.6656     26.9344     0.475842     0.0891086     8.50152e-10
  475.000      691.751         1.0000           0.155663         0.684877       34.6656     26.6041     0.484092     0.0844402     3.26494e-10
  470.000      665.994         1.0000           0.148992         0.694846       34.6656     26.2776     0.492112     0.0799883     1.25425e-10
  465.000      640.520         1.0000           0.142574         0.704560       34.6656     25.9546     0.499915     0.0757415     4.81397e-11
  460.000      615.371         1.0000           0.136392         0.714029       34.6656     25.6351     0.507511     0.0716895     1.84391e-11
  455.000      590.585         1.0000           0.130436         0.723265       34.6656     25.3190     0.514909     0.0678230     7.04086e-12
  450.000      566.194         1.0000           0.124692         0.732275       34.6656     25.0062     0.522118     0.0641332     2.67740e-12
  445.000      542.228         1.0000           0.119152         0.741069       34.6656     24.6967     0.529146     0.0606122     1.01290e-12
  440.000      518.714         1.0000           0.113806         0.749654       34.6656     24.3905     0.536000     0.0572523     3.80858e-13
  435.000      495.674         1.0000           0.108646         0.758037       34.6656     24.0877     0.542688     0.0540467     1.42196e-13
  430.000      473.128         1.0000           0.103663         0.766225       34.6656     23.7883     0.549215     0.0509888     5.26653e-14
  425.000      451.093         1.0000           0.098851         0.774224       34.6656     23.4925     0.555588     0.0480724     1.93316e-14
  420.000      429.584         1.0000           0.094203         0.782040       34.6656     23.2002     0.561812     0.0452917     7.02603e-15
  415.000      408.615         1.0000           0.089713         0.789678       34.6656     22.9117     0.567894     0.0426412     2.52602e-15
  410.000      388.195         1.0000           0.085376         0.797144       34.6656     22.6270     0.573836     0.0401156     8.97496e-16
  405.000      368.335         1.0000           0.081186         0.804442       34.6656     22.3463     0.579645     0.0377100     3.14830e-16
  400.000      349.041         1.0000           0.077139         0.811577       34.6656     22.0698     0.585325     0.0354195     1.08928e-16
  395.000      330.320         1.0000           0.073231         0.818555       34.6656     21.7976     0.590880     0.0332396     3.71347e-17
  390.000      312.175         1.0000           0.069457         0.825378       34.6656     21.5299     0.596314     0.0311660     1.24609e-17
  385.000      294.611         1.0000           0.065813         0.832052       34.6656     21.2670     0.601631     0.0291945     4.11139e-18
  380.000      277.628         1.0000           0.062297         0.838581       34.6656     21.0090     0.606834     0.0273210     1.33234e-18
  375.000      261.227         1.0000           0.058904         0.844968       34.6656     20.7561     0.611927     0.0255416     4.23580e-19
  370.000      245.408         1.0000           0.055631         0.851217       34.6656     20.5085     0.616913     0.0238527     1.31959e-19
  365.000      230.171         1.0000           0.052477         0.857332       34.6656     20.2664     0.621795     0.0222506     4.02343e-20
  360.000      215.512         1.0000           0.049437         0.863316       34.6656     20.0301     0.626576     0.0207319     1.19909e-20
  355.000      201.430         1.0000           0.046510         0.869172       34.6656     19.7997     0.631260     0.0192932     3.48840e-21
  350.000      187.919         1.0000           0.043692         0.874904       34.6656     19.5754     0.635848     0.0179312     9.89278e-22
  345.000      174.975         1.0000           0.040983         0.880514       34.6656     19.3575     0.640344     0.0166429     2.73084e-22
  340.000      162.594         1.0000           0.038379         0.886004       34.6656     19.1462     0.644750     0.0154252     7.32653e-23
  335.000      150.770         1.0000           0.035878         0.891376       34.6656     18.9416     0.649068     0.0142752     1.90734e-23
  330.000      139.495         1.0000           0.033480         0.896633       34.6656     18.7439     0.653301     0.0131900     4.81005e-24
  325.000      128.762         1.0000           0.031182         0.901777       34.6656     18.5533     0.657451     0.0121670     1.17299e-24
  320.000      118.565         1.0000           0.028981         0.906808       34.6656     18.3699     0.661520     0.0112035     2.76085e-25
  315.000      108.895         1.0000           0.026878         0.911726       34.6656     18.1938     0.665510     0.0102970     6.25942e-26
  310.000       99.742         1.0000           0.024870         0.916534       34.6656     18.0252     0.669423     0.0094451     1.36412e-26
  305.000       91.098         1.0000           0.022955         0.921230       34.6656     17.8642     0.673262     0.0086453     2.85117e-27
  300.000       82.952         1.0000           0.021133         0.925814       34.6656     17.7108     0.677027     0.0078954     5.70184e-28
  295.000       75.294         1.0000           0.019401         0.930286       34.6656     17.5651     0.680721     0.0071933     1.08824e-28
  290.000       68.113         1.0000           0.017759         0.934644       34.6656     17.4272     0.684345     0.0065369     1.97687e-29
  287.955       65.310         1.0000           0.017112         0.936393       34.6656     17.3730     0.685808     0.0062811     9.69431e-30
END

set output "Figures/Env_006_P_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:2.0e+03] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set title "P-T Diagram for Solvent With\n1.e-10 Mole Fraction Reservoir Fluid A"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                    Liq Den       Gas Den             
#   (R)          (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
  366.345     1.00000e-12        0.00000         2.43835e-15       1.00000e+00      628.000     34.6656     1.04937     1.41242e-16     4.21174e-27
  370.000     2.42978e-12        0.00000         5.86769e-15       1.00000e+00      628.000     34.6656     1.04910     3.39799e-16     9.92525e-27
  375.000     7.93410e-12        0.00000         1.89115e-14       1.00000e+00      628.000     34.6656     1.04872     1.09477e-15     3.11189e-26
  380.000     2.50254e-11        0.00000         5.88865e-14       1.00000e+00      628.000     34.6656     1.04833     3.40763e-15     9.43733e-26
  385.000     7.63540e-11        0.00000         1.77399e-13       1.00000e+00      628.000     34.6656     1.04794     1.02619e-14     2.77209e-25
  390.000     2.25649e-10        0.00000         5.17739e-13       1.00000e+00      628.000     34.6656     1.04755     2.99381e-14     7.89694e-25
  395.000     6.46749e-10        0.00000         1.46570e-12       1.00000e+00      628.000     34.6656     1.04715     8.47216e-14     2.18441e-24
  400.000     1.79997e-09        0.00000         4.02974e-12       1.00000e+00      628.000     34.6656     1.04675     2.32841e-13     5.87400e-24
  405.000     4.86984e-09        0.00000         1.07721e-11       1.00000e+00      628.000     34.6656     1.04635     6.22179e-13     1.53722e-23
  410.000     1.28221e-08        0.00000         2.80276e-11       1.00000e+00      628.000     34.6656     1.04594     1.61820e-12     3.91921e-23
  415.000     3.28887e-08        0.00000         7.10526e-11       1.00000e+00      628.000     34.6656     1.04553     4.10067e-12     9.74421e-23
  420.000     8.22628e-08        0.00000         1.75674e-10       1.00000e+00      628.000     34.6656     1.04511     1.01347e-11     2.36479e-22
  425.000     2.00833e-07        0.00000         4.24008e-10       1.00000e+00      628.000     34.6656     1.04469     2.44513e-11     5.60696e-22
  430.000     4.78991e-07        0.00000         9.99914e-10       1.00000e+00      628.000     34.6656     1.04427     5.76387e-11     1.29993e-21
  435.000     1.11699e-06        0.00000         2.30591e-09       1.00000e+00      628.000     34.6656     1.04384     1.32866e-10     2.94935e-21
  440.000     2.54888e-06        0.00000         5.20426e-09       1.00000e+00      628.000     34.6656     1.04341     2.99746e-10     6.55361e-21
  445.000     5.69595e-06        0.00000         1.15040e-08       1.00000e+00      628.000     34.6656     1.04298     6.62311e-10     1.42727e-20
  450.000     1.24743e-05        0.00000         2.49247e-08       1.00000e+00      628.000     34.6656     1.04254     1.43436e-09     3.04868e-20
  455.000     2.67919e-05        0.00000         5.29667e-08       1.00000e+00      628.000     34.6656     1.04209     3.04683e-09     6.39125e-20
  460.000     5.64703e-05        0.00000         1.10474e-07       1.00000e+00      628.000     34.6656     1.04164     6.35211e-09     1.31587e-19
  465.000     1.16881e-04        0.00000         2.26297e-07       1.00000e+00      628.000     34.6656     1.04119     1.30061e-08     2.66228e-19
  470.000     2.37707e-04        0.00000         4.55535e-07       1.00000e+00      627.999     34.6656     1.04073     2.61698e-08     5.29628e-19
  475.000     4.75301e-04        0.00000         9.01661e-07       1.00000e+00      627.998     34.6656     1.04027     5.17763e-08     1.03659e-18
  480.000     9.34903e-04        0.00000         1.75585e-06       9.99999e-01      627.997     34.6656     1.03981     1.00782e-07     1.99707e-18
  485.000     1.80997e-03        0.00000         3.36577e-06       9.99999e-01      627.995     34.6656     1.03934     1.93101e-07     3.78931e-18
  490.000     3.45068e-03        0.00000         6.35420e-06       9.99998e-01      627.991     34.6656     1.03886     3.64389e-07     7.08468e-18
  495.000     6.48166e-03        0.00000         1.18203e-05       9.99996e-01      627.984     34.6656     1.03838     6.77546e-07     1.30583e-17
  500.000     1.20012e-02        0.00000         2.16770e-05       9.99992e-01      627.973     34.6656     1.03790     1.24198e-06     2.37388e-17
  505.000     2.19144e-02        0.00000         3.92077e-05       9.99986e-01      627.954     34.6656     1.03741     2.24543e-06     4.25834e-17
  510.000     3.94819e-02        0.00000         6.99758e-05       9.99976e-01      627.922     34.6656     1.03692     4.00585e-06     7.54101e-17
  515.000     7.02167e-02        0.00000         1.23290e-04       9.99959e-01      627.871     34.6656     1.03641     7.05516e-06     1.31896e-16
  520.000     1.23330e-01        0.00000         2.14544e-04       9.99930e-01      627.787     34.6656     1.03590     1.22731e-05     2.27964e-16
  525.000     2.14052e-01        0.00000         3.68922e-04       9.99881e-01      627.653     34.6656     1.03538     2.10993e-05     3.89556e-16
  530.000     3.67330e-01        0.00000         6.27236e-04       9.99801e-01      627.439     34.6656     1.03485     3.58692e-05     6.58611e-16
  535.000     6.23740e-01        0.00000         1.05511e-03       9.99672e-01      627.102     34.6656     1.03430     6.03459e-05     1.10254e-15
  540.000     1.04901e+00        0.00000         1.75757e-03       9.99462e-01      626.574     34.6656     1.03372     1.00572e-04     1.82949e-15
  545.000     1.74968e+00        0.00000         2.90252e-03       9.99127e-01      625.752     34.6656     1.03311     1.66263e-04     3.01360e-15
  550.000     2.89978e+00        0.00000         4.76003e-03       9.98591e-01      624.475     34.6656     1.03244     2.73193e-04     4.93861e-15
  555.000     4.78922e+00        0.00000         7.77165e-03       9.97733e-01      622.485     34.6656     1.03168     4.47521e-04     8.07886e-15
  560.000     7.92005e+00        0.00000         1.26844e-02       9.96347e-01      619.358     34.6656     1.03079     7.34488e-04     1.32654e-14
  565.000     1.32273e+01        0.00000         2.08489e-02       9.94053e-01      614.328     34.6656     1.02967     1.21862e-03     2.20822e-14
  570.000     2.27161e+01        0.00000         3.50511e-02       9.90036e-01      605.798     34.6656     1.02811     2.08287e-03     3.80592e-14
  571.677     2.75926e+01        0.00000         4.21822e-02       9.87993e-01      601.559     34.6656     1.02742     2.52781e-03     4.64093e-14
  573.261     3.35161e+01        0.00000         5.07057e-02       9.85523e-01      596.502     34.6656     1.02663     3.06966e-03     5.66963e-14
  574.725     4.07111e+01        0.00000         6.08665e-02       9.82530e-01      590.465     34.6656     1.02571     3.73047e-03     6.94196e-14
  576.037     4.94507e+01        0.00000         7.29392e-02       9.78896e-01      583.255     34.6656     1.02465     4.53776e-03     8.52336e-14
  577.159     6.00665e+01        0.00000         8.72244e-02       9.74474e-01      574.635     34.6656     1.02341     5.52615e-03     1.05008e-13
  578.039     7.29613e+01        0.00000         1.04039e-01       9.69075e-01      564.316     34.6656     1.02193     6.73960e-03     1.29925e-13
  578.614     8.86242e+01        0.00000         1.23695e-01       9.62457e-01      551.943     34.6656     1.02015     8.23451e-03     1.61622e-13
  578.803     1.07650e+02        0.00000         1.46466e-01       9.54302e-01      537.074     34.6656     1.01797     1.00844e-02     2.02447e-13
  578.499     1.30759e+02        0.00000         1.72520e-01       9.44186e-01      519.148     34.6656     1.01526     1.23870e-02     2.55886e-13
  577.560     1.58830e+02        0.00000         2.01802e-01       9.31524e-01      497.434     34.6656     1.01182     1.52755e-02     3.27383e-13
  575.792     1.92927e+02        0.00000         2.33824e-01       9.15480e-01      470.941     34.6656     1.00730     1.89380e-02     4.26007e-13
  572.918     2.34343e+02        0.00000         2.67254e-01       8.94794e-01      438.226     34.6656     1.00113     2.36533e-02     5.68326e-13
  568.517     2.84650e+02        0.00000         2.99016e-01       8.67420e-01      396.944     34.6656     0.99211     2.98672e-02     7.89096e-13
  561.882     3.45757e+02        0.00000         3.21843e-01       8.29628e-01      342.427     34.6656     0.97725     3.83794e-02     1.18058e-12
  551.642     4.19983e+02        0.00000         3.13196e-01       7.73133e-01      260.213     34.6656     0.94415     5.09536e-02     2.16014e-12
  548.175     4.41295e+02        0.00000         2.95692e-01       7.53598e-01      227.596     34.6656     0.92489     5.52746e-02     2.79650e-12
  548.175     4.41295e+02        0.00000         1.10122e-01       7.53598e-01       44.334     34.6656     0.48377     5.52746e-02     5.01024e-10
  555.890     5.10142e+02        0.00000         1.27090e-01       7.23285e-01       42.040     34.6656     0.45311     6.56521e-02     3.92380e-09
  566.067     6.19657e+02        0.00000         1.57450e-01       6.75893e-01       40.813     34.6656     0.42355     8.38032e-02     6.49638e-08
  575.000     7.52681e+02        0.00000         1.98985e-01       6.16754e-01       39.611     34.6656     0.38896     1.09821e-01     1.83486e-06
  580.000     8.80983e+02        0.00000         2.47192e-01       5.54201e-01       38.330     34.6656     0.35157     1.41817e-01     6.11361e-05
  580.796     9.45949e+02        0.00000         2.77342e-01       5.17824e-01       37.559     34.6656     0.32923     1.62749e-01     4.85492e-04
  580.796     9.46125e+02        0.00000         2.77432e-01       5.17718e-01       37.557     34.6656     0.32916     1.62812e-01     4.88469e-04
  580.000     1.00072e+03        0.00000         3.08819e-01       4.81786e-01       36.767     34.6656     0.30662     1.85304e-01     3.97870e-03
  575.000     1.06430e+03        0.00000         3.64613e-01       4.22160e-01       35.380     34.6656     0.26809     2.26870e-01     1.53628e-01
  570.822     1.08023e+03        0.00000         3.93116e-01       3.93421e-01       34.669     34.6656     0.24911     2.48894e-01     9.90003e-01
  570.807     1.08027e+03        0.50000         3.93330e-01       3.93330e-01       34.666     34.6656     0.24897     2.48966e-01     1.00000e+00
      NaN             NaN            NaN                 NaN               NaN          NaN         NaN         NaN             NaN             NaN
  287.955     6.53105e+01        0.00000         1.07222e-02       1.71124e-02       42.638     34.6656     1.34625     6.85808e-01     3.45508e-16
  287.987     9.60248e+01        0.00000         1.57611e-02       2.51511e-02       42.637     34.6656     1.34637     6.85977e-01     3.46327e-16
  288.034     1.41184e+02        0.00000         2.31657e-02       3.69598e-02       42.635     34.6656     1.34655     6.86224e-01     3.47526e-16
  288.104     2.07580e+02        0.00000         3.40437e-02       5.42997e-02       42.633     34.6656     1.34681     6.86585e-01     3.49274e-16
  288.205     3.05201e+02        0.00000         5.00187e-02       7.97467e-02       42.630     34.6656     1.34719     6.87111e-01     3.51814e-16
  288.353     4.48731e+02        0.00000         7.34660e-02       1.17060e-01       42.626     34.6656     1.34775     6.87872e-01     3.55484e-16
  288.567     6.59761e+02        0.00000         1.07854e-01       1.71710e-01       42.620     34.6656     1.34857     6.88969e-01     3.60739e-16
  288.878     9.70035e+02        0.00000         1.58233e-01       2.51620e-01       42.612     34.6656     1.34978     6.90533e-01     3.68165e-16
  289.323     1.42623e+03        0.00000         2.31923e-01       3.68208e-01       42.600     34.6656     1.35153     6.92737e-01     3.78441e-16
  289.954     2.09695e+03        0.00000         3.39479e-01       5.37821e-01       42.583     34.6656     1.35407     6.95789e-01     3.92201e-16
  290.837     3.08311e+03        0.00000         4.96018e-01       7.83696e-01       42.561     34.6656     1.35774     6.99921e-01     4.09656e-16
  292.045     4.53305e+03        0.00000         7.23017e-01       1.13865e+00       42.533     34.6656     1.36294     7.05353e-01     4.29858e-16
  293.655     6.66486e+03        0.00000         1.05077e+00       1.64885e+00       42.498     34.6656     1.37018     7.12243e-01     4.49532e-16
  295.728     9.79922e+03        0.00000         1.52176e+00       2.37928e+00       42.458     34.6656     1.37996     7.20623e-01     4.62057e-16
  298.292     1.44076e+04        0.00000         2.19568e+00       3.42202e+00       42.414     34.6656     1.39267     7.30340e-01     4.58076e-16
  301.312     2.11833e+04        0.00000         3.15695e+00       4.90902e+00       42.370     34.6656     1.40839     7.41033e-01     4.29495e-16
  304.685     3.11454e+04        0.00000         4.52679e+00       7.03205e+00       42.329     34.6656     1.42673     7.52171e-01     3.75620e-16
  308.244     4.57925e+04        0.00000         6.48200e+00       1.00729e+01       42.293     34.6656     1.44683     7.63131e-01     3.05830e-16
  311.784     6.73279e+04        0.00000         9.28360e+00       1.44490e+01       42.265     34.6656     1.46746     7.73322e-01     2.34721e-16
  315.100     9.89910e+04        0.00000         1.33193e+01       2.07795e+01       42.245     34.6656     1.48728     7.82290e-01     1.73950e-16
  318.034     1.45545e+05        0.00000         1.91653e+01       2.99825e+01       42.231     34.6656     1.50519     7.89787e-01     1.28141e-16
  320.495     2.13992e+05        0.00000         2.76755e+01       4.34152e+01       42.222     34.6656     1.52045     7.95774e-01     9.63149e-17
  322.462     3.14628e+05        0.00000         4.01112e+01       6.30787e+01       42.216     34.6656     1.53282     8.00373e-01     7.51848e-17
  323.973     4.62593e+05        0.00000         5.83301e+01       9.19178e+01       42.213     34.6656     1.54242     8.03794e-01     6.14239e-17
  325.097     6.80142e+05        0.00000         8.50648e+01       1.34263e+02       42.212     34.6656     1.54962     8.06278e-01     5.24904e-17
  325.913     1.00000e+06        0.00000         1.24332e+02       1.96480e+02       42.211     34.6656     1.55487     8.08047e-01     4.66618e-17
END

$Env_BP << END
#   Temp      Sat Pres                                                                                   Liq Den      Gas Den            
#   (R)        (psia)       Liq Mole Frac     Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)       Kmin/Kmax
#---------   ----------   ----------------   --------------   --------------   ---------   ---------   ----------   -----------   -------------
  570.807     1080.266         0.5000           0.393330         0.393330       34.6656     34.6656     0.248966     0.2489659     1.00000e+00
  570.792     1080.299         1.0000           0.393239         0.393560       34.6656     34.6615     0.249038     0.2488059     9.89486e-01
  570.000     1081.839         1.0000           0.388594         0.398185       34.6656     34.5448     0.252724     0.2457777     7.28504e-01
  565.000     1084.807         1.0000           0.362846         0.425062       34.6656     33.8717     0.273802     0.2283740     1.24643e-01
  560.000     1079.630         1.0000           0.341367         0.448269       34.6656     33.2852     0.292228     0.2136767     2.66914e-02
  555.000     1069.076         1.0000           0.322688         0.469055       34.6656     32.7541     0.308879     0.2007771     6.59073e-03
  550.000     1054.672         1.0000           0.306034         0.488085       34.6656     32.2621     0.324221     0.1891948     1.79731e-03
  545.000     1037.384         1.0000           0.290934         0.505758       34.6656     31.7993     0.338535     0.1786386     5.27403e-04
  540.000     1017.876         1.0000           0.277078         0.522340       34.6656     31.3593     0.352009     0.1689162     1.63704e-04
  535.000      996.633         1.0000           0.264248         0.538018       34.6656     30.9376     0.364775     0.1598927     5.31086e-05
  530.000      974.026         1.0000           0.252285         0.552926       34.6656     30.5308     0.376929     0.1514689     1.78498e-05
  525.000      950.347         1.0000           0.241066         0.567167       34.6656     30.1365     0.388546     0.1435694     6.17382e-06
  520.000      925.830         1.0000           0.230498         0.580823       34.6656     29.7528     0.399684     0.1361351     2.18594e-06
  515.000      900.672         1.0000           0.220505         0.593956       34.6656     29.3783     0.410391     0.1291186     7.88946e-07
  510.000      875.036         1.0000           0.211026         0.606618       34.6656     29.0116     0.420704     0.1224811     2.89246e-07
  505.000      849.060         1.0000           0.202010         0.618851       34.6656     28.6518     0.430656     0.1161905     1.07406e-07
  500.000      822.863         1.0000           0.193415         0.630690       34.6656     28.2982     0.440275     0.1102195     4.02945e-08
  495.000      796.549         1.0000           0.185205         0.642165       34.6656     27.9502     0.449584     0.1045448     1.52400e-08
  490.000      770.206         1.0000           0.177349         0.653301       34.6656     27.6071     0.458603     0.0991462     5.79985e-09
  485.000      743.914         1.0000           0.169822         0.664120       34.6656     27.2686     0.467350     0.0940060     2.21722e-09
  480.000      717.742         1.0000           0.162600         0.674640       34.6656     26.9344     0.475842     0.0891086     8.50152e-10
  475.000      691.751         1.0000           0.155663         0.684877       34.6656     26.6041     0.484092     0.0844402     3.26494e-10
  470.000      665.994         1.0000           0.148992         0.694846       34.6656     26.2776     0.492112     0.0799883     1.25425e-10
  465.000      640.520         1.0000           0.142574         0.704560       34.6656     25.9546     0.499915     0.0757415     4.81397e-11
  460.000      615.371         1.0000           0.136392         0.714029       34.6656     25.6351     0.507511     0.0716895     1.84391e-11
  455.000      590.585         1.0000           0.130436         0.723265       34.6656     25.3190     0.514909     0.0678230     7.04086e-12
  450.000      566.194         1.0000           0.124692         0.732275       34.6656     25.0062     0.522118     0.0641332     2.67740e-12
  445.000      542.228         1.0000           0.119152         0.741069       34.6656     24.6967     0.529146     0.0606122     1.01290e-12
  440.000      518.714         1.0000           0.113806         0.749654       34.6656     24.3905     0.536000     0.0572523     3.80858e-13
  435.000      495.674         1.0000           0.108646         0.758037       34.6656     24.0877     0.542688     0.0540467     1.42196e-13
  430.000      473.128         1.0000           0.103663         0.766225       34.6656     23.7883     0.549215     0.0509888     5.26653e-14
  425.000      451.093         1.0000           0.098851         0.774224       34.6656     23.4925     0.555588     0.0480724     1.93316e-14
  420.000      429.584         1.0000           0.094203         0.782040       34.6656     23.2002     0.561812     0.0452917     7.02603e-15
  415.000      408.615         1.0000           0.089713         0.789678       34.6656     22.9117     0.567894     0.0426412     2.52602e-15
  410.000      388.195         1.0000           0.085376         0.797144       34.6656     22.6270     0.573836     0.0401156     8.97496e-16
  405.000      368.335         1.0000           0.081186         0.804442       34.6656     22.3463     0.579645     0.0377100     3.14830e-16
  400.000      349.041         1.0000           0.077139         0.811577       34.6656     22.0698     0.585325     0.0354195     1.08928e-16
  395.000      330.320         1.0000           0.073231         0.818555       34.6656     21.7976     0.590880     0.0332396     3.71347e-17
  390.000      312.175         1.0000           0.069457         0.825378       34.6656     21.5299     0.596314     0.0311660     1.24609e-17
  385.000      294.611         1.0000           0.065813         0.832052       34.6656     21.2670     0.601631     0.0291945     4.11139e-18
  380.000      277.628         1.0000           0.062297         0.838581       34.6656     21.0090     0.606834     0.0273210     1.33234e-18
  375.000      261.227         1.0000           0.058904         0.844968       34.6656     20.7561     0.611927     0.0255416     4.23580e-19
  370.000      245.408         1.0000           0.055631         0.851217       34.6656     20.5085     0.616913     0.0238527     1.31959e-19
  365.000      230.171         1.0000           0.052477         0.857332       34.6656     20.2664     0.621795     0.0222506     4.02343e-20
  360.000      215.512         1.0000           0.049437         0.863316       34.6656     20.0301     0.626576     0.0207319     1.19909e-20
  355.000      201.430         1.0000           0.046510         0.869172       34.6656     19.7997     0.631260     0.0192932     3.48840e-21
  350.000      187.919         1.0000           0.043692         0.874904       34.6656     19.5754     0.635848     0.0179312     9.89278e-22
  345.000      174.975         1.0000           0.040983         0.880514       34.6656     19.3575     0.640344     0.0166429     2.73084e-22
  340.000      162.594         1.0000           0.038379         0.886004       34.6656     19.1462     0.644750     0.0154252     7.32653e-23
  335.000      150.770         1.0000           0.035878         0.891376       34.6656     18.9416     0.649068     0.0142752     1.90734e-23
  330.000      139.495         1.0000           0.033480         0.896633       34.6656     18.7439     0.653301     0.0131900     4.81005e-24
  325.000      128.762         1.0000           0.031182         0.901777       34.6656     18.5533     0.657451     0.0121670     1.17299e-24
  320.000      118.565         1.0000           0.028981         0.906808       34.6656     18.3699     0.661520     0.0112035     2.76085e-25
  315.000      108.895         1.0000           0.026878         0.911726       34.6656     18.1938     0.665510     0.0102970     6.25942e-26
  310.000       99.742         1.0000           0.024870         0.916534       34.6656     18.0252     0.669423     0.0094451     1.36412e-26
  305.000       91.098         1.0000           0.022955         0.921230       34.6656     17.8642     0.673262     0.0086453     2.85117e-27
  300.000       82.952         1.0000           0.021133         0.925814       34.6656     17.7108     0.677027     0.0078954     5.70184e-28
  295.000       75.294         1.0000           0.019401         0.930286       34.6656     17.5651     0.680721     0.0071933     1.08824e-28
  290.000       68.113         1.0000           0.017759         0.934644       34.6656     17.4272     0.684345     0.0065369     1.97687e-29
  287.955       65.310         1.0000           0.017112         0.936393       34.6656     17.3730     0.685808     0.0062811     9.69431e-30
END

set output "Figures/Env_007_P_vs_T_1.pdf"
set xlabel "Temperature (R)"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:2.0e+03] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set title "P-X Diagram for Reservoir Fluid A with Solvent"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       8.86016e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       8.86017e-07        0.000000         1.25126e-09         1.00000        627.982     125.165     1.02114     2.54664e-10     1.23038e-11
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       8.86017e-07        0.000000         1.25127e-09         1.00000        627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       8.86018e-07        0.000000         1.25127e-09         1.00000        627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       8.86021e-07        0.000000         1.25127e-09         1.00000        627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       8.86025e-07        0.000000         1.25128e-09         1.00000        627.982     125.164     1.02114     2.54664e-10     1.23038e-11
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       8.86034e-07        0.000000         1.25129e-09         1.00000        627.982     125.163     1.02114     2.54665e-10     1.23038e-11
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       8.86061e-07        0.000000         1.25133e-09         1.00000        627.982     125.160     1.02114     2.54667e-10     1.23038e-11
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       8.86105e-07        0.000000         1.25139e-09         1.00000        627.982     125.156     1.02114     2.54671e-10     1.23038e-11
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       8.86194e-07        0.000000         1.25151e-09         1.00000        627.982     125.146     1.02114     2.54678e-10     1.23038e-11
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       8.86459e-07        0.000000         1.25189e-09         1.00000        627.982     125.119     1.02114     2.54699e-10     1.23038e-11
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       8.86903e-07        0.000000         1.25252e-09         1.00000        627.982     125.074     1.02114     2.54734e-10     1.23038e-11
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       8.87792e-07        0.000000         1.25377e-09         1.00000        627.982     124.984     1.02114     2.54805e-10     1.23038e-11
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       8.90469e-07        0.000000         1.25755e-09         1.00000        627.982     124.712     1.02114     2.55018e-10     1.23038e-11
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       8.94966e-07        0.000000         1.26390e-09         1.00000        627.982     124.260     1.02114     2.55376e-10     1.23038e-11
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       9.04098e-07        0.000000         1.27680e-09         1.00000        627.982     123.355     1.02114     2.56103e-10     1.23038e-11
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       9.13419e-07        0.000000         1.28996e-09         1.00000        627.982     122.450     1.02114     2.56845e-10     1.23038e-11
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       9.22934e-07        0.000000         1.30340e-09         1.00000        627.982     121.545     1.02114     2.57603e-10     1.23038e-11
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       9.32649e-07        0.000000         1.31712e-09         1.00000        627.982     120.640     1.02114     2.58376e-10     1.23038e-11
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       9.42570e-07        0.000000         1.33113e-09         1.00000        627.982     119.735     1.02114     2.59166e-10     1.23038e-11
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       9.52706e-07        0.000000         1.34545e-09         1.00000        627.982     118.830     1.02114     2.59973e-10     1.23038e-11
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       9.63061e-07        0.000000         1.36007e-09         1.00000        627.982     117.925     1.02114     2.60797e-10     1.23038e-11
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       9.73644e-07        0.000000         1.37502e-09         1.00000        627.982     117.020     1.02114     2.61639e-10     1.23038e-11
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       9.84463e-07        0.000000         1.39029e-09         1.00000        627.982     116.115     1.02114     2.62501e-10     1.23038e-11
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       9.95524e-07        0.000000         1.40591e-09         1.00000        627.982     115.210     1.02114     2.63381e-10     1.23038e-11
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       1.00684e-06        0.000000         1.42189e-09         1.00000        627.982     114.305     1.02114     2.64282e-10     1.23038e-11
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       1.01841e-06        0.000000         1.43823e-09         1.00000        627.982     113.400     1.02114     2.65203e-10     1.23038e-11
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       1.03025e-06        0.000000         1.45496e-09         1.00000        627.982     112.495     1.02114     2.66146e-10     1.23038e-11
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       1.04237e-06        0.000000         1.47208e-09         1.00000        627.982     111.590     1.02114     2.67110e-10     1.23038e-11
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       1.05478e-06        0.000000         1.48960e-09         1.00000        627.982     110.685     1.02114     2.68098e-10     1.23038e-11
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       1.06749e-06        0.000000         1.50755e-09         1.00000        627.982     109.780     1.02114     2.69110e-10     1.23038e-11
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       1.08051e-06        0.000000         1.52593e-09         1.00000        627.982     108.875     1.02114     2.70146e-10     1.23038e-11
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       1.09385e-06        0.000000         1.54477e-09         1.00000        627.982     107.970     1.02114     2.71208e-10     1.23038e-11
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       1.10752e-06        0.000000         1.56408e-09         1.00000        627.982     107.065     1.02114     2.72297e-10     1.23038e-11
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       1.12154e-06        0.000000         1.58388e-09         1.00000        627.982     106.160     1.02114     2.73413e-10     1.23038e-11
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       1.13592e-06        0.000000         1.60418e-09         1.00000        627.982     105.255     1.02114     2.74557e-10     1.23038e-11
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       1.15067e-06        0.000000         1.62502e-09         1.00000        627.982     104.350     1.02114     2.75732e-10     1.23038e-11
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       1.16581e-06        0.000000         1.64640e-09         1.00000        627.982     103.445     1.02114     2.76937e-10     1.23038e-11
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       1.18136e-06        0.000000         1.66835e-09         1.00000        627.982     102.540     1.02114     2.78174e-10     1.23038e-11
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       1.19732e-06        0.000000         1.69090e-09         1.00000        627.982     101.635     1.02114     2.79445e-10     1.23038e-11
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       1.21372e-06        0.000000         1.71406e-09         1.00000        627.982     100.730     1.02114     2.80751e-10     1.23038e-11
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       1.23058e-06        0.000000         1.73787e-09         1.00000        627.982      99.825     1.02114     2.82093e-10     1.23038e-11
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       1.24791e-06        0.000000         1.76234e-09         1.00000        627.982      98.920     1.02114     2.83472e-10     1.23038e-11
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       1.26574e-06        0.000000         1.78752e-09         1.00000        627.982      98.015     1.02114     2.84892e-10     1.23038e-11
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       1.28408e-06        0.000000         1.81343e-09         1.00000        627.982      97.110     1.02114     2.86352e-10     1.23038e-11
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       1.30297e-06        0.000000         1.84009e-09         1.00000        627.982      96.205     1.02114     2.87855e-10     1.23038e-11
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       1.32241e-06        0.000000         1.86756e-09         1.00000        627.982      95.300     1.02114     2.89403e-10     1.23038e-11
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       1.34245e-06        0.000000         1.89585e-09         1.00000        627.982      94.395     1.02114     2.90998e-10     1.23038e-11
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       1.36310e-06        0.000000         1.92502e-09         1.00000        627.982      93.490     1.02114     2.92642e-10     1.23038e-11
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       1.38440e-06        0.000000         1.95510e-09         1.00000        627.982      92.585     1.02114     2.94338e-10     1.23038e-11
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       1.40638e-06        0.000000         1.98613e-09         1.00000        627.982      91.680     1.02114     2.96087e-10     1.23038e-11
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       1.42906e-06        0.000000         2.01817e-09         1.00000        627.982      90.775     1.02114     2.97893e-10     1.23038e-11
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       1.45249e-06        0.000000         2.05125e-09         1.00000        627.982      89.870     1.02114     2.99758e-10     1.23038e-11
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       1.47669e-06        0.000000         2.08544e-09         1.00000        627.982      88.965     1.02114     3.01685e-10     1.23038e-11
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       1.50172e-06        0.000000         2.12079e-09         1.00000        627.982      88.060     1.02114     3.03677e-10     1.23038e-11
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       1.52761e-06        0.000000         2.15735e-09         1.00000        627.982      87.155     1.02114     3.05738e-10     1.23038e-11
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       1.55441e-06        0.000000         2.19520e-09         1.00000        627.982      86.250     1.02114     3.07872e-10     1.23038e-11
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       1.58217e-06        0.000000         2.23440e-09         1.00000        627.982      85.345     1.02114     3.10081e-10     1.23038e-11
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       1.61094e-06        0.000000         2.27503e-09         1.00000        627.982      84.440     1.02114     3.12371e-10     1.23038e-11
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       1.64077e-06        0.000000         2.31716e-09         1.00000        627.982      83.535     1.02114     3.14746e-10     1.23038e-11
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       1.67173e-06        0.000000         2.36088e-09         1.00000        627.982      82.630     1.02114     3.17211e-10     1.23038e-11
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       1.70388e-06        0.000000         2.40628e-09         1.00000        627.982      81.725     1.02114     3.19770e-10     1.23038e-11
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       1.73729e-06        0.000000         2.45346e-09         1.00000        627.982      80.820     1.02114     3.22429e-10     1.23038e-11
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       1.77203e-06        0.000000         2.50253e-09         1.00000        627.982      79.915     1.02114     3.25195e-10     1.23038e-11
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       1.80820e-06        0.000000         2.55360e-09         1.00000        627.982      79.010     1.02114     3.28074e-10     1.23038e-11
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       1.84587e-06        0.000000         2.60680e-09         1.00000        627.982      78.105     1.02114     3.31073e-10     1.23038e-11
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       1.88514e-06        0.000000         2.66226e-09         1.00000        627.982      77.200     1.02114     3.34199e-10     1.23038e-11
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       1.92612e-06        0.000000         2.72014e-09         1.00000        627.982      76.295     1.02114     3.37462e-10     1.23038e-11
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       1.96893e-06        0.000000         2.78059e-09         1.00000        627.982      75.390     1.02114     3.40869e-10     1.23038e-11
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       2.01367e-06        0.000000         2.84378e-09         1.00000        627.982      74.485     1.02114     3.44431e-10     1.23038e-11
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       2.06050e-06        0.000000         2.90992e-09         1.00000        627.982      73.580     1.02114     3.48159e-10     1.23038e-11
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       2.10956e-06        0.000000         2.97920e-09         1.00000        627.982      72.675     1.02114     3.52065e-10     1.23038e-11
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       2.16102e-06        0.000000         3.05186e-09         1.00000        627.982      71.770     1.02114     3.56160e-10     1.23038e-11
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       2.21504e-06        0.000000         3.12816e-09         1.00000        627.982      70.865     1.02114     3.60461e-10     1.23038e-11
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       2.27184e-06        0.000000         3.20837e-09         1.00000        627.982      69.960     1.02114     3.64982e-10     1.23038e-11
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       2.33162e-06        0.000000         3.29280e-09         1.00000        627.982      69.055     1.02114     3.69742e-10     1.23038e-11
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       2.39464e-06        0.000000         3.38179e-09         1.00000        627.982      68.150     1.02114     3.74758e-10     1.23038e-11
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       2.46116e-06        0.000000         3.47573e-09         1.00000        627.982      67.245     1.02114     3.80053e-10     1.23038e-11
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       2.53148e-06        0.000000         3.57504e-09         1.00000        627.982      66.340     1.02114     3.85651e-10     1.23038e-11
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       2.60593e-06        0.000000         3.68019e-09         1.00000        627.982      65.435     1.02114     3.91578e-10     1.23038e-11
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       2.68490e-06        0.000000         3.79171e-09         1.00000        627.982      64.530     1.02114     3.97864e-10     1.23038e-11
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       2.76880e-06        0.000000         3.91020e-09         1.00000        627.982      63.625     1.02114     4.04543e-10     1.23038e-11
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       2.85812e-06        0.000000         4.03634e-09         1.00000        627.982      62.720     1.02114     4.11654e-10     1.23038e-11
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       2.95339e-06        0.000000         4.17088e-09         1.00000        627.982      61.815     1.02114     4.19238e-10     1.23038e-11
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       3.05523e-06        0.000000         4.31470e-09         1.00000        627.982      60.910     1.02114     4.27345e-10     1.23038e-11
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       3.16434e-06        0.000000         4.46880e-09         1.00000        627.982      60.005     1.02114     4.36031e-10     1.23038e-11
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       3.28154e-06        0.000000         4.63431e-09         1.00000        627.982      59.100     1.02114     4.45360e-10     1.23038e-11
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       3.40775e-06        0.000000         4.81255e-09         1.00000        627.982      58.195     1.02114     4.55408e-10     1.23038e-11
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       3.54407e-06        0.000000         5.00506e-09         1.00000        627.982      57.290     1.02114     4.66259e-10     1.23038e-11
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       3.69173e-06        0.000000         5.21360e-09         1.00000        627.982      56.385     1.02114     4.78014e-10     1.23038e-11
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       3.85224e-06        0.000000         5.44028e-09         1.00000        627.982      55.480     1.02114     4.90791e-10     1.23038e-11
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       4.02735e-06        0.000000         5.68756e-09         1.00000        627.982      54.575     1.02114     5.04730e-10     1.23038e-11
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       4.21913e-06        0.000000         5.95840e-09         1.00000        627.982      53.670     1.02114     5.19997e-10     1.23038e-11
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       4.43008e-06        0.000000         6.25632e-09         1.00000        627.982      52.765     1.02114     5.36790e-10     1.23038e-11
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       4.66324e-06        0.000000         6.58560e-09         1.00000        627.982      51.860     1.02114     5.55351e-10     1.23038e-11
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       4.92231e-06        0.000000         6.95147e-09         1.00000        627.982      50.955     1.02114     5.75975e-10     1.23038e-11
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       5.21186e-06        0.000000         7.36038e-09         1.00000        627.982      50.050     1.02114     5.99024e-10     1.23038e-11
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       5.53760e-06        0.000000         7.82040e-09         1.00000        627.982      49.145     1.02114     6.24955e-10     1.23038e-11
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       5.90678e-06        0.000000         8.34176e-09         1.00000        627.982      48.240     1.02114     6.54343e-10     1.23038e-11
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       6.32869e-06        0.000000         8.93760e-09         1.00000        627.982      47.335     1.02114     6.87930e-10     1.23038e-11
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       6.81551e-06        0.000000         9.62511e-09         1.00000        627.982      46.430     1.02114     7.26683e-10     1.23038e-11
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       7.38347e-06        0.000000         1.04272e-08         1.00000        627.982      45.525     1.02114     7.71896e-10     1.23038e-11
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       8.05469e-06        0.000000         1.13751e-08         1.00000        627.982      44.620     1.02114     8.25329e-10     1.23038e-11
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       8.86016e-06        0.000000         1.25126e-08         1.00000        627.982      43.715     1.02114     8.89449e-10     1.23038e-11
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       9.84463e-06        0.000000         1.39029e-08         1.00000        627.982      42.810     1.02114     9.67817e-10     1.23038e-11
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       1.10752e-05        0.000000         1.56408e-08         1.00000        627.982      41.905     1.02114     1.06578e-09     1.23038e-11
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       1.26574e-05        0.000000         1.78752e-08         1.00000        627.982      41.001     1.02114     1.19173e-09     1.23038e-11
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       1.47669e-05        0.000000         2.08544e-08         1.00000        627.982      40.096     1.02114     1.35966e-09     1.23038e-11
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       1.77203e-05        0.000000         2.50253e-08         1.00000        627.982      39.191     1.02114     1.59477e-09     1.23038e-11
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       2.21504e-05        0.000000         3.12816e-08         1.00000        627.982      38.286     1.02114     1.94742e-09     1.23038e-11
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       2.95339e-05        0.000000         4.17088e-08         1.00000        627.982      37.381     1.02114     2.53519e-09     1.23038e-11
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.43008e-05        0.000000         6.25632e-08         1.00000        627.982      36.476     1.02114     3.71072e-09     1.23038e-11
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       8.86017e-05        0.000000         1.25126e-07         1.00000        627.982      35.571     1.02114     7.23730e-09     1.23038e-11
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       1.77203e-04        0.000000         2.50253e-07         1.00000        627.982      35.118     1.02114     1.42905e-08     1.23038e-11
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       4.43009e-04        0.000000         6.25634e-07         1.00000        627.982      34.847     1.02114     3.54501e-08     1.23039e-11
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       8.86022e-04        0.000000         1.25127e-06         1.00000        627.982      34.756     1.02114     7.07162e-08     1.23039e-11
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.77205e-03        0.000000         2.50256e-06         1.00000        627.981      34.711     1.02114     1.41249e-07     1.23040e-11
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       4.43022e-03        0.000000         6.25649e-06         1.00000        627.980      34.684     1.02114     3.52854e-07     1.23043e-11
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       8.86070e-03        0.000000         1.25133e-05         1.00000        627.978      34.675     1.02114     7.05545e-07     1.23047e-11
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.77225e-02        0.000000         2.50280e-05         0.99999        627.973      34.670     1.02114     1.41100e-06     1.23055e-11
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       4.43143e-02        0.000000         6.25801e-05         0.99999        627.959      34.667     1.02113     3.52789e-06     1.23081e-11
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       8.86556e-02        0.000000         1.25194e-04         0.99997        627.935      34.666     1.02113     7.05783e-06     1.23123e-11
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.77419e-01        0.000000         2.50523e-04         0.99995        627.888      34.666     1.02113     1.41245e-05     1.23208e-11
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       4.44363e-01        0.000000         6.27328e-04         0.99987        627.747      34.666     1.02111     3.53784e-05     1.23463e-11
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       8.91460e-01        0.000000         1.25808e-03         0.99974        627.511      34.666     1.02108     7.09837e-05     1.23892e-11
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.79402e+00        0.000000         2.53003e-03         0.99948        627.034      34.666     1.02102     1.42888e-04     1.24762e-11
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       4.57152e+00        0.000000         6.43309e-03         0.99867        625.570      34.666     1.02085     3.64404e-04     1.27481e-11
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       9.45562e+00        0.000000         1.32555e-02         0.99724        623.007      34.666     1.02054     7.54801e-04     1.32409e-11
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       2.03928e+01        0.000000         2.83464e-02         0.99405        617.320      34.666     1.01984     1.63310e-03     1.44167e-11
   1.00000e+00        3.50935e-08        1.00000e+00        1.26710e-07       3.13399e+01        0.000000         4.31959e-02         0.99085        611.700      34.666     1.01915     2.51786e-03     1.57011e-11
   1.00000e+00        2.56631e-08        1.00000e+00        9.26599e-08       4.81634e+01        0.000000         6.55308e-02         0.98593        603.203      34.666     1.01807     3.88878e-03     1.79081e-11
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.40178e+01        0.000000         9.87435e-02         0.97836        590.468      34.666     1.01641     6.02257e-03     2.19392e-11
   1.00000e+00        1.76689e-08        1.00000e+00        6.37959e-08       1.01942e+02        0.000000         1.33164e-01         0.97016        577.145      34.666     1.01460     8.36470e-03     2.73515e-11
   1.00000e+00        1.68479e-08        1.00000e+00        6.08317e-08       1.40401e+02        0.000000         1.78239e-01         0.95886        559.509      34.666     1.01209     1.16562e-02     3.71351e-11
   1.00000e+00        1.68479e-08        1.00000e+00        6.08317e-08       1.40428e+02        0.000000         1.78270e-01         0.95885        559.496      34.666     1.01209     1.16586e-02     3.71432e-11
   1.00000e+00        1.75134e-08        1.00000e+00        6.32345e-08       1.82204e+02        0.000000         2.24367e-01         0.94654        541.246      34.666     1.00934     1.53236e-02     5.19230e-11
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       2.36407e+02        0.000000         2.80100e-01         0.93053        518.916      34.666     1.00575     2.02243e-02     8.05473e-11
   1.00000e+00        2.42939e-08        1.00000e+00        8.77165e-08       2.91082e+02        0.000000         3.32094e-01         0.91433        497.871      34.666     1.00211     2.53428e-02     1.26082e-10
   1.00000e+00        3.26634e-08        1.00000e+00        1.17935e-07       3.58403e+02        0.000000         3.90958e-01         0.89435        473.898      34.666     0.99763     3.19013e-02     2.20498e-10
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       4.41294e+02        0.000000         4.56717e-01         0.86971        447.159      34.666     0.99217     4.03922e-02     4.43709e-10
   1.00000e+00        6.85252e-08        1.00000e+00        2.47419e-07       4.96963e+02        0.000000         4.97355e-01         0.85316        430.828      34.666     0.98857     4.63701e-02     7.14518e-10
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       5.59655e+02        0.000000         5.40285e-01         0.83455        413.919      34.666     0.98460     5.33840e-02     1.22973e-09
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       6.66783e+02        0.000000         6.08092e-01         0.80293        388.447      34.666     0.97812     6.61076e-02     3.15632e-09
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       7.98217e+02        0.000000         6.84606e-01         0.76476        362.619      34.666     0.97090     8.30878e-02     1.02546e-08
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       8.92697e+02        0.000000         7.36933e-01         0.73810        347.385      34.666     0.96634     9.62785e-02     2.41642e-08
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       9.84582e+02        0.000000         7.86828e-01         0.71316        334.946      34.666     0.96248     1.09903e-01     5.57474e-08
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.10433e+03        0.000000         8.51519e-01         0.68275        321.778      34.666     0.95831     1.28762e-01     1.64296e-07
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.19544e+03        0.000000         9.00964e-01         0.66176        313.674      34.666     0.95575     1.43807e-01     3.67133e-07
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.28886e+03        0.000000         9.51969e-01         0.64267        306.711      34.667     0.95358     1.59655e-01     8.13643e-07
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.41971e+03        0.000000         1.02358e+00         0.62080        298.623      34.670     0.95113     1.82072e-01     2.31125e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.52816e+03        0.000000         1.08256e+00         0.60732        292.891      34.675     0.94944     2.00359e-01     5.07825e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.64959e+03        0.000000         1.14755e+00         0.59712        287.097      34.684     0.94771     2.20029e-01     1.11668e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.84132e+03        0.000000         1.24686e+00         0.59026        278.697      34.711     0.94512     2.48652e-01     3.18463e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       2.02309e+03        0.000000         1.33672e+00         0.59189        271.232      34.756     0.94267     2.72802e-01     7.10224e-05
   9.98567e-01        1.43317e-03        9.94845e-01        5.15538e-03       2.13565e+03        0.000000         1.39027e+00         0.59584        266.797      34.795     0.94114     2.86395e-01     1.08222e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       2.25446e+03        0.000000         1.44514e+00         0.60187        262.260      34.847     0.93953     2.99741e-01     1.60438e-04
   9.96750e-01        3.25026e-03        9.88363e-01        1.16367e-02       2.45979e+03        0.000000         1.53624e+00         0.61573        254.762      34.960     0.93674     3.20715e-01     2.86980e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.68381e+03        0.000000         1.63074e+00         0.63448        247.062      35.118     0.93372     3.41122e-01     4.85267e-04
   9.92805e-01        7.19463e-03        9.74502e-01        2.54982e-02       2.91387e+03        0.000000         1.72303e+00         0.65652        239.649      35.317     0.93067     3.59955e-01     7.62829e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.16365e+03        0.000000         1.81835e+00         0.68278        232.130      35.571     0.92744     3.78480e-01     1.15782e-03
   9.87199e-01        1.28013e-02        9.55274e-01        4.47262e-02       3.38330e+03        0.000000         1.89838e+00         0.70743        225.935      35.824     0.92467     3.93440e-01     1.59239e-03
   9.83884e-01        1.61160e-02        9.44160e-01        5.58397e-02       3.61821e+03        0.000000         1.98036e+00         0.73509        219.701      36.124     0.92177     4.08311e-01     2.15402e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       3.86942e+03        0.000000         2.06425e+00         0.76596        213.439      36.476     0.91876     4.23143e-01     2.87302e-03
   9.75374e-01        2.46256e-02        9.16457e-01        8.35432e-02       4.14419e+03        0.000000         2.15187e+00         0.80105        207.018      36.894     0.91554     4.38311e-01     3.80992e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       4.43847e+03        0.000000         2.24124e+00         0.84005        200.581      37.381     0.91218     4.53544e-01     5.00256e-03
   9.65288e-01        3.47123e-02        8.85081e-01        1.14919e-01       4.67897e+03        0.000000         2.31103e+00         0.87296        195.616      37.807     0.90948     4.65344e-01     6.13605e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       4.93250e+03        0.000000         2.38159e+00         0.90865        190.637      38.286     0.90667     4.77253e-01     7.50163e-03
   9.55248e-01        4.47520e-02        8.55320e-01        1.44680e-01       5.14732e+03        0.000000         2.43901e+00         0.93971        186.598      38.716     0.90431     4.86985e-01     8.81036e-03
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       5.37148e+03        0.000000         2.49662e+00         0.97296        182.537      39.191     0.90186     4.96847e-01     1.03424e-02
   9.45230e-01        5.47698e-02        8.26985e-01        1.73015e-01       5.56405e+03        0.000000         2.54421e+00         1.00225        179.157      39.622     0.89974     5.05123e-01     1.18111e-02
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.76352e+03        0.000000         2.59161e+00         1.03335        175.745      40.096     0.89752     5.13546e-01     1.35026e-02
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       6.11213e+03        0.000000         2.66949e+00         1.08983        169.945      41.001     0.89354     5.28039e-01     1.69626e-02
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       6.41886e+03        0.000000         2.73206e+00         1.14226        164.930      41.905     0.88984     5.40762e-01     2.07038e-02
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       6.68454e+03        0.000000         2.78060e+00         1.19046        160.554      42.810     0.88634     5.52017e-01     2.47081e-02
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       6.90988e+03        0.000000         2.81612e+00         1.23423        156.711      43.715     0.88300     5.62023e-01     2.89590e-02
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       7.09585e+03        0.000000         2.83955e+00         1.27345        153.314      44.620     0.87979     5.70953e-01     3.34407e-02
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       7.24381e+03        0.000000         2.85182e+00         1.30806        150.298      45.525     0.87668     5.78945e-01     3.81391e-02
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       7.35558e+03        0.000000         2.85387e+00         1.33807        147.606      46.430     0.87364     5.86118e-01     4.30420e-02
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       7.43343e+03        0.000000         2.84666e+00         1.36358        145.193      47.335     0.87065     5.92570e-01     4.81391e-02
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       7.47995e+03        0.000000         2.83119e+00         1.38474        143.020      48.240     0.86770     5.98390e-01     5.34222e-02
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       7.49798e+03        0.000000         2.80844e+00         1.40179        141.054      49.145     0.86479     6.03654e-01     5.88855e-02
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       7.49048e+03        0.000000         2.77938e+00         1.41498        139.267      50.050     0.86189     6.08432e-01     6.45251e-02
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       7.46042e+03        0.000000         2.74493e+00         1.42459        137.633      50.955     0.85901     6.12782e-01     7.03395e-02
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       7.41066e+03        0.000000         2.70593e+00         1.43094        136.132      51.860     0.85614     6.16759e-01     7.63292e-02
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       7.34395e+03        0.000000         2.66316e+00         1.43432        134.745      52.765     0.85328     6.20409e-01     8.24968e-02
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       7.26281e+03        0.000000         2.61733e+00         1.43502        133.456      53.670     0.85041     6.23772e-01     8.88467e-02
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       7.16955e+03        0.000000         2.56905e+00         1.43333        132.251      54.575     0.84755     6.26884e-01     9.53856e-02
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       7.06623e+03        0.000000         2.51885e+00         1.42950        131.117      55.480     0.84467     6.29776e-01     1.02122e-01
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       6.95467e+03        0.000000         2.46719e+00         1.42378        130.042      56.385     0.84179     6.32476e-01     1.09067e-01
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       6.83650e+03        0.000000         2.41446e+00         1.41638        129.018      57.290     0.83889     6.35006e-01     1.16234e-01
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       6.71309e+03        0.000000         2.36100e+00         1.40751        128.033      58.195     0.83598     6.37388e-01     1.23638e-01
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       6.58565e+03        0.000000         2.30706e+00         1.39733        127.081      59.100     0.83304     6.39638e-01     1.31299e-01
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       6.45521e+03        0.000000         2.25287e+00         1.38600        126.152      60.005     0.83006     6.41772e-01     1.39239e-01
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       6.32266e+03        0.000000         2.19860e+00         1.37367        125.238      60.910     0.82705     6.43803e-01     1.47485e-01
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       6.18873e+03        0.000000         2.14440e+00         1.36045        124.333      61.815     0.82400     6.45742e-01     1.56071e-01
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       6.05407e+03        0.000000         2.09036e+00         1.34645        123.428      62.720     0.82089     6.47601e-01     1.65035e-01
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       5.91920e+03        0.000000         2.03656e+00         1.33178        122.514      63.625     0.81771     6.49387e-01     1.74425e-01
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       5.78458e+03        0.000000         1.98304e+00         1.31652        121.584      64.530     0.81444     6.51108e-01     1.84302e-01
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       5.65059e+03        0.000000         1.92982e+00         1.30073        120.625      65.435     0.81107     6.52772e-01     1.94738e-01
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       5.51755e+03        0.000000         1.87688e+00         1.28450        119.628      66.340     0.80758     6.54383e-01     2.05831e-01
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       5.38573e+03        0.000000         1.82419e+00         1.26788        118.577      67.245     0.80393     6.55949e-01     2.17705e-01
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       5.25537e+03        0.000000         1.77166e+00         1.25094        117.454      68.150     0.80008     6.57473e-01     2.30529e-01
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       5.12667e+03        0.000000         1.71916e+00         1.23372        116.236      69.055     0.79598     6.58961e-01     2.44540e-01
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       4.99982e+03        0.000000         1.66646e+00         1.21627        114.888      69.960     0.79155     6.60417e-01     2.60083e-01
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       4.87501e+03        0.000000         1.61322e+00         1.19866        113.359      70.865     0.78665     6.61845e-01     2.77698e-01
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       4.75242e+03        0.000000         1.55883e+00         1.18093        111.567      71.770     0.78108     6.63250e-01     2.98308e-01
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       4.63231e+03        0.000000         1.50206e+00         1.16317        109.352      72.675     0.77443     6.64637e-01     3.23722e-01
   5.78679e-01        4.21321e-01        2.75573e-01        7.24427e-01       4.61664e+03        0.000000         1.49425e+00         1.16082        109.013      72.795     0.77343     6.64820e-01     3.27619e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                    Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)       Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
   5.78679e-01          0.42132          2.75573e-01          0.72443          4616.64          1.0000            1.16082          0.982323        72.795     52.1376     0.664820     0.562686     2.94626e-01
   5.70000e-01          0.43000          2.68542e-01          0.73146          4576.84          1.0000            1.15944          0.956543        73.580     49.6183     0.666995     0.545189     2.27806e-01
   5.60000e-01          0.44000          2.60625e-01          0.73937          4535.18          1.0000            1.15863          0.934371        74.485     47.4329     0.669521     0.528687     1.76388e-01
   5.50000e-01          0.45000          2.52899e-01          0.74710          4496.98          1.0000            1.15845          0.916932        75.390     45.6745     0.672051     0.514401     1.39848e-01
   5.40000e-01          0.46000          2.45355e-01          0.75464          4461.60          1.0000            1.15878          0.902681        76.295     44.1898     0.674576     0.501560     1.12534e-01
   5.30000e-01          0.47000          2.37989e-01          0.76201          4428.59          1.0000            1.15953          0.890785        77.200     42.8991     0.677089     0.489762     9.14890e-02
   5.20000e-01          0.48000          2.30793e-01          0.76921          4397.65          1.0000            1.16064          0.880731        78.105     41.7546     0.679586     0.478769     7.49447e-02
   5.10000e-01          0.49000          2.23762e-01          0.77624          4368.52          1.0000            1.16208          0.872174        79.010     40.7252     0.682063     0.468423     6.17524e-02
   5.00000e-01          0.50000          2.16890e-01          0.78311          4341.03          1.0000            1.16380          0.864868        79.915     39.7891     0.684519     0.458617     5.11221e-02
   4.90000e-01          0.51000          2.10172e-01          0.78983          4315.01          1.0000            1.16579          0.858626        80.820     38.9305     0.686952     0.449275     4.24872e-02
   4.80000e-01          0.52000          2.03603e-01          0.79640          4290.33          1.0000            1.16800          0.853304        81.725     38.1376     0.689359     0.440337     3.54288e-02
   4.70000e-01          0.53000          1.97178e-01          0.80282          4266.90          1.0000            1.17044          0.848787        82.630     37.4011     0.691741     0.431759     2.96296e-02
   4.60000e-01          0.54000          1.90892e-01          0.80911          4244.60          1.0000            1.17308          0.844980        83.535     36.7136     0.694097     0.423507     2.48452e-02
   4.50000e-01          0.55000          1.84741e-01          0.81526          4223.36          1.0000            1.17591          0.841801        84.440     36.0690     0.696425     0.415553     2.08839e-02
   4.40000e-01          0.56000          1.78720e-01          0.82128          4203.10          1.0000            1.17892          0.839185        85.345     35.4625     0.698726     0.407873     1.75941e-02
   4.30000e-01          0.57000          1.72825e-01          0.82717          4183.75          1.0000            1.18209          0.837070        86.250     34.8898     0.701000     0.400449     1.48548e-02
   4.20000e-01          0.58000          1.67053e-01          0.83295          4165.26          1.0000            1.18542          0.835407        87.155     34.3475     0.703245     0.393264     1.25682e-02
   4.10000e-01          0.59000          1.61400e-01          0.83860          4147.57          1.0000            1.18889          0.834150        88.060     33.8326     0.705463     0.386304     1.06553e-02
   4.00000e-01          0.60000          1.55862e-01          0.84414          4130.63          1.0000            1.19250          0.833258        88.965     33.3423     0.707652     0.379556     9.05168e-03
   3.90000e-01          0.61000          1.50435e-01          0.84957          4114.39          1.0000            1.19624          0.832695        89.870     32.8744     0.709814     0.373011     7.70470e-03
   3.80000e-01          0.62000          1.45116e-01          0.85488          4098.82          1.0000            1.20011          0.832430        90.775     32.4270     0.711947     0.366658     6.57111e-03
   3.70000e-01          0.63000          1.39903e-01          0.86010          4083.86          1.0000            1.20409          0.832433        91.680     31.9982     0.714053     0.360488     5.61531e-03
   3.60000e-01          0.64000          1.34791e-01          0.86521          4069.49          1.0000            1.20818          0.832679        92.585     31.5865     0.716131     0.354493     4.80795e-03
   3.50000e-01          0.65000          1.29778e-01          0.87022          4055.67          1.0000            1.21238          0.833143        93.490     31.1904     0.718182     0.348665     4.12472e-03
   3.40000e-01          0.66000          1.24862e-01          0.87514          4042.37          1.0000            1.21667          0.833804        94.395     30.8088     0.720205     0.342998     3.54548e-03
   3.30000e-01          0.67000          1.20038e-01          0.87996          4029.57          1.0000            1.22106          0.834643        95.300     30.4405     0.722202     0.337484     3.05353e-03
   3.20000e-01          0.68000          1.15306e-01          0.88469          4017.22          1.0000            1.22554          0.835642        96.205     30.0845     0.724172     0.332118     2.63494e-03
   3.10000e-01          0.69000          1.10662e-01          0.88934          4005.32          1.0000            1.23010          0.836785        97.110     29.7398     0.726115     0.326893     2.27813e-03
   3.00000e-01          0.70000          1.06103e-01          0.89390          3993.83          1.0000            1.23474          0.838058        98.015     29.4057     0.728032     0.321804     1.97343e-03
   2.90000e-01          0.71000          1.01628e-01          0.89837          3982.73          1.0000            1.23946          0.839446        98.920     29.0814     0.729923     0.316845     1.71275e-03
   2.80000e-01          0.72000          9.72339e-02          0.90277          3972.01          1.0000            1.24425          0.840940        99.825     28.7662     0.731789     0.312012     1.48932e-03
   2.70000e-01          0.73000          9.29189e-02          0.90708          3961.64          1.0000            1.24911          0.842526       100.730     28.4595     0.733630     0.307300     1.29748e-03
   2.60000e-01          0.74000          8.86807e-02          0.91132          3951.60          1.0000            1.25404          0.844196       101.635     28.1607     0.735445     0.302703     1.13246e-03
   2.50000e-01          0.75000          8.45173e-02          0.91548          3941.89          1.0000            1.25902          0.845941       102.540     27.8693     0.737237     0.298218     9.90250e-04
   2.40000e-01          0.76000          8.04268e-02          0.91957          3932.48          1.0000            1.26407          0.847751       103.445     27.5849     0.739004     0.293841     8.67477e-04
   2.30000e-01          0.77000          7.64072e-02          0.92359          3923.35          1.0000            1.26918          0.849620       104.350     27.3069     0.740747     0.289567     7.61295e-04
   2.20000e-01          0.78000          7.24568e-02          0.92754          3914.50          1.0000            1.27434          0.851541       105.255     27.0351     0.742467     0.285393     6.69297e-04
   2.10000e-01          0.79000          6.85737e-02          0.93143          3905.91          1.0000            1.27955          0.853508       106.160     26.7690     0.744163     0.281314     5.89448e-04
   2.00000e-01          0.80000          6.47563e-02          0.93524          3897.57          1.0000            1.28482          0.855515       107.065     26.5084     0.745837     0.277328     5.20022e-04
   1.90000e-01          0.81000          6.10028e-02          0.93900          3889.47          1.0000            1.29013          0.857556       107.970     26.2528     0.747489     0.273431     4.59553e-04
   1.80000e-01          0.82000          5.73117e-02          0.94269          3881.60          1.0000            1.29548          0.859628       108.875     26.0020     0.749119     0.269619     4.06794e-04
   1.70000e-01          0.83000          5.36815e-02          0.94632          3873.95          1.0000            1.30088          0.861725       109.780     25.7558     0.750727     0.265891     3.60686e-04
   1.60000e-01          0.84000          5.01107e-02          0.94989          3866.50          1.0000            1.30633          0.863844       110.685     25.5138     0.752313     0.262242     3.20321e-04
   1.50000e-01          0.85000          4.65978e-02          0.95340          3859.26          1.0000            1.31181          0.865982       111.590     25.2760     0.753879     0.258670     2.84926e-04
   1.40000e-01          0.86000          4.31414e-02          0.95686          3852.20          1.0000            1.31733          0.868134       112.495     25.0420     0.755424     0.255173     2.53838e-04
   1.30000e-01          0.87000          3.97402e-02          0.96026          3845.33          1.0000            1.32289          0.870299       113.400     24.8116     0.756949     0.251747     2.26488e-04
   1.20000e-01          0.88000          3.63928e-02          0.96361          3838.64          1.0000            1.32848          0.872474       114.305     24.5848     0.758453     0.248391     2.02390e-04
   1.10000e-01          0.89000          3.30980e-02          0.96690          3832.11          1.0000            1.33411          0.874655       115.210     24.3613     0.759939     0.245102     1.81123e-04
   1.00000e-01          0.90000          2.98546e-02          0.97015          3825.75          1.0000            1.33978          0.876841       116.115     24.1410     0.761405     0.241877     1.62326e-04
   9.00000e-02          0.91000          2.66613e-02          0.97334          3819.55          1.0000            1.34547          0.879030       117.020     23.9236     0.762852     0.238715     1.45687e-04
   8.00000e-02          0.92000          2.35171e-02          0.97648          3813.49          1.0000            1.35120          0.881219       117.925     23.7092     0.764280     0.235613     1.30936e-04
   7.00000e-02          0.93000          2.04207e-02          0.97958          3807.59          1.0000            1.35696          0.883408       118.830     23.4975     0.765690     0.232570     1.17840e-04
   6.00000e-02          0.94000          1.73712e-02          0.98263          3801.82          1.0000            1.36274          0.885594       119.735     23.2885     0.767082     0.229584     1.06196e-04
   5.00000e-02          0.95000          1.43674e-02          0.98563          3796.19          1.0000            1.36856          0.887777       120.640     23.0820     0.768456     0.226653     9.58287e-05
   4.00000e-02          0.96000          1.14083e-02          0.98859          3790.69          1.0000            1.37440          0.889954       121.545     22.8779     0.769813     0.223774     8.65853e-05
   3.00000e-02          0.97000          8.49302e-03          0.99151          3785.31          1.0000            1.38026          0.892126       122.450     22.6762     0.771153     0.220948     7.83325e-05
   2.00000e-02          0.98000          5.62047e-03          0.99438          3780.06          1.0000            1.38616          0.894289       123.355     22.4767     0.772476     0.218171     7.09543e-05
   1.00000e-02          0.99000          2.78977e-03          0.99721          3774.93          1.0000            1.39208          0.896445       124.260     22.2793     0.773783     0.215442     6.43494e-05
   5.00000e-03          0.99500          1.38982e-03          0.99861          3772.40          1.0000            1.39505          0.897519       124.712     22.1814     0.774430     0.214096     6.13088e-05
   2.00000e-03          0.99800          5.54722e-04          0.99945          3770.90          1.0000            1.39683          0.898163       124.984     22.1229     0.774816     0.213293     5.95622e-05
   1.00000e-03          0.99900          2.77160e-04          0.99972          3770.40          1.0000            1.39742          0.898377       125.074     22.1035     0.774945     0.213027     5.89926e-05
   5.00000e-04          0.99950          1.38530e-04          0.99986          3770.16          1.0000            1.39772          0.898484       125.119     22.0938     0.775009     0.212894     5.87100e-05
   2.00000e-04          0.99980          5.54000e-05          0.99994          3770.01          1.0000            1.39790          0.898549       125.146     22.0879     0.775047     0.212814     5.85413e-05
   1.00000e-04          0.99990          2.76980e-05          0.99997          3769.96          1.0000            1.39796          0.898570       125.156     22.0860     0.775060     0.212787     5.84851e-05
   5.00000e-05          0.99995          1.38485e-05          0.99999          3769.93          1.0000            1.39799          0.898581       125.160     22.0850     0.775067     0.212774     5.84571e-05
   2.00000e-05          0.99998          5.53928e-06          0.99999          3769.92          1.0000            1.39801          0.898587       125.163     22.0844     0.775070     0.212766     5.84403e-05
   1.00000e-05          0.99999          2.76962e-06          1.00000          3769.91          1.0000            1.39801          0.898589       125.164     22.0842     0.775072     0.212763     5.84347e-05
   5.00000e-06          0.99999          1.38480e-06          1.00000          3769.91          1.0000            1.39802          0.898590       125.164     22.0841     0.775072     0.212762     5.84318e-05
   2.00000e-06          1.00000          5.53921e-07          1.00000          3769.91          1.0000            1.39802          0.898591       125.164     22.0841     0.775073     0.212761     5.84302e-05
   1.00000e-06          1.00000          2.76960e-07          1.00000          3769.91          1.0000            1.39802          0.898591       125.164     22.0841     0.775073     0.212761     5.84296e-05
   5.00000e-07          1.00000          1.38480e-07          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84293e-05
   2.00000e-07          1.00000          5.53920e-08          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84292e-05
   1.00000e-07          1.00000          2.76960e-08          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84291e-05
   5.00000e-08          1.00000          1.38480e-08          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84291e-05
   2.00000e-08          1.00000          5.53920e-09          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84291e-05
   1.00000e-08          1.00000          2.76960e-09          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84291e-05
   5.00000e-09          1.00000          1.38480e-09          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   2.00000e-09          1.00000          5.53920e-10          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   1.00000e-09          1.00000          2.76960e-10          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   5.00000e-10          1.00000          1.38480e-10          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   2.00000e-10          1.00000          5.53920e-11          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   1.00000e-10          1.00000          2.76960e-11          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   5.00000e-11          1.00000          1.38480e-11          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   2.00000e-11          1.00000          5.53920e-12          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   1.00000e-11          1.00000          2.76960e-12          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   5.00000e-12          1.00000          1.38480e-12          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   2.00000e-12          1.00000          5.53920e-13          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   1.00000e-12          1.00000          2.76960e-13          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          3769.91          1.0000            1.39802          0.898591       125.165     22.0841     0.775073     0.212761     5.84290e-05
END

set output "Figures/Env_008_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_008_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_008_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Reservoir Fluid A Swollen with Solvent\nJust Above the Saturation Temperature Minimum"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                    Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       3.53791e-09        0.00000         5.57746e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       3.53791e-09        0.00000         5.57747e-12          1.00000       627.998     125.165     1.02984     1.14480e-12     5.59824e-14
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       3.53792e-09        0.00000         5.57747e-12          1.00000       627.998     125.164     1.02984     1.14480e-12     5.59824e-14
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       3.53792e-09        0.00000         5.57747e-12          1.00000       627.998     125.164     1.02984     1.14480e-12     5.59824e-14
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       3.53793e-09        0.00000         5.57749e-12          1.00000       627.998     125.164     1.02984     1.14480e-12     5.59824e-14
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       3.53795e-09        0.00000         5.57752e-12          1.00000       627.998     125.164     1.02984     1.14480e-12     5.59824e-14
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       3.53798e-09        0.00000         5.57758e-12          1.00000       627.998     125.163     1.02984     1.14480e-12     5.59824e-14
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       3.53809e-09        0.00000         5.57774e-12          1.00000       627.998     125.160     1.02984     1.14481e-12     5.59824e-14
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       3.53827e-09        0.00000         5.57802e-12          1.00000       627.998     125.156     1.02984     1.14483e-12     5.59824e-14
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       3.53862e-09        0.00000         5.57858e-12          1.00000       627.998     125.146     1.02984     1.14486e-12     5.59824e-14
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       3.53968e-09        0.00000         5.58025e-12          1.00000       627.998     125.119     1.02984     1.14495e-12     5.59824e-14
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       3.54145e-09        0.00000         5.58305e-12          1.00000       627.998     125.074     1.02984     1.14511e-12     5.59824e-14
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       3.54500e-09        0.00000         5.58864e-12          1.00000       627.998     124.984     1.02984     1.14543e-12     5.59824e-14
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       3.55569e-09        0.00000         5.60549e-12          1.00000       627.998     124.712     1.02984     1.14639e-12     5.59824e-14
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       3.57365e-09        0.00000         5.63380e-12          1.00000       627.998     124.260     1.02984     1.14800e-12     5.59824e-14
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       3.61012e-09        0.00000         5.69129e-12          1.00000       627.998     123.355     1.02984     1.15127e-12     5.59824e-14
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.64733e-09        0.00000         5.74996e-12          1.00000       627.998     122.450     1.02984     1.15460e-12     5.59824e-14
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.68533e-09        0.00000         5.80986e-12          1.00000       627.998     121.545     1.02984     1.15801e-12     5.59824e-14
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.72412e-09        0.00000         5.87101e-12          1.00000       627.998     120.640     1.02984     1.16148e-12     5.59824e-14
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       3.76374e-09        0.00000         5.93347e-12          1.00000       627.998     119.735     1.02984     1.16503e-12     5.59824e-14
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       3.80421e-09        0.00000         5.99727e-12          1.00000       627.998     118.830     1.02984     1.16866e-12     5.59824e-14
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       3.84556e-09        0.00000         6.06246e-12          1.00000       627.998     117.925     1.02984     1.17237e-12     5.59824e-14
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.88782e-09        0.00000         6.12908e-12          1.00000       627.998     117.020     1.02984     1.17615e-12     5.59824e-14
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.93101e-09        0.00000         6.19718e-12          1.00000       627.998     116.115     1.02984     1.18002e-12     5.59824e-14
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.97518e-09        0.00000         6.26681e-12          1.00000       627.998     115.210     1.02984     1.18398e-12     5.59824e-14
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       4.02036e-09        0.00000         6.33803e-12          1.00000       627.998     114.305     1.02984     1.18803e-12     5.59824e-14
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       4.06657e-09        0.00000         6.41088e-12          1.00000       627.998     113.400     1.02984     1.19217e-12     5.59824e-14
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       4.11385e-09        0.00000         6.48542e-12          1.00000       627.998     112.495     1.02984     1.19641e-12     5.59824e-14
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       4.16225e-09        0.00000         6.56172e-12          1.00000       627.998     111.590     1.02984     1.20075e-12     5.59824e-14
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       4.21180e-09        0.00000         6.63984e-12          1.00000       627.998     110.685     1.02984     1.20519e-12     5.59824e-14
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       4.26255e-09        0.00000         6.71984e-12          1.00000       627.998     109.780     1.02984     1.20974e-12     5.59824e-14
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       4.31453e-09        0.00000         6.80178e-12          1.00000       627.998     108.875     1.02984     1.21439e-12     5.59824e-14
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       4.36779e-09        0.00000         6.88576e-12          1.00000       627.998     107.970     1.02984     1.21917e-12     5.59824e-14
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       4.42239e-09        0.00000         6.97183e-12          1.00000       627.998     107.065     1.02984     1.22406e-12     5.59824e-14
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       4.47837e-09        0.00000         7.06008e-12          1.00000       627.998     106.160     1.02984     1.22908e-12     5.59824e-14
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       4.53579e-09        0.00000         7.15059e-12          1.00000       627.998     105.255     1.02984     1.23422e-12     5.59824e-14
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       4.59469e-09        0.00000         7.24346e-12          1.00000       627.998     104.350     1.02984     1.23950e-12     5.59824e-14
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       4.65515e-09        0.00000         7.33877e-12          1.00000       627.998     103.445     1.02984     1.24492e-12     5.59824e-14
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       4.71722e-09        0.00000         7.43662e-12          1.00000       627.998     102.540     1.02984     1.25048e-12     5.59824e-14
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       4.78096e-09        0.00000         7.53711e-12          1.00000       627.998     101.635     1.02984     1.25620e-12     5.59824e-14
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       4.84646e-09        0.00000         7.64036e-12          1.00000       627.998     100.730     1.02984     1.26206e-12     5.59824e-14
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       4.91377e-09        0.00000         7.74648e-12          1.00000       627.998      99.825     1.02984     1.26810e-12     5.59824e-14
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       4.98298e-09        0.00000         7.85558e-12          1.00000       627.998      98.920     1.02984     1.27430e-12     5.59824e-14
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       5.05416e-09        0.00000         7.96780e-12          1.00000       627.998      98.015     1.02984     1.28068e-12     5.59824e-14
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       5.12741e-09        0.00000         8.08328e-12          1.00000       627.998      97.110     1.02984     1.28724e-12     5.59824e-14
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       5.20281e-09        0.00000         8.20215e-12          1.00000       627.998      96.205     1.02984     1.29400e-12     5.59824e-14
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       5.28047e-09        0.00000         8.32457e-12          1.00000       627.998      95.300     1.02984     1.30096e-12     5.59824e-14
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       5.36047e-09        0.00000         8.45070e-12          1.00000       627.998      94.395     1.02984     1.30813e-12     5.59824e-14
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       5.44294e-09        0.00000         8.58071e-12          1.00000       627.998      93.490     1.02984     1.31552e-12     5.59824e-14
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       5.52799e-09        0.00000         8.71479e-12          1.00000       627.998      92.585     1.02984     1.32314e-12     5.59824e-14
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       5.61574e-09        0.00000         8.85312e-12          1.00000       627.998      91.680     1.02984     1.33101e-12     5.59824e-14
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       5.70631e-09        0.00000         8.99591e-12          1.00000       627.998      90.775     1.02984     1.33912e-12     5.59824e-14
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       5.79986e-09        0.00000         9.14338e-12          1.00000       627.998      89.870     1.02984     1.34751e-12     5.59824e-14
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       5.89652e-09        0.00000         9.29577e-12          1.00000       627.998      88.965     1.02984     1.35617e-12     5.59824e-14
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       5.99646e-09        0.00000         9.45333e-12          1.00000       627.998      88.060     1.02984     1.36513e-12     5.59824e-14
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       6.09985e-09        0.00000         9.61632e-12          1.00000       627.998      87.155     1.02984     1.37439e-12     5.59824e-14
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       6.20687e-09        0.00000         9.78502e-12          1.00000       627.998      86.250     1.02984     1.38398e-12     5.59824e-14
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       6.31770e-09        0.00000         9.95976e-12          1.00000       627.998      85.345     1.02984     1.39392e-12     5.59824e-14
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       6.43257e-09        0.00000         1.01408e-11          1.00000       627.998      84.440     1.02984     1.40421e-12     5.59824e-14
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       6.55169e-09        0.00000         1.03286e-11          1.00000       627.998      83.535     1.02984     1.41489e-12     5.59824e-14
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       6.67531e-09        0.00000         1.05235e-11          1.00000       627.998      82.630     1.02984     1.42596e-12     5.59824e-14
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       6.80368e-09        0.00000         1.07259e-11          1.00000       627.998      81.725     1.02984     1.43747e-12     5.59824e-14
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       6.93708e-09        0.00000         1.09362e-11          1.00000       627.998      80.820     1.02984     1.44942e-12     5.59824e-14
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       7.07583e-09        0.00000         1.11549e-11          1.00000       627.998      79.915     1.02984     1.46186e-12     5.59824e-14
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       7.22023e-09        0.00000         1.13826e-11          1.00000       627.998      79.010     1.02984     1.47480e-12     5.59824e-14
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       7.37065e-09        0.00000         1.16197e-11          1.00000       627.998      78.105     1.02984     1.48828e-12     5.59824e-14
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       7.52747e-09        0.00000         1.18669e-11          1.00000       627.998      77.200     1.02984     1.50233e-12     5.59824e-14
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       7.69112e-09        0.00000         1.21249e-11          1.00000       627.998      76.295     1.02984     1.51700e-12     5.59824e-14
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       7.86203e-09        0.00000         1.23944e-11          1.00000       627.998      75.390     1.02984     1.53232e-12     5.59824e-14
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       8.04071e-09        0.00000         1.26761e-11          1.00000       627.998      74.485     1.02984     1.54833e-12     5.59824e-14
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       8.22770e-09        0.00000         1.29708e-11          1.00000       627.998      73.580     1.02984     1.56509e-12     5.59824e-14
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       8.42360e-09        0.00000         1.32797e-11          1.00000       627.998      72.675     1.02984     1.58264e-12     5.59824e-14
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       8.62906e-09        0.00000         1.36036e-11          1.00000       627.998      71.770     1.02984     1.60106e-12     5.59824e-14
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       8.84478e-09        0.00000         1.39437e-11          1.00000       627.998      70.865     1.02984     1.62039e-12     5.59824e-14
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       9.07157e-09        0.00000         1.43012e-11          1.00000       627.998      69.960     1.02984     1.64071e-12     5.59824e-14
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       9.31030e-09        0.00000         1.46775e-11          1.00000       627.998      69.055     1.02984     1.66211e-12     5.59824e-14
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       9.56193e-09        0.00000         1.50742e-11          1.00000       627.998      68.150     1.02984     1.68466e-12     5.59824e-14
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       9.82754e-09        0.00000         1.54930e-11          1.00000       627.998      67.245     1.02984     1.70846e-12     5.59824e-14
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       1.01083e-08        0.00000         1.59356e-11          1.00000       627.998      66.340     1.02984     1.73363e-12     5.59824e-14
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       1.04056e-08        0.00000         1.64043e-11          1.00000       627.998      65.435     1.02984     1.76027e-12     5.59824e-14
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       1.07209e-08        0.00000         1.69014e-11          1.00000       627.998      64.530     1.02984     1.78853e-12     5.59824e-14
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       1.10560e-08        0.00000         1.74296e-11          1.00000       627.998      63.625     1.02984     1.81855e-12     5.59824e-14
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       1.14126e-08        0.00000         1.79918e-11          1.00000       627.998      62.720     1.02984     1.85051e-12     5.59824e-14
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       1.17930e-08        0.00000         1.85915e-11          1.00000       627.998      61.815     1.02984     1.88461e-12     5.59824e-14
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       1.21997e-08        0.00000         1.92326e-11          1.00000       627.998      60.910     1.02984     1.92105e-12     5.59824e-14
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       1.26354e-08        0.00000         1.99195e-11          1.00000       627.998      60.005     1.02984     1.96010e-12     5.59824e-14
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       1.31034e-08        0.00000         2.06573e-11          1.00000       627.998      59.100     1.02984     2.00204e-12     5.59824e-14
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       1.36074e-08        0.00000         2.14518e-11          1.00000       627.998      58.195     1.02984     2.04720e-12     5.59824e-14
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       1.41517e-08        0.00000         2.23099e-11          1.00000       627.998      57.290     1.02984     2.09598e-12     5.59824e-14
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       1.47413e-08        0.00000         2.32394e-11          1.00000       627.998      56.385     1.02984     2.14883e-12     5.59824e-14
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       1.53822e-08        0.00000         2.42498e-11          1.00000       627.998      55.480     1.02984     2.20626e-12     5.59824e-14
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       1.60814e-08        0.00000         2.53521e-11          1.00000       627.998      54.575     1.02984     2.26893e-12     5.59824e-14
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       1.68472e-08        0.00000         2.65593e-11          1.00000       627.998      53.670     1.02984     2.33755e-12     5.59824e-14
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       1.76896e-08        0.00000         2.78873e-11          1.00000       627.998      52.765     1.02984     2.41304e-12     5.59824e-14
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       1.86206e-08        0.00000         2.93551e-11          1.00000       627.998      51.860     1.02984     2.49648e-12     5.59824e-14
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       1.96551e-08        0.00000         3.09859e-11          1.00000       627.998      50.955     1.02984     2.58919e-12     5.59824e-14
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       2.08113e-08        0.00000         3.28086e-11          1.00000       627.998      50.050     1.02984     2.69281e-12     5.59824e-14
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       2.21120e-08        0.00000         3.48591e-11          1.00000       627.998      49.145     1.02984     2.80937e-12     5.59824e-14
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       2.35861e-08        0.00000         3.71831e-11          1.00000       627.998      48.240     1.02984     2.94148e-12     5.59824e-14
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       2.52708e-08        0.00000         3.98390e-11          1.00000       627.998      47.335     1.02984     3.09246e-12     5.59824e-14
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       2.72147e-08        0.00000         4.29036e-11          1.00000       627.998      46.430     1.02984     3.26667e-12     5.59824e-14
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       2.94826e-08        0.00000         4.64789e-11          1.00000       627.998      45.525     1.02984     3.46992e-12     5.59824e-14
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       3.21628e-08        0.00000         5.07042e-11          1.00000       627.998      44.620     1.02984     3.71012e-12     5.59824e-14
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       3.53791e-08        0.00000         5.57746e-11          1.00000       627.998      43.715     1.02984     3.99836e-12     5.59824e-14
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       3.93101e-08        0.00000         6.19718e-11          1.00000       627.998      42.810     1.02984     4.35065e-12     5.59824e-14
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       4.42239e-08        0.00000         6.97183e-11          1.00000       627.998      41.905     1.02984     4.79101e-12     5.59824e-14
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       5.05416e-08        0.00000         7.96780e-11          1.00000       627.998      41.001     1.02984     5.35720e-12     5.59824e-14
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.89652e-08        0.00000         9.29577e-11          1.00000       627.998      40.096     1.02984     6.11211e-12     5.59824e-14
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       7.07583e-08        0.00000         1.11549e-10          1.00000       627.998      39.191     1.02984     7.16898e-12     5.59824e-14
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.84478e-08        0.00000         1.39437e-10          1.00000       627.998      38.286     1.02984     8.75429e-12     5.59824e-14
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       1.17930e-07        0.00000         1.85915e-10          1.00000       627.998      37.381     1.02984     1.13965e-11     5.59824e-14
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       1.76896e-07        0.00000         2.78873e-10          1.00000       627.998      36.476     1.02984     1.66809e-11     5.59824e-14
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.53791e-07        0.00000         5.57746e-10          1.00000       627.998      35.571     1.02984     3.25340e-11     5.59824e-14
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       7.07583e-07        0.00000         1.11549e-09          1.00000       627.998      35.118     1.02984     6.42402e-11     5.59824e-14
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.76896e-06        0.00000         2.78873e-09          1.00000       627.998      34.847     1.02984     1.59359e-10     5.59824e-14
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       3.53791e-06        0.00000         5.57746e-09          1.00000       627.998      34.756     1.02984     3.17890e-10     5.59824e-14
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       7.07583e-06        0.00000         1.11549e-08          1.00000       627.998      34.711     1.02984     6.34953e-10     5.59824e-14
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.76896e-05        0.00000         2.78873e-08          1.00000       627.998      34.684     1.02984     1.58614e-09     5.59824e-14
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       3.53791e-05        0.00000         5.57746e-08          1.00000       627.998      34.675     1.02984     3.17145e-09     5.59824e-14
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       7.07583e-05        0.00000         1.11549e-07          1.00000       627.998      34.670     1.02984     6.34208e-09     5.59824e-14
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.76896e-04        0.00000         2.78874e-07          1.00000       627.998      34.667     1.02984     1.58540e-08     5.59825e-14
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       3.53792e-04        0.00000         5.57748e-07          1.00000       627.998      34.666     1.02984     3.17072e-08     5.59826e-14
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       7.07587e-04        0.00000         1.11550e-06          1.00000       627.997      34.666     1.02984     6.34137e-08     5.59828e-14
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.76898e-03        0.00000         2.78877e-06          1.00000       627.996      34.666     1.02984     1.58535e-07     5.59834e-14
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       3.53803e-03        0.00000         5.57761e-06          1.00000       627.995      34.666     1.02984     3.17074e-07     5.59845e-14
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       7.07628e-03        0.00000         1.11555e-05          1.00000       627.991      34.666     1.02983     6.34168e-07     5.59866e-14
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.76924e-02        0.00000         2.78911e-05          0.99999       627.981      34.666     1.02983     1.58558e-06     5.59929e-14
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       3.53904e-02        0.00000         5.57897e-05          0.99999       627.965      34.666     1.02983     3.17168e-06     5.60034e-14
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       7.08033e-02        0.00000         1.11609e-04          0.99997       627.932      34.666     1.02983     6.34547e-06     5.60245e-14
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.77178e-01        0.00000         2.79250e-04          0.99993       627.834      34.666     1.02982     1.58796e-05     5.60878e-14
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       3.54922e-01        0.00000         5.59255e-04          0.99985       627.669      34.666     1.02980     3.18123e-05     5.61939e-14
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       7.12127e-01        0.00000         1.12156e-03          0.99970       627.338      34.666     1.02976     6.38389e-05     5.64075e-14
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.79779e+00        0.00000         2.82718e-03          0.99924       626.332      34.666     1.02965     1.61237e-04     5.70621e-14
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       3.65622e+00        0.00000         5.73503e-03          0.99846       624.615      34.666     1.02946     3.28170e-04     5.82011e-14
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       7.57533e+00        0.00000         1.18185e-02          0.99681       621.010      34.666     1.02905     6.81061e-04     6.06814e-14
   1.00000e+00        3.11169e-10        1.00000e+00        1.12352e-09       1.27554e+01        0.00000         1.97589e-02          0.99463       616.277      34.666     1.02851     1.14930e-03     6.41297e-14
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       2.14777e+01        0.00000         3.28740e-02          0.99094       608.392      34.666     1.02758     1.94240e-03     7.04051e-14
   1.00000e+00        1.34476e-10        1.00000e+00        4.85544e-10       3.66953e+01        0.00000         5.50064e-02          0.98448       594.884      34.666     1.02596     3.34041e-03     8.29331e-14
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       6.26951e+01        0.00000         9.06991e-02          0.97338       572.520      34.666     1.02310     5.77232e-03     1.10006e-13
   1.00000e+00        9.17021e-11        1.00000e+00        3.31103e-10       8.13153e+01        0.00000         1.14691e-01          0.96536       557.043      34.666     1.02101     7.54882e-03     1.34964e-13
   1.00000e+00        8.87642e-11        1.00000e+00        3.20495e-10       1.05466e+02        0.00000         1.43961e-01          0.95490       537.622      34.666     1.01822     9.89811e-03     1.76444e-13
   1.00000e+00        8.87642e-11        1.00000e+00        3.20495e-10       1.05481e+02        0.00000         1.43978e-01          0.95489       537.610      34.666     1.01822     9.89957e-03     1.76473e-13
   1.00000e+00        9.12187e-11        1.00000e+00        3.29357e-10       1.31143e+02        0.00000         1.72913e-01          0.94367       517.759      34.666     1.01518     1.24543e-02     2.35460e-13
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.63048e+02        0.00000         2.05976e-01          0.92958       494.168      34.666     1.01128     1.57190e-02     3.38830e-13
   1.00000e+00        1.27941e-10        1.00000e+00        4.61948e-10       2.16077e+02        0.00000         2.54427e-01          0.90578       457.520      34.666     1.00451     2.13787e-02     6.29335e-13
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       2.86352e+02        0.00000         3.07733e-01          0.87345       413.610      34.666     0.99499     2.93805e-02     1.47346e-12
   1.00000e+00        2.96250e-10        1.00000e+00        1.06965e-09       3.37964e+02        0.00000         3.40203e-01          0.84907       384.564      34.666     0.98764     3.56717e-02     2.82023e-12
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       3.98877e+02        0.00000         3.72602e-01          0.81952       353.623      34.666     0.97867     4.36192e-02     6.25223e-12
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       4.70482e+02        0.00000         4.04369e-01          0.78357       321.785      34.666     0.96790     5.38100e-02     1.66989e-11
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       5.34591e+02        0.00000         4.28977e-01          0.75011       297.484      34.666     0.95841     6.38693e-02     4.22318e-11
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.10444e+02        0.00000         4.56371e-01          0.70874       274.176      34.666     0.94810     7.71893e-02     1.35342e-10
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       6.62271e+02        0.00000         4.76013e-01          0.67920       261.968      34.666     0.94225     8.73850e-02     3.14224e-10
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.10031e+02        0.00000         4.96301e-01          0.65096       253.662      34.666     0.93818     9.77510e-02     7.08757e-10
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       7.67804e+02        0.00000         5.25471e-01          0.61542       247.650      34.666     0.93549     1.11809e-01     1.99948e-09
   1.00000e+00        8.29678e-08        1.00000e+00        2.99566e-07       7.97465e+02        0.00000         5.43006e-01          0.59658       246.310      34.666     0.93516     1.19795e-01     3.49212e-09
   1.00000e+00        8.29678e-08        1.00000e+00        2.99566e-07       7.97465e+02        0.00000         2.13287e-01          0.59658        39.590      34.666     0.38268     1.19795e-01     5.02735e-06
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       7.99440e+02        0.00000         2.14574e-01          0.59531        39.386      34.666     0.37935     1.20348e-01     5.69786e-06
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       8.01033e+02        0.00000         2.15618e-01          0.59429        39.232      34.666     0.37680     1.20795e-01     6.28885e-06
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       8.01530e+02        0.00000         2.15944e-01          0.59397        39.187      34.666     0.37602     1.20935e-01     6.48271e-06
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       8.01772e+02        0.00000         2.16104e-01          0.59381        39.165      34.666     0.37565     1.21004e-01     6.57913e-06
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       8.01916e+02        0.00000         2.16198e-01          0.59372        39.152      34.666     0.37543     1.21044e-01     6.63682e-06
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       8.01963e+02        0.00000         2.16230e-01          0.59369        39.147      34.666     0.37535     1.21058e-01     6.65603e-06
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       8.01987e+02        0.00000         2.16245e-01          0.59368        39.145      34.666     0.37532     1.21064e-01     6.66563e-06
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       8.02001e+02        0.00000         2.16255e-01          0.59367        39.144      34.666     0.37530     1.21068e-01     6.67139e-06
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       8.02006e+02        0.00000         2.16258e-01          0.59366        39.144      34.666     0.37529     1.21070e-01     6.67330e-06
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       8.02009e+02        0.00000         2.16259e-01          0.59366        39.143      34.666     0.37529     1.21070e-01     6.67426e-06
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       8.02010e+02        0.00000         2.16260e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67484e-06
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       8.02010e+02        0.00000         2.16261e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67503e-06
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       8.02011e+02        0.00000         2.16261e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67513e-06
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       8.02011e+02        0.00000         2.16261e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67518e-06
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       8.02011e+02        0.00000         2.16261e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67520e-06
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       8.02011e+02        0.00000         2.16261e-01          0.59366        39.143      34.666     0.37528     1.21071e-01     6.67522e-06
           NaN                NaN                NaN                NaN               NaN            NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93810e-02
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93811e-02
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11096e-01     3.93812e-02
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11097e-01     3.93815e-02
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.04556e+03        0.00000         3.43736e-01          0.44388        35.898      34.666     0.28229     2.11098e-01     3.93821e-02
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       1.04556e+03        0.00000         3.43736e-01          0.44387        35.898      34.666     0.28229     2.11100e-01     3.93838e-02
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       1.04557e+03        0.00000         3.43735e-01          0.44387        35.898      34.666     0.28229     2.11104e-01     3.93867e-02
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.04559e+03        0.00000         3.43734e-01          0.44386        35.898      34.666     0.28230     2.11111e-01     3.93924e-02
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.04564e+03        0.00000         3.43731e-01          0.44384        35.898      34.666     0.28232     2.11134e-01     3.94094e-02
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       1.04573e+03        0.00000         3.43725e-01          0.44380        35.899      34.666     0.28235     2.11171e-01     3.94377e-02
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.04590e+03        0.00000         3.43714e-01          0.44372        35.899      34.666     0.28241     2.11245e-01     3.94937e-02
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.04642e+03        0.00000         3.43678e-01          0.44347        35.902      34.666     0.28260     2.11467e-01     3.96572e-02
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.04727e+03        0.00000         3.43612e-01          0.44308        35.906      34.666     0.28291     2.11829e-01     3.99145e-02
   9.99988e-01        1.20033e-05        9.99957e-01        4.33381e-05       1.04760e+03        0.00000         3.43583e-01          0.44292        35.907      34.667     0.28304     2.11972e-01     4.00124e-02
   9.99988e-01        1.20033e-05        9.99957e-01        4.33381e-05       1.04760e+03        0.00000         7.57043e-01          0.44292       265.687      34.667     0.95048     2.11972e-01     6.46490e-07
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.07595e+03        0.00000         7.83348e-01          0.43142       268.153      34.667     0.95218     2.23518e-01     1.10114e-06
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.13499e+03        0.00000         8.35343e-01          0.41405       271.831      34.670     0.95483     2.45694e-01     2.88103e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.19086e+03        0.00000         8.81158e-01          0.40446       273.741      34.675     0.95641     2.63931e-01     6.00547e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.26236e+03        0.00000         9.36051e-01          0.39898       274.656      34.684     0.95757     2.83696e-01     1.26176e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.39606e+03        0.00000         1.03143e+00          0.40056       273.879      34.711     0.95835     3.12754e-01     3.42047e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       1.54612e+03        0.00000         1.13183e+00          0.41150       271.337      34.756     0.95823     3.37596e-01     7.38857e-05
   9.98551e-01        1.44862e-03        9.94789e-01        5.21073e-03       1.65325e+03        0.00000         1.20076e+00          0.42230       269.108      34.797     0.95787     3.52170e-01     1.12328e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.76781e+03        0.00000         1.27258e+00          0.43543       266.582      34.847     0.95737     3.65744e-01     1.62526e-04
   9.97172e-01        2.82753e-03        9.89866e-01        1.01344e-02       1.91985e+03        0.00000         1.36545e+00          0.45444       263.175      34.921     0.95661     3.81400e-01     2.43048e-04
   9.96174e-01        3.82581e-03        9.86323e-01        1.36770e-02       2.08496e+03        0.00000         1.46367e+00          0.47637       259.528      35.012     0.95573     3.96153e-01     3.47374e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.26427e+03        0.00000         1.56770e+00          0.50114       255.704      35.118     0.95478     4.10206e-01     4.79011e-04
   9.93539e-01        6.46130e-03        9.77058e-01        2.29424e-02       2.47423e+03        0.00000         1.68648e+00          0.53091       251.449      35.250     0.95369     4.24696e-01     6.55070e-04
   9.91871e-01        8.12916e-03        9.71259e-01        2.87414e-02       2.70366e+03        0.00000         1.81303e+00          0.56406       247.085      35.401     0.95256     4.38676e-01     8.71368e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       2.95436e+03        0.00000         1.94791e+00          0.60074       242.649      35.571     0.95142     4.52238e-01     1.13234e-03
   9.88549e-01        1.14509e-02        9.59855e-01        4.01449e-02       3.14681e+03        0.00000         2.04933e+00          0.62911       239.465      35.702     0.95060     4.61672e-01     1.34758e-03
   9.87003e-01        1.29967e-02        9.54614e-01        4.53862e-02       3.35179e+03        0.00000         2.15553e+00          0.65947       236.271      35.842     0.94980     4.70946e-01     1.58892e-03
   9.85368e-01        1.46318e-02        9.49114e-01        5.08864e-02       3.57012e+03        0.00000         2.26679e+00          0.69192       233.075      35.990     0.94900     4.80072e-01     1.85755e-03
   9.83650e-01        1.63497e-02        9.43384e-01        5.66163e-02       3.80267e+03        0.00000         2.38338e+00          0.72657       229.889      36.145     0.94823     4.89062e-01     2.15441e-03
   9.81858e-01        1.81423e-02        9.37457e-01        6.25430e-02       4.05037e+03        0.00000         2.50562e+00          0.76354       226.722      36.307     0.94749     4.97920e-01     2.48013e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.31421e+03        0.00000         2.63386e+00          0.80296       223.583      36.476     0.94678     5.06651e-01     2.83497e-03
   9.78382e-01        2.16182e-02        9.26114e-01        7.38856e-02       4.55138e+03        0.00000         2.74758e+00          0.83841       220.951      36.622     0.94621     5.13957e-01     3.15855e-03
   9.76732e-01        2.32678e-02        9.20799e-01        7.92006e-02       4.80158e+03        0.00000         2.86615e+00          0.87581       218.352      36.771     0.94567     5.21172e-01     3.50251e-03
   9.75060e-01        2.49404e-02        9.15454e-01        8.45457e-02       5.06553e+03        0.00000         2.98982e+00          0.91525       215.793      36.923     0.94518     5.28297e-01     3.86609e-03
   9.73373e-01        2.66267e-02        9.10109e-01        8.98906e-02       5.34400e+03        0.00000         3.11891e+00          0.95682       213.279      37.075     0.94474     5.35328e-01     4.24817e-03
   9.71683e-01        2.83168e-02        9.04796e-01        9.52036e-02       5.63777e+03        0.00000         3.25374e+00          1.00062       210.817      37.228     0.94434     5.42264e-01     4.64727e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       5.94769e+03        0.00000         3.39467e+00          1.04674       208.411      37.381     0.94400     5.49102e-01     5.06146e-03
   9.68442e-01        3.15580e-02        8.94729e-01        1.05271e-01       6.25298e+03        0.00000         3.53235e+00          1.09208       206.219      37.522     0.94374     5.55406e-01     5.43741e-03
   9.66910e-01        3.30902e-02        8.90024e-01        1.09976e-01       6.57393e+03        0.00000         3.67606e+00          1.13964       204.086      37.660     0.94353     5.61618e-01     5.81300e-03
   9.65414e-01        3.45864e-02        8.85463e-01        1.14537e-01       6.91136e+03        0.00000         3.82617e+00          1.18948       202.018      37.796     0.94338     5.67734e-01     6.19151e-03
   9.63964e-01        3.60360e-02        8.81075e-01        1.18925e-01       7.26611e+03        0.00000         3.98309e+00          1.24172       200.019      37.927     0.94330     5.73752e-01     6.57009e-03
   9.62571e-01        3.74286e-02        8.76889e-01        1.23111e-01       7.63907e+03        0.00000         4.14726e+00          1.29642       198.093      38.053     0.94329     5.79669e-01     6.94562e-03
   9.61247e-01        3.87534e-02        8.72931e-01        1.27069e-01       8.03117e+03        0.00000         4.31916e+00          1.35369       196.243      38.173     0.94335     5.85480e-01     7.31476e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.44339e+03        0.00000         4.49929e+00          1.41361       194.475      38.286     0.94349     5.91182e-01     7.67402e-03
   9.58946e-01        4.10543e-02        8.66117e-01        1.33883e-01       8.83548e+03        0.00000         4.67021e+00          1.47032       192.944      38.381     0.94368     5.96258e-01     7.98822e-03
   9.57971e-01        4.20288e-02        8.63254e-01        1.36746e-01       9.24576e+03        0.00000         4.84880e+00          1.52935       191.485      38.469     0.94394     6.01240e-01     8.28859e-03
   9.57083e-01        4.29167e-02        8.60656e-01        1.39344e-01       9.67511e+03        0.00000         5.03551e+00          1.59078       190.100      38.549     0.94426     6.06126e-01     8.57245e-03
   9.56288e-01        4.37121e-02        8.58338e-01        1.41662e-01       1.01244e+04        0.00000         5.23084e+00          1.65468       188.789      38.621     0.94466     6.10917e-01     8.83717e-03
   9.55590e-01        4.44096e-02        8.56312e-01        1.43688e-01       1.05945e+04        0.00000         5.43532e+00          1.72113       187.556      38.685     0.94512     6.15610e-01     9.08030e-03
   9.54995e-01        4.50048e-02        8.54589e-01        1.45411e-01       1.10865e+04        0.00000         5.64950e+00          1.79019       186.401      38.738     0.94565     6.20206e-01     9.29956e-03
   9.54506e-01        4.54943e-02        8.53175e-01        1.46825e-01       1.16013e+04        0.00000         5.87397e+00          1.86196       185.325      38.783     0.94626     6.24704e-01     9.49295e-03
   9.54124e-01        4.58756e-02        8.52076e-01        1.47924e-01       1.21400e+04        0.00000         6.10934e+00          1.93652       184.329      38.817     0.94693     6.29104e-01     9.65876e-03
   9.53853e-01        4.61474e-02        8.51294e-01        1.48706e-01       1.27038e+04        0.00000         6.35626e+00          2.01395       183.412      38.842     0.94767     6.33408e-01     9.79563e-03
   9.53690e-01        4.63097e-02        8.50827e-01        1.49173e-01       1.32937e+04        0.00000         6.61542e+00          2.09435       182.575      38.857     0.94848     6.37616e-01     9.90259e-03
   9.53637e-01        4.63635e-02        8.50673e-01        1.49327e-01       1.39110e+04        0.00000         6.88754e+00          2.17783       181.817      38.861     0.94936     6.41731e-01     9.97907e-03
   9.56153e-01        4.38472e-02        8.57945e-01        1.42055e-01       1.93276e+04        0.00000         9.32052e+00          2.88555       178.593      38.634     0.95742     6.68983e-01     9.66369e-03
   9.62084e-01        3.79163e-02        8.75429e-01        1.24571e-01       2.68532e+04        0.00000         1.28298e+01          3.81873       178.810      38.097     0.96753     6.92574e-01     8.25501e-03
   9.68924e-01        3.10764e-02        8.96214e-01        1.03786e-01       3.73091e+04        0.00000         1.78946e+01          5.06648       181.486      37.478     0.97822     7.13483e-01     6.52146e-03
   9.75099e-01        2.49008e-02        9.15580e-01        8.44197e-02       5.18362e+04        0.00000         2.51708e+01          6.75764       185.637      36.919     0.98832     7.32130e-01     4.97095e-03
   9.80051e-01        1.99489e-02        9.31538e-01        6.84625e-02       7.20198e+04        0.00000         3.55565e+01          9.07164       190.431      36.471     0.99717     7.48535e-01     3.77270e-03
   9.83782e-01        1.62179e-02        9.43822e-01        5.61782e-02       1.00062e+05        0.00000         5.02814e+01         12.25659       195.249      36.133     1.00450     7.62618e-01     2.91131e-03
   9.86502e-01        1.34981e-02        9.52922e-01        4.70778e-02       1.39024e+05        0.00000         7.10336e+01         16.65627       199.686      35.887     1.01035     7.74371e-01     2.31277e-03
   9.88451e-01        1.15486e-02        9.59523e-01        4.04773e-02       1.93156e+05        0.00000         1.00141e+02         22.74768       203.526      35.711     1.01488     7.83913e-01     1.90217e-03
   9.89839e-01        1.01615e-02        9.64259e-01        3.57413e-02       2.68365e+05        0.00000         1.40825e+02         31.19322       206.698      35.585     1.01832     7.91469e-01     1.62084e-03
   9.90823e-01        9.17681e-03        9.67641e-01        3.23588e-02       3.72859e+05        0.00000         1.97555e+02         42.91285       209.229      35.496     1.02088     7.97327e-01     1.42718e-03
   9.91523e-01        8.47742e-03        9.70054e-01        2.99461e-02       5.18040e+05        0.00000         2.76542e+02         59.18438       211.194      35.433     1.02278     8.01789e-01     1.29294e-03
   9.92020e-01        7.97982e-03        9.71776e-01        2.82242e-02       7.19750e+05        0.00000         3.86415e+02         81.78272       212.691      35.388     1.02418     8.05141e-01     1.19922e-03
   9.92375e-01        7.62504e-03        9.73006e-01        2.69939e-02       1.00000e+06        0.00000         5.39171e+02        113.17344       213.813      35.356     1.02519     8.07632e-01     1.13334e-03
           NaN                NaN                NaN                NaN               NaN            NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       1.00000e+06        0.21073         5.02873e+02        311.97600       191.892     107.349     0.98650     8.89557e-01     6.80435e-02
           NaN                NaN                NaN                NaN               NaN            NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       7.71998e+03        0.00000         3.73564e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       7.71999e+03        0.00000         3.73565e+00          3.03798       165.324     125.165     0.88325     8.22267e-01     3.21209e-01
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       7.71999e+03        0.00000         3.73565e+00          3.03798       165.323     125.165     0.88325     8.22267e-01     3.21209e-01
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       7.72000e+03        0.00000         3.73565e+00          3.03798       165.323     125.165     0.88325     8.22267e-01     3.21208e-01
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       7.72002e+03        0.00000         3.73566e+00          3.03799       165.323     125.164     0.88325     8.22267e-01     3.21208e-01
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       7.72006e+03        0.00000         3.73568e+00          3.03800       165.323     125.164     0.88325     8.22267e-01     3.21208e-01
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       7.72017e+03        0.00000         3.73573e+00          3.03804       165.323     125.164     0.88325     8.22267e-01     3.21207e-01
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       7.72037e+03        0.00000         3.73581e+00          3.03810       165.323     125.164     0.88325     8.22267e-01     3.21206e-01
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       7.72075e+03        0.00000         3.73597e+00          3.03823       165.322     125.163     0.88325     8.22268e-01     3.21204e-01
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       7.72190e+03        0.00000         3.73646e+00          3.03861       165.319     125.160     0.88326     8.22270e-01     3.21198e-01
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       7.72382e+03        0.00000         3.73727e+00          3.03924       165.315     125.156     0.88326     8.22274e-01     3.21187e-01
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       7.72766e+03        0.00000         3.73890e+00          3.04051       165.306     125.146     0.88327     8.22281e-01     3.21165e-01
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       7.73918e+03        0.00000         3.74377e+00          3.04430       165.281     125.119     0.88330     8.22301e-01     3.21100e-01
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       7.75835e+03        0.00000         3.75188e+00          3.05061       165.238     125.074     0.88334     8.22336e-01     3.20991e-01
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       7.79663e+03        0.00000         3.76807e+00          3.06319       165.153     124.984     0.88343     8.22404e-01     3.20772e-01
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       7.91100e+03        0.00000         3.81630e+00          3.10062       164.899     124.712     0.88370     8.22604e-01     3.20109e-01
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       8.10004e+03        0.00000         3.89566e+00          3.16198       164.480     124.260     0.88414     8.22920e-01     3.18982e-01
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       8.47251e+03        0.00000         4.05064e+00          3.28100       163.662     123.355     0.88498     8.23493e-01     3.16656e-01
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       8.83772e+03        0.00000         4.20084e+00          3.39527       162.866     122.450     0.88580     8.23992e-01     3.14238e-01
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       9.19572e+03        0.00000         4.34640e+00          3.50487       162.092     121.545     0.88658     8.24420e-01     3.11738e-01
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       9.54636e+03        0.00000         4.48733e+00          3.60984       161.338     120.640     0.88733     8.24781e-01     3.09162e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       9.88928e+03        0.00000         4.62358e+00          3.71012       160.602     119.735     0.88805     8.25078e-01     3.06515e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       1.02240e+04        0.00000         4.75502e+00          3.80562       159.885     118.830     0.88874     8.25312e-01     3.03803e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       1.05498e+04        0.00000         4.88147e+00          3.89620       159.186     117.925     0.88940     8.25482e-01     3.01031e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       1.08661e+04        0.00000         5.00269e+00          3.98168       158.503     117.020     0.89004     8.25591e-01     2.98202e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       1.11719e+04        0.00000         5.11843e+00          4.06186       157.838     116.115     0.89064     8.25637e-01     2.95321e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       1.14663e+04        0.00000         5.22837e+00          4.13651       157.189     115.210     0.89121     8.25619e-01     2.92391e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       1.17483e+04        0.00000         5.33215e+00          4.20536       156.557     114.305     0.89176     8.25536e-01     2.89416e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       1.20167e+04        0.00000         5.42940e+00          4.26815       155.941     113.400     0.89227     8.25388e-01     2.86399e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       1.22703e+04        0.00000         5.51971e+00          4.32457       155.342     112.495     0.89274     8.25172e-01     2.83342e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       1.25077e+04        0.00000         5.60260e+00          4.37429       154.759     111.590     0.89319     8.24885e-01     2.80250e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       1.27275e+04        0.00000         5.67759e+00          4.41698       154.193     110.685     0.89360     8.24525e-01     2.77124e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       1.29281e+04        0.00000         5.74415e+00          4.45226       153.644     109.780     0.89397     8.24088e-01     2.73968e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       1.31077e+04        0.00000         5.80169e+00          4.47974       153.112     108.875     0.89430     8.23571e-01     2.70783e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       1.32647e+04        0.00000         5.84956e+00          4.49899       152.598     107.970     0.89459     8.22969e-01     2.67573e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       1.33968e+04        0.00000         5.88708e+00          4.50952       152.103     107.065     0.89483     8.22276e-01     2.64339e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       1.35020e+04        0.00000         5.91343e+00          4.51082       151.628     106.160     0.89503     8.21485e-01     2.61084e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       1.35775e+04        0.00000         5.92772e+00          4.50229       151.173     105.255     0.89517     8.20589e-01     2.57809e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       1.36204e+04        0.00000         5.92889e+00          4.48322       150.740     104.350     0.89525     8.19577e-01     2.54517e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       1.36272e+04        0.00000         5.91565e+00          4.45276       150.331     103.445     0.89527     8.18437e-01     2.51208e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       1.35936e+04        0.00000         5.88643e+00          4.40985       149.949     102.540     0.89521     8.17152e-01     2.47884e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       1.35139e+04        0.00000         5.83912e+00          4.35305       149.597     101.635     0.89507     8.15700e-01     2.44545e-01
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       1.33806e+04        0.00000         5.77084e+00          4.28038       149.281     100.730     0.89483     8.14048e-01     2.41189e-01
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       1.31822e+04        0.00000         5.67726e+00          4.18881       149.008      99.825     0.89446     8.12150e-01     2.37815e-01
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       1.29003e+04        0.00000         5.55117e+00          4.07323       148.792      98.920     0.89391     8.09925e-01     2.34415e-01
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       1.24988e+04        0.00000         5.37848e+00          3.92347       148.661      98.015     0.89311     8.07216e-01     2.30973e-01
   3.05695e-01        6.94305e-01        1.08689e-01        8.91311e-01       1.21864e+04        0.00000         5.24736e+00          3.81423       148.648      97.499     0.89247     8.05325e-01     2.28978e-01
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       1.18819e+04        0.00000         5.12131e+00          3.71197       148.690      97.110     0.89183     8.03606e-01     2.27438e-01
   3.15170e-01        6.84830e-01        1.13052e-01        8.86948e-01       1.13555e+04        0.00000         4.90645e+00          3.54259       148.864      96.642     0.89069     8.00850e-01     2.25503e-01
   3.17892e-01        6.82108e-01        1.14319e-01        8.85681e-01       1.08525e+04        0.00000         4.70354e+00          3.38732       149.132      96.396     0.88956     7.98419e-01     2.24349e-01
   3.18718e-01        6.81282e-01        1.14706e-01        8.85294e-01       1.03718e+04        0.00000         4.51115e+00          3.24357       149.473      96.321     0.88844     7.96252e-01     2.23792e-01
   3.18718e-01        6.81282e-01        1.14706e-01        8.85294e-01       1.03699e+04        0.00000         4.51042e+00          3.24302       149.475      96.321     0.88844     7.96244e-01     2.23791e-01
   3.18099e-01        6.81901e-01        1.14416e-01        8.85584e-01       9.94875e+03        0.00000         4.34272e+00          3.12009       149.839      96.377     0.88742     7.94462e-01     2.23705e-01
   3.16356e-01        6.83644e-01        1.13603e-01        8.86397e-01       9.54465e+03        0.00000         4.18235e+00          3.00435       150.246      96.535     0.88642     7.92852e-01     2.23960e-01
   3.13622e-01        6.86378e-01        1.12334e-01        8.87666e-01       9.15697e+03        0.00000         4.02881e+00          2.89502       150.691      96.782     0.88544     7.91398e-01     2.24510e-01
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       8.78504e+03        0.00000         3.88166e+00          2.79144       151.168      97.110     0.88448     7.90091e-01     2.25320e-01
   3.05393e-01        6.94607e-01        1.08551e-01        8.91449e-01       8.41510e+03        0.00000         3.73534e+00          2.68950       151.696      97.527     0.88349     7.88879e-01     2.26404e-01
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       8.06075e+03        0.00000         3.59510e+00          2.59267       152.254      98.015     0.88253     7.87806e-01     2.27710e-01
   2.95211e-01        7.04789e-01        1.03950e-01        8.96050e-01       7.79055e+03        0.00000         3.48806e+00          2.51926       152.715      98.448     0.88179     7.87049e-01     2.28886e-01
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       7.52941e+03        0.00000         3.38448e+00          2.44859       153.192      98.920     0.88106     7.86370e-01     2.30177e-01
   2.85142e-01        7.14858e-01        9.94832e-02        9.00517e-01       7.30929e+03        0.00000         3.29704e+00          2.38919       153.620      99.360     0.88044     7.85840e-01     2.31386e-01
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       7.09560e+03        0.00000         3.21201e+00          2.33161       154.058      99.825     0.87982     7.85365e-01     2.32669e-01
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       6.72393e+03        0.00000         3.06373e+00          2.23158       154.880     100.730     0.87875     7.84636e-01     2.35169e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       6.39648e+03        0.00000         2.93260e+00          2.14343       155.669     101.635     0.87779     7.84105e-01     2.37668e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       6.10269e+03        0.00000         2.81447e+00          2.06419       156.436     102.540     0.87692     7.83725e-01     2.40164e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       5.83570e+03        0.00000         2.70666e+00          1.99196       157.184     103.445     0.87613     7.83466e-01     2.42652e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       5.59073e+03        0.00000         2.60732e+00          1.92543       157.918     104.350     0.87540     7.83307e-01     2.45133e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       5.36435e+03        0.00000         2.51512e+00          1.86366       158.639     105.255     0.87472     7.83232e-01     2.47605e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       5.15394e+03        0.00000         2.42905e+00          1.80597       159.350     106.160     0.87409     7.83230e-01     2.50068e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       4.95751e+03        0.00000         2.34833e+00          1.75180       160.052     107.065     0.87350     7.83291e-01     2.52523e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       4.77346e+03        0.00000         2.27237e+00          1.70077       160.746     107.970     0.87295     7.83410e-01     2.54969e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       4.60052e+03        0.00000         2.20069e+00          1.65253       161.432     108.875     0.87244     7.83580e-01     2.57408e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       4.43767e+03        0.00000         2.13289e+00          1.60684       162.111     109.780     0.87196     7.83798e-01     2.59839e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       4.28405e+03        0.00000         2.06867e+00          1.56348       162.784     110.685     0.87151     7.84058e-01     2.62265e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       4.13898e+03        0.00000         2.00776e+00          1.52230       163.450     111.590     0.87109     7.84360e-01     2.64685e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       4.00186e+03        0.00000         1.94997e+00          1.48317       164.111     112.495     0.87070     7.84699e-01     2.67102e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       3.87223e+03        0.00000         1.89513e+00          1.44598       164.765     113.400     0.87034     7.85075e-01     2.69516e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       3.74971e+03        0.00000         1.84310e+00          1.41066       165.414     114.305     0.87000     7.85487e-01     2.71928e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.63399e+03        0.00000         1.79380e+00          1.37717       166.056     115.210     0.86969     7.85932e-01     2.74341e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.52482e+03        0.00000         1.74716e+00          1.34547       166.692     116.115     0.86940     7.86412e-01     2.76756e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.42204e+03        0.00000         1.70314e+00          1.31556       167.321     117.020     0.86913     7.86925e-01     2.79176e-01
   8.75034e-02        9.12497e-01        2.58718e-02        9.74128e-01       3.39736e+03        0.00000         1.69256e+00          1.30837       167.477     117.246     0.86907     7.87058e-01     2.79780e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                    Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)       Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
   8.75034e-02          0.91250          2.58718e-02          0.97413          3397.36          1.0000            1.30837          0.796352       117.246     22.6003     0.787058     0.249258     2.94009e-05
   8.00000e-02          0.92000          2.35171e-02          0.97648          3396.88          1.0000            1.31412          0.798631       117.925     22.4518     0.788038     0.246879     2.68108e-05
   7.00000e-02          0.93000          2.04207e-02          0.97958          3396.35          1.0000            1.32184          0.801652       118.830     22.2567     0.789330     0.243773     2.37550e-05
   6.00000e-02          0.94000          1.73712e-02          0.98263          3395.94          1.0000            1.32960          0.804654       119.735     22.0646     0.790604     0.240739     2.10917e-05
   5.00000e-02          0.95000          1.43674e-02          0.98563          3395.64          1.0000            1.33740          0.807635       120.640     21.8755     0.791862     0.237774     1.87651e-05
   4.00000e-02          0.96000          1.14083e-02          0.98859          3395.46          1.0000            1.34525          0.810595       121.545     21.6892     0.793103     0.234875     1.67281e-05
   3.00000e-02          0.97000          8.49302e-03          0.99151          3395.37          1.0000            1.35314          0.813532       122.450     21.5055     0.794328     0.232039     1.49407e-05
   2.00000e-02          0.98000          5.62047e-03          0.99438          3395.38          1.0000            1.36108          0.816447       123.355     21.3243     0.795537     0.229263     1.33691e-05
   1.00000e-02          0.99000          2.78977e-03          0.99721          3395.49          1.0000            1.36905          0.819338       124.260     21.1455     0.796731     0.226546     1.19843e-05
   5.00000e-03          0.99500          1.38982e-03          0.99861          3395.57          1.0000            1.37305          0.820774       124.712     21.0570     0.797322     0.225209     1.13542e-05
   2.00000e-03          0.99800          5.54722e-04          0.99945          3395.64          1.0000            1.37546          0.821634       124.984     21.0042     0.797675     0.224413     1.09944e-05
   1.00000e-03          0.99900          2.77160e-04          0.99972          3395.66          1.0000            1.37626          0.821919       125.074     20.9866     0.797792     0.224149     1.08774e-05
   5.00000e-04          0.99950          1.38530e-04          0.99986          3395.67          1.0000            1.37666          0.822062       125.119     20.9779     0.797851     0.224017     1.08194e-05
   2.00000e-04          0.99980          5.54000e-05          0.99994          3395.68          1.0000            1.37690          0.822148       125.146     20.9726     0.797886     0.223938     1.07848e-05
   1.00000e-04          0.99990          2.76980e-05          0.99997          3395.68          1.0000            1.37698          0.822177       125.156     20.9708     0.797898     0.223912     1.07733e-05
   5.00000e-05          0.99995          1.38485e-05          0.99999          3395.68          1.0000            1.37702          0.822191       125.160     20.9700     0.797904     0.223898     1.07675e-05
   2.00000e-05          0.99998          5.53928e-06          0.99999          3395.68          1.0000            1.37705          0.822199       125.163     20.9694     0.797907     0.223891     1.07641e-05
   1.00000e-05          0.99999          2.76962e-06          1.00000          3395.68          1.0000            1.37706          0.822202       125.164     20.9693     0.797908     0.223888     1.07629e-05
   5.00000e-06          0.99999          1.38480e-06          1.00000          3395.68          1.0000            1.37706          0.822204       125.164     20.9692     0.797909     0.223887     1.07624e-05
   2.00000e-06          1.00000          5.53921e-07          1.00000          3395.68          1.0000            1.37706          0.822205       125.164     20.9691     0.797909     0.223886     1.07620e-05
   1.00000e-06          1.00000          2.76960e-07          1.00000          3395.68          1.0000            1.37706          0.822205       125.164     20.9691     0.797909     0.223886     1.07619e-05
   5.00000e-07          1.00000          1.38480e-07          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-07          1.00000          5.53920e-08          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-07          1.00000          2.76960e-08          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   5.00000e-08          1.00000          1.38480e-08          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-08          1.00000          5.53920e-09          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-08          1.00000          2.76960e-09          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   5.00000e-09          1.00000          1.38480e-09          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-09          1.00000          5.53920e-10          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-09          1.00000          2.76960e-10          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   5.00000e-10          1.00000          1.38480e-10          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-10          1.00000          5.53920e-11          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-10          1.00000          2.76960e-11          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   5.00000e-11          1.00000          1.38480e-11          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-11          1.00000          5.53920e-12          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-11          1.00000          2.76960e-12          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   5.00000e-12          1.00000          1.38480e-12          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   2.00000e-12          1.00000          5.53920e-13          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   1.00000e-12          1.00000          2.76960e-13          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          3395.68          1.0000            1.37706          0.822205       125.165     20.9691     0.797909     0.223885     1.07618e-05
END

set output "Figures/Env_009_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_009_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_009_P_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_009_LogP_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output "Figures/Env_009_P_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_009_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Reservoir Fluid A Swollen with Solvent\nAt the Saturation Temperature Minimum"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       3.24144e-09        0.000000         5.11839e-12          1.00000       627.998     125.165     1.02995     1.05068e-12     5.14071e-14
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       3.24144e-09        0.000000         5.11840e-12          1.00000       627.998     125.164     1.02995     1.05068e-12     5.14071e-14
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       3.24145e-09        0.000000         5.11840e-12          1.00000       627.998     125.164     1.02995     1.05068e-12     5.14071e-14
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       3.24146e-09        0.000000         5.11842e-12          1.00000       627.998     125.164     1.02995     1.05068e-12     5.14071e-14
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       3.24147e-09        0.000000         5.11844e-12          1.00000       627.998     125.164     1.02995     1.05069e-12     5.14071e-14
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       3.24151e-09        0.000000         5.11849e-12          1.00000       627.998     125.163     1.02995     1.05069e-12     5.14071e-14
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       3.24160e-09        0.000000         5.11865e-12          1.00000       627.998     125.160     1.02995     1.05070e-12     5.14071e-14
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       3.24177e-09        0.000000         5.11890e-12          1.00000       627.998     125.156     1.02995     1.05071e-12     5.14071e-14
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       3.24209e-09        0.000000         5.11941e-12          1.00000       627.998     125.146     1.02995     1.05074e-12     5.14071e-14
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       3.24306e-09        0.000000         5.12095e-12          1.00000       627.998     125.119     1.02995     1.05083e-12     5.14071e-14
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       3.24469e-09        0.000000         5.12351e-12          1.00000       627.998     125.074     1.02995     1.05097e-12     5.14071e-14
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       3.24794e-09        0.000000         5.12865e-12          1.00000       627.998     124.984     1.02995     1.05127e-12     5.14071e-14
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       3.25773e-09        0.000000         5.14411e-12          1.00000       627.998     124.712     1.02995     1.05215e-12     5.14071e-14
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       3.27418e-09        0.000000         5.17009e-12          1.00000       627.998     124.260     1.02995     1.05362e-12     5.14071e-14
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       3.30759e-09        0.000000         5.22285e-12          1.00000       627.998     123.355     1.02995     1.05662e-12     5.14071e-14
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.34169e-09        0.000000         5.27669e-12          1.00000       627.998     122.450     1.02995     1.05968e-12     5.14071e-14
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.37650e-09        0.000000         5.33166e-12          1.00000       627.998     121.545     1.02995     1.06281e-12     5.14071e-14
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.41204e-09        0.000000         5.38778e-12          1.00000       627.998     120.640     1.02995     1.06600e-12     5.14071e-14
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       3.44834e-09        0.000000         5.44510e-12          1.00000       627.998     119.735     1.02995     1.06926e-12     5.14071e-14
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       3.48542e-09        0.000000         5.50365e-12          1.00000       627.998     118.830     1.02995     1.07259e-12     5.14071e-14
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       3.52331e-09        0.000000         5.56347e-12          1.00000       627.998     117.925     1.02995     1.07599e-12     5.14071e-14
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.56202e-09        0.000000         5.62461e-12          1.00000       627.998     117.020     1.02995     1.07946e-12     5.14071e-14
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.60160e-09        0.000000         5.68710e-12          1.00000       627.998     116.115     1.02995     1.08302e-12     5.14071e-14
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.64207e-09        0.000000         5.75100e-12          1.00000       627.998     115.210     1.02995     1.08665e-12     5.14071e-14
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       3.68346e-09        0.000000         5.81635e-12          1.00000       627.998     114.305     1.02995     1.09036e-12     5.14071e-14
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       3.72579e-09        0.000000         5.88321e-12          1.00000       627.998     113.400     1.02995     1.09417e-12     5.14071e-14
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       3.76912e-09        0.000000         5.95162e-12          1.00000       627.998     112.495     1.02995     1.09805e-12     5.14071e-14
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       3.81346e-09        0.000000         6.02164e-12          1.00000       627.998     111.590     1.02995     1.10204e-12     5.14071e-14
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       3.85886e-09        0.000000         6.09332e-12          1.00000       627.998     110.685     1.02995     1.10611e-12     5.14071e-14
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       3.90535e-09        0.000000         6.16674e-12          1.00000       627.998     109.780     1.02995     1.11028e-12     5.14071e-14
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       3.95298e-09        0.000000         6.24194e-12          1.00000       627.998     108.875     1.02995     1.11456e-12     5.14071e-14
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       4.00178e-09        0.000000         6.31900e-12          1.00000       627.998     107.970     1.02995     1.11894e-12     5.14071e-14
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       4.05180e-09        0.000000         6.39799e-12          1.00000       627.998     107.065     1.02995     1.12343e-12     5.14071e-14
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       4.10309e-09        0.000000         6.47898e-12          1.00000       627.998     106.160     1.02995     1.12804e-12     5.14071e-14
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       4.15569e-09        0.000000         6.56204e-12          1.00000       627.998     105.255     1.02995     1.13276e-12     5.14071e-14
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       4.20966e-09        0.000000         6.64726e-12          1.00000       627.998     104.350     1.02995     1.13760e-12     5.14071e-14
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       4.26505e-09        0.000000         6.73472e-12          1.00000       627.998     103.445     1.02995     1.14258e-12     5.14071e-14
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       4.32192e-09        0.000000         6.82452e-12          1.00000       627.998     102.540     1.02995     1.14768e-12     5.14071e-14
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       4.38033e-09        0.000000         6.91674e-12          1.00000       627.998     101.635     1.02995     1.15292e-12     5.14071e-14
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       4.44033e-09        0.000000         7.01149e-12          1.00000       627.998     100.730     1.02995     1.15831e-12     5.14071e-14
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       4.50200e-09        0.000000         7.10888e-12          1.00000       627.998      99.825     1.02995     1.16385e-12     5.14071e-14
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       4.56541e-09        0.000000         7.20900e-12          1.00000       627.998      98.920     1.02995     1.16954e-12     5.14071e-14
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       4.63063e-09        0.000000         7.31199e-12          1.00000       627.998      98.015     1.02995     1.17540e-12     5.14071e-14
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       4.69774e-09        0.000000         7.41796e-12          1.00000       627.998      97.110     1.02995     1.18142e-12     5.14071e-14
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       4.76683e-09        0.000000         7.52705e-12          1.00000       627.998      96.205     1.02995     1.18762e-12     5.14071e-14
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       4.83797e-09        0.000000         7.63939e-12          1.00000       627.998      95.300     1.02995     1.19401e-12     5.14071e-14
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       4.91127e-09        0.000000         7.75514e-12          1.00000       627.998      94.395     1.02995     1.20059e-12     5.14071e-14
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       4.98683e-09        0.000000         7.87445e-12          1.00000       627.998      93.490     1.02995     1.20737e-12     5.14071e-14
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       5.06475e-09        0.000000         7.99749e-12          1.00000       627.998      92.585     1.02995     1.21437e-12     5.14071e-14
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       5.14514e-09        0.000000         8.12443e-12          1.00000       627.998      91.680     1.02995     1.22159e-12     5.14071e-14
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       5.22813e-09        0.000000         8.25547e-12          1.00000       627.998      90.775     1.02995     1.22904e-12     5.14071e-14
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       5.31384e-09        0.000000         8.39080e-12          1.00000       627.998      89.870     1.02995     1.23673e-12     5.14071e-14
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       5.40240e-09        0.000000         8.53065e-12          1.00000       627.998      88.965     1.02995     1.24468e-12     5.14071e-14
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       5.49397e-09        0.000000         8.67524e-12          1.00000       627.998      88.060     1.02995     1.25290e-12     5.14071e-14
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       5.58869e-09        0.000000         8.82481e-12          1.00000       627.998      87.155     1.02995     1.26140e-12     5.14071e-14
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       5.68674e-09        0.000000         8.97963e-12          1.00000       627.998      86.250     1.02995     1.27021e-12     5.14071e-14
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       5.78829e-09        0.000000         9.13998e-12          1.00000       627.998      85.345     1.02995     1.27932e-12     5.14071e-14
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       5.89353e-09        0.000000         9.30617e-12          1.00000       627.998      84.440     1.02995     1.28877e-12     5.14071e-14
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       6.00267e-09        0.000000         9.47850e-12          1.00000       627.998      83.535     1.02995     1.29857e-12     5.14071e-14
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       6.11593e-09        0.000000         9.65734e-12          1.00000       627.998      82.630     1.02995     1.30874e-12     5.14071e-14
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       6.23354e-09        0.000000         9.84306e-12          1.00000       627.998      81.725     1.02995     1.31930e-12     5.14071e-14
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       6.35577e-09        0.000000         1.00361e-11          1.00000       627.998      80.820     1.02995     1.33027e-12     5.14071e-14
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       6.48288e-09        0.000000         1.02368e-11          1.00000       627.998      79.915     1.02995     1.34168e-12     5.14071e-14
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       6.61519e-09        0.000000         1.04457e-11          1.00000       627.998      79.010     1.02995     1.35356e-12     5.14071e-14
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       6.75300e-09        0.000000         1.06633e-11          1.00000       627.998      78.105     1.02995     1.36593e-12     5.14071e-14
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       6.89668e-09        0.000000         1.08902e-11          1.00000       627.998      77.200     1.02995     1.37883e-12     5.14071e-14
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       7.04661e-09        0.000000         1.11269e-11          1.00000       627.998      76.295     1.02995     1.39229e-12     5.14071e-14
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       7.20320e-09        0.000000         1.13742e-11          1.00000       627.998      75.390     1.02995     1.40635e-12     5.14071e-14
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       7.36691e-09        0.000000         1.16327e-11          1.00000       627.998      74.485     1.02995     1.42104e-12     5.14071e-14
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       7.53824e-09        0.000000         1.19032e-11          1.00000       627.998      73.580     1.02995     1.43642e-12     5.14071e-14
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       7.71772e-09        0.000000         1.21866e-11          1.00000       627.998      72.675     1.02995     1.45254e-12     5.14071e-14
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       7.90595e-09        0.000000         1.24839e-11          1.00000       627.998      71.770     1.02995     1.46943e-12     5.14071e-14
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       8.10360e-09        0.000000         1.27960e-11          1.00000       627.998      70.865     1.02995     1.48718e-12     5.14071e-14
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       8.31139e-09        0.000000         1.31241e-11          1.00000       627.998      69.960     1.02995     1.50583e-12     5.14071e-14
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       8.53011e-09        0.000000         1.34694e-11          1.00000       627.998      69.055     1.02995     1.52547e-12     5.14071e-14
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       8.76065e-09        0.000000         1.38335e-11          1.00000       627.998      68.150     1.02995     1.54616e-12     5.14071e-14
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       9.00400e-09        0.000000         1.42178e-11          1.00000       627.998      67.245     1.02995     1.56801e-12     5.14071e-14
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       9.26126e-09        0.000000         1.46240e-11          1.00000       627.998      66.340     1.02995     1.59111e-12     5.14071e-14
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       9.53365e-09        0.000000         1.50541e-11          1.00000       627.998      65.435     1.02995     1.61556e-12     5.14071e-14
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       9.82255e-09        0.000000         1.55103e-11          1.00000       627.998      64.530     1.02995     1.64149e-12     5.14071e-14
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       1.01295e-08        0.000000         1.59950e-11          1.00000       627.998      63.625     1.02995     1.66905e-12     5.14071e-14
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       1.04563e-08        0.000000         1.65109e-11          1.00000       627.998      62.720     1.02995     1.69839e-12     5.14071e-14
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       1.08048e-08        0.000000         1.70613e-11          1.00000       627.998      61.815     1.02995     1.72968e-12     5.14071e-14
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       1.11774e-08        0.000000         1.76496e-11          1.00000       627.998      60.910     1.02995     1.76312e-12     5.14071e-14
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       1.15766e-08        0.000000         1.82800e-11          1.00000       627.998      60.005     1.02995     1.79896e-12     5.14071e-14
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       1.20053e-08        0.000000         1.89570e-11          1.00000       627.998      59.100     1.02995     1.83745e-12     5.14071e-14
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       1.24671e-08        0.000000         1.96861e-11          1.00000       627.998      58.195     1.02995     1.87891e-12     5.14071e-14
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       1.29658e-08        0.000000         2.04736e-11          1.00000       627.998      57.290     1.02995     1.92367e-12     5.14071e-14
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       1.35060e-08        0.000000         2.13266e-11          1.00000       627.998      56.385     1.02995     1.97217e-12     5.14071e-14
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       1.40932e-08        0.000000         2.22539e-11          1.00000       627.998      55.480     1.02995     2.02489e-12     5.14071e-14
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       1.47338e-08        0.000000         2.32654e-11          1.00000       627.998      54.575     1.02995     2.08240e-12     5.14071e-14
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       1.54354e-08        0.000000         2.43733e-11          1.00000       627.998      53.670     1.02995     2.14539e-12     5.14071e-14
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       1.62072e-08        0.000000         2.55920e-11          1.00000       627.998      52.765     1.02995     2.21467e-12     5.14071e-14
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       1.70602e-08        0.000000         2.69389e-11          1.00000       627.998      51.860     1.02995     2.29125e-12     5.14071e-14
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       1.80080e-08        0.000000         2.84355e-11          1.00000       627.998      50.955     1.02995     2.37634e-12     5.14071e-14
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       1.90673e-08        0.000000         3.01082e-11          1.00000       627.998      50.050     1.02995     2.47143e-12     5.14071e-14
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       2.02590e-08        0.000000         3.19899e-11          1.00000       627.998      49.145     1.02995     2.57842e-12     5.14071e-14
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       2.16096e-08        0.000000         3.41226e-11          1.00000       627.998      48.240     1.02995     2.69967e-12     5.14071e-14
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       2.31532e-08        0.000000         3.65599e-11          1.00000       627.998      47.335     1.02995     2.83824e-12     5.14071e-14
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       2.49342e-08        0.000000         3.93722e-11          1.00000       627.998      46.430     1.02995     2.99812e-12     5.14071e-14
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       2.70120e-08        0.000000         4.26533e-11          1.00000       627.998      45.525     1.02995     3.18466e-12     5.14071e-14
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       2.94676e-08        0.000000         4.65308e-11          1.00000       627.998      44.620     1.02995     3.40511e-12     5.14071e-14
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       3.24144e-08        0.000000         5.11839e-11          1.00000       627.998      43.715     1.02995     3.66966e-12     5.14071e-14
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       3.60160e-08        0.000000         5.68710e-11          1.00000       627.998      42.810     1.02995     3.99299e-12     5.14071e-14
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       4.05180e-08        0.000000         6.39799e-11          1.00000       627.998      41.905     1.02995     4.39715e-12     5.14071e-14
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       4.63063e-08        0.000000         7.31199e-11          1.00000       627.998      41.001     1.02995     4.91679e-12     5.14071e-14
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.40240e-08        0.000000         8.53065e-11          1.00000       627.998      40.096     1.02995     5.60964e-12     5.14071e-14
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       6.48288e-08        0.000000         1.02368e-10          1.00000       627.998      39.191     1.02995     6.57963e-12     5.14071e-14
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.10360e-08        0.000000         1.27960e-10          1.00000       627.998      38.286     1.02995     8.03461e-12     5.14071e-14
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       1.08048e-07        0.000000         1.70613e-10          1.00000       627.998      37.381     1.02995     1.04596e-11     5.14071e-14
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       1.62072e-07        0.000000         2.55920e-10          1.00000       627.998      36.476     1.02995     1.53095e-11     5.14071e-14
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.24144e-07        0.000000         5.11839e-10          1.00000       627.998      35.571     1.02995     2.98594e-11     5.14071e-14
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       6.48288e-07        0.000000         1.02368e-09          1.00000       627.998      35.118     1.02995     5.89591e-11     5.14071e-14
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.62072e-06        0.000000         2.55920e-09          1.00000       627.998      34.847     1.02995     1.46258e-10     5.14071e-14
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       3.24144e-06        0.000000         5.11839e-09          1.00000       627.998      34.756     1.02995     2.91757e-10     5.14071e-14
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       6.48288e-06        0.000000         1.02368e-08          1.00000       627.998      34.711     1.02995     5.82754e-10     5.14071e-14
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.62072e-05        0.000000         2.55920e-08          1.00000       627.998      34.684     1.02995     1.45574e-09     5.14071e-14
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       3.24144e-05        0.000000         5.11839e-08          1.00000       627.998      34.675     1.02995     2.91073e-09     5.14071e-14
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       6.48289e-05        0.000000         1.02368e-07          1.00000       627.998      34.670     1.02995     5.82070e-09     5.14072e-14
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.62072e-04        0.000000         2.55920e-07          1.00000       627.998      34.667     1.02995     1.45506e-08     5.14072e-14
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       3.24145e-04        0.000000         5.11840e-07          1.00000       627.998      34.666     1.02995     2.91005e-08     5.14073e-14
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       6.48292e-04        0.000000         1.02368e-06          1.00000       627.997      34.666     1.02995     5.82005e-08     5.14075e-14
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.62074e-03        0.000000         2.55923e-06          1.00000       627.996      34.666     1.02995     1.45501e-07     5.14080e-14
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       3.24154e-03        0.000000         5.11852e-06          1.00000       627.995      34.666     1.02995     2.91007e-07     5.14089e-14
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       6.48326e-03        0.000000         1.02373e-05          1.00000       627.992      34.666     1.02995     5.82030e-07     5.14107e-14
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.62096e-02        0.000000         2.55951e-05          0.99999       627.983      34.666     1.02995     1.45521e-06     5.14160e-14
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       3.24239e-02        0.000000         5.11966e-05          0.99999       627.968      34.666     1.02994     2.91086e-06     5.14249e-14
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       6.48668e-02        0.000000         1.02419e-04          0.99997       627.937      34.666     1.02994     5.82351e-06     5.14427e-14
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.62310e-01        0.000000         2.56237e-04          0.99993       627.846      34.666     1.02993     1.45722e-05     5.14962e-14
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       3.25096e-01        0.000000         5.13111e-04          0.99986       627.694      34.666     1.02991     2.91892e-05     5.15858e-14
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.52114e-01        0.000000         1.02879e-03          0.99972       627.388      34.666     1.02988     5.85590e-05     5.17661e-14
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.64496e+00        0.000000         2.59154e-03          0.99930       626.459      34.666     1.02978     1.47777e-04     5.23178e-14
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       3.34069e+00        0.000000         5.25068e-03          0.99859       624.878      34.666     1.02960     3.00331e-04     5.32741e-14
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       6.89993e+00        0.000000         1.07914e-02          0.99708       621.570      34.666     1.02922     6.21248e-04     5.53412e-14
   1.00000e+00        3.11753e-10        1.00000e+00        1.12562e-09       1.15417e+01        0.000000         1.79351e-02          0.99511       617.284      34.666     1.02873     1.04123e-03     5.81632e-14
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.93061e+01        0.000000         2.96791e-02          0.99181       610.182      34.666     1.02791     1.74748e-03     6.32239e-14
   1.00000e+00        1.36224e-10        1.00000e+00        4.91855e-10       3.17583e+01        0.000000         4.79870e-02          0.98651       598.966      34.666     1.02657     2.89006e-03     7.23203e-14
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       5.22422e+01        0.000000         7.67353e-02          0.97773       580.976      34.666     1.02432     4.79680e-03     9.03718e-14
   1.00000e+00        8.64134e-11        1.00000e+00        3.12007e-10       7.40852e+01        0.000000         1.05594e-01          0.96831       562.405      34.666     1.02187     6.86858e-03     1.14888e-13
   1.00000e+00        8.16271e-11        1.00000e+00        2.94725e-10       1.05061e+02        0.000000         1.43517e-01          0.95483       537.124      34.666     1.01827     9.87793e-03     1.62192e-13
   1.00000e+00        8.16271e-11        1.00000e+00        2.94725e-10       1.05085e+02        0.000000         1.43545e-01          0.95482       537.105      34.666     1.01827     9.88031e-03     1.62236e-13
   1.00000e+00        8.54030e-11        1.00000e+00        3.08359e-10       1.38627e+02        0.000000         1.80903e-01          0.94005       511.074      34.666     1.01423     1.32387e-02     2.37140e-13
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.82875e+02        0.000000         2.24796e-01          0.92029       478.778      34.666     1.00868     1.78394e-02     3.95419e-13
   1.00000e+00        1.30292e-10        1.00000e+00        4.70436e-10       2.32944e+02        0.000000         2.67835e-01          0.89752       444.903      34.666     1.00208     2.33001e-02     7.16327e-13
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       2.96721e+02        0.000000         3.13831e-01          0.86781       405.632      34.666     0.99320     3.06954e-02     1.56804e-12
   1.00000e+00        2.97286e-10        1.00000e+00        1.07339e-09       3.47201e+02        0.000000         3.44288e-01          0.84369       377.482      34.666     0.98584     3.69445e-02     2.98437e-12
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       4.06269e+02        0.000000         3.74472e-01          0.81469       347.711      34.666     0.97694     4.47684e-02     6.52658e-12
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       4.76454e+02        0.000000         4.04476e-01          0.77903       316.713      34.666     0.96615     5.49060e-02     1.73232e-11
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       5.39392e+02        0.000000         4.27869e-01          0.74576       293.030      34.666     0.95666     6.49314e-02     4.36325e-11
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.13888e+02        0.000000         4.54193e-01          0.70457       270.381      34.666     0.94640     7.82192e-02     1.39255e-10
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       6.64776e+02        0.000000         4.73325e-01          0.67515       258.617      34.666     0.94064     8.83951e-02     3.22381e-10
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.11647e+02        0.000000         4.93305e-01          0.64700       250.735      34.666     0.93673     9.87435e-02     7.25048e-10
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       7.68302e+02        0.000000         5.22297e-01          0.61157       245.257      34.666     0.93430     1.12781e-01     2.03743e-09
   1.00000e+00        5.66052e-08        1.00000e+00        2.04380e-07       7.75560e+02        0.000000         5.26488e-01          0.60692       244.882      34.666     0.93419     1.14719e-01     2.33661e-09
   1.00000e+00        5.66052e-08        1.00000e+00        2.04380e-07       7.75560e+02        0.000000         2.05622e-01          0.60692        39.860      34.666     0.38934     1.14719e-01     2.79956e-06
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       7.76141e+02        0.000000         2.05986e-01          0.60654        39.786      34.666     0.38823     1.14876e-01     2.91128e-06
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.78508e+02        0.000000         2.07477e-01          0.60502        39.506      34.666     0.38390     1.15516e-01     3.40231e-06
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       7.79217e+02        0.000000         2.07927e-01          0.60456        39.428      34.666     0.38265     1.15709e-01     3.56130e-06
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       7.79560e+02        0.000000         2.08144e-01          0.60434        39.391      34.666     0.38206     1.15802e-01     3.64009e-06
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       7.79761e+02        0.000000         2.08273e-01          0.60421        39.370      34.666     0.38172     1.15857e-01     3.68715e-06
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       7.79828e+02        0.000000         2.08315e-01          0.60417        39.362      34.666     0.38160     1.15875e-01     3.70281e-06
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       7.79861e+02        0.000000         2.08336e-01          0.60415        39.359      34.666     0.38155     1.15884e-01     3.71063e-06
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       7.79881e+02        0.000000         2.08349e-01          0.60413        39.357      34.666     0.38151     1.15890e-01     3.71532e-06
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       7.79888e+02        0.000000         2.08353e-01          0.60413        39.356      34.666     0.38150     1.15891e-01     3.71688e-06
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       7.79891e+02        0.000000         2.08355e-01          0.60413        39.356      34.666     0.38150     1.15892e-01     3.71766e-06
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       7.79893e+02        0.000000         2.08356e-01          0.60413        39.356      34.666     0.38149     1.15893e-01     3.71813e-06
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       7.79893e+02        0.000000         2.08357e-01          0.60413        39.355      34.666     0.38149     1.15893e-01     3.71829e-06
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       7.79894e+02        0.000000         2.08357e-01          0.60413        39.355      34.666     0.38149     1.15893e-01     3.71837e-06
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       7.79894e+02        0.000000         2.08357e-01          0.60413        39.355      34.666     0.38149     1.15893e-01     3.71841e-06
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       7.79894e+02        0.000000         2.08357e-01          0.60413        39.355      34.666     0.38149     1.15893e-01     3.71843e-06
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       7.79894e+02        0.000000         2.08357e-01          0.60413        39.355      34.666     0.38149     1.15893e-01     3.71844e-06
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28223e-02
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28224e-02
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28224e-02
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28224e-02
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28224e-02
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28224e-02
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.05476e+03        0.000000         3.53159e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28225e-02
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       1.05476e+03        0.000000         3.53158e-01          0.43399        35.664      34.666     0.27585     2.18184e-01     7.28226e-02
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       1.05477e+03        0.000000         3.53158e-01          0.43399        35.664      34.666     0.27585     2.18185e-01     7.28229e-02
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.05477e+03        0.000000         3.53158e-01          0.43399        35.664      34.666     0.27585     2.18185e-01     7.28235e-02
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       1.05477e+03        0.000000         3.53158e-01          0.43399        35.664      34.666     0.27585     2.18187e-01     7.28252e-02
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       1.05478e+03        0.000000         3.53157e-01          0.43399        35.664      34.666     0.27585     2.18189e-01     7.28280e-02
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.05479e+03        0.000000         3.53156e-01          0.43398        35.664      34.666     0.27586     2.18195e-01     7.28336e-02
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.05482e+03        0.000000         3.53151e-01          0.43397        35.664      34.666     0.27587     2.18210e-01     7.28505e-02
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       1.05488e+03        0.000000         3.53144e-01          0.43394        35.665      34.666     0.27589     2.18237e-01     7.28785e-02
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.05500e+03        0.000000         3.53129e-01          0.43389        35.665      34.666     0.27594     2.18289e-01     7.29341e-02
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.05536e+03        0.000000         3.53084e-01          0.43373        35.666      34.666     0.27608     2.18445e-01     7.30969e-02
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.05596e+03        0.000000         3.53006e-01          0.43346        35.669      34.666     0.27632     2.18703e-01     7.33558e-02
   9.99984e-01        1.57817e-05        9.99943e-01        5.69796e-05       1.05663e+03        0.000000         3.52913e-01          0.43317        35.672      34.667     0.27659     2.18996e-01     7.36360e-02
   9.99984e-01        1.57817e-05        9.99943e-01        5.69796e-05       1.05663e+03        0.000000         7.67041e-01          0.43317       266.709      34.667     0.95147     2.18996e-01     8.62316e-07
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.06983e+03        0.000000         7.79341e-01          0.42799       267.863      34.667     0.95226     2.24419e-01     1.10396e-06
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.12790e+03        0.000000         8.30986e-01          0.41067       271.679      34.670     0.95496     2.46595e-01     2.88561e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.18307e+03        0.000000         8.76549e-01          0.40114       273.676      34.675     0.95658     2.64835e-01     6.01149e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.25393e+03        0.000000         9.31242e-01          0.39574       274.665      34.684     0.95778     2.84604e-01     1.26241e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.38693e+03        0.000000         1.02655e+00          0.39746       273.969      34.711     0.95858     3.13676e-01     3.42048e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       1.53672e+03        0.000000         1.12718e+00          0.40858       271.477      34.756     0.95849     3.38535e-01     7.38643e-05
   9.98551e-01        1.44885e-03        9.94788e-01        5.21156e-03       1.64394e+03        0.000000         1.19645e+00          0.41951       269.269      34.797     0.95815     3.53130e-01     1.12302e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.75865e+03        0.000000         1.26866e+00          0.43278       266.761      34.847     0.95765     3.66712e-01     1.62445e-04
   9.97172e-01        2.82814e-03        9.89863e-01        1.01365e-02       1.91126e+03        0.000000         1.36228e+00          0.45201       263.367      34.922     0.95690     3.82400e-01     2.42973e-04
   9.96173e-01        3.82650e-03        9.86321e-01        1.36794e-02       2.07712e+03        0.000000         1.46137e+00          0.47418       259.729      35.012     0.95604     3.97177e-01     3.47244e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.25737e+03        0.000000         1.56640e+00          0.49921       255.913      35.118     0.95509     4.11249e-01     4.78731e-04
   9.93538e-01        6.46226e-03        9.77054e-01        2.29457e-02       2.46899e+03        0.000000         1.68665e+00          0.52936       251.656      35.250     0.95401     4.25782e-01     6.54830e-04
   9.91870e-01        8.13028e-03        9.71255e-01        2.87453e-02       2.70045e+03        0.000000         1.81488e+00          0.56293       247.290      35.401     0.95290     4.39801e-01     8.71098e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       2.95360e+03        0.000000         1.95169e+00          0.60008       242.850      35.571     0.95177     4.53400e-01     1.13191e-03
   9.88546e-01        1.14537e-02        9.59846e-01        4.01544e-02       3.14871e+03        0.000000         2.05497e+00          0.62893       239.653      35.702     0.95096     4.62889e-01     1.34761e-03
   9.86998e-01        1.30016e-02        9.54597e-01        4.54030e-02       3.35671e+03        0.000000         2.16322e+00          0.65981       236.445      35.842     0.95016     4.72215e-01     1.58942e-03
   9.85362e-01        1.46380e-02        9.49093e-01        5.09072e-02       3.57845e+03        0.000000         2.27671e+00          0.69284       233.237      35.990     0.94937     4.81393e-01     1.85848e-03
   9.83644e-01        1.63558e-02        9.43363e-01        5.66365e-02       3.81483e+03        0.000000         2.39574e+00          0.72813       230.038      36.146     0.94861     4.90431e-01     2.15567e-03
   9.81854e-01        1.81465e-02        9.37443e-01        6.25567e-02       4.06683e+03        0.000000         2.52065e+00          0.76580       226.859      36.308     0.94788     4.99336e-01     2.48153e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.33548e+03        0.000000         2.65181e+00          0.80600       223.710      36.476     0.94718     5.08111e-01     2.83621e-03
   9.78375e-01        2.16252e-02        9.26092e-01        7.39082e-02       4.57910e+03        0.000000         2.76915e+00          0.84245       221.050      36.623     0.94662     5.15510e-01     3.16195e-03
   9.76720e-01        2.32798e-02        9.20761e-01        7.92391e-02       4.83641e+03        0.000000         2.89162e+00          0.88095       218.425      36.772     0.94610     5.22815e-01     3.50797e-03
   9.75045e-01        2.49548e-02        9.15408e-01        8.45917e-02       5.10818e+03        0.000000         3.01952e+00          0.92157       215.842      36.924     0.94562     5.30026e-01     3.87339e-03
   9.73360e-01        2.66404e-02        9.10066e-01        8.99338e-02       5.39522e+03        0.000000         3.15317e+00          0.96443       213.307      37.076     0.94519     5.37140e-01     4.25693e-03
   9.71674e-01        2.83259e-02        9.04768e-01        9.52321e-02       5.69839e+03        0.000000         3.29293e+00          1.00963       210.826      37.229     0.94481     5.44155e-01     4.65692e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       6.01860e+03        0.000000         3.43920e+00          1.05728       208.406      37.381     0.94450     5.51068e-01     5.06712e-03
   9.68415e-01        3.15854e-02        8.94644e-01        1.05356e-01       6.34294e+03        0.000000         3.58614e+00          1.10541       206.145      37.524     0.94425     5.57605e-01     5.44503e-03
   9.66862e-01        3.31380e-02        8.89878e-01        1.10122e-01       6.68476e+03        0.000000         3.73989e+00          1.15600       203.951      37.665     0.94407     5.64041e-01     5.82749e-03
   9.65354e-01        3.46462e-02        8.85281e-01        1.14719e-01       7.04501e+03        0.000000         3.90089e+00          1.20914       201.828      37.801     0.94396     5.70373e-01     6.21149e-03
   9.63902e-01        3.60983e-02        8.80887e-01        1.19113e-01       7.42466e+03        0.000000         4.06961e+00          1.26493       199.783      37.932     0.94392     5.76596e-01     6.59373e-03
   9.62518e-01        3.74824e-02        8.76727e-01        1.23273e-01       7.82478e+03        0.000000         4.24660e+00          1.32348       197.819      38.058     0.94395     5.82707e-01     6.97063e-03
   9.61213e-01        3.87868e-02        8.72832e-01        1.27168e-01       8.24645e+03        0.000000         4.43242e+00          1.38488       195.941      38.176     0.94407     5.88703e-01     7.33839e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.69085e+03        0.000000         4.62768e+00          1.44924       194.154      38.286     0.94427     5.94579e-01     7.69307e-03
   9.59009e-01        4.09906e-02        8.66305e-01        1.33695e-01       9.10486e+03        0.000000         4.80922e+00          1.50887       192.647      38.375     0.94452     5.99687e-01     7.99337e-03
   9.58106e-01        4.18940e-02        8.63649e-01        1.36351e-01       9.53859e+03        0.000000         4.99920e+00          1.57099       191.216      38.457     0.94484     6.04698e-01     8.27744e-03
   9.57296e-01        4.27038e-02        8.61278e-01        1.38722e-01       9.99298e+03        0.000000         5.19814e+00          1.63567       189.863      38.530     0.94523     6.09610e-01     8.54261e-03
   9.56586e-01        4.34143e-02        8.59204e-01        1.40796e-01       1.04690e+04        0.000000         5.40659e+00          1.70301       188.589      38.595     0.94570     6.14421e-01     8.78631e-03
   9.55979e-01        4.40210e-02        8.57440e-01        1.42560e-01       1.09677e+04        0.000000         5.62514e+00          1.77308       187.397      38.649     0.94623     6.19133e-01     9.00618e-03
   9.55480e-01        4.45200e-02        8.55992e-01        1.44008e-01       1.14902e+04        0.000000         5.85442e+00          1.84597       186.286      38.695     0.94684     6.23743e-01     9.20013e-03
   9.55091e-01        4.49089e-02        8.54866e-01        1.45134e-01       1.20375e+04        0.000000         6.09509e+00          1.92177       185.258      38.730     0.94752     6.28253e-01     9.36638e-03
   9.54814e-01        4.51863e-02        8.54064e-01        1.45936e-01       1.26110e+04        0.000000         6.34784e+00          2.00057       184.313      38.755     0.94827     6.32664e-01     9.50352e-03
   9.54648e-01        4.53519e-02        8.53586e-01        1.46414e-01       1.32117e+04        0.000000         6.61340e+00          2.08249       183.451      38.770     0.94909     6.36976e-01     9.61052e-03
   9.54593e-01        4.54069e-02        8.53427e-01        1.46573e-01       1.38411e+04        0.000000         6.89255e+00          2.16763       182.672      38.775     0.94998     6.41192e-01     9.68678e-03
   9.57038e-01        4.29615e-02        8.60525e-01        1.39475e-01       1.92379e+04        0.000000         9.33065e+00          2.87328       179.415      38.554     0.95798     6.68492e-01     9.38679e-03
   9.62816e-01        3.71842e-02        8.77621e-01        1.22379e-01       2.67389e+04        0.000000         1.28467e+01          3.80467       179.586      38.031     0.96801     6.92171e-01     8.02979e-03
   9.69497e-01        3.05029e-02        8.97989e-01        1.02011e-01       3.71647e+04        0.000000         1.79214e+01          5.05084       182.223      37.426     0.97862     7.13170e-01     6.35247e-03
   9.75545e-01        2.44552e-02        9.17000e-01        8.29997e-02       5.16557e+04        0.000000         2.52137e+01          6.74061       186.344      36.879     0.98867     7.31892e-01     4.84709e-03
   9.80403e-01        1.95970e-02        9.32686e-01        6.73138e-02       7.17968e+04        0.000000         3.56257e+01          9.05348       191.120      36.439     0.99747     7.48357e-01     3.68087e-03
   9.84068e-01        1.59324e-02        9.44771e-01        5.52289e-02       9.97911e+04        0.000000         5.03932e+01         12.23796       195.928      36.107     1.00477     7.62485e-01     2.84119e-03
   9.86741e-01        1.32593e-02        9.53727e-01        4.62728e-02       1.38701e+05        0.000000         7.12133e+01         16.63851       200.359      35.866     1.01060     7.74272e-01     2.25720e-03
   9.88657e-01        1.13426e-02        9.60224e-01        3.97762e-02       1.92782e+05        0.000000         1.00427e+02         22.73333       204.196      35.692     1.01511     7.83838e-01     1.85639e-03
   9.90021e-01        9.97883e-03        9.64885e-01        3.51151e-02       2.67949e+05        0.000000         1.41276e+02         31.18674       207.366      35.569     1.01853     7.91410e-01     1.58172e-03
   9.90989e-01        9.01077e-03        9.68213e-01        3.17868e-02       3.72425e+05        0.000000         1.98257e+02         42.92175       209.895      35.481     1.02109     7.97279e-01     1.39265e-03
   9.91677e-01        8.32333e-03        9.70587e-01        2.94134e-02       5.17638e+05        0.000000         2.77624e+02         59.22087       211.859      35.419     1.02298     8.01748e-01     1.26161e-03
   9.92166e-01        7.83436e-03        9.72280e-01        2.77200e-02       7.19471e+05        0.000000         3.88069e+02         81.86625       213.354      35.375     1.02437     8.05103e-01     1.17014e-03
   9.92514e-01        7.48584e-03        9.73489e-01        2.65105e-02       1.00000e+06        0.000000         5.41679e+02        113.33449       214.475      35.343     1.02538     8.07595e-01     1.10586e-03
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       4.74070e+03        0.000000         2.37114e+00          1.90361       168.991     125.165     0.87499     8.07230e-01     3.08905e-01
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       4.73956e+03        0.000000         2.37060e+00          1.90317       168.993     125.165     0.87499     8.07223e-01     3.08900e-01
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       4.73871e+03        0.000000         2.37020e+00          1.90284       168.994     125.165     0.87498     8.07218e-01     3.08896e-01
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       4.73760e+03        0.000000         2.36968e+00          1.90241       168.996     125.165     0.87498     8.07211e-01     3.08891e-01
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       4.73550e+03        0.000000         2.36869e+00          1.90160       168.999     125.165     0.87497     8.07198e-01     3.08882e-01
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       4.73317e+03        0.000000         2.36760e+00          1.90070       169.003     125.164     0.87497     8.07184e-01     3.08872e-01
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       4.72991e+03        0.000000         2.36607e+00          1.89943       169.008     125.164     0.87496     8.07164e-01     3.08858e-01
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       4.72349e+03        0.000000         2.36305e+00          1.89694       169.018     125.164     0.87493     8.07124e-01     3.08829e-01
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       4.71629e+03        0.000000         2.35966e+00          1.89415       169.029     125.164     0.87491     8.07080e-01     3.08797e-01
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       4.70618e+03        0.000000         2.35491e+00          1.89022       169.045     125.163     0.87488     8.07017e-01     3.08750e-01
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       4.68633e+03        0.000000         2.34556e+00          1.88250       169.074     125.160     0.87482     8.06892e-01     3.08656e-01
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       4.66429e+03        0.000000         2.33517e+00          1.87391       169.107     125.156     0.87474     8.06751e-01     3.08545e-01
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       4.63371e+03        0.000000         2.32072e+00          1.86195       169.151     125.146     0.87465     8.06552e-01     3.08382e-01
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       4.57507e+03        0.000000         2.29294e+00          1.83889       169.231     125.119     0.87445     8.06156e-01     3.08035e-01
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       4.51220e+03        0.000000         2.26302e+00          1.81397       169.310     125.074     0.87425     8.05708e-01     3.07607e-01
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       4.42909e+03        0.000000         2.22324e+00          1.78068       169.401     124.984     0.87397     8.05072e-01     3.06935e-01
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       4.28422e+03        0.000000         2.15312e+00          1.72140       169.507     124.712     0.87346     8.03807e-01     3.05379e-01
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       4.15273e+03        0.000000         2.08821e+00          1.66547       169.507     124.260     0.87297     8.02379e-01     3.03282e-01
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       4.02437e+03        0.000000         2.02227e+00          1.60626       169.287     123.355     0.87244     8.00368e-01     2.99717e-01
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.97237e+03        0.000000         1.99266e+00          1.57688       168.937     122.450     0.87215     7.98842e-01     2.96522e-01
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.96090e+03        0.000000         1.98231e+00          1.56319       168.518     121.545     0.87201     7.97575e-01     2.93523e-01
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.97637e+03        0.000000         1.98467e+00          1.55974       168.053     120.640     0.87196     7.96480e-01     2.90653e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       4.01199e+03        0.000000         1.99646e+00          1.56381       167.555     119.735     0.87198     7.95513e-01     2.87874e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       4.06392e+03        0.000000         2.01579e+00          1.57379       167.030     118.830     0.87206     7.94648e-01     2.85162e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       4.12981e+03        0.000000         2.04147e+00          1.58869       166.483     117.925     0.87219     7.93868e-01     2.82503e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       4.20820e+03        0.000000         2.07276e+00          1.60785       165.918     117.020     0.87236     7.93163e-01     2.79885e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       4.29818e+03        0.000000         2.10915e+00          1.63084       165.337     116.115     0.87257     7.92525e-01     2.77300e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       4.39923e+03        0.000000         2.15034e+00          1.65737       164.741     115.210     0.87282     7.91950e-01     2.74741e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       4.51116e+03        0.000000         2.19617e+00          1.68729       164.132     114.305     0.87311     7.91436e-01     2.72204e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       4.63401e+03        0.000000         2.24660e+00          1.72050       163.510     113.400     0.87343     7.90980e-01     2.69683e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       4.76805e+03        0.000000         2.30167e+00          1.75702       162.877     112.495     0.87379     7.90583e-01     2.67176e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       4.91380e+03        0.000000         2.36155e+00          1.79693       162.231     111.590     0.87419     7.90246e-01     2.64680e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       5.07202e+03        0.000000         2.42648e+00          1.84038       161.574     110.685     0.87464     7.89972e-01     2.62192e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       5.24376e+03        0.000000         2.49687e+00          1.88764       160.904     109.780     0.87512     7.89766e-01     2.59712e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       5.43047e+03        0.000000         2.57324e+00          1.93906       160.222     108.875     0.87565     7.89632e-01     2.57237e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       5.63406e+03        0.000000         2.65634e+00          1.99517       159.525     107.970     0.87623     7.89579e-01     2.54767e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       5.85715e+03        0.000000         2.74718e+00          2.05668       158.812     107.065     0.87687     7.89619e-01     2.52302e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       6.10337e+03        0.000000         2.84719e+00          2.12462       158.080     106.160     0.87757     7.89768e-01     2.49843e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       6.37796e+03        0.000000         2.95844e+00          2.20050       157.325     105.255     0.87835     7.90048e-01     2.47393e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       6.68895e+03        0.000000         3.08414e+00          2.28666       156.542     104.350     0.87924     7.90498e-01     2.44955e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       7.04978e+03        0.000000         3.22967e+00          2.38706       155.717     103.445     0.88025     7.91176e-01     2.42540e-01
   2.45200e-01        7.54800e-01        8.25451e-02        9.17455e-01       7.26479e+03        0.000000         3.31628e+00          2.44719       155.266     102.974     0.88085     7.91654e-01     2.41299e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       7.48635e+03        0.000000         3.40548e+00          2.50946       154.830     102.540     0.88146     7.92200e-01     2.40168e-01
   2.55355e-01        7.44645e-01        8.67376e-02        9.13262e-01       7.77033e+03        0.000000         3.51977e+00          2.58980       154.313     102.055     0.88223     7.92978e-01     2.38931e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       8.06508e+03        0.000000         3.63843e+00          2.67395       153.824     101.635     0.88302     7.93872e-01     2.37895e-01
   2.65074e-01        7.34926e-01        9.08216e-02        9.09178e-01       8.48677e+03        0.000000         3.80842e+00          2.79601       153.203     101.176     0.88413     7.95302e-01     2.36848e-01
   2.68427e-01        7.31573e-01        9.22472e-02        9.07753e-01       8.93050e+03        0.000000         3.98790e+00          2.92713       152.649     100.872     0.88527     7.96997e-01     2.36309e-01
   2.69671e-01        7.30329e-01        9.27784e-02        9.07222e-01       9.39743e+03        0.000000         4.17788e+00          3.06902       152.176     100.760     0.88644     7.99002e-01     2.36408e-01
   2.69671e-01        7.30329e-01        9.27784e-02        9.07222e-01       9.39887e+03        0.000000         4.17847e+00          3.06946       152.174     100.760     0.88645     7.99009e-01     2.36409e-01
   2.68832e-01        7.31168e-01        9.24199e-02        9.07580e-01       9.76525e+03        0.000000         4.32881e+00          3.18453       151.888     100.836     0.88734     8.00762e-01     2.37031e-01
   2.65942e-01        7.34058e-01        9.11900e-02        9.08810e-01       1.01459e+04        0.000000         4.48686e+00          3.30887       151.681     101.097     0.88824     8.02790e-01     2.38299e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       1.05414e+04        0.000000         4.65430e+00          3.44575       151.595     101.635     0.88916     8.05209e-01     2.40541e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       1.09054e+04        0.000000         4.81406e+00          3.58431       151.705     102.540     0.88998     8.07939e-01     2.44059e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       1.11091e+04        0.000000         4.90934e+00          3.67426       151.947     103.445     0.89043     8.09976e-01     2.47454e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       1.12200e+04        0.000000         4.96726e+00          3.73579       152.263     104.350     0.89068     8.11622e-01     2.50783e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       1.12646e+04        0.000000         4.99851e+00          3.77680       152.631     105.255     0.89078     8.12994e-01     2.54064e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       1.12574e+04        0.000000         5.00874e+00          3.80140       153.040     106.160     0.89078     8.14155e-01     2.57306e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       1.12073e+04        0.000000         5.00142e+00          3.81212       153.484     107.065     0.89068     8.15142e-01     2.60511e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       1.11204e+04        0.000000         4.97893e+00          3.81063       153.957     107.970     0.89051     8.15980e-01     2.63680e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       1.10014e+04        0.000000         4.94300e+00          3.79817       154.458     108.875     0.89027     8.16686e-01     2.66813e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       1.08539e+04        0.000000         4.89493e+00          3.77565       154.984     109.780     0.88997     8.17272e-01     2.69907e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       1.06806e+04        0.000000         4.83580e+00          3.74382       155.534     110.685     0.88962     8.17749e-01     2.72961e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       1.04840e+04        0.000000         4.76644e+00          3.70326       156.107     111.590     0.88921     8.18123e-01     2.75972e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       1.02661e+04        0.000000         4.68755e+00          3.65446       156.702     112.495     0.88876     8.18399e-01     2.78936e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       1.00285e+04        0.000000         4.59971e+00          3.59781       157.320     113.400     0.88826     8.18581e-01     2.81851e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       9.77274e+03        0.000000         4.50339e+00          3.53364       157.960     114.305     0.88772     8.18672e-01     2.84711e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       9.49990e+03        0.000000         4.39895e+00          3.46219       158.623     115.210     0.88713     8.18672e-01     2.87512e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       9.21091e+03        0.000000         4.28663e+00          3.38361       159.309     116.115     0.88650     8.18581e-01     2.90248e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       8.90636e+03        0.000000         4.16656e+00          3.29797       160.019     117.020     0.88582     8.18397e-01     2.92912e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       8.58655e+03        0.000000         4.03873e+00          3.20524       160.756     117.925     0.88510     8.18117e-01     2.95498e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       8.25133e+03        0.000000         3.90291e+00          3.10519       161.520     118.830     0.88433     8.17735e-01     2.97994e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       7.89996e+03        0.000000         3.75863e+00          2.99742       162.316     119.735     0.88350     8.17240e-01     3.00389e-01
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       7.53077e+03        0.000000         3.60495e+00          2.88113       163.147     120.640     0.88262     8.16618e-01     3.02666e-01
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       7.14056e+03        0.000000         3.44022e+00          2.75495       164.021     121.545     0.88165     8.15843e-01     3.04801e-01
   3.48295e-02        9.65171e-01        9.89557e-03        9.90104e-01       6.92873e+03        0.000000         3.34980e+00          2.68507       164.493     122.013     0.88112     8.15369e-01     3.05838e-01
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       6.72318e+03        0.000000         3.26139e+00          2.61634       164.950     122.450     0.88059     8.14871e-01     3.06756e-01
   2.47729e-02        9.75227e-01        6.98625e-03        9.93014e-01       6.49035e+03        0.000000         3.16044e+00          2.53740       165.464     122.923     0.87999     8.14260e-01     3.07685e-01
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       6.26559e+03        0.000000         3.06215e+00          2.46008       165.957     123.355     0.87939     8.13617e-01     3.08460e-01
   1.46292e-02        9.85371e-01        4.09503e-03        9.95905e-01       5.99313e+03        0.000000         2.94187e+00          2.36486       166.547     123.841     0.87866     8.12762e-01     3.09221e-01
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       5.73251e+03        0.000000         2.82563e+00          2.27221       167.101     124.260     0.87793     8.11856e-01     3.09740e-01
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       5.39914e+03        0.000000         2.67513e+00          2.15134       167.787     124.712     0.87698     8.10544e-01     3.10044e-01
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       5.13333e+03        0.000000         2.55357e+00          2.05291       168.306     124.984     0.87620     8.09347e-01     3.09923e-01
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       5.00995e+03        0.000000         2.49664e+00          2.00654       168.534     125.074     0.87583     8.08733e-01     3.09728e-01
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       4.92695e+03        0.000000         2.45814e+00          1.97508       168.682     125.119     0.87557     8.08296e-01     3.09538e-01
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       4.85622e+03        0.000000         2.42521e+00          1.94809       168.804     125.146     0.87535     8.07906e-01     3.09334e-01
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       4.82162e+03        0.000000         2.40905e+00          1.93482       168.861     125.156     0.87524     8.07709e-01     3.09218e-01
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       4.79756e+03        0.000000         2.39780e+00          1.92557       168.901     125.160     0.87517     8.07569e-01     3.09132e-01
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       4.77651e+03        0.000000         2.38793e+00          1.91745       168.935     125.163     0.87510     8.07445e-01     3.09051e-01
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       4.76600e+03        0.000000         2.38301e+00          1.91340       168.951     125.164     0.87507     8.07383e-01     3.09010e-01
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       4.75860e+03        0.000000         2.37954e+00          1.91054       168.963     125.164     0.87505     8.07338e-01     3.08980e-01
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       4.75205e+03        0.000000         2.37647e+00          1.90801       168.974     125.164     0.87503     8.07299e-01     3.08953e-01
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       4.74875e+03        0.000000         2.37492e+00          1.90673       168.979     125.164     0.87501     8.07279e-01     3.08939e-01
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       4.74641e+03        0.000000         2.37381e+00          1.90582       168.982     125.165     0.87501     8.07265e-01     3.08929e-01
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       4.74429e+03        0.000000         2.37282e+00          1.90500       168.986     125.165     0.87500     8.07252e-01     3.08920e-01
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       4.74318e+03        0.000000         2.37230e+00          1.90457       168.987     125.165     0.87500     8.07245e-01     3.08915e-01
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       4.74233e+03        0.000000         2.37190e+00          1.90424       168.989     125.165     0.87499     8.07240e-01     3.08912e-01
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       4.74118e+03        0.000000         2.37136e+00          1.90380       168.991     125.165     0.87499     8.07233e-01     3.08907e-01
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       4.74070e+03        0.000000         2.37114e+00          1.90362       168.991     125.165     0.87499     8.07230e-01     3.08905e-01
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       4.73956e+03        0.000000         2.37060e+00          1.90317       168.993     125.165     0.87499     8.07223e-01     3.08900e-01
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       4.73871e+03        0.000000         2.37020e+00          1.90284       168.994     125.165     0.87498     8.07218e-01     3.08896e-01
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       4.73760e+03        0.000000         2.36968e+00          1.90241       168.996     125.165     0.87498     8.07211e-01     3.08891e-01
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       4.73550e+03        0.000000         2.36869e+00          1.90160       168.999     125.165     0.87497     8.07198e-01     3.08882e-01
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       4.73317e+03        0.000000         2.36760e+00          1.90070       169.003     125.164     0.87497     8.07184e-01     3.08872e-01
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       4.72991e+03        0.000000         2.36607e+00          1.89943       169.008     125.164     0.87496     8.07164e-01     3.08858e-01
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       4.72349e+03        0.000000         2.36305e+00          1.89694       169.018     125.164     0.87493     8.07124e-01     3.08829e-01
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       4.71629e+03        0.000000         2.35966e+00          1.89415       169.029     125.164     0.87491     8.07080e-01     3.08797e-01
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       4.70618e+03        0.000000         2.35491e+00          1.89022       169.045     125.163     0.87488     8.07017e-01     3.08750e-01
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       4.68633e+03        0.000000         2.34556e+00          1.88250       169.074     125.160     0.87482     8.06892e-01     3.08656e-01
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       4.66429e+03        0.000000         2.33517e+00          1.87391       169.107     125.156     0.87474     8.06751e-01     3.08545e-01
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       4.63371e+03        0.000000         2.32072e+00          1.86195       169.151     125.146     0.87465     8.06552e-01     3.08382e-01
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       4.57507e+03        0.000000         2.29294e+00          1.83889       169.231     125.119     0.87445     8.06156e-01     3.08035e-01
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       4.51220e+03        0.000000         2.26302e+00          1.81397       169.310     125.074     0.87425     8.05708e-01     3.07607e-01
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       4.42909e+03        0.000000         2.22324e+00          1.78068       169.401     124.984     0.87397     8.05072e-01     3.06935e-01
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       4.28422e+03        0.000000         2.15312e+00          1.72140       169.507     124.712     0.87346     8.03807e-01     3.05379e-01
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       4.15273e+03        0.000000         2.08821e+00          1.66547       169.507     124.260     0.87297     8.02379e-01     3.03282e-01
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       4.02437e+03        0.000000         2.02227e+00          1.60626       169.287     123.355     0.87244     8.00368e-01     2.99717e-01
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.97237e+03        0.000000         1.99266e+00          1.57688       168.937     122.450     0.87215     7.98842e-01     2.96522e-01
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.96090e+03        0.000000         1.98231e+00          1.56319       168.518     121.545     0.87201     7.97575e-01     2.93523e-01
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.97637e+03        0.000000         1.98467e+00          1.55974       168.053     120.640     0.87196     7.96480e-01     2.90653e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       4.01199e+03        0.000000         1.99646e+00          1.56381       167.555     119.735     0.87198     7.95513e-01     2.87874e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       4.06392e+03        0.000000         2.01579e+00          1.57379       167.030     118.830     0.87206     7.94648e-01     2.85162e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       4.12981e+03        0.000000         2.04147e+00          1.58869       166.483     117.925     0.87219     7.93868e-01     2.82503e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       4.20820e+03        0.000000         2.07276e+00          1.60785       165.918     117.020     0.87236     7.93163e-01     2.79885e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       4.29818e+03        0.000000         2.10915e+00          1.63084       165.337     116.115     0.87257     7.92525e-01     2.77300e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       4.39923e+03        0.000000         2.15034e+00          1.65737       164.741     115.210     0.87282     7.91950e-01     2.74741e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       4.51116e+03        0.000000         2.19617e+00          1.68729       164.132     114.305     0.87311     7.91436e-01     2.72204e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       4.63401e+03        0.000000         2.24660e+00          1.72050       163.510     113.400     0.87343     7.90980e-01     2.69683e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       4.76805e+03        0.000000         2.30167e+00          1.75702       162.877     112.495     0.87379     7.90583e-01     2.67176e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       4.91380e+03        0.000000         2.36155e+00          1.79693       162.231     111.590     0.87419     7.90246e-01     2.64680e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       5.07202e+03        0.000000         2.42648e+00          1.84038       161.574     110.685     0.87464     7.89972e-01     2.62192e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       5.24376e+03        0.000000         2.49687e+00          1.88764       160.904     109.780     0.87512     7.89766e-01     2.59712e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       5.43047e+03        0.000000         2.57324e+00          1.93906       160.222     108.875     0.87565     7.89632e-01     2.57237e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       5.63406e+03        0.000000         2.65634e+00          1.99517       159.525     107.970     0.87623     7.89579e-01     2.54767e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       5.85715e+03        0.000000         2.74718e+00          2.05668       158.812     107.065     0.87687     7.89619e-01     2.52302e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       6.10337e+03        0.000000         2.84719e+00          2.12462       158.080     106.160     0.87757     7.89768e-01     2.49843e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       6.37796e+03        0.000000         2.95844e+00          2.20050       157.325     105.255     0.87835     7.90048e-01     2.47393e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       6.68895e+03        0.000000         3.08414e+00          2.28666       156.542     104.350     0.87924     7.90498e-01     2.44955e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       7.04978e+03        0.000000         3.22967e+00          2.38706       155.717     103.445     0.88025     7.91176e-01     2.42540e-01
   2.45200e-01        7.54800e-01        8.25451e-02        9.17455e-01       7.26479e+03        0.000000         3.31628e+00          2.44719       155.266     102.974     0.88085     7.91654e-01     2.41299e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       7.48635e+03        0.000000         3.40548e+00          2.50946       154.830     102.540     0.88146     7.92200e-01     2.40168e-01
   2.55355e-01        7.44645e-01        8.67376e-02        9.13262e-01       7.77033e+03        0.000000         3.51977e+00          2.58980       154.313     102.055     0.88223     7.92978e-01     2.38931e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       8.06508e+03        0.000000         3.63843e+00          2.67395       153.824     101.635     0.88302     7.93872e-01     2.37895e-01
   2.65074e-01        7.34926e-01        9.08216e-02        9.09178e-01       8.48677e+03        0.000000         3.80842e+00          2.79601       153.203     101.176     0.88413     7.95302e-01     2.36848e-01
   2.68427e-01        7.31573e-01        9.22472e-02        9.07753e-01       8.93050e+03        0.000000         3.98790e+00          2.92713       152.649     100.872     0.88527     7.96997e-01     2.36309e-01
   2.69671e-01        7.30329e-01        9.27784e-02        9.07222e-01       9.39743e+03        0.000000         4.17788e+00          3.06902       152.176     100.760     0.88644     7.99002e-01     2.36408e-01
   2.69671e-01        7.30329e-01        9.27784e-02        9.07222e-01       9.39887e+03        0.000000         4.17847e+00          3.06946       152.174     100.760     0.88645     7.99009e-01     2.36409e-01
   2.68832e-01        7.31168e-01        9.24199e-02        9.07580e-01       9.76525e+03        0.000000         4.32881e+00          3.18453       151.888     100.836     0.88734     8.00762e-01     2.37031e-01
   2.65942e-01        7.34058e-01        9.11900e-02        9.08810e-01       1.01459e+04        0.000000         4.48686e+00          3.30887       151.681     101.097     0.88824     8.02790e-01     2.38299e-01
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       1.05414e+04        0.000000         4.65430e+00          3.44575       151.595     101.635     0.88916     8.05209e-01     2.40541e-01
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       1.09054e+04        0.000000         4.81406e+00          3.58431       151.705     102.540     0.88998     8.07939e-01     2.44059e-01
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       1.11091e+04        0.000000         4.90934e+00          3.67426       151.947     103.445     0.89043     8.09976e-01     2.47454e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       1.12200e+04        0.000000         4.96726e+00          3.73579       152.263     104.350     0.89068     8.11622e-01     2.50783e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       1.12646e+04        0.000000         4.99851e+00          3.77680       152.631     105.255     0.89078     8.12994e-01     2.54064e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       1.12574e+04        0.000000         5.00874e+00          3.80140       153.040     106.160     0.89078     8.14155e-01     2.57306e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       1.12073e+04        0.000000         5.00142e+00          3.81212       153.484     107.065     0.89068     8.15142e-01     2.60511e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       1.11204e+04        0.000000         4.97893e+00          3.81063       153.957     107.970     0.89051     8.15980e-01     2.63680e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       1.10014e+04        0.000000         4.94300e+00          3.79817       154.458     108.875     0.89027     8.16686e-01     2.66813e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       1.08539e+04        0.000000         4.89493e+00          3.77565       154.984     109.780     0.88997     8.17272e-01     2.69907e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       1.06806e+04        0.000000         4.83580e+00          3.74382       155.534     110.685     0.88962     8.17749e-01     2.72961e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       1.04840e+04        0.000000         4.76644e+00          3.70326       156.107     111.590     0.88921     8.18123e-01     2.75972e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       1.02661e+04        0.000000         4.68755e+00          3.65446       156.702     112.495     0.88876     8.18399e-01     2.78936e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       1.00285e+04        0.000000         4.59971e+00          3.59781       157.320     113.400     0.88826     8.18581e-01     2.81851e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       9.77274e+03        0.000000         4.50339e+00          3.53364       157.960     114.305     0.88772     8.18672e-01     2.84711e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       9.49990e+03        0.000000         4.39895e+00          3.46219       158.623     115.210     0.88713     8.18672e-01     2.87512e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       9.21091e+03        0.000000         4.28663e+00          3.38361       159.309     116.115     0.88650     8.18581e-01     2.90248e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       8.90636e+03        0.000000         4.16656e+00          3.29797       160.019     117.020     0.88582     8.18397e-01     2.92912e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       8.58655e+03        0.000000         4.03873e+00          3.20524       160.756     117.925     0.88510     8.18117e-01     2.95498e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       8.25133e+03        0.000000         3.90291e+00          3.10519       161.520     118.830     0.88433     8.17735e-01     2.97994e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       7.89996e+03        0.000000         3.75863e+00          2.99742       162.316     119.735     0.88350     8.17240e-01     3.00389e-01
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       7.53077e+03        0.000000         3.60495e+00          2.88113       163.147     120.640     0.88262     8.16618e-01     3.02666e-01
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       7.14056e+03        0.000000         3.44022e+00          2.75495       164.021     121.545     0.88165     8.15843e-01     3.04801e-01
   3.48295e-02        9.65171e-01        9.89557e-03        9.90104e-01       6.92873e+03        0.000000         3.34980e+00          2.68507       164.493     122.013     0.88112     8.15369e-01     3.05838e-01
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       6.72318e+03        0.000000         3.26139e+00          2.61634       164.950     122.450     0.88059     8.14871e-01     3.06756e-01
   2.47729e-02        9.75227e-01        6.98625e-03        9.93014e-01       6.49035e+03        0.000000         3.16044e+00          2.53740       165.464     122.923     0.87999     8.14260e-01     3.07685e-01
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       6.26559e+03        0.000000         3.06215e+00          2.46008       165.957     123.355     0.87939     8.13617e-01     3.08460e-01
   1.46292e-02        9.85371e-01        4.09503e-03        9.95905e-01       5.99313e+03        0.000000         2.94187e+00          2.36486       166.547     123.841     0.87866     8.12762e-01     3.09221e-01
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       5.73251e+03        0.000000         2.82563e+00          2.27221       167.101     124.260     0.87793     8.11856e-01     3.09740e-01
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       5.39914e+03        0.000000         2.67513e+00          2.15134       167.787     124.712     0.87698     8.10544e-01     3.10044e-01
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       5.13333e+03        0.000000         2.55357e+00          2.05291       168.306     124.984     0.87620     8.09347e-01     3.09923e-01
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       5.00995e+03        0.000000         2.49664e+00          2.00654       168.534     125.074     0.87583     8.08733e-01     3.09728e-01
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       4.92695e+03        0.000000         2.45814e+00          1.97508       168.682     125.119     0.87557     8.08296e-01     3.09538e-01
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       4.85622e+03        0.000000         2.42521e+00          1.94809       168.804     125.146     0.87535     8.07906e-01     3.09334e-01
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       4.82162e+03        0.000000         2.40905e+00          1.93482       168.861     125.156     0.87524     8.07709e-01     3.09218e-01
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       4.79756e+03        0.000000         2.39780e+00          1.92557       168.901     125.160     0.87517     8.07569e-01     3.09132e-01
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       4.77651e+03        0.000000         2.38793e+00          1.91745       168.935     125.163     0.87510     8.07445e-01     3.09051e-01
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       4.76600e+03        0.000000         2.38301e+00          1.91340       168.951     125.164     0.87507     8.07383e-01     3.09010e-01
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       4.75860e+03        0.000000         2.37954e+00          1.91054       168.963     125.164     0.87505     8.07338e-01     3.08980e-01
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       4.75205e+03        0.000000         2.37647e+00          1.90801       168.974     125.164     0.87503     8.07299e-01     3.08953e-01
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       4.74875e+03        0.000000         2.37492e+00          1.90673       168.979     125.164     0.87501     8.07279e-01     3.08939e-01
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       4.74641e+03        0.000000         2.37381e+00          1.90582       168.982     125.165     0.87501     8.07265e-01     3.08929e-01
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       4.74429e+03        0.000000         2.37282e+00          1.90500       168.986     125.165     0.87500     8.07252e-01     3.08920e-01
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       4.74318e+03        0.000000         2.37230e+00          1.90457       168.987     125.165     0.87500     8.07245e-01     3.08915e-01
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       4.74233e+03        0.000000         2.37190e+00          1.90424       168.989     125.165     0.87499     8.07240e-01     3.08912e-01
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       4.74118e+03        0.000000         2.37136e+00          1.90380       168.991     125.165     0.87499     8.07233e-01     3.08907e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                   Liq Den     Gas Den          
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)      Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)     (g/cm3)     Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ---------------   ---------------   ---------------   ---------   ---------   ---------   ---------   -----------
END

set output "Figures/Env_010_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_010_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_010_P_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_010_LogP_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output "Figures/Env_010_P_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_010_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Reservoir Fluid A Swollen with Solvent\nJust Below the Saturation Temperature Minimum"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       3.10224e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       3.10225e-09        0.000000         4.90258e-12          1.00000       627.998     125.165     1.03000     1.00644e-12     4.92554e-14
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       3.10225e-09        0.000000         4.90258e-12          1.00000       627.998     125.164     1.03000     1.00644e-12     4.92554e-14
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       3.10225e-09        0.000000         4.90259e-12          1.00000       627.998     125.164     1.03000     1.00644e-12     4.92554e-14
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       3.10226e-09        0.000000         4.90260e-12          1.00000       627.998     125.164     1.03000     1.00644e-12     4.92554e-14
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       3.10227e-09        0.000000         4.90263e-12          1.00000       627.998     125.164     1.03000     1.00644e-12     4.92554e-14
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       3.10231e-09        0.000000         4.90268e-12          1.00000       627.998     125.163     1.03000     1.00644e-12     4.92554e-14
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       3.10240e-09        0.000000         4.90282e-12          1.00000       627.998     125.160     1.03000     1.00645e-12     4.92554e-14
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       3.10255e-09        0.000000         4.90307e-12          1.00000       627.998     125.156     1.03000     1.00646e-12     4.92554e-14
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       3.10286e-09        0.000000         4.90356e-12          1.00000       627.998     125.146     1.03000     1.00649e-12     4.92554e-14
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       3.10380e-09        0.000000         4.90503e-12          1.00000       627.998     125.119     1.03000     1.00658e-12     4.92554e-14
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       3.10535e-09        0.000000         4.90749e-12          1.00000       627.998     125.074     1.03000     1.00672e-12     4.92554e-14
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       3.10846e-09        0.000000         4.91240e-12          1.00000       627.998     124.984     1.03000     1.00699e-12     4.92554e-14
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       3.11783e-09        0.000000         4.92722e-12          1.00000       627.998     124.712     1.03000     1.00784e-12     4.92554e-14
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       3.13358e-09        0.000000         4.95210e-12          1.00000       627.998     124.260     1.03000     1.00925e-12     4.92554e-14
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       3.16555e-09        0.000000         5.00263e-12          1.00000       627.998     123.355     1.03000     1.01212e-12     4.92554e-14
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.19819e-09        0.000000         5.05421e-12          1.00000       627.998     122.450     1.03000     1.01506e-12     4.92554e-14
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.23150e-09        0.000000         5.10685e-12          1.00000       627.998     121.545     1.03000     1.01805e-12     4.92554e-14
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.26552e-09        0.000000         5.16061e-12          1.00000       627.998     120.640     1.03000     1.02111e-12     4.92554e-14
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       3.30026e-09        0.000000         5.21551e-12          1.00000       627.998     119.735     1.03000     1.02423e-12     4.92554e-14
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       3.33575e-09        0.000000         5.27159e-12          1.00000       627.998     118.830     1.03000     1.02742e-12     4.92554e-14
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       3.37200e-09        0.000000         5.32889e-12          1.00000       627.998     117.925     1.03000     1.03067e-12     4.92554e-14
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.40906e-09        0.000000         5.38745e-12          1.00000       627.998     117.020     1.03000     1.03400e-12     4.92554e-14
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.44694e-09        0.000000         5.44731e-12          1.00000       627.998     116.115     1.03000     1.03741e-12     4.92554e-14
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.48567e-09        0.000000         5.50852e-12          1.00000       627.998     115.210     1.03000     1.04089e-12     4.92554e-14
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       3.52528e-09        0.000000         5.57111e-12          1.00000       627.998     114.305     1.03000     1.04445e-12     4.92554e-14
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       3.56580e-09        0.000000         5.63515e-12          1.00000       627.998     113.400     1.03000     1.04809e-12     4.92554e-14
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       3.60726e-09        0.000000         5.70067e-12          1.00000       627.998     112.495     1.03000     1.05181e-12     4.92554e-14
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       3.64970e-09        0.000000         5.76774e-12          1.00000       627.998     111.590     1.03000     1.05563e-12     4.92554e-14
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       3.69315e-09        0.000000         5.83640e-12          1.00000       627.998     110.685     1.03000     1.05953e-12     4.92554e-14
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       3.73764e-09        0.000000         5.90672e-12          1.00000       627.998     109.780     1.03000     1.06353e-12     4.92554e-14
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       3.78322e-09        0.000000         5.97876e-12          1.00000       627.998     108.875     1.03000     1.06762e-12     4.92554e-14
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       3.82993e-09        0.000000         6.05257e-12          1.00000       627.998     107.970     1.03000     1.07182e-12     4.92554e-14
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       3.87780e-09        0.000000         6.12822e-12          1.00000       627.998     107.065     1.03000     1.07612e-12     4.92554e-14
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       3.92689e-09        0.000000         6.20580e-12          1.00000       627.998     106.160     1.03000     1.08053e-12     4.92554e-14
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       3.97724e-09        0.000000         6.28536e-12          1.00000       627.998     105.255     1.03000     1.08506e-12     4.92554e-14
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       4.02889e-09        0.000000         6.36699e-12          1.00000       627.998     104.350     1.03000     1.08970e-12     4.92554e-14
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       4.08190e-09        0.000000         6.45076e-12          1.00000       627.998     103.445     1.03000     1.09446e-12     4.92554e-14
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       4.13632e-09        0.000000         6.53677e-12          1.00000       627.998     102.540     1.03000     1.09935e-12     4.92554e-14
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       4.19222e-09        0.000000         6.62511e-12          1.00000       627.998     101.635     1.03000     1.10437e-12     4.92554e-14
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       4.24965e-09        0.000000         6.71586e-12          1.00000       627.998     100.730     1.03000     1.10953e-12     4.92554e-14
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       4.30867e-09        0.000000         6.80914e-12          1.00000       627.998      99.825     1.03000     1.11484e-12     4.92554e-14
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       4.36936e-09        0.000000         6.90504e-12          1.00000       627.998      98.920     1.03000     1.12029e-12     4.92554e-14
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       4.43178e-09        0.000000         7.00368e-12          1.00000       627.998      98.015     1.03000     1.12590e-12     4.92554e-14
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       4.49601e-09        0.000000         7.10519e-12          1.00000       627.998      97.110     1.03000     1.13167e-12     4.92554e-14
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       4.56212e-09        0.000000         7.20968e-12          1.00000       627.998      96.205     1.03000     1.13761e-12     4.92554e-14
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       4.63021e-09        0.000000         7.31728e-12          1.00000       627.998      95.300     1.03000     1.14373e-12     4.92554e-14
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       4.70037e-09        0.000000         7.42815e-12          1.00000       627.998      94.395     1.03000     1.15003e-12     4.92554e-14
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       4.77268e-09        0.000000         7.54243e-12          1.00000       627.998      93.490     1.03000     1.15653e-12     4.92554e-14
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       4.84726e-09        0.000000         7.66028e-12          1.00000       627.998      92.585     1.03000     1.16323e-12     4.92554e-14
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       4.92420e-09        0.000000         7.78187e-12          1.00000       627.998      91.680     1.03000     1.17014e-12     4.92554e-14
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       5.00362e-09        0.000000         7.90739e-12          1.00000       627.998      90.775     1.03000     1.17728e-12     4.92554e-14
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       5.08565e-09        0.000000         8.03702e-12          1.00000       627.998      89.870     1.03000     1.18465e-12     4.92554e-14
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       5.17041e-09        0.000000         8.17097e-12          1.00000       627.998      88.965     1.03000     1.19226e-12     4.92554e-14
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       5.25804e-09        0.000000         8.30946e-12          1.00000       627.998      88.060     1.03000     1.20014e-12     4.92554e-14
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       5.34870e-09        0.000000         8.45272e-12          1.00000       627.998      87.155     1.03000     1.20828e-12     4.92554e-14
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       5.44253e-09        0.000000         8.60102e-12          1.00000       627.998      86.250     1.03000     1.21672e-12     4.92554e-14
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       5.53972e-09        0.000000         8.75461e-12          1.00000       627.998      85.345     1.03000     1.22545e-12     4.92554e-14
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       5.64044e-09        0.000000         8.91378e-12          1.00000       627.998      84.440     1.03000     1.23450e-12     4.92554e-14
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       5.74490e-09        0.000000         9.07885e-12          1.00000       627.998      83.535     1.03000     1.24388e-12     4.92554e-14
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       5.85329e-09        0.000000         9.25015e-12          1.00000       627.998      82.630     1.03000     1.25362e-12     4.92554e-14
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       5.96585e-09        0.000000         9.42804e-12          1.00000       627.998      81.725     1.03000     1.26374e-12     4.92554e-14
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       6.08283e-09        0.000000         9.61290e-12          1.00000       627.998      80.820     1.03000     1.27425e-12     4.92554e-14
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       6.20449e-09        0.000000         9.80516e-12          1.00000       627.998      79.915     1.03000     1.28518e-12     4.92554e-14
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       6.33111e-09        0.000000         1.00053e-11          1.00000       627.998      79.010     1.03000     1.29656e-12     4.92554e-14
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       6.46301e-09        0.000000         1.02137e-11          1.00000       627.998      78.105     1.03000     1.30841e-12     4.92554e-14
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       6.60052e-09        0.000000         1.04310e-11          1.00000       627.998      77.200     1.03000     1.32076e-12     4.92554e-14
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       6.74401e-09        0.000000         1.06578e-11          1.00000       627.998      76.295     1.03000     1.33366e-12     4.92554e-14
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       6.89387e-09        0.000000         1.08946e-11          1.00000       627.998      75.390     1.03000     1.34712e-12     4.92554e-14
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       7.05055e-09        0.000000         1.11422e-11          1.00000       627.998      74.485     1.03000     1.36120e-12     4.92554e-14
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       7.21452e-09        0.000000         1.14013e-11          1.00000       627.998      73.580     1.03000     1.37593e-12     4.92554e-14
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       7.38629e-09        0.000000         1.16728e-11          1.00000       627.998      72.675     1.03000     1.39137e-12     4.92554e-14
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       7.56645e-09        0.000000         1.19575e-11          1.00000       627.998      71.770     1.03000     1.40755e-12     4.92554e-14
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       7.75561e-09        0.000000         1.22564e-11          1.00000       627.998      70.865     1.03000     1.42455e-12     4.92554e-14
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       7.95447e-09        0.000000         1.25707e-11          1.00000       627.998      69.960     1.03000     1.44242e-12     4.92554e-14
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       8.16380e-09        0.000000         1.29015e-11          1.00000       627.998      69.055     1.03000     1.46123e-12     4.92554e-14
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       8.38444e-09        0.000000         1.32502e-11          1.00000       627.998      68.150     1.03000     1.48105e-12     4.92554e-14
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       8.61734e-09        0.000000         1.36183e-11          1.00000       627.998      67.245     1.03000     1.50198e-12     4.92554e-14
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       8.86355e-09        0.000000         1.40074e-11          1.00000       627.998      66.340     1.03000     1.52410e-12     4.92554e-14
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       9.12425e-09        0.000000         1.44194e-11          1.00000       627.998      65.435     1.03000     1.54752e-12     4.92554e-14
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       9.40074e-09        0.000000         1.48563e-11          1.00000       627.998      64.530     1.03000     1.57237e-12     4.92554e-14
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       9.69451e-09        0.000000         1.53206e-11          1.00000       627.998      63.625     1.03000     1.59876e-12     4.92554e-14
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       1.00072e-08        0.000000         1.58148e-11          1.00000       627.998      62.720     1.03000     1.62686e-12     4.92554e-14
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       1.03408e-08        0.000000         1.63419e-11          1.00000       627.998      61.815     1.03000     1.65684e-12     4.92554e-14
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       1.06974e-08        0.000000         1.69054e-11          1.00000       627.998      60.910     1.03000     1.68887e-12     4.92554e-14
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       1.10794e-08        0.000000         1.75092e-11          1.00000       627.998      60.005     1.03000     1.72320e-12     4.92554e-14
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       1.14898e-08        0.000000         1.81577e-11          1.00000       627.998      59.100     1.03000     1.76007e-12     4.92554e-14
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       1.19317e-08        0.000000         1.88561e-11          1.00000       627.998      58.195     1.03000     1.79978e-12     4.92554e-14
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       1.24090e-08        0.000000         1.96103e-11          1.00000       627.998      57.290     1.03000     1.84266e-12     4.92554e-14
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       1.29260e-08        0.000000         2.04274e-11          1.00000       627.998      56.385     1.03000     1.88912e-12     4.92554e-14
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       1.34880e-08        0.000000         2.13156e-11          1.00000       627.998      55.480     1.03000     1.93962e-12     4.92554e-14
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       1.41011e-08        0.000000         2.22845e-11          1.00000       627.998      54.575     1.03000     1.99471e-12     4.92554e-14
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       1.47726e-08        0.000000         2.33456e-11          1.00000       627.998      53.670     1.03000     2.05504e-12     4.92554e-14
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       1.55112e-08        0.000000         2.45129e-11          1.00000       627.998      52.765     1.03000     2.12141e-12     4.92554e-14
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       1.63276e-08        0.000000         2.58030e-11          1.00000       627.998      51.860     1.03000     2.19476e-12     4.92554e-14
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       1.72347e-08        0.000000         2.72366e-11          1.00000       627.998      50.955     1.03000     2.27626e-12     4.92554e-14
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       1.82485e-08        0.000000         2.88387e-11          1.00000       627.998      50.050     1.03000     2.36736e-12     4.92554e-14
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       1.93890e-08        0.000000         3.06411e-11          1.00000       627.998      49.145     1.03000     2.46983e-12     4.92554e-14
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       2.06816e-08        0.000000         3.26839e-11          1.00000       627.998      48.240     1.03000     2.58598e-12     4.92554e-14
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       2.21589e-08        0.000000         3.50184e-11          1.00000       627.998      47.335     1.03000     2.71871e-12     4.92554e-14
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       2.38634e-08        0.000000         3.77121e-11          1.00000       627.998      46.430     1.03000     2.87187e-12     4.92554e-14
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       2.58520e-08        0.000000         4.08548e-11          1.00000       627.998      45.525     1.03000     3.05055e-12     4.92554e-14
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       2.82022e-08        0.000000         4.45689e-11          1.00000       627.998      44.620     1.03000     3.26172e-12     4.92554e-14
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       3.10224e-08        0.000000         4.90258e-11          1.00000       627.998      43.715     1.03000     3.51512e-12     4.92554e-14
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       3.44694e-08        0.000000         5.44731e-11          1.00000       627.998      42.810     1.03000     3.82483e-12     4.92554e-14
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       3.87780e-08        0.000000         6.12822e-11          1.00000       627.998      41.905     1.03000     4.21198e-12     4.92554e-14
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       4.43178e-08        0.000000         7.00368e-11          1.00000       627.998      41.001     1.03000     4.70973e-12     4.92554e-14
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.17041e-08        0.000000         8.17097e-11          1.00000       627.998      40.096     1.03000     5.37340e-12     4.92554e-14
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       6.20449e-08        0.000000         9.80516e-11          1.00000       627.998      39.191     1.03000     6.30254e-12     4.92554e-14
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       7.75561e-08        0.000000         1.22564e-10          1.00000       627.998      38.286     1.03000     7.69626e-12     4.92554e-14
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       1.03408e-07        0.000000         1.63419e-10          1.00000       627.998      37.381     1.03000     1.00191e-11     4.92554e-14
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       1.55112e-07        0.000000         2.45129e-10          1.00000       627.998      36.476     1.03000     1.46648e-11     4.92554e-14
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.10224e-07        0.000000         4.90258e-10          1.00000       627.998      35.571     1.03000     2.86019e-11     4.92554e-14
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       6.20449e-07        0.000000         9.80516e-10          1.00000       627.998      35.118     1.03000     5.64762e-11     4.92554e-14
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.55112e-06        0.000000         2.45129e-09          1.00000       627.998      34.847     1.03000     1.40099e-10     4.92554e-14
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       3.10224e-06        0.000000         4.90258e-09          1.00000       627.998      34.756     1.03000     2.79470e-10     4.92554e-14
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       6.20449e-06        0.000000         9.80516e-09          1.00000       627.998      34.711     1.03000     5.58213e-10     4.92554e-14
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.55112e-05        0.000000         2.45129e-08          1.00000       627.998      34.684     1.03000     1.39444e-09     4.92554e-14
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       3.10224e-05        0.000000         4.90258e-08          1.00000       627.998      34.675     1.03000     2.78815e-09     4.92554e-14
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       6.20449e-05        0.000000         9.80516e-08          1.00000       627.998      34.670     1.03000     5.57558e-09     4.92554e-14
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.55112e-04        0.000000         2.45129e-07          1.00000       627.998      34.667     1.03000     1.39379e-08     4.92555e-14
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       3.10225e-04        0.000000         4.90259e-07          1.00000       627.998      34.666     1.03000     2.78751e-08     4.92556e-14
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       6.20452e-04        0.000000         9.80521e-07          1.00000       627.997      34.666     1.03000     5.57496e-08     4.92557e-14
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.55114e-03        0.000000         2.45132e-06          1.00000       627.997      34.666     1.03000     1.39374e-07     4.92562e-14
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       3.10233e-03        0.000000         4.90270e-06          1.00000       627.995      34.666     1.03000     2.78751e-07     4.92570e-14
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       6.20484e-03        0.000000         9.80562e-06          1.00000       627.992      34.666     1.03000     5.57518e-07     4.92587e-14
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.55134e-02        0.000000         2.45158e-05          0.99999       627.983      34.666     1.03000     1.39392e-06     4.92636e-14
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       3.10311e-02        0.000000         4.90374e-05          0.99999       627.969      34.666     1.03000     2.78824e-06     4.92718e-14
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       6.20797e-02        0.000000         9.80981e-05          0.99997       627.940      34.666     1.03000     5.57813e-06     4.92881e-14
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.55330e-01        0.000000         2.45420e-04          0.99993       627.852      34.666     1.02999     1.39576e-05     4.93373e-14
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       3.11098e-01        0.000000         4.91425e-04          0.99987       627.705      34.666     1.02997     2.79564e-05     4.94196e-14
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.23958e-01        0.000000         9.85203e-04          0.99974       627.411      34.666     1.02994     5.60786e-05     4.95853e-14
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.57334e+00        0.000000         2.48095e-03          0.99933       626.520      34.666     1.02984     1.41462e-04     5.00915e-14
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       3.19314e+00        0.000000         5.02378e-03          0.99865       625.001      34.666     1.02967     2.87299e-04     5.09678e-14
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       6.58557e+00        0.000000         1.03122e-02          0.99721       621.833      34.666     1.02931     5.93384e-04     5.28553e-14
   1.00000e+00        3.12013e-10        1.00000e+00        1.12656e-09       1.09830e+01        0.000000         1.70929e-02          0.99534       617.751      34.666     1.02884     9.91470e-04     5.54109e-14
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.83169e+01        0.000000         2.82166e-02          0.99222       611.004      34.666     1.02806     1.65872e-03     5.99634e-14
   1.00000e+00        1.36823e-10        1.00000e+00        4.94019e-10       2.97153e+01        0.000000         4.50549e-02          0.98735       600.666      34.666     1.02683     2.70419e-03     6.78286e-14
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       4.82067e+01        0.000000         7.12383e-02          0.97941       584.275      34.666     1.02480     4.42251e-03     8.29577e-14
   1.00000e+00        8.39048e-11        1.00000e+00        3.02949e-10       7.10985e+01        0.000000         1.01788e-01          0.96952       564.619      34.666     1.02223     6.58915e-03     1.06705e-13
   1.00000e+00        7.82661e-11        1.00000e+00        2.82590e-10       1.04861e+02        0.000000         1.43297e-01          0.95480       536.871      34.666     1.01830     9.86801e-03     1.55487e-13
   1.00000e+00        7.82661e-11        1.00000e+00        2.82590e-10       1.04887e+02        0.000000         1.43328e-01          0.95478       536.850      34.666     1.01829     9.87063e-03     1.55534e-13
   1.00000e+00        8.26056e-11        1.00000e+00        2.98258e-10       1.41741e+02        0.000000         1.84156e-01          0.93850       508.188      34.666     1.01383     1.35703e-02     2.36363e-13
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.91545e+02        0.000000         2.32604e-01          0.91615       472.020      34.666     1.00749     1.87860e-02     4.21723e-13
   1.00000e+00        1.31125e-10        1.00000e+00        4.73444e-10       2.40417e+02        0.000000         2.73458e-01          0.89377       439.248      34.666     1.00095     2.41694e-02     7.56584e-13
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       3.01758e+02        0.000000         3.16641e-01          0.86503       401.720      34.666     0.99230     3.13441e-02     1.61606e-12
   1.00000e+00        2.97756e-10        1.00000e+00        1.07509e-09       3.51694e+02        0.000000         3.46142e-01          0.84102       373.995      34.666     0.98493     3.75738e-02     3.06772e-12
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       4.09894e+02        0.000000         3.75282e-01          0.81228       344.772      34.666     0.97605     4.53411e-02     6.66716e-12
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       4.79384e+02        0.000000         4.04432e-01          0.77675       314.180      34.666     0.96526     5.54535e-02     1.76439e-11
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       5.41743e+02        0.000000         4.27233e-01          0.74358       290.799      34.666     0.95576     6.54624e-02     4.43534e-11
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.15566e+02        0.000000         4.53035e-01          0.70249       268.476      34.666     0.94553     7.87345e-02     1.41269e-10
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       6.65986e+02        0.000000         4.71921e-01          0.67311       256.934      34.666     0.93982     8.89006e-02     3.26577e-10
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.12415e+02        0.000000         4.91756e-01          0.64502       249.264      34.666     0.93599     9.92401e-02     7.33408e-10
   1.00000e+00        4.73908e-08        1.00000e+00        1.71111e-07       7.65380e+02        0.000000         5.18883e-01          0.61166       244.228      34.666     0.93375     1.12433e-01     1.93846e-09
   1.00000e+00        4.73908e-08        1.00000e+00        1.71111e-07       7.65380e+02        0.000000         2.02151e-01          0.61166        39.985      34.666     0.39240     1.12433e-01     2.14000e-06
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.67996e+02        0.000000         2.03761e-01          0.60997        39.646      34.666     0.38731     1.13129e-01     2.55492e-06
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       7.68840e+02        0.000000         2.04285e-01          0.60943        39.544      34.666     0.38576     1.13355e-01     2.70109e-06
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       7.69244e+02        0.000000         2.04537e-01          0.60917        39.497      34.666     0.38502     1.13463e-01     2.77334e-06
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       7.69481e+02        0.000000         2.04685e-01          0.60902        39.470      34.666     0.38460     1.13526e-01     2.81646e-06
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       7.69559e+02        0.000000         2.04733e-01          0.60897        39.461      34.666     0.38446     1.13547e-01     2.83079e-06
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       7.69598e+02        0.000000         2.04758e-01          0.60894        39.457      34.666     0.38439     1.13558e-01     2.83795e-06
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       7.69621e+02        0.000000         2.04772e-01          0.60893        39.454      34.666     0.38435     1.13564e-01     2.84224e-06
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       7.69629e+02        0.000000         2.04777e-01          0.60892        39.453      34.666     0.38433     1.13566e-01     2.84367e-06
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       7.69633e+02        0.000000         2.04780e-01          0.60892        39.453      34.666     0.38433     1.13567e-01     2.84439e-06
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       7.69635e+02        0.000000         2.04781e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84482e-06
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       7.69636e+02        0.000000         2.04782e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84496e-06
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       7.69636e+02        0.000000         2.04782e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84503e-06
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       7.69637e+02        0.000000         2.04782e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84507e-06
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       7.69637e+02        0.000000         2.04782e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84509e-06
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       7.69637e+02        0.000000         2.04782e-01          0.60892        39.452      34.666     0.38432     1.13568e-01     2.84510e-06
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65993e-02
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65994e-02
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65994e-02
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65994e-02
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65996e-02
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21462e-01     9.65999e-02
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.05859e+03        0.000000         3.57493e-01          0.42949        35.556      34.666     0.27290     2.21463e-01     9.66005e-02
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       1.05859e+03        0.000000         3.57492e-01          0.42949        35.556      34.666     0.27290     2.21464e-01     9.66022e-02
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       1.05860e+03        0.000000         3.57492e-01          0.42949        35.557      34.666     0.27291     2.21467e-01     9.66051e-02
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.05861e+03        0.000000         3.57490e-01          0.42948        35.557      34.666     0.27291     2.21471e-01     9.66108e-02
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.05864e+03        0.000000         3.57486e-01          0.42947        35.557      34.666     0.27292     2.21485e-01     9.66279e-02
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       1.05869e+03        0.000000         3.57478e-01          0.42945        35.557      34.666     0.27294     2.21507e-01     9.66563e-02
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.05879e+03        0.000000         3.57463e-01          0.42940        35.557      34.666     0.27298     2.21552e-01     9.67127e-02
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.05910e+03        0.000000         3.57418e-01          0.42927        35.558      34.666     0.27311     2.21687e-01     9.68783e-02
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.05961e+03        0.000000         3.57341e-01          0.42905        35.560      34.666     0.27331     2.21910e-01     9.71426e-02
   9.99982e-01        1.78520e-05        9.99936e-01        6.44540e-05       1.06039e+03        0.000000         3.57215e-01          0.42871        35.564      34.667     0.27364     2.22254e-01     9.75284e-02
   9.99982e-01        1.78520e-05        9.99936e-01        6.44540e-05       1.06039e+03        0.000000         7.71397e-01          0.42871       267.165      34.667     0.95191     2.22254e-01     9.81854e-07
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.06674e+03        0.000000         7.77318e-01          0.42626       267.721      34.667     0.95229     2.24870e-01     1.10536e-06
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.12433e+03        0.000000         8.28786e-01          0.40898       271.605      34.670     0.95503     2.47046e-01     2.88786e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.17915e+03        0.000000         8.74220e-01          0.39948       273.645      34.675     0.95667     2.65287e-01     6.01442e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.24968e+03        0.000000         9.28812e-01          0.39411       274.671      34.684     0.95788     2.85059e-01     1.26272e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.38233e+03        0.000000         1.02408e+00          0.39590       274.016      34.711     0.95870     3.14137e-01     3.42045e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       1.53199e+03        0.000000         1.12483e+00          0.40711       271.549      34.756     0.95862     3.39005e-01     7.38529e-05
   9.98551e-01        1.44897e-03        9.94788e-01        5.21198e-03       1.63926e+03        0.000000         1.19427e+00          0.41811       269.351      34.797     0.95828     3.53610e-01     1.12288e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.75404e+03        0.000000         1.26668e+00          0.43145       266.852      34.847     0.95780     3.67197e-01     1.62403e-04
   9.97172e-01        2.82845e-03        9.89862e-01        1.01376e-02       1.90695e+03        0.000000         1.36068e+00          0.45079       263.464      34.922     0.95705     3.82901e-01     2.42935e-04
   9.96173e-01        3.82685e-03        9.86319e-01        1.36807e-02       2.07319e+03        0.000000         1.46021e+00          0.47308       259.831      35.012     0.95619     3.97690e-01     3.47178e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.25392e+03        0.000000         1.56575e+00          0.49824       256.018      35.118     0.95525     4.11772e-01     4.78590e-04
   9.93537e-01        6.46275e-03        9.77053e-01        2.29474e-02       2.46638e+03        0.000000         1.68674e+00          0.52858       251.761      35.250     0.95418     4.26327e-01     6.54710e-04
   9.91869e-01        8.13084e-03        9.71253e-01        2.87473e-02       2.69887e+03        0.000000         1.81583e+00          0.56236       247.393      35.401     0.95307     4.40366e-01     8.70964e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       2.95328e+03        0.000000         1.95363e+00          0.59977       242.951      35.571     0.95194     4.53984e-01     1.13169e-03
   9.88545e-01        1.14551e-02        9.59841e-01        4.01593e-02       3.14975e+03        0.000000         2.05786e+00          0.62886       239.747      35.702     0.95113     4.63501e-01     1.34763e-03
   9.86996e-01        1.30042e-02        9.54588e-01        4.54116e-02       3.35930e+03        0.000000         2.16715e+00          0.66001       236.532      35.842     0.95034     4.72854e-01     1.58969e-03
   9.85359e-01        1.46412e-02        9.49082e-01        5.09178e-02       3.58279e+03        0.000000         2.28179e+00          0.69333       233.317      35.991     0.94956     4.82057e-01     1.85897e-03
   9.83641e-01        1.63590e-02        9.43353e-01        5.66469e-02       3.82114e+03        0.000000         2.40208e+00          0.72895       230.112      36.146     0.94880     4.91120e-01     2.15633e-03
   9.81851e-01        1.81486e-02        9.37436e-01        6.25638e-02       4.07536e+03        0.000000         2.52836e+00          0.76698       226.927      36.308     0.94807     5.00049e-01     2.48227e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.34648e+03        0.000000         2.66102e+00          0.80757       223.773      36.476     0.94738     5.08847e-01     2.83688e-03
   9.78371e-01        2.16289e-02        9.26080e-01        7.39201e-02       4.59348e+03        0.000000         2.78025e+00          0.84455       221.098      36.623     0.94683     5.16294e-01     3.16375e-03
   9.76714e-01        2.32862e-02        9.20741e-01        7.92594e-02       4.85451e+03        0.000000         2.90476e+00          0.88362       218.459      36.773     0.94631     5.23647e-01     3.51086e-03
   9.75038e-01        2.49624e-02        9.15384e-01        8.46159e-02       5.13037e+03        0.000000         3.03487e+00          0.92487       215.864      36.925     0.94584     5.30902e-01     3.87724e-03
   9.73352e-01        2.66476e-02        9.10043e-01        8.99566e-02       5.42191e+03        0.000000         3.17091e+00          0.96841       213.318      37.077     0.94542     5.38060e-01     4.26155e-03
   9.71669e-01        2.83307e-02        9.04753e-01        9.52470e-02       5.73002e+03        0.000000         3.31326e+00          1.01434       210.827      37.229     0.94505     5.45116e-01     4.66200e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       6.05564e+03        0.000000         3.46234e+00          1.06278       208.399      37.381     0.94475     5.52068e-01     5.06716e-03
   9.68597e-01        3.14028e-02        8.95207e-01        1.04793e-01       6.34776e+03        0.000000         3.59505e+00          1.10613       206.384      37.507     0.94454     5.57908e-01     5.40148e-03
   9.67221e-01        3.27785e-02        8.90978e-01        1.09022e-01       6.65397e+03        0.000000         3.73327e+00          1.15145       204.421      37.632     0.94438     5.63668e-01     5.73915e-03
   9.65881e-01        3.41191e-02        8.86884e-01        1.13116e-01       6.97496e+03        0.000000         3.87732e+00          1.19881       202.517      37.753     0.94428     5.69344e-01     6.07805e-03
   9.64584e-01        3.54160e-02        8.82948e-01        1.17052e-01       7.31143e+03        0.000000         4.02755e+00          1.24829       200.673      37.871     0.94423     5.74934e-01     6.41584e-03
   9.63339e-01        3.66608e-02        8.79193e-01        1.20807e-01       7.66413e+03        0.000000         4.18434e+00          1.29997       198.893      37.983     0.94425     5.80434e-01     6.75002e-03
   9.62155e-01        3.78452e-02        8.75641e-01        1.24359e-01       8.03385e+03        0.000000         4.34807e+00          1.35390       197.181      38.091     0.94433     5.85844e-01     7.07794e-03
   9.61039e-01        3.89609e-02        8.72314e-01        1.27686e-01       8.42140e+03        0.000000         4.51919e+00          1.41018       195.540      38.191     0.94447     5.91159e-01     7.39684e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.82764e+03        0.000000         4.69816e+00          1.46888       193.972      38.286     0.94468     5.96379e-01     7.70390e-03
   9.59091e-01        4.09088e-02        8.66546e-01        1.33454e-01       9.23146e+03        0.000000         4.87578e+00          1.52692       192.554      38.368     0.94495     6.01244e-01     7.98190e-03
   9.58264e-01        4.17359e-02        8.64113e-01        1.35887e-01       9.65376e+03        0.000000         5.06135e+00          1.58727       191.206      38.443     0.94528     6.06019e-01     8.24428e-03
   9.57524e-01        4.24760e-02        8.61944e-01        1.38056e-01       1.00954e+04        0.000000         5.25536e+00          1.65002       189.930      38.510     0.94567     6.10703e-01     8.48875e-03
   9.56876e-01        4.31244e-02        8.60050e-01        1.39950e-01       1.05572e+04        0.000000         5.45830e+00          1.71523       188.727      38.568     0.94614     6.15296e-01     8.71314e-03
   9.56323e-01        4.36772e-02        8.58439e-01        1.41561e-01       1.10401e+04        0.000000         5.67071e+00          1.78298       187.599      38.618     0.94667     6.19797e-01     8.91546e-03
   9.55868e-01        4.41316e-02        8.57119e-01        1.42881e-01       1.15452e+04        0.000000         5.89314e+00          1.85335       186.547      38.659     0.94726     6.24205e-01     9.09395e-03
   9.55515e-01        4.44854e-02        8.56092e-01        1.43908e-01       1.20733e+04        0.000000         6.12619e+00          1.92641       185.570      38.691     0.94792     6.28522e-01     9.24713e-03
   9.55262e-01        4.47376e-02        8.55362e-01        1.44638e-01       1.26256e+04        0.000000         6.37047e+00          2.00226       184.670      38.714     0.94865     6.32749e-01     9.37382e-03
   9.55112e-01        4.48882e-02        8.54926e-01        1.45074e-01       1.32032e+04        0.000000         6.62663e+00          2.08099       183.845      38.728     0.94944     6.36885e-01     9.47316e-03
   9.55062e-01        4.49382e-02        8.54781e-01        1.45219e-01       1.38071e+04        0.000000         6.89537e+00          2.16269       183.097      38.732     0.95029     6.40933e-01     9.54467e-03
   9.57474e-01        4.25263e-02        8.61797e-01        1.38203e-01       1.91943e+04        0.000000         9.33615e+00          2.86734       179.824      38.514     0.95826     6.68255e-01     9.25177e-03
   9.63177e-01        3.68235e-02        8.78705e-01        1.21295e-01       2.66834e+04        0.000000         1.28557e+01          3.79787       179.974      37.998     0.96825     6.91977e-01     7.91960e-03
   9.69780e-01        3.02195e-02        8.98867e-01        1.01133e-01       3.70946e+04        0.000000         1.79356e+01          5.04330       182.592      37.400     0.97882     7.13018e-01     6.26955e-03
   9.75765e-01        2.42348e-02        9.17704e-01        8.22962e-02       5.15679e+04        0.000000         2.52362e+01          6.73241       186.699      36.859     0.98884     7.31777e-01     4.78621e-03
   9.80577e-01        1.94229e-02        9.33255e-01        6.67447e-02       7.16883e+04        0.000000         3.56617e+01          9.04478       191.466      36.423     0.99762     7.48271e-01     3.63570e-03
   9.84209e-01        1.57912e-02        9.45241e-01        5.47587e-02       9.96592e+04        0.000000         5.04509e+01         12.22909       196.268      36.095     1.00491     7.62421e-01     2.80669e-03
   9.86859e-01        1.31412e-02        9.54126e-01        4.58742e-02       1.38544e+05        0.000000         7.13055e+01         16.63015       200.696      35.855     1.01072     7.74224e-01     2.22987e-03
   9.88759e-01        1.12408e-02        9.60571e-01        3.94292e-02       1.92600e+05        0.000000         1.00573e+02         22.72677       204.531      35.683     1.01522     7.83801e-01     1.83388e-03
   9.90111e-01        9.88853e-03        9.65195e-01        3.48053e-02       2.67747e+05        0.000000         1.41504e+02         31.18419       207.700      35.560     1.01864     7.91382e-01     1.56249e-03
   9.91071e-01        8.92872e-03        9.68496e-01        3.15040e-02       3.72214e+05        0.000000         1.98612e+02         42.92694       210.228      35.474     1.02119     7.97255e-01     1.37568e-03
   9.91753e-01        8.24720e-03        9.70850e-01        2.91500e-02       5.17442e+05        0.000000         2.78169e+02         59.23987       212.192      35.412     1.02308     8.01727e-01     1.24621e-03
   9.92237e-01        7.76250e-03        9.72529e-01        2.74708e-02       7.19335e+05        0.000000         3.88900e+02         81.90868       213.686      35.368     1.02447     8.05084e-01     1.15585e-03
   9.92583e-01        7.41707e-03        9.73728e-01        2.62716e-02       1.00000e+06        0.000000         5.42937e+02        113.41542       214.806      35.337     1.02548     8.07577e-01     1.09235e-03
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       5.08052e+03        0.000000         2.49327e+00          1.96430       165.795     119.735     0.87566     8.02692e-01     2.90931e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       4.95938e+03        0.000000         2.43149e+00          1.90754       165.548     118.830     0.87520     8.00767e-01     2.87470e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       4.93172e+03        0.000000         2.41276e+00          1.88568       165.161     117.925     0.87502     7.99397e-01     2.84367e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       4.95077e+03        0.000000         2.41545e+00          1.88101       164.704     117.020     0.87500     7.98306e-01     2.81438e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       5.00115e+03        0.000000         2.43236e+00          1.88760       164.201     116.115     0.87508     7.97400e-01     2.78621e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       5.07586e+03        0.000000         2.46017e+00          1.90269       163.663     115.210     0.87524     7.96635e-01     2.75881e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       5.17136e+03        0.000000         2.49715e+00          1.92482       163.098     114.305     0.87546     7.95989e-01     2.73200e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       5.28592e+03        0.000000         2.54241e+00          1.95321       162.508     113.400     0.87575     7.95448e-01     2.70565e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       5.41895e+03        0.000000         2.59556e+00          1.98749       161.897     112.495     0.87609     7.95008e-01     2.67966e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       5.57077e+03        0.000000         2.65663e+00          2.02761       161.264     111.590     0.87650     7.94666e-01     2.65399e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       5.74256e+03        0.000000         2.72601e+00          2.07381       160.610     110.685     0.87696     7.94427e-01     2.62858e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       5.93644e+03        0.000000         2.80449e+00          2.12664       159.935     109.780     0.87749     7.94299e-01     2.60342e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       6.15592e+03        0.000000         2.89345e+00          2.18709       159.234     108.875     0.87810     7.94297e-01     2.57851e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       6.40658e+03        0.000000         2.99511e+00          2.25680       158.505     107.970     0.87879     7.94447e-01     2.55387e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       6.69785e+03        0.000000         3.11330e+00          2.33861       157.739     107.065     0.87959     7.94790e-01     2.52958e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       7.04754e+03        0.000000         3.25527e+00          2.43801       156.919     106.160     0.88055     7.95411e-01     2.50581e-01
   2.15312e-01        7.84688e-01        7.06283e-02        9.29372e-01       7.26941e+03        0.000000         3.34544e+00          2.50180       156.451     105.679     0.88116     7.95910e-01     2.49353e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       7.49825e+03        0.000000         3.43856e+00          2.56828       156.008     105.255     0.88178     7.96506e-01     2.48304e-01
   2.25998e-01        7.74002e-01        7.48179e-02        9.25182e-01       7.87385e+03        0.000000         3.59179e+00          2.67915       155.363     104.712     0.88278     7.97657e-01     2.47055e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       8.26826e+03        0.000000         3.75355e+00          2.79855       154.796     104.350     0.88382     7.99102e-01     2.46397e-01
   2.31424e-01        7.68576e-01        7.69755e-02        9.23025e-01       8.65881e+03        0.000000         3.91515e+00          2.92091       154.354     104.221     0.88482     8.00798e-01     2.46492e-01
   2.31424e-01        7.68576e-01        7.69755e-02        9.23025e-01       8.65959e+03        0.000000         3.91548e+00          2.92116       154.353     104.221     0.88482     8.00802e-01     2.46493e-01
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       9.01368e+03        0.000000         4.06409e+00          3.03743       154.073     104.350     0.88572     8.02632e-01     2.47401e-01
   2.26781e-01        7.73219e-01        7.51283e-02        9.24872e-01       9.26287e+03        0.000000         4.17078e+00          3.12414       153.972     104.641     0.88634     8.04167e-01     2.48729e-01
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       9.51896e+03        0.000000         4.28418e+00          3.22142       154.013     105.255     0.88697     8.06144e-01     2.51191e-01
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       9.69002e+03        0.000000         4.36618e+00          3.29945       154.264     106.160     0.88739     8.08113e-01     2.54583e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       9.74604e+03        0.000000         4.40076e+00          3.34081       154.618     107.065     0.88755     8.09565e-01     2.57847e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       9.73053e+03        0.000000         4.40574e+00          3.35899       155.037     107.970     0.88753     8.10699e-01     2.61028e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       9.66225e+03        0.000000         4.38867e+00          3.35963       155.504     108.875     0.88740     8.11600e-01     2.64144e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       9.55154e+03        0.000000         4.35367e+00          3.34581       156.012     109.780     0.88716     8.12312e-01     2.67198e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       9.40493e+03        0.000000         4.30328e+00          3.31937       156.554     110.685     0.88685     8.12861e-01     2.70193e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       9.22683e+03        0.000000         4.23917e+00          3.28152       157.129     111.590     0.88646     8.13263e-01     2.73126e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       9.02030e+03        0.000000         4.16244e+00          3.23303       157.736     112.495     0.88600     8.13527e-01     2.75995e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       8.78741e+03        0.000000         4.07380e+00          3.17438       158.374     113.400     0.88547     8.13659e-01     2.78793e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       8.52934e+03        0.000000         3.97356e+00          3.10575       159.045     114.305     0.88488     8.13658e-01     2.81513e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       8.24637e+03        0.000000         3.86163e+00          3.02700       159.750     115.210     0.88422     8.13520e-01     2.84146e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       7.93760e+03        0.000000         3.73743e+00          2.93759       160.493     116.115     0.88349     8.13232e-01     2.86675e-01
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       7.60028e+03        0.000000         3.59949e+00          2.83627       161.280     117.020     0.88267     8.12774e-01     2.89082e-01
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       7.22819e+03        0.000000         3.44477e+00          2.72053       162.123     117.925     0.88174     8.12101e-01     2.91331e-01
   7.47408e-02        9.25259e-01        2.18828e-02        9.78117e-01       7.01426e+03        0.000000         3.35464e+00          2.65219       162.596     118.401     0.88120     8.11634e-01     2.92431e-01
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       6.80666e+03        0.000000         3.26635e+00          2.58465       163.046     118.830     0.88066     8.11122e-01     2.93357e-01
   6.45473e-02        9.35453e-01        1.87522e-02        9.81248e-01       6.54304e+03        0.000000         3.15305e+00          2.49714       163.602     119.323     0.87997     8.10381e-01     2.94315e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       6.28963e+03        0.000000         3.04285e+00          2.41115       164.117     119.735     0.87928     8.09562e-01     2.94977e-01
   5.62087e-02        9.43791e-01        1.62271e-02        9.83773e-01       6.02941e+03        0.000000         2.92829e+00          2.32081       164.620     120.078     0.87856     8.08589e-01     2.95340e-01
   5.36803e-02        9.46320e-01        1.54676e-02        9.84532e-01       5.77996e+03        0.000000         2.81701e+00          2.23204       165.065     120.307     0.87785     8.07498e-01     2.95306e-01
   5.27217e-02        9.47278e-01        1.51805e-02        9.84820e-01       5.54083e+03        0.000000         2.70876e+00          2.14454       165.438     120.393     0.87714     8.06253e-01     2.94787e-01
   5.27217e-02        9.47278e-01        1.51805e-02        9.84820e-01       5.54030e+03        0.000000         2.70852e+00          2.14435       165.439     120.393     0.87714     8.06250e-01     2.94786e-01
   5.40786e-02        9.45921e-01        1.55871e-02        9.84413e-01       5.30543e+03        0.000000         2.60022e+00          2.05523       165.717     120.271     0.87641     8.04727e-01     2.93543e-01
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       5.08052e+03        0.000000         2.49327e+00          1.96430       165.795     119.735     0.87566     8.02692e-01     2.90931e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                   Liq Den     Gas Den          
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)      Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)     (g/cm3)     Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ---------------   ---------------   ---------------   ---------   ---------   ---------   ---------   -----------
END

set output "Figures/Env_011_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_011_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_011_P_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_011_LogP_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output "Figures/Env_011_P_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_011_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Reservoir Fluid A Swollen with Solvent\nJust Below the Saturation Temperature Minimum"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       3.03480e-09        0.000000         4.79795e-12          1.00000       627.998     125.165     1.03003     9.84984e-13     4.82120e-14
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       3.03480e-09        0.000000         4.79796e-12          1.00000       627.998     125.164     1.03003     9.84985e-13     4.82120e-14
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       3.03481e-09        0.000000         4.79796e-12          1.00000       627.998     125.164     1.03003     9.84985e-13     4.82120e-14
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       3.03482e-09        0.000000         4.79798e-12          1.00000       627.998     125.164     1.03003     9.84986e-13     4.82120e-14
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       3.03483e-09        0.000000         4.79800e-12          1.00000       627.998     125.164     1.03003     9.84987e-13     4.82120e-14
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       3.03486e-09        0.000000         4.79805e-12          1.00000       627.998     125.163     1.03003     9.84990e-13     4.82120e-14
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       3.03495e-09        0.000000         4.79819e-12          1.00000       627.998     125.160     1.03003     9.84998e-13     4.82120e-14
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       3.03511e-09        0.000000         4.79843e-12          1.00000       627.998     125.156     1.03003     9.85012e-13     4.82120e-14
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       3.03541e-09        0.000000         4.79891e-12          1.00000       627.998     125.146     1.03003     9.85039e-13     4.82120e-14
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       3.03632e-09        0.000000         4.80035e-12          1.00000       627.998     125.119     1.03003     9.85121e-13     4.82120e-14
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       3.03784e-09        0.000000         4.80275e-12          1.00000       627.998     125.074     1.03003     9.85257e-13     4.82120e-14
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       3.04088e-09        0.000000         4.80757e-12          1.00000       627.998     124.984     1.03003     9.85531e-13     4.82120e-14
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       3.05005e-09        0.000000         4.82206e-12          1.00000       627.998     124.712     1.03003     9.86355e-13     4.82120e-14
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       3.06546e-09        0.000000         4.84642e-12          1.00000       627.998     124.260     1.03003     9.87740e-13     4.82120e-14
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       3.09674e-09        0.000000         4.89587e-12          1.00000       627.998     123.355     1.03003     9.90552e-13     4.82120e-14
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.12866e-09        0.000000         4.94634e-12          1.00000       627.998     122.450     1.03003     9.93421e-13     4.82120e-14
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.16125e-09        0.000000         4.99787e-12          1.00000       627.998     121.545     1.03003     9.96351e-13     4.82120e-14
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.19453e-09        0.000000         5.05048e-12          1.00000       627.998     120.640     1.03003     9.99342e-13     4.82120e-14
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       3.22851e-09        0.000000         5.10420e-12          1.00000       627.998     119.735     1.03003     1.00240e-12     4.82120e-14
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       3.26323e-09        0.000000         5.15909e-12          1.00000       627.998     118.830     1.03003     1.00552e-12     4.82120e-14
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       3.29870e-09        0.000000         5.21516e-12          1.00000       627.998     117.925     1.03003     1.00871e-12     4.82120e-14
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.33495e-09        0.000000         5.27247e-12          1.00000       627.998     117.020     1.03003     1.01196e-12     4.82120e-14
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.37200e-09        0.000000         5.33106e-12          1.00000       627.998     116.115     1.03003     1.01530e-12     4.82120e-14
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.40989e-09        0.000000         5.39096e-12          1.00000       627.998     115.210     1.03003     1.01870e-12     4.82120e-14
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       3.44864e-09        0.000000         5.45222e-12          1.00000       627.998     114.305     1.03003     1.02218e-12     4.82120e-14
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       3.48828e-09        0.000000         5.51489e-12          1.00000       627.998     113.400     1.03003     1.02575e-12     4.82120e-14
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       3.52884e-09        0.000000         5.57901e-12          1.00000       627.998     112.495     1.03003     1.02939e-12     4.82120e-14
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       3.57036e-09        0.000000         5.64465e-12          1.00000       627.998     111.590     1.03003     1.03313e-12     4.82120e-14
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       3.61286e-09        0.000000         5.71185e-12          1.00000       627.998     110.685     1.03003     1.03695e-12     4.82120e-14
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       3.65639e-09        0.000000         5.78066e-12          1.00000       627.998     109.780     1.03003     1.04086e-12     4.82120e-14
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       3.70098e-09        0.000000         5.85116e-12          1.00000       627.998     108.875     1.03003     1.04487e-12     4.82120e-14
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       3.74667e-09        0.000000         5.92340e-12          1.00000       627.998     107.970     1.03003     1.04897e-12     4.82120e-14
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       3.79350e-09        0.000000         5.99744e-12          1.00000       627.998     107.065     1.03003     1.05318e-12     4.82120e-14
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       3.84152e-09        0.000000         6.07336e-12          1.00000       627.998     106.160     1.03003     1.05750e-12     4.82120e-14
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       3.89077e-09        0.000000         6.15122e-12          1.00000       627.998     105.255     1.03003     1.06193e-12     4.82120e-14
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       3.94130e-09        0.000000         6.23111e-12          1.00000       627.998     104.350     1.03003     1.06647e-12     4.82120e-14
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       3.99316e-09        0.000000         6.31309e-12          1.00000       627.998     103.445     1.03003     1.07113e-12     4.82120e-14
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       4.04640e-09        0.000000         6.39727e-12          1.00000       627.998     102.540     1.03003     1.07592e-12     4.82120e-14
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       4.10108e-09        0.000000         6.48372e-12          1.00000       627.998     101.635     1.03003     1.08083e-12     4.82120e-14
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       4.15726e-09        0.000000         6.57254e-12          1.00000       627.998     100.730     1.03003     1.08588e-12     4.82120e-14
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       4.21500e-09        0.000000         6.66382e-12          1.00000       627.998      99.825     1.03003     1.09107e-12     4.82120e-14
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       4.27437e-09        0.000000         6.75768e-12          1.00000       627.998      98.920     1.03003     1.09641e-12     4.82120e-14
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       4.33543e-09        0.000000         6.85422e-12          1.00000       627.998      98.015     1.03003     1.10190e-12     4.82120e-14
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       4.39826e-09        0.000000         6.95355e-12          1.00000       627.998      97.110     1.03003     1.10755e-12     4.82120e-14
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       4.46294e-09        0.000000         7.05581e-12          1.00000       627.998      96.205     1.03003     1.11336e-12     4.82120e-14
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       4.52955e-09        0.000000         7.16112e-12          1.00000       627.998      95.300     1.03003     1.11935e-12     4.82120e-14
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       4.59818e-09        0.000000         7.26962e-12          1.00000       627.998      94.395     1.03003     1.12552e-12     4.82120e-14
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       4.66893e-09        0.000000         7.38146e-12          1.00000       627.998      93.490     1.03003     1.13188e-12     4.82120e-14
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       4.74188e-09        0.000000         7.49680e-12          1.00000       627.998      92.585     1.03003     1.13843e-12     4.82120e-14
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       4.81715e-09        0.000000         7.61580e-12          1.00000       627.998      91.680     1.03003     1.14520e-12     4.82120e-14
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       4.89484e-09        0.000000         7.73863e-12          1.00000       627.998      90.775     1.03003     1.15218e-12     4.82120e-14
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       4.97508e-09        0.000000         7.86549e-12          1.00000       627.998      89.870     1.03003     1.15940e-12     4.82120e-14
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       5.05800e-09        0.000000         7.99659e-12          1.00000       627.998      88.965     1.03003     1.16685e-12     4.82120e-14
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       5.14373e-09        0.000000         8.13212e-12          1.00000       627.998      88.060     1.03003     1.17456e-12     4.82120e-14
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       5.23242e-09        0.000000         8.27233e-12          1.00000       627.998      87.155     1.03003     1.18253e-12     4.82120e-14
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       5.32421e-09        0.000000         8.41746e-12          1.00000       627.998      86.250     1.03003     1.19078e-12     4.82120e-14
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       5.41929e-09        0.000000         8.56777e-12          1.00000       627.998      85.345     1.03003     1.19933e-12     4.82120e-14
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       5.51782e-09        0.000000         8.72355e-12          1.00000       627.998      84.440     1.03003     1.20819e-12     4.82120e-14
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       5.62000e-09        0.000000         8.88510e-12          1.00000       627.998      83.535     1.03003     1.21737e-12     4.82120e-14
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       5.72604e-09        0.000000         9.05274e-12          1.00000       627.998      82.630     1.03003     1.22690e-12     4.82120e-14
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       5.83616e-09        0.000000         9.22683e-12          1.00000       627.998      81.725     1.03003     1.23680e-12     4.82120e-14
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       5.95059e-09        0.000000         9.40775e-12          1.00000       627.998      80.820     1.03003     1.24709e-12     4.82120e-14
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       6.06960e-09        0.000000         9.59590e-12          1.00000       627.998      79.915     1.03003     1.25779e-12     4.82120e-14
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       6.19347e-09        0.000000         9.79174e-12          1.00000       627.998      79.010     1.03003     1.26892e-12     4.82120e-14
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       6.32250e-09        0.000000         9.99573e-12          1.00000       627.998      78.105     1.03003     1.28052e-12     4.82120e-14
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       6.45703e-09        0.000000         1.02084e-11          1.00000       627.998      77.200     1.03003     1.29261e-12     4.82120e-14
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       6.59740e-09        0.000000         1.04303e-11          1.00000       627.998      76.295     1.03003     1.30523e-12     4.82120e-14
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       6.74400e-09        0.000000         1.06621e-11          1.00000       627.998      75.390     1.03003     1.31841e-12     4.82120e-14
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       6.89728e-09        0.000000         1.09044e-11          1.00000       627.998      74.485     1.03003     1.33219e-12     4.82120e-14
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       7.05768e-09        0.000000         1.11580e-11          1.00000       627.998      73.580     1.03003     1.34660e-12     4.82120e-14
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       7.22572e-09        0.000000         1.14237e-11          1.00000       627.998      72.675     1.03003     1.36171e-12     4.82120e-14
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       7.40196e-09        0.000000         1.17023e-11          1.00000       627.998      71.770     1.03003     1.37755e-12     4.82120e-14
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       7.58700e-09        0.000000         1.19949e-11          1.00000       627.998      70.865     1.03003     1.39419e-12     4.82120e-14
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       7.78154e-09        0.000000         1.23024e-11          1.00000       627.998      69.960     1.03003     1.41167e-12     4.82120e-14
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       7.98632e-09        0.000000         1.26262e-11          1.00000       627.998      69.055     1.03003     1.43008e-12     4.82120e-14
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       8.20217e-09        0.000000         1.29674e-11          1.00000       627.998      68.150     1.03003     1.44948e-12     4.82120e-14
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       8.43000e-09        0.000000         1.33276e-11          1.00000       627.998      67.245     1.03003     1.46996e-12     4.82120e-14
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       8.67086e-09        0.000000         1.37084e-11          1.00000       627.998      66.340     1.03003     1.49162e-12     4.82120e-14
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       8.92589e-09        0.000000         1.41116e-11          1.00000       627.998      65.435     1.03003     1.51454e-12     4.82120e-14
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       9.19637e-09        0.000000         1.45392e-11          1.00000       627.998      64.530     1.03003     1.53885e-12     4.82120e-14
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       9.48376e-09        0.000000         1.49936e-11          1.00000       627.998      63.625     1.03003     1.56469e-12     4.82120e-14
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       9.78968e-09        0.000000         1.54773e-11          1.00000       627.998      62.720     1.03003     1.59219e-12     4.82120e-14
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       1.01160e-08        0.000000         1.59932e-11          1.00000       627.998      61.815     1.03003     1.62152e-12     4.82120e-14
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       1.04648e-08        0.000000         1.65447e-11          1.00000       627.998      60.910     1.03003     1.65288e-12     4.82120e-14
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       1.08386e-08        0.000000         1.71355e-11          1.00000       627.998      60.005     1.03003     1.68647e-12     4.82120e-14
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       1.12400e-08        0.000000         1.77702e-11          1.00000       627.998      59.100     1.03003     1.72256e-12     4.82120e-14
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       1.16723e-08        0.000000         1.84537e-11          1.00000       627.998      58.195     1.03003     1.76142e-12     4.82120e-14
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       1.21392e-08        0.000000         1.91918e-11          1.00000       627.998      57.290     1.03003     1.80339e-12     4.82120e-14
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       1.26450e-08        0.000000         1.99915e-11          1.00000       627.998      56.385     1.03003     1.84885e-12     4.82120e-14
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       1.31948e-08        0.000000         2.08607e-11          1.00000       627.998      55.480     1.03003     1.89828e-12     4.82120e-14
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       1.37946e-08        0.000000         2.18089e-11          1.00000       627.998      54.575     1.03003     1.95219e-12     4.82120e-14
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       1.44514e-08        0.000000         2.28474e-11          1.00000       627.998      53.670     1.03003     2.01124e-12     4.82120e-14
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       1.51740e-08        0.000000         2.39898e-11          1.00000       627.998      52.765     1.03003     2.07619e-12     4.82120e-14
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       1.59726e-08        0.000000         2.52524e-11          1.00000       627.998      51.860     1.03003     2.14798e-12     4.82120e-14
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       1.68600e-08        0.000000         2.66553e-11          1.00000       627.998      50.955     1.03003     2.22775e-12     4.82120e-14
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       1.78518e-08        0.000000         2.82232e-11          1.00000       627.998      50.050     1.03003     2.31690e-12     4.82120e-14
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       1.89675e-08        0.000000         2.99872e-11          1.00000       627.998      49.145     1.03003     2.41719e-12     4.82120e-14
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       2.02320e-08        0.000000         3.19863e-11          1.00000       627.998      48.240     1.03003     2.53086e-12     4.82120e-14
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       2.16772e-08        0.000000         3.42711e-11          1.00000       627.998      47.335     1.03003     2.66076e-12     4.82120e-14
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       2.33446e-08        0.000000         3.69073e-11          1.00000       627.998      46.430     1.03003     2.81065e-12     4.82120e-14
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       2.52900e-08        0.000000         3.99829e-11          1.00000       627.998      45.525     1.03003     2.98553e-12     4.82120e-14
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       2.75891e-08        0.000000         4.36177e-11          1.00000       627.998      44.620     1.03003     3.19219e-12     4.82120e-14
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       3.03480e-08        0.000000         4.79795e-11          1.00000       627.998      43.715     1.03003     3.44019e-12     4.82120e-14
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       3.37200e-08        0.000000         5.33106e-11          1.00000       627.998      42.810     1.03003     3.74331e-12     4.82120e-14
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       3.79350e-08        0.000000         5.99744e-11          1.00000       627.998      41.905     1.03003     4.12220e-12     4.82120e-14
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       4.33543e-08        0.000000         6.85422e-11          1.00000       627.998      41.001     1.03003     4.60934e-12     4.82120e-14
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.05800e-08        0.000000         7.99659e-11          1.00000       627.998      40.096     1.03003     5.25887e-12     4.82120e-14
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       6.06960e-08        0.000000         9.59590e-11          1.00000       627.998      39.191     1.03003     6.16821e-12     4.82120e-14
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       7.58700e-08        0.000000         1.19949e-10          1.00000       627.998      38.286     1.03003     7.53221e-12     4.82120e-14
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       1.01160e-07        0.000000         1.59932e-10          1.00000       627.998      37.381     1.03003     9.80556e-12     4.82120e-14
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       1.51740e-07        0.000000         2.39898e-10          1.00000       627.998      36.476     1.03003     1.43522e-11     4.82120e-14
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.03480e-07        0.000000         4.79795e-10          1.00000       627.998      35.571     1.03003     2.79923e-11     4.82120e-14
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       6.06960e-07        0.000000         9.59590e-10          1.00000       627.998      35.118     1.03003     5.52724e-11     4.82120e-14
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.51740e-06        0.000000         2.39898e-09          1.00000       627.998      34.847     1.03003     1.37113e-10     4.82120e-14
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       3.03480e-06        0.000000         4.79795e-09          1.00000       627.998      34.756     1.03003     2.73513e-10     4.82120e-14
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       6.06960e-06        0.000000         9.59590e-09          1.00000       627.998      34.711     1.03003     5.46315e-10     4.82120e-14
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.51740e-05        0.000000         2.39898e-08          1.00000       627.998      34.684     1.03003     1.36472e-09     4.82120e-14
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       3.03480e-05        0.000000         4.79795e-08          1.00000       627.998      34.675     1.03003     2.72872e-09     4.82120e-14
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       6.06961e-05        0.000000         9.59591e-08          1.00000       627.998      34.670     1.03003     5.45674e-09     4.82120e-14
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.51740e-04        0.000000         2.39898e-07          1.00000       627.998      34.667     1.03003     1.36408e-08     4.82121e-14
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       3.03481e-04        0.000000         4.79796e-07          1.00000       627.998      34.666     1.03003     2.72809e-08     4.82122e-14
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       6.06964e-04        0.000000         9.59595e-07          1.00000       627.997      34.666     1.03003     5.45613e-08     4.82123e-14
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.51742e-03        0.000000         2.39900e-06          1.00000       627.997      34.666     1.03003     1.36403e-07     4.82128e-14
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       3.03489e-03        0.000000         4.79806e-06          1.00000       627.995      34.666     1.03003     2.72810e-07     4.82136e-14
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       6.06994e-03        0.000000         9.59635e-06          1.00000       627.992      34.666     1.03003     5.45634e-07     4.82151e-14
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.51761e-02        0.000000         2.39925e-05          0.99999       627.984      34.666     1.03003     1.36420e-06     4.82199e-14
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       3.03564e-02        0.000000         4.79907e-05          0.99999       627.969      34.666     1.03003     2.72880e-06     4.82277e-14
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       6.07294e-02        0.000000         9.60036e-05          0.99997       627.941      34.666     1.03002     5.45916e-06     4.82434e-14
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.51949e-01        0.000000         2.40176e-04          0.99994       627.855      34.666     1.03001     1.36597e-05     4.82905e-14
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       3.04317e-01        0.000000         4.80913e-04          0.99987       627.711      34.666     1.03000     2.73589e-05     4.83694e-14
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.10321e-01        0.000000         9.64079e-04          0.99974       627.423      34.666     1.02997     5.48765e-05     4.85282e-14
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.53868e+00        0.000000         2.42738e-03          0.99935       626.549      34.666     1.02987     1.38403e-04     4.90132e-14
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       3.12178e+00        0.000000         4.91395e-03          0.99867       625.061      34.666     1.02970     2.80992e-04     4.98520e-14
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       6.43389e+00        0.000000         1.00807e-02          0.99727       621.960      34.666     1.02935     5.79933e-04     5.16556e-14
   1.00000e+00        3.12136e-10        1.00000e+00        1.12701e-09       1.07149e+01        0.000000         1.66879e-02          0.99545       617.976      34.666     1.02890     9.67575e-04     5.40882e-14
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.78443e+01        0.000000         2.75163e-02          0.99241       611.398      34.666     1.02814     1.61631e-03     5.84078e-14
   1.00000e+00        1.37080e-10        1.00000e+00        4.94944e-10       2.87720e+01        0.000000         4.36955e-02          0.98774       601.453      34.666     1.02696     2.61846e-03     6.57402e-14
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       4.63918e+01        0.000000         6.87464e-02          0.98017       585.766      34.666     1.02502     4.25457e-03     7.96521e-14
   1.00000e+00        8.26809e-11        1.00000e+00        2.98530e-10       6.97174e+01        0.000000         1.00019e-01          0.97008       565.642      34.666     1.02239     6.46024e-03     1.02955e-13
   1.00000e+00        7.66353e-11        1.00000e+00        2.76702e-10       1.04771e+02        0.000000         1.43199e-01          0.95477       536.735      34.666     1.01831     9.86410e-03     1.52253e-13
   1.00000e+00        7.66353e-11        1.00000e+00        2.76702e-10       1.04778e+02        0.000000         1.43207e-01          0.95477       536.730      34.666     1.01831     9.86477e-03     1.52264e-13
   1.00000e+00        8.12329e-11        1.00000e+00        2.93302e-10       1.43183e+02        0.000000         1.85647e-01          0.93778       506.827      34.666     1.01363     1.37248e-02     2.35677e-13
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.95664e+02        0.000000         2.36223e-01          0.91416       468.801      34.666     1.00692     1.92401e-02     4.34580e-13
   1.00000e+00        1.31487e-10        1.00000e+00        4.74750e-10       2.43986e+02        0.000000         2.76073e-01          0.89196       436.533      34.666     1.00041     2.45886e-02     7.76238e-13
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       3.04242e+02        0.000000         3.17990e-01          0.86364       399.782      34.666     0.99185     3.16666e-02     1.64027e-12
   1.00000e+00        2.97980e-10        1.00000e+00        1.07590e-09       3.53911e+02        0.000000         3.47023e-01          0.83970       372.264      34.666     0.98448     3.78868e-02     3.10975e-12
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       4.11689e+02        0.000000         3.75657e-01          0.81108       343.306      34.666     0.97561     4.56270e-02     6.73835e-12
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       4.80836e+02        0.000000         4.04386e-01          0.77562       312.914      34.666     0.96481     5.57271e-02     1.78066e-11
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       5.42907e+02        0.000000         4.26894e-01          0.74249       289.683      34.666     0.95531     6.57279e-02     4.47192e-11
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.16395e+02        0.000000         4.52438e-01          0.70144       267.521      34.666     0.94509     7.89922e-02     1.42292e-10
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       6.66581e+02        0.000000         4.71204e-01          0.67210       256.090      34.666     0.93941     8.91534e-02     3.28706e-10
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.12789e+02        0.000000         4.90968e-01          0.64403       248.527      34.666     0.93562     9.94885e-02     7.37644e-10
   1.00000e+00        4.34829e-08        1.00000e+00        1.57001e-07       7.60451e+02        0.000000         5.15216e-01          0.61394       243.913      34.666     0.93354     1.11342e-01     1.77072e-09
   1.00000e+00        4.34829e-08        1.00000e+00        1.57001e-07       7.60451e+02        0.000000         2.00490e-01          0.61394        40.046      34.666     0.39387     1.11342e-01     1.88027e-06
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.62891e+02        0.000000         2.01973e-01          0.61237        39.717      34.666     0.38901     1.11986e-01     2.22248e-06
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       7.63810e+02        0.000000         2.02538e-01          0.61178        39.602      34.666     0.38727     1.12230e-01     2.36306e-06
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       7.64249e+02        0.000000         2.02809e-01          0.61149        39.549      34.666     0.38646     1.12346e-01     2.43245e-06
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       7.64506e+02        0.000000         2.02967e-01          0.61133        39.519      34.666     0.38599     1.12414e-01     2.47382e-06
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       7.64590e+02        0.000000         2.03019e-01          0.61127        39.509      34.666     0.38583     1.12437e-01     2.48757e-06
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       7.64632e+02        0.000000         2.03046e-01          0.61125        39.504      34.666     0.38576     1.12448e-01     2.49444e-06
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       7.64657e+02        0.000000         2.03061e-01          0.61123        39.501      34.666     0.38571     1.12455e-01     2.49856e-06
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       7.64666e+02        0.000000         2.03066e-01          0.61122        39.500      34.666     0.38570     1.12457e-01     2.49993e-06
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       7.64670e+02        0.000000         2.03069e-01          0.61122        39.499      34.666     0.38569     1.12458e-01     2.50062e-06
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       7.64673e+02        0.000000         2.03070e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50103e-06
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       7.64673e+02        0.000000         2.03071e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50117e-06
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       7.64674e+02        0.000000         2.03071e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50123e-06
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       7.64674e+02        0.000000         2.03071e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50128e-06
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       7.64674e+02        0.000000         2.03071e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50129e-06
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       7.64674e+02        0.000000         2.03072e-01          0.61122        39.499      34.666     0.38568     1.12459e-01     2.50130e-06
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10696e-01
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.06034e+03        0.000000         3.59583e-01          0.42733        35.505      34.666     0.27149     2.23047e-01     1.10697e-01
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       1.06034e+03        0.000000         3.59582e-01          0.42733        35.505      34.666     0.27149     2.23049e-01     1.10699e-01
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       1.06035e+03        0.000000         3.59582e-01          0.42733        35.505      34.666     0.27149     2.23051e-01     1.10701e-01
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.06036e+03        0.000000         3.59580e-01          0.42732        35.505      34.666     0.27149     2.23055e-01     1.10707e-01
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.06039e+03        0.000000         3.59576e-01          0.42731        35.505      34.666     0.27150     2.23068e-01     1.10725e-01
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       1.06043e+03        0.000000         3.59569e-01          0.42729        35.505      34.666     0.27152     2.23089e-01     1.10753e-01
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.06053e+03        0.000000         3.59554e-01          0.42725        35.505      34.666     0.27156     2.23131e-01     1.10810e-01
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.06082e+03        0.000000         3.59509e-01          0.42713        35.506      34.666     0.27168     2.23257e-01     1.10978e-01
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.06129e+03        0.000000         3.59433e-01          0.42692        35.508      34.666     0.27187     2.23465e-01     1.11246e-01
   9.99981e-01        1.89339e-05        9.99932e-01        6.83600e-05       1.06212e+03        0.000000         3.59292e-01          0.42657        35.511      34.667     0.27221     2.23831e-01     1.11691e-01
   9.99981e-01        1.89339e-05        9.99932e-01        6.83600e-05       1.06212e+03        0.000000         7.73441e-01          0.42657       267.382      34.667     0.95213     2.23831e-01     1.04464e-06
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.06518e+03        0.000000         7.76301e-01          0.42540       267.651      34.667     0.95231     2.25095e-01     1.10605e-06
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.12253e+03        0.000000         8.27680e-01          0.40813       271.569      34.670     0.95507     2.47272e-01     2.88898e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.17717e+03        0.000000         8.73050e-01          0.39864       273.630      34.675     0.95672     2.65513e-01     6.01586e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.24754e+03        0.000000         9.27590e-01          0.39329       274.675      34.684     0.95793     2.85286e-01     1.26287e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.38003e+03        0.000000         1.02284e+00          0.39512       274.040      34.711     0.95876     3.14368e-01     3.42043e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       1.52962e+03        0.000000         1.12365e+00          0.40637       271.585      34.756     0.95869     3.39240e-01     7.38471e-05
   9.98551e-01        1.44903e-03        9.94788e-01        5.21218e-03       1.63691e+03        0.000000         1.19318e+00          0.41741       269.393      34.797     0.95835     3.53850e-01     1.12281e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.75173e+03        0.000000         1.26568e+00          0.43078       266.898      34.847     0.95787     3.67440e-01     1.62383e-04
   9.97171e-01        2.82860e-03        9.89862e-01        1.01382e-02       1.90479e+03        0.000000         1.35987e+00          0.45018       263.513      34.922     0.95712     3.83152e-01     2.42915e-04
   9.96173e-01        3.82702e-03        9.86319e-01        1.36813e-02       2.07122e+03        0.000000         1.45963e+00          0.47254       259.882      35.012     0.95627     3.97946e-01     3.47145e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.25219e+03        0.000000         1.56542e+00          0.49776       256.071      35.118     0.95533     4.12033e-01     4.78519e-04
   9.93537e-01        6.46299e-03        9.77052e-01        2.29483e-02       2.46508e+03        0.000000         1.68679e+00          0.52819       251.813      35.250     0.95426     4.26599e-01     6.54650e-04
   9.91869e-01        8.13112e-03        9.71252e-01        2.87482e-02       2.69809e+03        0.000000         1.81631e+00          0.56209       247.444      35.401     0.95315     4.40649e-01     8.70898e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       2.95313e+03        0.000000         1.95461e+00          0.59961       243.001      35.571     0.95203     4.54277e-01     1.13158e-03
   9.88544e-01        1.14559e-02        9.59838e-01        4.01618e-02       3.15030e+03        0.000000         2.05932e+00          0.62882       239.794      35.702     0.95122     4.63807e-01     1.34765e-03
   9.86995e-01        1.30055e-02        9.54584e-01        4.54160e-02       3.36063e+03        0.000000         2.16914e+00          0.66011       236.576      35.843     0.95043     4.73174e-01     1.58983e-03
   9.85357e-01        1.46428e-02        9.49077e-01        5.09232e-02       3.58500e+03        0.000000         2.28436e+00          0.69358       233.357      35.991     0.94965     4.82390e-01     1.85923e-03
   9.83639e-01        1.63605e-02        9.43348e-01        5.66522e-02       3.82436e+03        0.000000         2.40529e+00          0.72937       230.149      36.146     0.94889     4.91466e-01     2.15667e-03
   9.81850e-01        1.81497e-02        9.37433e-01        6.25674e-02       4.07969e+03        0.000000         2.53227e+00          0.76758       226.961      36.308     0.94817     5.00407e-01     2.48265e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.35208e+03        0.000000         2.66569e+00          0.80838       223.804      36.476     0.94748     5.09216e-01     2.83723e-03
   9.78369e-01        2.16308e-02        9.26074e-01        7.39263e-02       4.60080e+03        0.000000         2.78588e+00          0.84562       221.121      36.623     0.94693     5.16689e-01     3.16468e-03
   9.76711e-01        2.32894e-02        9.20730e-01        7.92698e-02       4.86373e+03        0.000000         2.91144e+00          0.88498       218.476      36.773     0.94642     5.24065e-01     3.51234e-03
   9.75034e-01        2.49663e-02        9.15372e-01        8.46283e-02       5.14169e+03        0.000000         3.04267e+00          0.92655       215.874      36.925     0.94595     5.31343e-01     3.87922e-03
   9.73349e-01        2.66513e-02        9.10032e-01        8.99682e-02       5.43554e+03        0.000000         3.17994e+00          0.97043       213.322      37.077     0.94553     5.38523e-01     4.26392e-03
   9.71667e-01        2.83331e-02        9.04745e-01        9.52547e-02       5.74618e+03        0.000000         3.32362e+00          1.01674       210.827      37.230     0.94517     5.45600e-01     4.66461e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       6.07457e+03        0.000000         3.47414e+00          1.06559       208.395      37.381     0.94487     5.52572e-01     5.06721e-03
   9.68590e-01        3.14103e-02        8.95184e-01        1.04816e-01       6.37161e+03        0.000000         3.60924e+00          1.10966       206.361      37.508     0.94467     5.58474e-01     5.40366e-03
   9.67208e-01        3.27921e-02        8.90937e-01        1.09063e-01       6.68317e+03        0.000000         3.75003e+00          1.15576       204.383      37.633     0.94452     5.64292e-01     5.74325e-03
   9.65863e-01        3.41366e-02        8.86831e-01        1.13169e-01       7.00996e+03        0.000000         3.89685e+00          1.20396       202.463      37.755     0.94442     5.70025e-01     6.08375e-03
   9.64565e-01        3.54354e-02        8.82890e-01        1.17110e-01       7.35274e+03        0.000000         4.05007e+00          1.25434       200.607      37.872     0.94439     5.75669e-01     6.42275e-03
   9.63320e-01        3.66797e-02        8.79137e-01        1.20863e-01       7.71227e+03        0.000000         4.21008e+00          1.30698       198.816      37.985     0.94441     5.81222e-01     6.75764e-03
   9.62139e-01        3.78607e-02        8.75595e-01        1.24405e-01       8.08939e+03        0.000000         4.37731e+00          1.36196       197.096      38.092     0.94450     5.86681e-01     7.08567e-03
   9.61030e-01        3.89702e-02        8.72286e-01        1.27714e-01       8.48494e+03        0.000000         4.55219e+00          1.41935       195.448      38.192     0.94466     5.92044e-01     7.40399e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.89984e+03        0.000000         4.73523e+00          1.47923       193.876      38.286     0.94489     5.97308e-01     7.70969e-03
   9.59040e-01        4.09598e-02        8.66396e-01        1.33604e-01       9.34364e+03        0.000000         4.93071e+00          1.54292       192.353      38.372     0.94520     6.02571e-01     8.00529e-03
   9.58178e-01        4.18215e-02        8.63862e-01        1.36138e-01       9.80956e+03        0.000000         5.13578e+00          1.60938       190.915      38.450     0.94558     6.07727e-01     8.28175e-03
   9.57421e-01        4.25787e-02        8.61643e-01        1.38357e-01       1.02987e+04        0.000000         5.35106e+00          1.67870       189.562      38.519     0.94605     6.12776e-01     8.53620e-03
   9.56774e-01        4.32259e-02        8.59754e-01        1.40246e-01       1.08123e+04        0.000000         5.57721e+00          1.75097       188.296      38.577     0.94659     6.17717e-01     8.76595e-03
   9.56241e-01        4.37588e-02        8.58202e-01        1.41798e-01       1.13514e+04        0.000000         5.81492e+00          1.82629       187.120      38.626     0.94720     6.22549e-01     8.96865e-03
   9.55826e-01        4.41742e-02        8.56995e-01        1.43005e-01       1.19175e+04        0.000000         6.06495e+00          1.90478       186.032      38.663     0.94790     6.27273e-01     9.14226e-03
   9.55529e-01        4.44706e-02        8.56135e-01        1.43865e-01       1.25117e+04        0.000000         6.32807e+00          1.98652       185.034      38.690     0.94867     6.31890e-01     9.28516e-03
   9.55352e-01        4.46475e-02        8.55623e-01        1.44377e-01       1.31356e+04        0.000000         6.60512e+00          2.07166       184.127      38.706     0.94952     6.36401e-01     9.39618e-03
   9.55294e-01        4.47061e-02        8.55453e-01        1.44547e-01       1.37907e+04        0.000000         6.89698e+00          2.16030       183.309      38.711     0.95044     6.40808e-01     9.47462e-03
   9.57690e-01        4.23104e-02        8.62429e-01        1.37571e-01       1.91732e+04        0.000000         9.33916e+00          2.86447       180.028      38.495     0.95839     6.68141e-01     9.18504e-03
   9.63356e-01        3.66440e-02        8.79244e-01        1.20756e-01       2.66565e+04        0.000000         1.28605e+01          3.79458       180.168      37.982     0.96837     6.91882e-01     7.86502e-03
   9.69922e-01        3.00784e-02        8.99305e-01        1.00695e-01       3.70605e+04        0.000000         1.79432e+01          5.03966       182.777      37.388     0.97893     7.12945e-01     6.22841e-03
   9.75875e-01        2.41250e-02        9.18055e-01        8.19453e-02       5.15253e+04        0.000000         2.52481e+01          6.72847       186.877      36.849     0.98893     7.31721e-01     4.75597e-03
   9.80664e-01        1.93362e-02        9.33539e-01        6.64609e-02       7.16357e+04        0.000000         3.56805e+01          9.04062       191.639      36.415     0.99770     7.48229e-01     3.61327e-03
   9.84279e-01        1.57208e-02        9.45476e-01        5.45243e-02       9.95951e+04        0.000000         5.04807e+01         12.22489       196.438      36.088     1.00498     7.62390e-01     2.78956e-03
   9.86918e-01        1.30824e-02        9.54324e-01        4.56756e-02       1.38467e+05        0.000000         7.13527e+01         16.62625       200.865      35.850     1.01078     7.74201e-01     2.21630e-03
   9.88810e-01        1.11901e-02        9.60744e-01        3.92565e-02       1.92511e+05        0.000000         1.00647e+02         22.72379       204.699      35.678     1.01528     7.83784e-01     1.82271e-03
   9.90156e-01        9.84362e-03        9.65349e-01        3.46512e-02       2.67648e+05        0.000000         1.41620e+02         31.18327       207.868      35.556     1.01869     7.91368e-01     1.55295e-03
   9.91112e-01        8.88792e-03        9.68637e-01        3.13633e-02       3.72112e+05        0.000000         1.98791e+02         42.92991       210.395      35.470     1.02124     7.97244e-01     1.36726e-03
   9.91791e-01        8.20936e-03        9.70981e-01        2.90190e-02       5.17347e+05        0.000000         2.78444e+02         59.24972       212.358      35.409     1.02313     8.01717e-01     1.23858e-03
   9.92273e-01        7.72679e-03        9.72653e-01        2.73469e-02       7.19269e+05        0.000000         3.89318e+02         81.93018       213.852      35.365     1.02451     8.05075e-01     1.14876e-03
   9.92617e-01        7.38290e-03        9.73847e-01        2.61529e-02       1.00000e+06        0.000000         5.43567e+02        113.45599       214.971      35.334     1.02552     8.07569e-01     1.08566e-03
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       5.77019e+03        0.000000         2.78050e+00          2.16589       163.074     116.115     0.87755     8.02156e-01     2.80522e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       5.73481e+03        0.000000         2.75768e+00          2.13959       162.701     115.210     0.87737     8.00746e-01     2.77372e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       5.77525e+03        0.000000         2.76883e+00          2.14038       162.224     114.305     0.87742     7.99763e-01     2.74454e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       5.86112e+03        0.000000         2.80010e+00          2.15698       161.688     113.400     0.87761     7.99033e-01     2.71664e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       5.98278e+03        0.000000         2.84698e+00          2.18564       161.107     112.495     0.87791     7.98499e-01     2.68962e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       6.13752e+03        0.000000         2.90806e+00          2.22513       160.487     111.590     0.87831     7.98141e-01     2.66329e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       6.32683e+03        0.000000         2.98376e+00          2.27567       159.829     110.685     0.87881     7.97961e-01     2.63755e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       6.55658e+03        0.000000         3.07641e+00          2.33896       159.129     109.780     0.87943     7.97986e-01     2.61242e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       6.84044e+03        0.000000         3.19159e+00          2.41922       158.374     108.875     0.88019     7.98277e-01     2.58802e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       7.21423e+03        0.000000         3.34422e+00          2.52790       157.529     107.970     0.88120     7.99005e-01     2.56483e-01
   1.96401e-01        8.03599e-01        6.33980e-02        9.36602e-01       7.56157e+03        0.000000         3.48712e+00          2.63213       156.880     107.391     0.88212     7.99995e-01     2.55152e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       7.92562e+03        0.000000         3.63852e+00          2.74577       156.343     107.065     0.88309     8.01372e-01     2.54666e-01
   2.00384e-01        7.99616e-01        6.49015e-02        9.35098e-01       8.07535e+03        0.000000         3.70153e+00          2.79433       156.171     107.030     0.88348     8.02060e-01     2.54794e-01
   2.00384e-01        7.99616e-01        6.49015e-02        9.35098e-01       8.07557e+03        0.000000         3.70162e+00          2.79440       156.170     107.030     0.88348     8.02061e-01     2.54795e-01
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       8.21384e+03        0.000000         3.76040e+00          2.84062       156.044     107.065     0.88384     8.02780e-01     2.55139e-01
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       8.62005e+03        0.000000         3.94156e+00          2.99454       156.042     107.970     0.88491     8.05934e-01     2.58921e-01
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       8.67672e+03        0.000000         3.97562e+00          3.03393       156.393     108.875     0.88509     8.07411e-01     2.62168e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       8.63243e+03        0.000000         3.96710e+00          3.03976       156.844     109.780     0.88501     8.08412e-01     2.65262e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       8.52393e+03        0.000000         3.93120e+00          3.02369       157.361     110.685     0.88477     8.09110e-01     2.68248e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       8.36581e+03        0.000000         3.87382e+00          2.99017       157.932     111.590     0.88441     8.09567e-01     2.71137e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       8.16483e+03        0.000000         3.79759e+00          2.94112       158.551     112.495     0.88394     8.09812e-01     2.73927e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       7.92336e+03        0.000000         3.70322e+00          2.87698       159.219     113.400     0.88337     8.09846e-01     2.76609e-01
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       7.63957e+03        0.000000         3.58961e+00          2.79673       159.942     114.305     0.88268     8.09653e-01     2.79163e-01
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       7.30464e+03        0.000000         3.45253e+00          2.69689       160.735     115.210     0.88184     8.09175e-01     2.81546e-01
   1.04590e-01        8.95410e-01        3.13371e-02        9.68663e-01       7.09379e+03        0.000000         3.36474e+00          2.63156       161.206     115.699     0.88130     8.08748e-01     2.82733e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       6.88901e+03        0.000000         3.27843e+00          2.56639       161.641     116.115     0.88077     8.08238e-01     2.83652e-01
   9.35327e-02        9.06467e-01        2.77838e-02        9.72216e-01       6.51171e+03        0.000000         3.11655e+00          2.44174       162.376     116.700     0.87975     8.07021e-01     2.84660e-01
   9.09033e-02        9.09097e-01        2.69478e-02        9.73052e-01       6.15507e+03        0.000000         2.95954e+00          2.31736       162.944     116.938     0.87875     8.05401e-01     2.84459e-01
   9.09033e-02        9.09097e-01        2.69478e-02        9.73052e-01       6.15465e+03        0.000000         2.95935e+00          2.31721       162.944     116.938     0.87875     8.05399e-01     2.84457e-01
   9.22771e-02        9.07723e-01        2.73841e-02        9.72616e-01       5.95932e+03        0.000000         2.87086e+00          2.24476       163.145     116.814     0.87816     8.04151e-01     2.83455e-01
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       5.77019e+03        0.000000         2.78050e+00          2.16589       163.074     116.115     0.87755     8.02156e-01     2.80522e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                   Liq Den     Gas Den          
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)      Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)     (g/cm3)     Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ---------------   ---------------   ---------------   ---------   ---------   ---------   ---------   -----------
END

set output "Figures/Env_012_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_012_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_012_P_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_012_LogP_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output "Figures/Env_012_P_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_012_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Reservoir Fluid A Swollen with Solvent\nJust Below the Saturation Temperature Minimum"
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (psia)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ----------------   ---------------   ---------------   ---------   ---------   ---------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-12        1.00000e+00        2.76960e-13        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-12        1.00000e+00        5.53920e-13        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-12        1.00000e+00        1.38480e-12        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-11        1.00000e+00        2.76960e-12        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-11        1.00000e+00        5.53920e-12        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-11        1.00000e+00        1.38480e-11        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-10        1.00000e+00        2.76960e-11        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-10        1.00000e+00        5.53920e-11        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-10        1.00000e+00        1.38480e-10        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-09        1.00000e+00        2.76960e-10        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-09        1.00000e+00        5.53920e-10        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-09        1.00000e+00        1.38480e-09        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-08        1.00000e+00        2.76960e-09        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-08        1.00000e+00        5.53920e-09        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-08        1.00000e+00        1.38480e-08        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-07        1.00000e+00        2.76960e-08        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   2.00000e-07        1.00000e+00        5.53920e-08        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   5.00000e-07        1.00000e+00        1.38480e-07        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.165     1.03004     9.74422e-13     4.76983e-14
   1.00000e-06        9.99999e-01        2.76960e-07        1.00000e+00       3.00161e-09        0.000000         4.74644e-12          1.00000       627.998     125.164     1.03004     9.74423e-13     4.76983e-14
   2.00000e-06        9.99998e-01        5.53921e-07        9.99999e-01       3.00161e-09        0.000000         4.74645e-12          1.00000       627.998     125.164     1.03004     9.74423e-13     4.76983e-14
   5.00000e-06        9.99995e-01        1.38480e-06        9.99999e-01       3.00162e-09        0.000000         4.74646e-12          1.00000       627.998     125.164     1.03004     9.74424e-13     4.76983e-14
   1.00000e-05        9.99990e-01        2.76962e-06        9.99997e-01       3.00164e-09        0.000000         4.74649e-12          1.00000       627.998     125.164     1.03004     9.74425e-13     4.76983e-14
   2.00000e-05        9.99980e-01        5.53928e-06        9.99994e-01       3.00167e-09        0.000000         4.74653e-12          1.00000       627.998     125.163     1.03004     9.74428e-13     4.76983e-14
   5.00000e-05        9.99950e-01        1.38485e-05        9.99986e-01       3.00176e-09        0.000000         4.74668e-12          1.00000       627.998     125.160     1.03004     9.74436e-13     4.76983e-14
   1.00000e-04        9.99900e-01        2.76980e-05        9.99972e-01       3.00191e-09        0.000000         4.74691e-12          1.00000       627.998     125.156     1.03004     9.74449e-13     4.76983e-14
   2.00000e-04        9.99800e-01        5.54000e-05        9.99945e-01       3.00221e-09        0.000000         4.74739e-12          1.00000       627.998     125.146     1.03004     9.74476e-13     4.76983e-14
   5.00000e-04        9.99500e-01        1.38530e-04        9.99861e-01       3.00311e-09        0.000000         4.74881e-12          1.00000       627.998     125.119     1.03004     9.74557e-13     4.76983e-14
   1.00000e-03        9.99000e-01        2.77160e-04        9.99723e-01       3.00461e-09        0.000000         4.75119e-12          1.00000       627.998     125.074     1.03004     9.74692e-13     4.76983e-14
   2.00000e-03        9.98000e-01        5.54722e-04        9.99445e-01       3.00762e-09        0.000000         4.75595e-12          1.00000       627.998     124.984     1.03004     9.74963e-13     4.76983e-14
   5.00000e-03        9.95000e-01        1.38982e-03        9.98610e-01       3.01669e-09        0.000000         4.77029e-12          1.00000       627.998     124.712     1.03004     9.75778e-13     4.76983e-14
   1.00000e-02        9.90000e-01        2.78977e-03        9.97210e-01       3.03193e-09        0.000000         4.79438e-12          1.00000       627.998     124.260     1.03004     9.77148e-13     4.76983e-14
   2.00000e-02        9.80000e-01        5.62047e-03        9.94380e-01       3.06286e-09        0.000000         4.84331e-12          1.00000       627.998     123.355     1.03004     9.79930e-13     4.76983e-14
   3.00000e-02        9.70000e-01        8.49302e-03        9.91507e-01       3.09444e-09        0.000000         4.89324e-12          1.00000       627.998     122.450     1.03004     9.82769e-13     4.76983e-14
   4.00000e-02        9.60000e-01        1.14083e-02        9.88592e-01       3.12667e-09        0.000000         4.94421e-12          1.00000       627.998     121.545     1.03004     9.85667e-13     4.76983e-14
   5.00000e-02        9.50000e-01        1.43674e-02        9.85633e-01       3.15959e-09        0.000000         4.99625e-12          1.00000       627.998     120.640     1.03004     9.88626e-13     4.76983e-14
   6.00000e-02        9.40000e-01        1.73712e-02        9.82629e-01       3.19320e-09        0.000000         5.04940e-12          1.00000       627.998     119.735     1.03004     9.91648e-13     4.76983e-14
   7.00000e-02        9.30000e-01        2.04207e-02        9.79579e-01       3.22754e-09        0.000000         5.10370e-12          1.00000       627.998     118.830     1.03004     9.94736e-13     4.76983e-14
   8.00000e-02        9.20000e-01        2.35171e-02        9.76483e-01       3.26262e-09        0.000000         5.15917e-12          1.00000       627.998     117.925     1.03004     9.97890e-13     4.76983e-14
   9.00000e-02        9.10000e-01        2.66613e-02        9.73339e-01       3.29847e-09        0.000000         5.21587e-12          1.00000       627.998     117.020     1.03004     1.00111e-12     4.76983e-14
   1.00000e-01        9.00000e-01        2.98546e-02        9.70145e-01       3.33512e-09        0.000000         5.27382e-12          1.00000       627.998     116.115     1.03004     1.00441e-12     4.76983e-14
   1.10000e-01        8.90000e-01        3.30980e-02        9.66902e-01       3.37259e-09        0.000000         5.33308e-12          1.00000       627.998     115.210     1.03004     1.00778e-12     4.76983e-14
   1.20000e-01        8.80000e-01        3.63928e-02        9.63607e-01       3.41092e-09        0.000000         5.39368e-12          1.00000       627.998     114.305     1.03004     1.01122e-12     4.76983e-14
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       3.45012e-09        0.000000         5.45568e-12          1.00000       627.998     113.400     1.03004     1.01475e-12     4.76983e-14
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       3.49024e-09        0.000000         5.51912e-12          1.00000       627.998     112.495     1.03004     1.01836e-12     4.76983e-14
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       3.53130e-09        0.000000         5.58405e-12          1.00000       627.998     111.590     1.03004     1.02205e-12     4.76983e-14
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       3.57334e-09        0.000000         5.65052e-12          1.00000       627.998     110.685     1.03004     1.02583e-12     4.76983e-14
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       3.61639e-09        0.000000         5.71860e-12          1.00000       627.998     109.780     1.03004     1.02970e-12     4.76983e-14
   1.80000e-01        8.20000e-01        5.73117e-02        9.42688e-01       3.66050e-09        0.000000         5.78834e-12          1.00000       627.998     108.875     1.03004     1.03366e-12     4.76983e-14
   1.90000e-01        8.10000e-01        6.10028e-02        9.38997e-01       3.70569e-09        0.000000         5.85980e-12          1.00000       627.998     107.970     1.03004     1.03773e-12     4.76983e-14
   2.00000e-01        8.00000e-01        6.47563e-02        9.35244e-01       3.75201e-09        0.000000         5.93305e-12          1.00000       627.998     107.065     1.03004     1.04189e-12     4.76983e-14
   2.10000e-01        7.90000e-01        6.85737e-02        9.31426e-01       3.79950e-09        0.000000         6.00815e-12          1.00000       627.998     106.160     1.03004     1.04616e-12     4.76983e-14
   2.20000e-01        7.80000e-01        7.24568e-02        9.27543e-01       3.84821e-09        0.000000         6.08518e-12          1.00000       627.998     105.255     1.03004     1.05054e-12     4.76983e-14
   2.30000e-01        7.70000e-01        7.64072e-02        9.23593e-01       3.89819e-09        0.000000         6.16421e-12          1.00000       627.998     104.350     1.03004     1.05503e-12     4.76983e-14
   2.40000e-01        7.60000e-01        8.04268e-02        9.19573e-01       3.94948e-09        0.000000         6.24531e-12          1.00000       627.998     103.445     1.03004     1.05965e-12     4.76983e-14
   2.50000e-01        7.50000e-01        8.45173e-02        9.15483e-01       4.00214e-09        0.000000         6.32859e-12          1.00000       627.998     102.540     1.03004     1.06438e-12     4.76983e-14
   2.60000e-01        7.40000e-01        8.86807e-02        9.11319e-01       4.05623e-09        0.000000         6.41411e-12          1.00000       627.998     101.635     1.03004     1.06924e-12     4.76983e-14
   2.70000e-01        7.30000e-01        9.29189e-02        9.07081e-01       4.11179e-09        0.000000         6.50197e-12          1.00000       627.998     100.730     1.03004     1.07424e-12     4.76983e-14
   2.80000e-01        7.20000e-01        9.72339e-02        9.02766e-01       4.16890e-09        0.000000         6.59228e-12          1.00000       627.998      99.825     1.03004     1.07937e-12     4.76983e-14
   2.90000e-01        7.10000e-01        1.01628e-01        8.98372e-01       4.22762e-09        0.000000         6.68513e-12          1.00000       627.998      98.920     1.03004     1.08465e-12     4.76983e-14
   3.00000e-01        7.00000e-01        1.06103e-01        8.93897e-01       4.28801e-09        0.000000         6.78063e-12          1.00000       627.998      98.015     1.03004     1.09008e-12     4.76983e-14
   3.10000e-01        6.90000e-01        1.10662e-01        8.89338e-01       4.35016e-09        0.000000         6.87890e-12          1.00000       627.998      97.110     1.03004     1.09567e-12     4.76983e-14
   3.20000e-01        6.80000e-01        1.15306e-01        8.84694e-01       4.41413e-09        0.000000         6.98006e-12          1.00000       627.998      96.205     1.03004     1.10142e-12     4.76983e-14
   3.30000e-01        6.70000e-01        1.20038e-01        8.79962e-01       4.48001e-09        0.000000         7.08424e-12          1.00000       627.998      95.300     1.03004     1.10735e-12     4.76983e-14
   3.40000e-01        6.60000e-01        1.24862e-01        8.75138e-01       4.54789e-09        0.000000         7.19157e-12          1.00000       627.998      94.395     1.03004     1.11345e-12     4.76983e-14
   3.50000e-01        6.50000e-01        1.29778e-01        8.70222e-01       4.61786e-09        0.000000         7.30221e-12          1.00000       627.998      93.490     1.03004     1.11974e-12     4.76983e-14
   3.60000e-01        6.40000e-01        1.34791e-01        8.65209e-01       4.69001e-09        0.000000         7.41631e-12          1.00000       627.998      92.585     1.03004     1.12623e-12     4.76983e-14
   3.70000e-01        6.30000e-01        1.39903e-01        8.60097e-01       4.76446e-09        0.000000         7.53403e-12          1.00000       627.998      91.680     1.03004     1.13292e-12     4.76983e-14
   3.80000e-01        6.20000e-01        1.45116e-01        8.54884e-01       4.84130e-09        0.000000         7.65555e-12          1.00000       627.998      90.775     1.03004     1.13983e-12     4.76983e-14
   3.90000e-01        6.10000e-01        1.50435e-01        8.49565e-01       4.92067e-09        0.000000         7.78105e-12          1.00000       627.998      89.870     1.03004     1.14697e-12     4.76983e-14
   4.00000e-01        6.00000e-01        1.55862e-01        8.44138e-01       5.00268e-09        0.000000         7.91073e-12          1.00000       627.998      88.965     1.03004     1.15434e-12     4.76983e-14
   4.10000e-01        5.90000e-01        1.61400e-01        8.38600e-01       5.08747e-09        0.000000         8.04481e-12          1.00000       627.998      88.060     1.03004     1.16196e-12     4.76983e-14
   4.20000e-01        5.80000e-01        1.67053e-01        8.32947e-01       5.17519e-09        0.000000         8.18352e-12          1.00000       627.998      87.155     1.03004     1.16985e-12     4.76983e-14
   4.30000e-01        5.70000e-01        1.72825e-01        8.27175e-01       5.26598e-09        0.000000         8.32709e-12          1.00000       627.998      86.250     1.03004     1.17801e-12     4.76983e-14
   4.40000e-01        5.60000e-01        1.78720e-01        8.21280e-01       5.36001e-09        0.000000         8.47578e-12          1.00000       627.998      85.345     1.03004     1.18647e-12     4.76983e-14
   4.50000e-01        5.50000e-01        1.84741e-01        8.15259e-01       5.45747e-09        0.000000         8.62989e-12          1.00000       627.998      84.440     1.03004     1.19523e-12     4.76983e-14
   4.60000e-01        5.40000e-01        1.90892e-01        8.09108e-01       5.55853e-09        0.000000         8.78970e-12          1.00000       627.998      83.535     1.03004     1.20432e-12     4.76983e-14
   4.70000e-01        5.30000e-01        1.97178e-01        8.02822e-01       5.66341e-09        0.000000         8.95555e-12          1.00000       627.998      82.630     1.03004     1.21375e-12     4.76983e-14
   4.80000e-01        5.20000e-01        2.03603e-01        7.96397e-01       5.77232e-09        0.000000         9.12777e-12          1.00000       627.998      81.725     1.03004     1.22354e-12     4.76983e-14
   4.90000e-01        5.10000e-01        2.10172e-01        7.89828e-01       5.88551e-09        0.000000         9.30674e-12          1.00000       627.998      80.820     1.03004     1.23371e-12     4.76983e-14
   5.00000e-01        5.00000e-01        2.16890e-01        7.83110e-01       6.00322e-09        0.000000         9.49288e-12          1.00000       627.998      79.915     1.03004     1.24430e-12     4.76983e-14
   5.10000e-01        4.90000e-01        2.23762e-01        7.76238e-01       6.12573e-09        0.000000         9.68661e-12          1.00000       627.998      79.010     1.03004     1.25531e-12     4.76983e-14
   5.20000e-01        4.80000e-01        2.30793e-01        7.69207e-01       6.25335e-09        0.000000         9.88841e-12          1.00000       627.998      78.105     1.03004     1.26679e-12     4.76983e-14
   5.30000e-01        4.70000e-01        2.37989e-01        7.62011e-01       6.38640e-09        0.000000         1.00988e-11          1.00000       627.998      77.200     1.03004     1.27875e-12     4.76983e-14
   5.40000e-01        4.60000e-01        2.45355e-01        7.54645e-01       6.52523e-09        0.000000         1.03183e-11          1.00000       627.998      76.295     1.03004     1.29123e-12     4.76983e-14
   5.50000e-01        4.50000e-01        2.52899e-01        7.47101e-01       6.67024e-09        0.000000         1.05476e-11          1.00000       627.998      75.390     1.03004     1.30427e-12     4.76983e-14
   5.60000e-01        4.40000e-01        2.60625e-01        7.39375e-01       6.82184e-09        0.000000         1.07874e-11          1.00000       627.998      74.485     1.03004     1.31790e-12     4.76983e-14
   5.70000e-01        4.30000e-01        2.68542e-01        7.31458e-01       6.98048e-09        0.000000         1.10382e-11          1.00000       627.998      73.580     1.03004     1.33216e-12     4.76983e-14
   5.80000e-01        4.20000e-01        2.76656e-01        7.23344e-01       7.14668e-09        0.000000         1.13010e-11          1.00000       627.998      72.675     1.03004     1.34711e-12     4.76983e-14
   5.90000e-01        4.10000e-01        2.84975e-01        7.15025e-01       7.32099e-09        0.000000         1.15767e-11          1.00000       627.998      71.770     1.03004     1.36278e-12     4.76983e-14
   6.00000e-01        4.00000e-01        2.93506e-01        7.06494e-01       7.50402e-09        0.000000         1.18661e-11          1.00000       627.998      70.865     1.03004     1.37924e-12     4.76983e-14
   6.10000e-01        3.90000e-01        3.02258e-01        6.97742e-01       7.69643e-09        0.000000         1.21704e-11          1.00000       627.998      69.960     1.03004     1.39654e-12     4.76983e-14
   6.20000e-01        3.80000e-01        3.11239e-01        6.88761e-01       7.89897e-09        0.000000         1.24906e-11          1.00000       627.998      69.055     1.03004     1.41475e-12     4.76983e-14
   6.30000e-01        3.70000e-01        3.20458e-01        6.79542e-01       8.11245e-09        0.000000         1.28282e-11          1.00000       627.998      68.150     1.03004     1.43394e-12     4.76983e-14
   6.40000e-01        3.60000e-01        3.29926e-01        6.70074e-01       8.33780e-09        0.000000         1.31846e-11          1.00000       627.998      67.245     1.03004     1.45420e-12     4.76983e-14
   6.50000e-01        3.50000e-01        3.39652e-01        6.60348e-01       8.57602e-09        0.000000         1.35613e-11          1.00000       627.998      66.340     1.03004     1.47562e-12     4.76983e-14
   6.60000e-01        3.40000e-01        3.49648e-01        6.50352e-01       8.82826e-09        0.000000         1.39601e-11          1.00000       627.998      65.435     1.03004     1.49830e-12     4.76983e-14
   6.70000e-01        3.30000e-01        3.59923e-01        6.40077e-01       9.09578e-09        0.000000         1.43831e-11          1.00000       627.998      64.530     1.03004     1.52235e-12     4.76983e-14
   6.80000e-01        3.20000e-01        3.70491e-01        6.29509e-01       9.38002e-09        0.000000         1.48326e-11          1.00000       627.998      63.625     1.03004     1.54791e-12     4.76983e-14
   6.90000e-01        3.10000e-01        3.81364e-01        6.18636e-01       9.68261e-09        0.000000         1.53111e-11          1.00000       627.998      62.720     1.03004     1.57511e-12     4.76983e-14
   7.00000e-01        3.00000e-01        3.92555e-01        6.07445e-01       1.00054e-08        0.000000         1.58215e-11          1.00000       627.998      61.815     1.03004     1.60413e-12     4.76983e-14
   7.10000e-01        2.90000e-01        4.04079e-01        5.95921e-01       1.03504e-08        0.000000         1.63670e-11          1.00000       627.998      60.910     1.03004     1.63515e-12     4.76983e-14
   7.20000e-01        2.80000e-01        4.15950e-01        5.84050e-01       1.07200e-08        0.000000         1.69516e-11          1.00000       627.998      60.005     1.03004     1.66839e-12     4.76983e-14
   7.30000e-01        2.70000e-01        4.28185e-01        5.71815e-01       1.11171e-08        0.000000         1.75794e-11          1.00000       627.998      59.100     1.03004     1.70409e-12     4.76983e-14
   7.40000e-01        2.60000e-01        4.40800e-01        5.59200e-01       1.15446e-08        0.000000         1.82555e-11          1.00000       627.998      58.195     1.03004     1.74253e-12     4.76983e-14
   7.50000e-01        2.50000e-01        4.53814e-01        5.46186e-01       1.20064e-08        0.000000         1.89858e-11          1.00000       627.998      57.290     1.03004     1.78405e-12     4.76983e-14
   7.60000e-01        2.40000e-01        4.67246e-01        5.32754e-01       1.25067e-08        0.000000         1.97768e-11          1.00000       627.998      56.385     1.03004     1.82903e-12     4.76983e-14
   7.70000e-01        2.30000e-01        4.81116e-01        5.18884e-01       1.30505e-08        0.000000         2.06367e-11          1.00000       627.998      55.480     1.03004     1.87792e-12     4.76983e-14
   7.80000e-01        2.20000e-01        4.95446e-01        5.04554e-01       1.36437e-08        0.000000         2.15747e-11          1.00000       627.998      54.575     1.03004     1.93126e-12     4.76983e-14
   7.90000e-01        2.10000e-01        5.10259e-01        4.89741e-01       1.42934e-08        0.000000         2.26021e-11          1.00000       627.998      53.670     1.03004     1.98967e-12     4.76983e-14
   8.00000e-01        2.00000e-01        5.25581e-01        4.74419e-01       1.50080e-08        0.000000         2.37322e-11          1.00000       627.998      52.765     1.03004     2.05393e-12     4.76983e-14
   8.10000e-01        1.90000e-01        5.41437e-01        4.58563e-01       1.57979e-08        0.000000         2.49813e-11          1.00000       627.998      51.860     1.03004     2.12495e-12     4.76983e-14
   8.20000e-01        1.80000e-01        5.57856e-01        4.42144e-01       1.66756e-08        0.000000         2.63691e-11          1.00000       627.998      50.955     1.03004     2.20386e-12     4.76983e-14
   8.30000e-01        1.70000e-01        5.74869e-01        4.25131e-01       1.76565e-08        0.000000         2.79202e-11          1.00000       627.998      50.050     1.03004     2.29205e-12     4.76983e-14
   8.40000e-01        1.60000e-01        5.92509e-01        4.07491e-01       1.87600e-08        0.000000         2.96652e-11          1.00000       627.998      49.145     1.03004     2.39127e-12     4.76983e-14
   8.50000e-01        1.50000e-01        6.10810e-01        3.89190e-01       2.00107e-08        0.000000         3.16429e-11          1.00000       627.998      48.240     1.03004     2.50372e-12     4.76983e-14
   8.60000e-01        1.40000e-01        6.29811e-01        3.70189e-01       2.14401e-08        0.000000         3.39031e-11          1.00000       627.998      47.335     1.03004     2.63223e-12     4.76983e-14
   8.70000e-01        1.30000e-01        6.49553e-01        3.50447e-01       2.30893e-08        0.000000         3.65111e-11          1.00000       627.998      46.430     1.03004     2.78051e-12     4.76983e-14
   8.80000e-01        1.20000e-01        6.70080e-01        3.29920e-01       2.50134e-08        0.000000         3.95537e-11          1.00000       627.998      45.525     1.03004     2.95351e-12     4.76983e-14
   8.90000e-01        1.10000e-01        6.91440e-01        3.08560e-01       2.72873e-08        0.000000         4.31494e-11          1.00000       627.998      44.620     1.03004     3.15796e-12     4.76983e-14
   9.00000e-01        1.00000e-01        7.13684e-01        2.86316e-01       3.00161e-08        0.000000         4.74644e-11          1.00000       627.998      43.715     1.03004     3.40331e-12     4.76983e-14
   9.10000e-01        9.00000e-02        7.36868e-01        2.63132e-01       3.33512e-08        0.000000         5.27382e-11          1.00000       627.998      42.810     1.03004     3.70317e-12     4.76983e-14
   9.20000e-01        8.00000e-02        7.61054e-01        2.38946e-01       3.75201e-08        0.000000         5.93305e-11          1.00000       627.998      41.905     1.03004     4.07800e-12     4.76983e-14
   9.30000e-01        7.00000e-02        7.86307e-01        2.13693e-01       4.28801e-08        0.000000         6.78063e-11          1.00000       627.998      41.001     1.03004     4.55992e-12     4.76983e-14
   9.40000e-01        6.00000e-02        8.12700e-01        1.87300e-01       5.00268e-08        0.000000         7.91073e-11          1.00000       627.998      40.096     1.03004     5.20248e-12     4.76983e-14
   9.50000e-01        5.00000e-02        8.40313e-01        1.59687e-01       6.00322e-08        0.000000         9.49288e-11          1.00000       627.998      39.191     1.03004     6.10206e-12     4.76983e-14
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       7.50402e-08        0.000000         1.18661e-10          1.00000       627.998      38.286     1.03004     7.45144e-12     4.76983e-14
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       1.00054e-07        0.000000         1.58215e-10          1.00000       627.998      37.381     1.03004     9.70041e-12     4.76983e-14
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       1.50080e-07        0.000000         2.37322e-10          1.00000       627.998      36.476     1.03004     1.41983e-11     4.76983e-14
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       3.00161e-07        0.000000         4.74644e-10          1.00000       627.998      35.571     1.03004     2.76921e-11     4.76983e-14
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       6.00322e-07        0.000000         9.49288e-10          1.00000       627.998      35.118     1.03004     5.46797e-11     4.76983e-14
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.50080e-06        0.000000         2.37322e-09          1.00000       627.998      34.847     1.03004     1.35642e-10     4.76983e-14
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       3.00161e-06        0.000000         4.74644e-09          1.00000       627.998      34.756     1.03004     2.70580e-10     4.76983e-14
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       6.00322e-06        0.000000         9.49288e-09          1.00000       627.998      34.711     1.03004     5.40456e-10     4.76983e-14
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.50080e-05        0.000000         2.37322e-08          1.00000       627.998      34.684     1.03004     1.35008e-09     4.76983e-14
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       3.00161e-05        0.000000         4.74644e-08          1.00000       627.998      34.675     1.03004     2.69946e-09     4.76983e-14
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       6.00322e-05        0.000000         9.49288e-08          1.00000       627.998      34.670     1.03004     5.39823e-09     4.76983e-14
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.50081e-04        0.000000         2.37322e-07          1.00000       627.998      34.667     1.03004     1.34945e-08     4.76983e-14
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       3.00162e-04        0.000000         4.74645e-07          1.00000       627.998      34.666     1.03004     2.69884e-08     4.76984e-14
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       6.00325e-04        0.000000         9.49292e-07          1.00000       627.997      34.666     1.03004     5.39762e-08     4.76986e-14
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.50082e-03        0.000000         2.37325e-06          1.00000       627.997      34.666     1.03004     1.34941e-07     4.76990e-14
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       3.00169e-03        0.000000         4.74655e-06          1.00000       627.995      34.666     1.03004     2.69884e-07     4.76998e-14
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       6.00354e-03        0.000000         9.49331e-06          1.00000       627.992      34.666     1.03004     5.39783e-07     4.77013e-14
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.50101e-02        0.000000         2.37349e-05          0.99999       627.984      34.666     1.03004     1.34957e-06     4.77059e-14
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       3.00242e-02        0.000000         4.74753e-05          0.99999       627.970      34.666     1.03004     2.69953e-06     4.77136e-14
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       6.00648e-02        0.000000         9.49724e-05          0.99997       627.941      34.666     1.03004     5.40059e-06     4.77290e-14
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.50285e-01        0.000000         2.37595e-04          0.99994       627.856      34.666     1.03003     1.35130e-05     4.77751e-14
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       3.00979e-01        0.000000         4.75738e-04          0.99987       627.714      34.666     1.03001     2.70647e-05     4.78523e-14
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.03610e-01        0.000000         9.53681e-04          0.99974       627.428      34.666     1.02998     5.42848e-05     4.80078e-14
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.52162e+00        0.000000         2.40101e-03          0.99935       626.563      34.666     1.02988     1.36898e-04     4.84825e-14
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       3.08670e+00        0.000000         4.85993e-03          0.99869       625.091      34.666     1.02972     2.77891e-04     4.93031e-14
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       6.35938e+00        0.000000         9.96690e-03          0.99730       622.023      34.666     1.02937     5.73324e-04     5.10663e-14
   1.00000e+00        3.12195e-10        1.00000e+00        1.12722e-09       1.05834e+01        0.000000         1.64894e-02          0.99550       618.086      34.666     1.02893     9.55864e-04     5.34397e-14
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.76132e+01        0.000000         2.71734e-02          0.99250       611.591      34.666     1.02817     1.59558e-03     5.76478e-14
   1.00000e+00        1.37199e-10        1.00000e+00        4.95375e-10       2.83176e+01        0.000000         4.30395e-02          0.98792       601.833      34.666     1.02702     2.57718e-03     6.47313e-14
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       4.55277e+01        0.000000         6.75557e-02          0.98053       586.477      34.666     1.02512     4.17471e-03     7.80847e-14
   1.00000e+00        8.20786e-11        1.00000e+00        2.96355e-10       6.90456e+01        0.000000         9.91561e-02          0.97035       566.141      34.666     1.02248     6.39758e-03     1.01149e-13
   1.00000e+00        7.58320e-11        1.00000e+00        2.73801e-10       1.04712e+02        0.000000         1.43133e-01          0.95477       536.679      34.666     1.01831     9.86071e-03     1.50635e-13
   1.00000e+00        7.58320e-11        1.00000e+00        2.73801e-10       1.04738e+02        0.000000         1.43164e-01          0.95476       536.658      34.666     1.01831     9.86328e-03     1.50679e-13
   1.00000e+00        8.05559e-11        1.00000e+00        2.90858e-10       1.43890e+02        0.000000         1.86374e-01          0.93742       506.156      34.666     1.01354     1.38009e-02     2.35302e-13
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.97677e+02        0.000000         2.37970e-01          0.91318       467.226      34.666     1.00664     1.94631e-02     4.40950e-13
   1.00000e+00        1.31656e-10        1.00000e+00        4.75362e-10       2.45735e+02        0.000000         2.77338e-01          0.89107       435.200      34.666     1.00013     2.47949e-02     7.85972e-13
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       3.05475e+02        0.000000         3.18650e-01          0.86295       398.817      34.666     0.99162     3.18273e-02     1.65243e-12
   1.00000e+00        2.98090e-10        1.00000e+00        1.07629e-09       3.55012e+02        0.000000         3.47452e-01          0.83903       371.402      34.666     0.98425     3.80429e-02     3.13085e-12
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       4.12582e+02        0.000000         3.75837e-01          0.81048       342.574      34.666     0.97539     4.57699e-02     6.77417e-12
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       4.81558e+02        0.000000         4.04357e-01          0.77505       312.281      34.666     0.96459     5.58639e-02     1.78885e-11
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       5.43486e+02        0.000000         4.26720e-01          0.74195       289.124      34.666     0.95508     6.58607e-02     4.49035e-11
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       6.16806e+02        0.000000         4.52136e-01          0.70092       267.043      34.666     0.94487     7.91211e-02     1.42807e-10
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       6.66876e+02        0.000000         4.70841e-01          0.67159       255.668      34.666     0.93920     8.92798e-02     3.29778e-10
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.12973e+02        0.000000         4.90571e-01          0.64353       248.158      34.666     0.93543     9.96127e-02     7.39777e-10
   1.00000e+00        4.16780e-08        1.00000e+00        1.50484e-07       7.58023e+02        0.000000         5.13415e-01          0.61506       243.759      34.666     0.93344     1.10809e-01     1.69349e-09
   1.00000e+00        4.16780e-08        1.00000e+00        1.50484e-07       7.58023e+02        0.000000         1.99677e-01          0.61506        40.076      34.666     0.39460     1.10809e-01     1.76447e-06
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       7.60372e+02        0.000000         2.01096e-01          0.61355        39.753      34.666     0.38986     1.11426e-01     2.07453e-06
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       7.61332e+02        0.000000         2.01682e-01          0.61293        39.631      34.666     0.38802     1.11679e-01     2.21249e-06
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       7.61789e+02        0.000000         2.01962e-01          0.61264        39.575      34.666     0.38717     1.11800e-01     2.28053e-06
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       7.62056e+02        0.000000         2.02126e-01          0.61246        39.542      34.666     0.38667     1.11871e-01     2.32109e-06
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       7.62144e+02        0.000000         2.02180e-01          0.61241        39.532      34.666     0.38651     1.11894e-01     2.33457e-06
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       7.62187e+02        0.000000         2.02207e-01          0.61238        39.527      34.666     0.38643     1.11906e-01     2.34130e-06
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       7.62214e+02        0.000000         2.02223e-01          0.61236        39.524      34.666     0.38638     1.11913e-01     2.34534e-06
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       7.62222e+02        0.000000         2.02229e-01          0.61236        39.522      34.666     0.38636     1.11915e-01     2.34668e-06
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       7.62227e+02        0.000000         2.02231e-01          0.61235        39.522      34.666     0.38635     1.11916e-01     2.34735e-06
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       7.62229e+02        0.000000         2.02233e-01          0.61235        39.522      34.666     0.38635     1.11917e-01     2.34776e-06
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       7.62230e+02        0.000000         2.02233e-01          0.61235        39.522      34.666     0.38635     1.11917e-01     2.34789e-06
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       7.62231e+02        0.000000         2.02234e-01          0.61235        39.521      34.666     0.38635     1.11917e-01     2.34796e-06
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       7.62231e+02        0.000000         2.02234e-01          0.61235        39.521      34.666     0.38635     1.11917e-01     2.34800e-06
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       7.62231e+02        0.000000         2.02234e-01          0.61235        39.521      34.666     0.38635     1.11917e-01     2.34801e-06
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       7.62231e+02        0.000000         2.02234e-01          0.61235        39.521      34.666     0.38635     1.11917e-01     2.34803e-06
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.00000e+00        0.00000e+00        1.00000e+00        0.00000e+00       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        1.00000e-12        1.00000e+00        3.61063e-12       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        2.00000e-12        1.00000e+00        7.22126e-12       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        5.00000e-12        1.00000e+00        1.80532e-11       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        1.00000e-11        1.00000e+00        3.61063e-11       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        2.00000e-11        1.00000e+00        7.22126e-11       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        5.00000e-11        1.00000e+00        1.80532e-10       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        1.00000e-10        1.00000e+00        3.61063e-10       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        2.00000e-10        1.00000e+00        7.22126e-10       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        5.00000e-10        1.00000e+00        1.80532e-09       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        1.00000e-09        1.00000e+00        3.61063e-09       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        2.00000e-09        1.00000e+00        7.22126e-09       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        5.00000e-09        1.00000e+00        1.80532e-08       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23826e-01     1.18361e-01
   1.00000e+00        1.00000e-08        1.00000e+00        3.61063e-08       1.06118e+03        0.000000         3.60611e-01          0.42627        35.479      34.666     0.27079     2.23827e-01     1.18361e-01
   1.00000e+00        2.00000e-08        1.00000e+00        7.22126e-08       1.06118e+03        0.000000         3.60610e-01          0.42627        35.479      34.666     0.27079     2.23827e-01     1.18362e-01
   1.00000e+00        5.00000e-08        1.00000e+00        1.80532e-07       1.06118e+03        0.000000         3.60610e-01          0.42627        35.479      34.666     0.27079     2.23828e-01     1.18363e-01
   1.00000e+00        1.00000e-07        1.00000e+00        3.61063e-07       1.06119e+03        0.000000         3.60609e-01          0.42627        35.479      34.666     0.27079     2.23830e-01     1.18366e-01
   1.00000e+00        2.00000e-07        9.99999e-01        7.22126e-07       1.06120e+03        0.000000         3.60608e-01          0.42626        35.479      34.666     0.27080     2.23834e-01     1.18372e-01
   1.00000e+00        5.00000e-07        9.99998e-01        1.80531e-06       1.06122e+03        0.000000         3.60603e-01          0.42625        35.479      34.666     0.27081     2.23847e-01     1.18390e-01
   9.99999e-01        1.00000e-06        9.99996e-01        3.61062e-06       1.06127e+03        0.000000         3.60596e-01          0.42623        35.479      34.666     0.27083     2.23867e-01     1.18419e-01
   9.99998e-01        2.00000e-06        9.99993e-01        7.22122e-06       1.06136e+03        0.000000         3.60581e-01          0.42619        35.480      34.666     0.27086     2.23908e-01     1.18476e-01
   9.99995e-01        5.00000e-06        9.99982e-01        1.80529e-05       1.06164e+03        0.000000         3.60537e-01          0.42608        35.481      34.666     0.27098     2.24029e-01     1.18645e-01
   9.99990e-01        1.00000e-05        9.99964e-01        3.61054e-05       1.06209e+03        0.000000         3.60461e-01          0.42588        35.482      34.666     0.27116     2.24231e-01     1.18916e-01
   9.99981e-01        1.94867e-05        9.99930e-01        7.03558e-05       1.06295e+03        0.000000         3.60313e-01          0.42552        35.486      34.667     0.27152     2.24607e-01     1.19391e-01
   9.99981e-01        1.94867e-05        9.99930e-01        7.03558e-05       1.06295e+03        0.000000         7.74433e-01          0.42552       267.488      34.667     0.95224     2.24607e-01     1.07680e-06
   9.99980e-01        2.00000e-05        9.99928e-01        7.22088e-05       1.06440e+03        0.000000         7.75791e-01          0.42497       267.616      34.667     0.95232     2.25208e-01     1.10639e-06
   9.99950e-01        5.00000e-05        9.99819e-01        1.80508e-04       1.12163e+03        0.000000         8.27125e-01          0.40770       271.551      34.670     0.95508     2.47384e-01     2.88954e-06
   9.99900e-01        1.00000e-04        9.99639e-01        3.60969e-04       1.17619e+03        0.000000         8.72464e-01          0.39823       273.623      34.675     0.95674     2.65626e-01     6.01658e-06
   9.99800e-01        2.00000e-04        9.99278e-01        7.21749e-04       1.24647e+03        0.000000         9.26978e-01          0.39289       274.677      34.684     0.95796     2.85400e-01     1.26295e-05
   9.99500e-01        5.00000e-04        9.98197e-01        1.80296e-03       1.37887e+03        0.000000         1.02222e+00          0.39473       274.052      34.711     0.95879     3.14483e-01     3.42042e-05
   9.99000e-01        1.00000e-03        9.96399e-01        3.60123e-03       1.52843e+03        0.000000         1.12306e+00          0.40600       271.603      34.756     0.95872     3.39358e-01     7.38442e-05
   9.98551e-01        1.44906e-03        9.94788e-01        5.21229e-03       1.63574e+03        0.000000         1.19263e+00          0.41706       269.414      34.797     0.95839     3.53971e-01     1.12277e-04
   9.98000e-01        2.00000e-03        9.92816e-01        7.18375e-03       1.75057e+03        0.000000         1.26519e+00          0.43045       266.921      34.847     0.95790     3.67561e-01     1.62372e-04
   9.97171e-01        2.82868e-03        9.89862e-01        1.01384e-02       1.90371e+03        0.000000         1.35947e+00          0.44988       263.537      34.922     0.95716     3.83277e-01     2.42905e-04
   9.96173e-01        3.82711e-03        9.86318e-01        1.36816e-02       2.07023e+03        0.000000         1.45933e+00          0.47226       259.908      35.012     0.95630     3.98075e-01     3.47128e-04
   9.95000e-01        5.00000e-03        9.82179e-01        1.78205e-02       2.25133e+03        0.000000         1.56526e+00          0.49752       256.098      35.118     0.95537     4.12164e-01     4.78483e-04
   9.93537e-01        6.46311e-03        9.77051e-01        2.29487e-02       2.46443e+03        0.000000         1.68682e+00          0.52800       251.840      35.250     0.95430     4.26736e-01     6.54620e-04
   9.91869e-01        8.13127e-03        9.71251e-01        2.87487e-02       2.69770e+03        0.000000         1.81656e+00          0.56195       247.470      35.401     0.95319     4.40791e-01     8.70864e-04
   9.90000e-01        1.00000e-02        9.64812e-01        3.51877e-02       2.95306e+03        0.000000         1.95510e+00          0.59954       243.026      35.571     0.95207     4.54423e-01     1.13153e-03
   9.88544e-01        1.14562e-02        9.59837e-01        4.01630e-02       3.15058e+03        0.000000         2.06006e+00          0.62881       239.817      35.702     0.95127     4.63961e-01     1.34765e-03
   9.86994e-01        1.30061e-02        9.54582e-01        4.54182e-02       3.36130e+03        0.000000         2.17015e+00          0.66016       236.597      35.843     0.95047     4.73334e-01     1.58990e-03
   9.85356e-01        1.46436e-02        9.49074e-01        5.09259e-02       3.58612e+03        0.000000         2.28565e+00          0.69371       233.377      35.991     0.94970     4.82557e-01     1.85936e-03
   9.83639e-01        1.63613e-02        9.43345e-01        5.66548e-02       3.82598e+03        0.000000         2.40690e+00          0.72958       230.167      36.146     0.94894     4.91639e-01     2.15684e-03
   9.81850e-01        1.81503e-02        9.37431e-01        6.25692e-02       4.08188e+03        0.000000         2.53423e+00          0.76789       226.978      36.308     0.94822     5.00586e-01     2.48284e-03
   9.80000e-01        2.00000e-02        9.31371e-01        6.86293e-02       4.35490e+03        0.000000         2.66804e+00          0.80878       223.819      36.476     0.94754     5.09402e-01     2.83740e-03
   9.78368e-01        2.16318e-02        9.26071e-01        7.39294e-02       4.60449e+03        0.000000         2.78872e+00          0.84616       221.133      36.623     0.94698     5.16886e-01     3.16515e-03
   9.76709e-01        2.32911e-02        9.20725e-01        7.92751e-02       4.86839e+03        0.000000         2.91480e+00          0.88567       218.484      36.773     0.94647     5.24274e-01     3.51310e-03
   9.75032e-01        2.49683e-02        9.15365e-01        8.46346e-02       5.14741e+03        0.000000         3.04661e+00          0.92740       215.879      36.925     0.94601     5.31565e-01     3.88023e-03
   9.73347e-01        2.66532e-02        9.10026e-01        8.99742e-02       5.44242e+03        0.000000         3.18450e+00          0.97146       213.324      37.078     0.94559     5.38755e-01     4.26512e-03
   9.71666e-01        2.83344e-02        9.04741e-01        9.52586e-02       5.75434e+03        0.000000         3.32885e+00          1.01796       210.827      37.230     0.94523     5.45843e-01     4.66593e-03
   9.70000e-01        3.00000e-02        8.99548e-01        1.00452e-01       6.08414e+03        0.000000         3.48010e+00          1.06701       208.393      37.381     0.94494     5.52825e-01     5.06725e-03
   9.68586e-01        3.14143e-02        8.95172e-01        1.04828e-01       6.38371e+03        0.000000         3.61643e+00          1.11145       206.350      37.509     0.94473     5.58759e-01     5.40480e-03
   9.67201e-01        3.27991e-02        8.90915e-01        1.09085e-01       6.69803e+03        0.000000         3.75854e+00          1.15795       204.363      37.634     0.94459     5.64608e-01     5.74538e-03
   9.65854e-01        3.41458e-02        8.86803e-01        1.13197e-01       7.02783e+03        0.000000         3.90680e+00          1.20659       202.436      37.756     0.94449     5.70370e-01     6.08672e-03
   9.64554e-01        3.54455e-02        8.82859e-01        1.17141e-01       7.37386e+03        0.000000         4.06156e+00          1.25744       200.572      37.873     0.94446     5.76042e-01     6.42635e-03
   9.63311e-01        3.66894e-02        8.79107e-01        1.20893e-01       7.73694e+03        0.000000         4.22324e+00          1.31058       198.777      37.986     0.94450     5.81622e-01     6.76160e-03
   9.62131e-01        3.78688e-02        8.75571e-01        1.24429e-01       8.11788e+03        0.000000         4.39227e+00          1.36609       197.051      38.093     0.94459     5.87107e-01     7.08968e-03
   9.61025e-01        3.89750e-02        8.72272e-01        1.27728e-01       8.51759e+03        0.000000         4.56911e+00          1.42405       195.400      38.193     0.94476     5.92494e-01     7.40769e-03
   9.60000e-01        4.00000e-02        8.69230e-01        1.30770e-01       8.93698e+03        0.000000         4.75426e+00          1.48455       193.826      38.286     0.94500     5.97781e-01     7.71268e-03
   9.59063e-01        4.09372e-02        8.66462e-01        1.33538e-01       9.37760e+03        0.000000         4.94849e+00          1.54775       192.329      38.370     0.94531     6.02973e-01     8.00206e-03
   9.58222e-01        4.17781e-02        8.63989e-01        1.36011e-01       9.83995e+03        0.000000         5.15216e+00          1.61366       190.914      38.446     0.94570     6.08061e-01     8.27255e-03
   9.57483e-01        4.25168e-02        8.61825e-01        1.38175e-01       1.03251e+04        0.000000         5.36586e+00          1.68238       189.582      38.513     0.94616     6.13045e-01     8.52138e-03
   9.56852e-01        4.31478e-02        8.59981e-01        1.40019e-01       1.08341e+04        0.000000         5.59023e+00          1.75399       188.336      38.570     0.94670     6.17923e-01     8.74602e-03
   9.56333e-01        4.36672e-02        8.58468e-01        1.41532e-01       1.13683e+04        0.000000         5.82595e+00          1.82859       187.177      38.617     0.94731     6.22695e-01     8.94420e-03
   9.55928e-01        4.40722e-02        8.57291e-01        1.42709e-01       1.19288e+04        0.000000         6.07375e+00          1.90628       186.105      38.654     0.94800     6.27362e-01     9.11399e-03
   9.55639e-01        4.43610e-02        8.56453e-01        1.43547e-01       1.25169e+04        0.000000         6.33438e+00          1.98716       185.121      38.680     0.94877     6.31924e-01     9.25384e-03
   9.55467e-01        4.45335e-02        8.55953e-01        1.44047e-01       1.31341e+04        0.000000         6.60865e+00          2.07136       184.224      38.696     0.94961     6.36383e-01     9.36265e-03
   9.55409e-01        4.45907e-02        8.55787e-01        1.44213e-01       1.37816e+04        0.000000         6.89741e+00          2.15899       183.415      38.701     0.95052     6.40741e-01     9.43976e-03
   9.57796e-01        4.22036e-02        8.62741e-01        1.37259e-01       1.91616e+04        0.000000         9.34018e+00          2.86290       180.131      38.485     0.95846     6.68079e-01     9.15205e-03
   9.63444e-01        3.65557e-02        8.79510e-01        1.20490e-01       2.66417e+04        0.000000         1.28623e+01          3.79278       180.265      37.974     0.96842     6.91832e-01     7.83814e-03
   9.69991e-01        3.00090e-02        8.99520e-01        1.00480e-01       3.70418e+04        0.000000         1.79461e+01          5.03764       182.868      37.381     0.97898     7.12905e-01     6.20818e-03
   9.75929e-01        2.40709e-02        9.18227e-01        8.17726e-02       5.15019e+04        0.000000         2.52529e+01          6.72626       186.965      36.844     0.98897     7.31691e-01     4.74110e-03
   9.80707e-01        1.92934e-02        9.33679e-01        6.63210e-02       7.16067e+04        0.000000         3.56885e+01          9.03825       191.725      36.412     0.99773     7.48206e-01     3.60221e-03
   9.84314e-01        1.56861e-02        9.45591e-01        5.44085e-02       9.95600e+04        0.000000         5.04939e+01         12.22242       196.523      36.085     1.00501     7.62373e-01     2.78110e-03
   9.86947e-01        1.30532e-02        9.54423e-01        4.55773e-02       1.38425e+05        0.000000         7.13743e+01         16.62387       200.949      35.847     1.01081     7.74188e-01     2.20958e-03
   9.88835e-01        1.11649e-02        9.60829e-01        3.91708e-02       1.92463e+05        0.000000         1.00682e+02         22.72182       204.782      35.676     1.01531     7.83774e-01     1.81717e-03
   9.90179e-01        9.82130e-03        9.65425e-01        3.45746e-02       2.67594e+05        0.000000         1.41676e+02         31.18226       207.951      35.554     1.01872     7.91361e-01     1.54821e-03
   9.91132e-01        8.86762e-03        9.68707e-01        3.12933e-02       3.72055e+05        0.000000         1.98878e+02         42.93083       210.479      35.468     1.02127     7.97238e-01     1.36308e-03
   9.91809e-01        8.19051e-03        9.71046e-01        2.89538e-02       5.17295e+05        0.000000         2.78579e+02         59.25413       212.441      35.407     1.02315     8.01712e-01     1.23478e-03
   9.92291e-01        7.70899e-03        9.72715e-01        2.72852e-02       7.19232e+05        0.000000         3.89525e+02         81.94058       213.935      35.363     1.02454     8.05070e-01     1.14524e-03
   9.92634e-01        7.36586e-03        9.73906e-01        2.60936e-02       1.00000e+06        0.000000         5.43882e+02        113.47630       215.054      35.332     1.02555     8.07564e-01     1.08232e-03
           NaN                NaN                NaN                NaN               NaN             NaN                 NaN              NaN           NaN         NaN         NaN             NaN             NaN
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       6.52558e+03        0.000000         3.09436e+00          2.39067       160.815     113.400     0.87960     8.02829e-01     2.73151e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       6.56612e+03        0.000000         3.10434e+00          2.38929       160.349     112.495     0.87966     8.01833e-01     2.70176e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       6.71303e+03        0.000000         3.16071e+00          2.42440       159.753     111.590     0.88003     8.01401e-01     2.67453e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       6.95208e+03        0.000000         3.25663e+00          2.49024       159.054     110.685     0.88065     8.01444e-01     2.64914e-01
   1.66356e-01        8.33644e-01        5.23737e-02        9.47626e-01       7.18497e+03        0.000000         3.35210e+00          2.55890       158.521     110.109     0.88126     8.01880e-01     2.63448e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       7.42567e+03        0.000000         3.45264e+00          2.63411       158.098     109.780     0.88191     8.02667e-01     2.62808e-01
   1.70442e-01        8.29558e-01        5.38408e-02        9.46159e-01       7.52764e+03        0.000000         3.49606e+00          2.66778       157.966     109.740     0.88218     8.03129e-01     2.62871e-01
   1.70442e-01        8.29558e-01        5.38408e-02        9.46159e-01       7.52800e+03        0.000000         3.49621e+00          2.66790       157.966     109.740     0.88218     8.03131e-01     2.62872e-01
   1.70000e-01        8.30000e-01        5.36815e-02        9.46318e-01       7.61529e+03        0.000000         3.53406e+00          2.69816       157.888     109.780     0.88242     8.03623e-01     2.63179e-01
   1.60000e-01        8.40000e-01        5.01107e-02        9.49889e-01       7.75176e+03        0.000000         3.60169e+00          2.76264       158.149     110.685     0.88282     8.05518e-01     2.66566e-01
   1.50000e-01        8.50000e-01        4.65978e-02        9.53402e-01       7.64459e+03        0.000000         3.56473e+00          2.74441       158.678     111.590     0.88258     8.06197e-01     2.69483e-01
   1.40000e-01        8.60000e-01        4.31414e-02        9.56859e-01       7.43709e+03        0.000000         3.48403e+00          2.69100       159.321     112.495     0.88208     8.06366e-01     2.72178e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       7.11588e+03        0.000000         3.35304e+00          2.59688       160.103     113.400     0.88126     8.05937e-01     2.74581e-01
   1.26033e-01        8.73967e-01        3.84059e-02        9.61594e-01       6.91411e+03        0.000000         3.26814e+00          2.53301       160.506     113.759     0.88072     8.05369e-01     2.75338e-01
   1.24391e-01        8.75609e-01        3.78562e-02        9.62144e-01       6.71805e+03        0.000000         3.18345e+00          2.46695       160.811     113.907     0.88018     8.04536e-01     2.75366e-01
   1.24391e-01        8.75609e-01        3.78562e-02        9.62144e-01       6.71767e+03        0.000000         3.18329e+00          2.46682       160.812     113.907     0.88018     8.04534e-01     2.75365e-01
   1.30000e-01        8.70000e-01        3.97402e-02        9.60260e-01       6.52558e+03        0.000000         3.09436e+00          2.39067       160.815     113.400     0.87960     8.02829e-01     2.73151e-01
END

$Env_BP << END
#                                                                              Sat Pres                                                                                   Liq Den     Gas Den          
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (psia)      Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW     (g/cm3)     (g/cm3)     Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ---------------   ---------------   ---------------   ---------   ---------   ---------   ---------   -----------
END

set output "Figures/Env_013_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_013_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_013_P_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_013_LogP_vs_LogXi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output "Figures/Env_013_P_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
plot [*:*] [*:1.5e+04] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x

set output "Figures/Env_013_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (psia)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set output
